/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.tile;

import com.tom.trading.Content;
import com.tom.trading.block.VendingMachineBlock;
import com.tom.trading.gui.VendingMachineConfigMenu;
import com.tom.trading.gui.VendingMachineTradingMenu;
import com.tom.trading.tile.OwnableBlockEntity;
import com.tom.trading.tile.VendingMachineBlockEntity;
import com.tom.trading.util.BasicContainer;
import com.tom.trading.util.BlockFaceDirection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class VendingMachineBlockEntityBase
extends OwnableBlockEntity
implements MenuProvider,
Nameable {
    private BasicContainer config = new BasicContainer(8);
    private BasicContainer inputs = new BasicContainer(8);
    private BasicContainer outputs = new BasicContainer(8);
    private int inputSides;
    private int outputSides;
    private int autoSides;
    private int matchNBT = 255;
    private Component name;
    private Boolean hasInputs;
    private boolean creativeMode;

    public VendingMachineBlockEntityBase(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Content.VENDING_MACHINE_TILE.get(), pPos, pBlockState);
        this.inputs.m_19164_(c -> {
            this.hasInputs = null;
        });
        this.config.m_19164_(c -> {
            this.hasInputs = null;
        });
        ContainerListener l = c -> this.m_6596_();
        this.config.m_19164_(l);
        this.inputs.m_19164_(l);
        this.outputs.m_19164_(l);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inputs.m_7797_(pTag.m_128437_("Inputs", 10));
        this.outputs.m_7797_(pTag.m_128437_("Outputs", 10));
        this.config.m_7797_(pTag.m_128437_("Config", 10));
        this.inputSides = pTag.m_128451_("inputSides");
        this.outputSides = pTag.m_128451_("outputSides");
        this.autoSides = pTag.m_128451_("autoSides");
        this.matchNBT = pTag.m_128441_("matchNBT") ? pTag.m_128451_("matchNBT") : 255;
        this.creativeMode = pTag.m_128471_("Creative");
        if (pTag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)pTag.m_128461_("CustomName"));
        }
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("Inputs", (Tag)this.inputs.m_7927_());
        pTag.m_128365_("Outputs", (Tag)this.outputs.m_7927_());
        pTag.m_128365_("Config", (Tag)this.config.m_7927_());
        pTag.m_128405_("inputSides", this.inputSides);
        pTag.m_128405_("outputSides", this.outputSides);
        pTag.m_128405_("autoSides", this.autoSides);
        pTag.m_128405_("matchNBT", this.matchNBT);
        pTag.m_128379_("Creative", this.creativeMode);
        if (this.name != null) {
            pTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
    }

    public BasicContainer getInputs() {
        return this.inputs;
    }

    public BasicContainer getOutputs() {
        return this.outputs;
    }

    public Runnable consumeInputs(List<ItemStack> items) {
        return this.consumeInputs((Container)this.inputs, 4, items);
    }

    public Runnable consumeInputs(Container inputs, int start, List<ItemStack> items) {
        ItemStack[] modArray = new ItemStack[inputs.m_6643_()];
        for (int i = 0; i < modArray.length; ++i) {
            modArray[i] = inputs.m_8020_(i).m_41777_();
        }
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        for (int i = 0; i < 4; ++i) {
            ItemStack o = this.config.m_8020_(i + start);
            int rem = o.m_41613_();
            if (rem > 0) {
                for (int j = 0; j < modArray.length; ++j) {
                    ItemStack s = modArray[j];
                    if (s.m_41619_() || !this.compareItemStack(s, o, i + start)) continue;
                    int d = Math.min(rem, s.m_41613_());
                    int fj = j;
                    actions.add(() -> inputs.m_7407_(fj, d));
                    items.add(s.m_41620_(d));
                    if ((rem -= d) < 1) break;
                }
            }
            if (rem <= 0) continue;
            return null;
        }
        return () -> actions.forEach(Runnable::run);
    }

    public Runnable addOutput(List<ItemStack> items) {
        return this.addOutput((Container)this.outputs, items, false);
    }

    private Runnable addOutput(Container outputs, List<ItemStack> items, boolean drop) {
        ItemStack[] modArray = new ItemStack[outputs.m_6643_()];
        for (int i = 0; i < modArray.length; ++i) {
            modArray[i] = outputs.m_8020_(i).m_41777_();
        }
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        for (int i = 0; i < items.size(); ++i) {
            int j;
            ItemStack o = items.get(i).m_41777_();
            for (j = 0; j < modArray.length; ++j) {
                if (ItemStack.m_150942_((ItemStack)o, (ItemStack)modArray[j])) {
                    ItemStack s = modArray[j];
                    int m = Math.min(outputs.m_6893_(), o.m_41741_());
                    int c = Math.min(o.m_41613_(), m - s.m_41613_());
                    if (c > 0) {
                        ItemStack ins = o.m_41777_();
                        ins.m_41764_(c);
                        o.m_41774_(c);
                        s.m_41769_(c);
                        actions.add(() -> {
                            ItemStack is = HopperBlockEntity.m_59326_(null, (Container)outputs, (ItemStack)ins, null);
                            if (!is.m_41619_() && drop) {
                                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)is);
                            }
                        });
                    }
                }
                if (o.m_41619_()) break;
            }
            if (!o.m_41619_()) {
                for (j = 0; j < modArray.length; ++j) {
                    ItemStack s2;
                    if (!modArray[j].m_41619_()) continue;
                    modArray[j] = s2 = o.m_41777_();
                    o.m_41764_(0);
                    actions.add(() -> {
                        ItemStack is = HopperBlockEntity.m_59326_(null, (Container)outputs, (ItemStack)s2, null);
                        if (!is.m_41619_() && drop) {
                            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)is);
                        }
                    });
                }
            }
            if (o.m_41619_()) continue;
            return null;
        }
        return () -> actions.forEach(Runnable::run);
    }

    public boolean canInput(ItemStack stack, Direction dir) {
        return this.canInputFrom(dir) && this.canInputItem(stack);
    }

    public boolean canInputItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack o = this.config.m_8020_(i + 4).m_41777_();
            if (!this.compareItemStack(stack, o, i + 4)) continue;
            return true;
        }
        return false;
    }

    public boolean compareItemStack(ItemStack stack, ItemStack template, int slot) {
        if (template.m_41720_() == Content.TAG_FILTER.get()) {
            if (!template.m_41782_() || !template.m_41783_().m_128425_("tag", 8)) {
                return false;
            }
            try {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(template.m_41783_().m_128461_("tag")));
                return stack.m_204117_(tag);
            }
            catch (Exception e) {
                return false;
            }
        }
        if ((this.matchNBT & 1 << slot) != 0) {
            return ItemStack.m_150942_((ItemStack)stack, (ItemStack)template);
        }
        return ItemStack.m_41656_((ItemStack)stack, (ItemStack)template);
    }

    public boolean canInputFrom(Direction dir) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)VendingMachineBlock.FACING);
        BlockFaceDirection d = BlockFaceDirection.getHorizontalFace(facing, dir);
        if (d == BlockFaceDirection.FRONT) {
            return false;
        }
        return (this.inputSides & 1 << d.ordinal()) != 0;
    }

    public boolean canOutput(Direction dir) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)VendingMachineBlock.FACING);
        BlockFaceDirection d = BlockFaceDirection.getHorizontalFace(facing, dir);
        if (d == BlockFaceDirection.FRONT) {
            return false;
        }
        return (this.outputSides & 1 << d.ordinal()) != 0;
    }

    public boolean isInRange(Player pPlayer) {
        return !this.f_58859_ && pPlayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (this.canAccess(pPlayer)) {
            return new VendingMachineConfigMenu(pContainerId, pPlayerInventory, this);
        }
        return new VendingMachineTradingMenu(pContainerId, pPlayerInventory, this);
    }

    public void setCustomName(Component pName) {
        this.name = pName;
        this.m_6596_();
    }

    public Component m_7755_() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component m_7770_() {
        return this.name;
    }

    protected Component getDefaultName() {
        return Content.VENDING_MACHINE.get().m_49954_();
    }

    public BasicContainer getConfig() {
        return this.config;
    }

    public int getInputSides() {
        return this.inputSides;
    }

    public int getOutputSides() {
        return this.outputSides;
    }

    public int getAutoSides() {
        return this.autoSides;
    }

    public int getMatchNBT() {
        return this.matchNBT;
    }

    public boolean isCreativeMode() {
        return this.creativeMode;
    }

    public int getTradingState() {
        if (this.hasInputs == null) {
            this.hasInputs = this.creativeMode || this.consumeInputs(new ArrayList<ItemStack>()) != null;
        }
        return this.hasInputs != false ? 1 : 0;
    }

    public void setSides(int id, int config, boolean auto) {
        this.inputSides = (config & 1) != 0 ? (this.inputSides |= 1 << id) : (this.inputSides &= ~(1 << id));
        this.outputSides = (config & 2) != 0 ? (this.outputSides |= 1 << id) : (this.outputSides &= ~(1 << id));
        this.autoSides = auto && config != 0 ? (this.autoSides |= 1 << id) : (this.autoSides &= ~(1 << id));
        this.m_6596_();
    }

    public void setMatchNBT(int slot, boolean config) {
        this.matchNBT = config ? (this.matchNBT |= 1 << slot) : (this.matchNBT &= ~(1 << slot));
    }

    public int tradeWith(Container c) {
        if (this.creativeMode) {
            ArrayList<ItemStack> playerItems = new ArrayList<ItemStack>();
            Runnable commitGetPlayer = this.consumeInputs(c, 0, playerItems);
            if (commitGetPlayer == null) {
                return 1;
            }
            ArrayList<ItemStack> machineItems = new ArrayList<ItemStack>();
            for (int i = 4; i < 8; ++i) {
                ItemStack o = this.config.m_8020_(i);
                int rem = o.m_41613_();
                if (rem <= 0 || o.m_41720_() == Content.TAG_FILTER.get()) continue;
                machineItems.add(o.m_41777_());
            }
            Runnable commitGive = this.addOutput(c, machineItems, true);
            if (commitGive == null) {
                return 3;
            }
            commitGetPlayer.run();
            commitGive.run();
            return 0;
        }
        ArrayList<ItemStack> playerItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> machineItems = new ArrayList<ItemStack>();
        Runnable commitGetPlayer = this.consumeInputs(c, 0, playerItems);
        if (commitGetPlayer == null) {
            return 1;
        }
        Runnable commitGetInv = this.consumeInputs(machineItems);
        if (commitGetInv == null) {
            return 2;
        }
        Runnable commitGive = this.addOutput(c, machineItems, true);
        if (commitGive == null) {
            return 3;
        }
        Runnable commitStore = this.addOutput(playerItems);
        if (commitStore == null) {
            return 4;
        }
        commitGetPlayer.run();
        commitGetInv.run();
        commitGive.run();
        commitStore.run();
        return 0;
    }

    @Override
    public boolean canAccess(Player p) {
        if (this.creativeMode && !p.m_150110_().f_35937_) {
            return false;
        }
        return super.canAccess(p);
    }

    public boolean isAutoSide(Direction dir) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)VendingMachineBlock.FACING);
        BlockFaceDirection d = BlockFaceDirection.getHorizontalFace(facing, dir);
        if (d == BlockFaceDirection.FRONT) {
            return false;
        }
        return (this.autoSides & 1 << d.ordinal()) != 0;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T beIn) {
        if (!(beIn instanceof VendingMachineBlockEntity)) {
            return;
        }
        VendingMachineBlockEntity be = (VendingMachineBlockEntity)beIn;
        if (level.m_46467_() % 20L != (long)(Math.abs(pos.hashCode()) % 20)) {
            return;
        }
        for (Direction d : Direction.values()) {
            if (!be.isAutoSide(d)) continue;
            if (be.canInputFrom(d)) {
                be.pullItemsFrom(pos.m_121945_(d), d.m_122424_());
            }
            if (!be.canOutput(d)) continue;
            be.pushItemsTo(pos.m_121945_(d), d.m_122424_());
        }
    }

    public void setCreativeMode(boolean b) {
        this.creativeMode = b;
        this.hasInputs = null;
        this.m_6596_();
    }
}

