/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.util;

import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class GameObject<T> {
    private final RegistryObject<T> value;

    protected GameObject(RegistryObject<T> value) {
        this.value = value;
    }

    public T get() {
        return (T)this.value.get();
    }

    public ResourceLocation getId() {
        return this.value.getId();
    }

    public static class GameObjectBlockEntity<T extends BlockEntity>
    extends GameObject<BlockEntityType<T>> {
        protected GameObjectBlockEntity(RegistryObject<BlockEntityType<T>> value) {
            super(value);
        }
    }

    public static class GameRegistryBE
    extends GameRegistry<BlockEntityType<?>> {
        public GameRegistryBE() {
            super(ForgeRegistries.BLOCK_ENTITY_TYPES);
        }

        public <BE extends BlockEntity, I extends BlockEntityType<BE>> GameObjectBlockEntity<BE> registerBE(String name, BlockEntityType.BlockEntitySupplier<BE> sup, GameObject<? extends Block> ... blocks) {
            return new GameObjectBlockEntity(this.handle.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)sup, (Block[])((Block[])Arrays.stream(blocks).map(GameObject::get).toArray(Block[]::new))).m_58966_(null)));
        }
    }

    public static class GameRegistry<T> {
        protected final DeferredRegister<T> handle;

        public GameRegistry(IForgeRegistry<T> reg) {
            this.handle = DeferredRegister.create(reg, (String)"toms_trading_network");
        }

        public <I extends T> GameObject<I> register(String name, Supplier<? extends I> sup) {
            return new GameObject(this.handle.register(name, sup));
        }

        public void register() {
            this.handle.register(FMLJavaModLoadingContext.get().getModEventBus());
        }
    }
}

