/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.util;

import com.tom.trading.gui.PlatformEditBox;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class PopupMenuManager {
    private final Screen screen;
    private int x;
    private int y;
    private List<PopupElement> menu;
    private int selected;

    public PopupMenuManager(Screen screen) {
        this.screen = screen;
    }

    public void open(double x, double y, PopupElement ... menu) {
        this.menu = Arrays.asList(menu);
        this.x = (int)x;
        this.y = (int)y;
        this.selected = -1;
    }

    public void replace(PopupElement ... menu) {
        this.menu = Arrays.asList(menu);
        this.selected = -1;
    }

    public boolean render(GuiGraphics g, Font font, int pMouseX, int pMouseY) {
        if (this.menu != null) {
            g.m_280245_(font, IntStream.range(0, this.menu.size()).mapToObj(i -> this.menu.get(i).getHoveredText(pMouseX - this.x, pMouseY - this.y - i * 10, this.selected == i)).map(Component::m_7532_).toList(), this.x - 12, this.y + 12);
        }
        return this.menu == null;
    }

    private static boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        return pMouseX >= (double)(pX - 1) && pMouseX < (double)(pX + pWidth + 1) && pMouseY >= (double)(pY - 1) && pMouseY < (double)(pY + pHeight + 1);
    }

    public boolean mouseClick(double pMouseX, double pMouseY, int pButton) {
        if (this.menu != null) {
            for (int i = 0; i < this.menu.size(); ++i) {
                if (!PopupMenuManager.isHovering(this.x, this.y + i * 10, 100, 8, pMouseX, pMouseY)) continue;
                this.menu.get(i).onClick(pMouseX - (double)this.x, pMouseY - (double)this.y - (double)(i * 10), pButton);
                this.selected = i;
                return true;
            }
            this.menu = null;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.menu != null) {
            if (this.selected != -1 && this.menu.get(this.selected).keyPressed(pKeyCode, pScanCode, pModifiers)) {
                return true;
            }
            if (pKeyCode == 264) {
                this.selected = (this.selected + 1) % this.menu.size();
            } else if (pKeyCode == 265) {
                this.selected = (this.selected + this.menu.size() - 1) % this.menu.size();
            } else if (pKeyCode == 256) {
                this.menu = null;
            }
            return true;
        }
        return false;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        return this.menu != null && this.selected != -1 && this.menu.get(this.selected).charTyped(pCodePoint, pModifiers);
    }

    public void close() {
        this.menu = null;
    }

    public static interface PopupElement {
        public MutableComponent getText();

        public void activate();

        default public void onClick(double pMouseX, double pMouseY, int pButton) {
            this.activate();
        }

        default public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
            if (pKeyCode == 257 || pKeyCode == 335) {
                this.activate();
                return true;
            }
            return false;
        }

        default public boolean charTyped(char pCodePoint, int pModifiers) {
            return false;
        }

        default public MutableComponent getHoveredText(int pMouseX, int pMouseY, boolean selected) {
            return this.getText().m_130940_(PopupMenuManager.isHovering(0, 0, 100, 8, pMouseX, pMouseY) || selected ? ChatFormatting.AQUA : ChatFormatting.GRAY);
        }
    }

    public static class TextFieldElement
    implements PopupElement {
        private final Supplier<MutableComponent> text;
        private final Consumer<String> action;
        private boolean activated;
        private PlatformEditBox box;
        private String value;

        public TextFieldElement(Supplier<MutableComponent> text, Consumer<String> action, Font font, String value) {
            this.text = text;
            this.action = action;
            this.box = new PlatformEditBox(font, 0, 0, 0, 0, null);
            this.value = value;
            this.box.m_94144_(value);
            this.box.m_94190_(false);
            this.box.setFocus(true);
        }

        @Override
        public MutableComponent getText() {
            if (this.activated) {
                StringBuilder sb = new StringBuilder(this.box.m_94155_());
                sb.insert(this.box.m_94207_(), '_');
                return Component.m_237110_((String)"tooltip.toms_trading_network.textfield", (Object[])new Object[]{this.text.get(), Component.m_237113_((String)sb.toString()).m_130940_(ChatFormatting.YELLOW)});
            }
            return Component.m_237110_((String)"tooltip.toms_trading_network.textfield", (Object[])new Object[]{this.text.get(), Component.m_237113_((String)this.box.m_94155_())});
        }

        @Override
        public void activate() {
            if (this.activated) {
                this.value = this.box.m_94155_();
                this.action.accept(this.value);
            }
            this.activated = !this.activated;
        }

        @Override
        public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
            if (this.activated && pKeyCode == 256) {
                this.box.m_94144_(this.value);
                this.activated = false;
                return true;
            }
            if (PopupElement.super.keyPressed(pKeyCode, pScanCode, pModifiers)) {
                return true;
            }
            if (this.activated) {
                return this.box.m_7933_(pKeyCode, pScanCode, pModifiers);
            }
            return false;
        }

        @Override
        public boolean charTyped(char pCodePoint, int pModifiers) {
            if (this.activated) {
                return this.box.m_5534_(pCodePoint, pModifiers);
            }
            return false;
        }
    }

    public static class ButtonElement
    implements PopupElement {
        private final Supplier<MutableComponent> text;
        private final Runnable action;

        public ButtonElement(Supplier<MutableComponent> text, Runnable action) {
            this.text = text;
            this.action = action;
        }

        @Override
        public MutableComponent getText() {
            return this.text.get();
        }

        @Override
        public void activate() {
            this.action.run();
        }
    }
}

