/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.potacore.item;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class EnchantHelper {
    public static boolean hasEnchantment(@NotNull ItemStack stack, Enchantment enchantment) {
        return stack.getEnchantmentLevel(enchantment) != 0;
    }

    public static boolean hasEnchantment(@NotNull ItemStack stack, ResourceLocation id) {
        return stack.getEnchantmentLevel((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id)) != 0;
    }

    public static int removeEnchantments(ItemStack stack, @NotNull Iterable<Enchantment> enchantments) {
        int count = 0;
        for (Enchantment enchantment : enchantments) {
            if (!EnchantHelper.removeEnchantment(stack, enchantment)) continue;
            ++count;
        }
        return count;
    }

    public static boolean removeEnchantment(ItemStack stack, ResourceLocation enchantment) {
        return EnchantHelper.removeEnchantment(stack, (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantment));
    }

    public static boolean removeEnchantment(@NotNull ItemStack stack, Enchantment enchantment) {
        if (stack.m_41619_() || enchantment == null || !stack.m_41782_()) {
            return false;
        }
        ResourceLocation targetId = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
        if (targetId == null) {
            return false;
        }
        String tagId = "Enchantments";
        if (stack.m_41720_().equals(Items.f_42690_)) {
            tagId = "StoredEnchantments";
        }
        CompoundTag nbt = stack.m_41784_();
        ListTag enchantmentList = nbt.m_128437_(tagId, 10);
        ListTag newList = new ListTag();
        boolean modified = false;
        for (int i = 0; i < enchantmentList.size(); ++i) {
            CompoundTag enchantmentTag = enchantmentList.m_128728_(i);
            ResourceLocation id = ResourceLocation.m_135820_((String)enchantmentTag.m_128461_("id"));
            if (id == null || !id.equals((Object)targetId)) {
                newList.add((Object)enchantmentTag);
                continue;
            }
            modified = true;
        }
        if (modified) {
            if (newList.isEmpty()) {
                nbt.m_128473_(tagId);
            } else {
                nbt.m_128365_(tagId, (Tag)newList);
            }
            if (nbt.m_128456_()) {
                stack.m_41751_(null);
            }
        }
        return modified;
    }
}

