/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.potacore.iteration;

import com.teampotato.potacore.iteration.MergedIterator;
import java.util.Iterator;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class MergedIterable<T>
implements Iterable<T> {
    private final Iterator<T> iterator1;
    private final Iterator<T> iterator2;

    public MergedIterable(@NotNull Iterable<T> iterable1, @NotNull Iterable<T> iterable2) {
        this(iterable1.iterator(), iterable2.iterator());
    }

    public MergedIterable(@NotNull Iterator<T> iterator1, @NotNull Iterator<T> iterator2) {
        this.iterator1 = iterator1;
        this.iterator2 = iterator2;
    }

    @Override
    @NotNull
    public MergedIterator<T> iterator() {
        return new MergedIterator<T>(this.iterator1, this.iterator2);
    }

    @Override
    public void forEach(@NotNull Consumer<? super T> action) {
        this.iterator().forEachRemaining(action);
    }
}

