/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.core;

import com.affehund.voidtotem.ModConstants;
import com.affehund.voidtotem.VoidTotemForge;
import com.affehund.voidtotem.core.EndCityTreasureAddition;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.UsedTotemTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoidTotemDataGeneration {

    public static final class RecipeGen
    extends RecipeProvider {
        public RecipeGen(PackOutput packOutput) {
            super(packOutput);
        }

        protected void m_245200_(@Nonnull Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)VoidTotemForge.VOID_TOTEM_ITEM.get())).m_126130_("cec").m_126130_("ltl").m_126130_(" e ").m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42730_).m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42545_).m_126127_(Character.valueOf('l'), (ItemLike)Items.f_42534_).m_126127_(Character.valueOf('t'), (ItemLike)Items.f_42747_).m_126132_("has_totem", (CriterionTriggerInstance)RecipeGen.m_125977_((ItemLike)Items.f_42747_)).m_176498_(consumer);
        }
    }

    public static class LootTableGen
    implements LootTableSubProvider {
        public void m_245126_(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            ImmutableList list = ImmutableList.of((Object)BuiltInLootTables.f_78741_);
            LootPool.Builder voidTotemLootPool = LootPool.m_79043_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.33f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)VoidTotemForge.VOID_TOTEM_ITEM.get())).m_79707_(1));
            this.createInjectPools(consumer, (List<ResourceLocation>)list, LootTable.m_79147_().m_79161_(voidTotemLootPool));
        }

        private void createInjectPools(BiConsumer<ResourceLocation, LootTable.Builder> consumer, List<ResourceLocation> list, LootTable.Builder builder) {
            list.forEach(resourceLocation -> consumer.accept(new ResourceLocation("voidtotem", "inject/" + resourceLocation.m_135815_()), builder));
        }
    }

    public static class ItemTagsGen
    extends ItemTagsProvider {
        public ItemTagsGen(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, BlockTagsProvider blockTagsProvider, ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, blockTagsProvider.m_274426_(), "voidtotem", existingFileHelper);
        }

        protected void m_6577_(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            this.m_206424_(ModConstants.ADDITIONAL_TOTEMS_TAG);
            this.m_206424_(ModConstants.CURIOS_CHARM_TAG).m_206428_(ModConstants.ADDITIONAL_TOTEMS_TAG).m_255245_((Object)((Item)VoidTotemForge.VOID_TOTEM_ITEM.get()));
            this.m_206424_(ModConstants.TRINKETS_CHARM_TAG).m_206428_(ModConstants.ADDITIONAL_TOTEMS_TAG).m_255245_((Object)((Item)VoidTotemForge.VOID_TOTEM_ITEM.get()));
        }
    }

    public static class LootModifierGen
    extends GlobalLootModifierProvider {
        public LootModifierGen(PackOutput output) {
            super(output, "voidtotem");
        }

        protected void start() {
            this.add("end_city_treasure_addition", (IGlobalLootModifier)new EndCityTreasureAddition(new LootItemCondition[]{LootItemRandomChanceCondition.m_81927_((float)0.3f).m_6409_(), LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("chests/end_city_treasure")).m_6409_()}, (Item)VoidTotemForge.VOID_TOTEM_ITEM.get()));
        }
    }

    public static class BlockTagsGen
    extends BlockTagsProvider {
        public BlockTagsGen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "voidtotem", existingFileHelper);
        }

        protected void m_6577_(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider p_256380_) {
        }
    }

    public static class AdvancementGen
    implements ForgeAdvancementProvider.AdvancementGenerator {
        public void generate(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull Consumer<Advancement> consumer, @NotNull ExistingFileHelper existingFileHelper) {
            Advancement.Builder.m_138353_().m_138398_(Advancement.Builder.m_138353_().m_138403_(new ResourceLocation("adventure/totem_of_undying"))).m_138371_((ItemLike)VoidTotemForge.VOID_TOTEM_ITEM.get(), (Component)Component.m_237115_((String)"advancements.voidtotem.adventure.totem_of_void_undying.title"), (Component)Component.m_237115_((String)"advancements.voidtotem.adventure.totem_of_void_undying.description"), null, FrameType.GOAL, true, true, false).m_138386_("used_void_totem", (CriterionTriggerInstance)UsedTotemTrigger.TriggerInstance.m_74452_((ItemLike)((ItemLike)VoidTotemForge.VOID_TOTEM_ITEM.get()))).save(consumer, new ResourceLocation("voidtotem", "adventure/totem_of_void_undying"), existingFileHelper);
        }
    }

    public static final class ItemModelGen
    extends ItemModelProvider {
        public ItemModelGen(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
            super(packOutput, "voidtotem", existingFileHelper);
        }

        protected void registerModels() {
            this.singleTexture((Item)VoidTotemForge.VOID_TOTEM_ITEM.get());
        }

        private void singleTexture(Item item) {
            ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)item);
            this.singleTexture(Objects.requireNonNull(registryName).m_135815_(), new ResourceLocation("item/generated"), "layer0", this.modLoc("item/" + registryName.m_135815_()));
        }
    }

    public static final class LanguageGen
    extends LanguageProvider {
        public LanguageGen(PackOutput packOutput, String locale) {
            super(packOutput, "voidtotem", locale);
        }

        protected void addTranslations() {
            String locale;
            switch (locale = this.m_6055_().replace("Languages: ", "")) {
                case "de_de": {
                    this.add("_comment", "Translation (de_de) by Affehund");
                    this.add((Item)VoidTotemForge.VOID_TOTEM_ITEM.get(), "Totem der Unsterblichkeit in der Leere");
                    this.add("tooltip.voidtotem.totem_of_void_undying", "Lege es in deine Haupt-/Nebenhand, um zu verhindern zu sterben, wenn du in die Leere f\u00e4llst.");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.title", "Post mortem 2");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.description", "Benutze ein Totem der Unsterblichkeit in der Leere, um dem Tod, wenn du in die Leere f\u00e4llst, von der Schippe zu springen");
                    this.add("trinkets.slot.charm.charm", "Amulett");
                    break;
                }
                case "en_us": {
                    this.add("_comment", "Translation (en_us) by Affehund");
                    this.add((Item)VoidTotemForge.VOID_TOTEM_ITEM.get(), "Totem of Void Undying");
                    this.add("tooltip.voidtotem.totem_of_void_undying", "Put in your main-/offhand to prevent dying if you fall in the void.");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.title", "Postmortal 2");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.description", "Use a Totem of Void Undying to cheat death when falling in the void");
                    this.add("trinkets.slot.charm.charm", "Charm");
                    this.addAutoConfigOption("ADD_END_CITY_TREASURE");
                    this.addAutoConfigOption("BLACKLISTED_DIMENSIONS");
                    this.addAutoConfigOption("DISPLAY_TOTEM_ON_CHEST");
                    this.addAutoConfigOption("GIVE_TOTEM_EFFECTS");
                    this.addAutoConfigOption("IS_INVERTED_BLACKLIST");
                    this.addAutoConfigOption("NEEDS_TOTEM");
                    this.addAutoConfigOption("SHOW_TOTEM_TOOLTIP");
                    this.addAutoConfigOption("TELEPORT_HEIGHT_OFFSET");
                    this.addAutoConfigOption("USE_TOTEM_FROM_INVENTORY");
                }
            }
        }

        private void addAutoConfigOption(String key) {
            this.add("text.autoconfig.voidtotem.option." + key, StringUtils.capitalizeFirstLetter((String)key.toLowerCase(Locale.ROOT).replace("_", " ")));
        }
    }
}

