/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SoftFluidRegistry {
    public static final ResourceKey<Registry<SoftFluid>> KEY = ResourceKey.m_135788_((ResourceLocation)Moonlight.res("soft_fluids"));

    public static Holder<SoftFluid> getEmpty() {
        return BuiltInSoftFluids.EMPTY.getHolder();
    }

    public static SoftFluid empty() {
        return (SoftFluid)BuiltInSoftFluids.EMPTY.get();
    }

    public static Registry<SoftFluid> hackyGetRegistry() {
        return Utils.hackyGetRegistry(KEY);
    }

    public static Registry<SoftFluid> getRegistry(RegistryAccess registryAccess) {
        return (Registry)registryAccess.m_6632_(KEY).orElseThrow();
    }

    public static Collection<SoftFluid> getValues() {
        return SoftFluidRegistry.hackyGetRegistry().m_123024_().toList();
    }

    public static Collection<Holder.Reference<SoftFluid>> getHolders() {
        return SoftFluidRegistry.hackyGetRegistry().m_203611_().toList();
    }

    public static Set<Map.Entry<ResourceKey<SoftFluid>, SoftFluid>> getEntries() {
        return SoftFluidRegistry.hackyGetRegistry().m_6579_();
    }

    public static Holder<SoftFluid> getHolder(ResourceLocation id) {
        Optional<Holder.Reference<SoftFluid>> opt = SoftFluidRegistry.getOptionalHolder(id);
        if (opt.isPresent()) {
            return (Holder)opt.get();
        }
        return SoftFluidRegistry.getEmpty();
    }

    public static Optional<Holder.Reference<SoftFluid>> getOptionalHolder(ResourceLocation id) {
        id = SoftFluidRegistry.backwardsCompat(id);
        return SoftFluidRegistry.hackyGetRegistry().m_203636_(ResourceKey.m_135785_(KEY, (ResourceLocation)id));
    }

    @NotNull
    private static ResourceLocation backwardsCompat(ResourceLocation id) {
        String namespace = id.m_135827_();
        if (namespace.equals("selene") || namespace.equals("minecraft")) {
            id = Moonlight.res(id.m_135815_());
        }
        return id;
    }
}

