/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria;

import it.mralxart.etheria.EtheriaClient;
import it.mralxart.etheria.config.RitualsConfig;
import it.mralxart.etheria.config.SkillsConfig;
import it.mralxart.etheria.config.TrialsConfig;
import it.mralxart.etheria.epicora.animations.util.AnimationsLoader;
import it.mralxart.etheria.epicora.geometry.util.GeometryLoader;
import it.mralxart.etheria.handlers.FreezeHandler;
import it.mralxart.etheria.handlers.TriggerHandler;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.registry.AnimationRegistry;
import it.mralxart.etheria.registry.BlockRegistry;
import it.mralxart.etheria.registry.CreativeTabRegistry;
import it.mralxart.etheria.registry.EffectRegistry;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.registry.FeatureRegistry;
import it.mralxart.etheria.registry.GeometryRegistry;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.registry.LootModifierRegistry;
import it.mralxart.etheria.registry.ParticleRegistry;
import it.mralxart.etheria.registry.SoundsRegistry;
import it.mralxart.etheria.registry.StructureRegistry;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.registry.TriggerRegistry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="etheria")
public class Etheria {
    public static final String MODID = "etheria";
    public static final Logger LOGGER = LogManager.getLogger((String)"etheria");

    public Etheria() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        EntityRegistry.ENTITIES.register(modEventBus);
        EffectRegistry.EFFECTS.register(modEventBus);
        GeometryRegistry.init();
        AnimationRegistry.init();
        Networking.init();
        CreativeTabRegistry.init();
        TriggerRegistry.init();
        BlockRegistry.register(modEventBus);
        ItemRegistry.ITEMS.register(modEventBus);
        ParticleRegistry.PARTICLES.register(modEventBus);
        TileRegistry.TILES.register(modEventBus);
        StructureRegistry.DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
        LootModifierRegistry.CODECS.register(modEventBus);
        FeatureRegistry.FEATURES.register(modEventBus);
        FeatureRegistry.PROCESSORS.register(modEventBus);
        SoundsRegistry.SOUNDS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)new TriggerHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FreezeHandler());
        modEventBus.addListener(this::setupCommon);
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.register((Object)new EtheriaClient());
            return new Object();
        });
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        new SkillsConfig().constructAndSave(false);
        new RitualsConfig().constructAndSave(false);
        new TrialsConfig().constructAndSave(false);
        GeometryLoader.init();
        AnimationsLoader.init();
        Path oldPath = FMLPaths.CONFIGDIR.get().resolve("etheria/skills_config.json");
        try {
            if (Files.exists(oldPath, new LinkOption[0])) {
                Files.delete(oldPath);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

