/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.artifacts;

import it.mralxart.etheria.artifacts.ArtifactStatsManager;
import it.mralxart.etheria.artifacts.StatType;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class ArtifactStatCalculator {
    private final EnumMap<StatType, Float> finalStats = new EnumMap(StatType.class);
    private Map<String, Element> elements = new HashMap<String, Element>();

    public ArtifactStatCalculator() {
        for (StatType stat : StatType.values()) {
            this.finalStats.put(stat, Float.valueOf(0.0f));
        }
    }

    public void updateElements(List<ItemStack> artifacts) {
        for (ItemStack artifact : artifacts) {
            if (!(artifact.m_41720_() instanceof IElementItem)) continue;
            Element element = ElementsUtils.getElement(artifact);
            this.elements.put(element.name().toLowerCase(), element);
        }
    }

    public void updateStats(List<ItemStack> artifacts) {
        EnumMap<StatType, Float> tempStats = new EnumMap<StatType, Float>(StatType.class);
        for (ItemStack artifact : artifacts) {
            Map<StatType, Float> artifactStats = ArtifactStatsManager.getAllStats(artifact);
            for (Map.Entry<StatType, Float> entry : artifactStats.entrySet()) {
                StatType stat = entry.getKey();
                float value = entry.getValue().floatValue();
                tempStats.merge(stat, Float.valueOf(value), Float::sum);
            }
        }
        this.finalStats.putAll(tempStats);
    }

    public float getStatValue(StatType statType) {
        return this.finalStats.getOrDefault((Object)statType, Float.valueOf(0.0f)).floatValue();
    }

    public static float getStatValue(List<ItemStack> artifacts, StatType statType) {
        EnumMap<StatType, Float> tempStats = new EnumMap<StatType, Float>(StatType.class);
        for (ItemStack artifact : artifacts) {
            Map<StatType, Float> artifactStats = ArtifactStatsManager.getAllStats(artifact);
            for (Map.Entry<StatType, Float> entry : artifactStats.entrySet()) {
                StatType stat = entry.getKey();
                float value = entry.getValue().floatValue();
                tempStats.merge(stat, Float.valueOf(value), Float::sum);
            }
        }
        return tempStats.getOrDefault((Object)statType, Float.valueOf(0.0f)).floatValue();
    }

    public static float getStatValue(ItemStack weapon, List<ItemStack> artifacts, StatType stat) {
        CompoundTag stats;
        CompoundTag tag;
        float total = 0.0f;
        if (weapon != null && weapon.m_41782_() && (tag = weapon.m_41783_()) != null && tag.m_128425_("etheria$stats", 10) && (stats = tag.m_128469_("etheria$stats")).m_128441_(stat.name())) {
            total += stats.m_128457_(stat.name());
        }
        return total += ArtifactStatCalculator.getStatValue(artifacts, stat);
    }

    public static float getStatValue(ItemStack artifact, StatType statType) {
        Map<StatType, Float> artifactStats = ArtifactStatsManager.getAllStats(artifact);
        return artifactStats.getOrDefault((Object)statType, Float.valueOf(0.0f)).floatValue();
    }

    public static float getStatValue(Map<StatType, Float> stats, StatType statType) {
        return stats.getOrDefault((Object)statType, Float.valueOf(0.0f)).floatValue();
    }

    public EnumMap<StatType, Float> getFinalStats() {
        return this.finalStats;
    }

    public Map<String, Element> getElements() {
        return this.elements;
    }

    public void setElements(Map<String, Element> elements) {
        this.elements = elements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactStatCalculator)) {
            return false;
        }
        ArtifactStatCalculator other = (ArtifactStatCalculator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EnumMap<StatType, Float> this$finalStats = this.getFinalStats();
        EnumMap<StatType, Float> other$finalStats = other.getFinalStats();
        if (this$finalStats == null ? other$finalStats != null : !((Object)this$finalStats).equals(other$finalStats)) {
            return false;
        }
        Map<String, Element> this$elements = this.getElements();
        Map<String, Element> other$elements = other.getElements();
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArtifactStatCalculator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EnumMap<StatType, Float> $finalStats = this.getFinalStats();
        result = result * 59 + ($finalStats == null ? 43 : ((Object)$finalStats).hashCode());
        Map<String, Element> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        return result;
    }

    public String toString() {
        return "ArtifactStatCalculator(finalStats=" + this.getFinalStats() + ", elements=" + this.getElements() + ")";
    }
}

