/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.artifacts;

import com.google.common.collect.Multimap;
import it.mralxart.etheria.artifacts.ArtifactStatCalculator;
import it.mralxart.etheria.artifacts.StatType;
import it.mralxart.etheria.artifacts.data.StatPack;
import it.mralxart.etheria.artifacts.data.StatPackType;
import it.mralxart.etheria.items.ArtifactItem;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.magic.spells.Spell;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.utils.EntityUtils;
import it.mralxart.etheria.utils.EtherUtils;
import it.mralxart.etheria.world.loot.data.LootData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ArtifactStatsManager {
    private static final Random RANDOM = new Random();
    public static final Map<StatPackType, List<StatPack>> STAT_PACKS = new HashMap<StatPackType, List<StatPack>>();
    public static final Map<ArtifactItem, LootData> ARTIFACT_LOOT = new HashMap<ArtifactItem, LootData>();

    public static Map<StatType, Float> getAllStats(ItemStack stack) {
        HashMap<StatType, Float> stats = new HashMap<StatType, Float>(ArtifactStatsManager.getMainStats(stack));
        stats.putAll(ArtifactStatsManager.getSecondaryStats(stack));
        return stats;
    }

    public static Map<StatType, Float> getMainStats(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        HashMap<StatType, Float> mainStats = new HashMap<StatType, Float>();
        ListTag mainStatsList = tag.m_128437_("etheria$main_stats", 10);
        for (Tag statTag : mainStatsList) {
            CompoundTag mainStatTag = (CompoundTag)statTag;
            try {
                StatType type = StatType.valueOf(mainStatTag.m_128461_("StatType"));
                float value = mainStatTag.m_128457_("Value");
                mainStats.put(type, Float.valueOf(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return mainStats;
    }

    public static Map<StatType, Float> getSecondaryStats(ItemStack stack) {
        HashMap<StatType, Float> secondaryStats = new HashMap<StatType, Float>();
        if (stack.m_41782_() && stack.m_41783_().m_128425_("etheria$stats", 9)) {
            ListTag statsList = stack.m_41783_().m_128437_("etheria$stats", 10);
            for (Tag tag : statsList) {
                CompoundTag statTag = (CompoundTag)tag;
                StatType type = StatType.valueOf(statTag.m_128461_("StatType"));
                float value = statTag.m_128457_("Value");
                secondaryStats.put(type, Float.valueOf(value));
            }
        }
        return secondaryStats;
    }

    public static Map<StatType, Float> getAllStats(CompoundTag tag) {
        HashMap<StatType, Float> stats = new HashMap<StatType, Float>(ArtifactStatsManager.getMainStats(tag));
        stats.putAll(ArtifactStatsManager.getSecondaryStats(tag));
        return stats;
    }

    public static Map<StatType, Float> getMainStats(CompoundTag tag) {
        HashMap<StatType, Float> mainStats = new HashMap<StatType, Float>();
        ListTag mainStatsList = tag.m_128437_("etheria$main_stats", 10);
        for (Tag statTag : mainStatsList) {
            CompoundTag mainStatTag = (CompoundTag)statTag;
            StatType type = StatType.valueOf(mainStatTag.m_128461_("StatType"));
            float value = mainStatTag.m_128457_("Value");
            mainStats.put(type, Float.valueOf(value));
        }
        return mainStats;
    }

    public static Map<StatType, Float> getSecondaryStats(CompoundTag compoundTag) {
        HashMap<StatType, Float> secondaryStats = new HashMap<StatType, Float>();
        if (compoundTag.m_128425_("etheria$stats", 9)) {
            ListTag statsList = compoundTag.m_128437_("etheria$stats", 10);
            for (Tag tag : statsList) {
                CompoundTag statTag = (CompoundTag)tag;
                StatType type = StatType.valueOf(statTag.m_128461_("StatType"));
                float value = statTag.m_128457_("Value");
                secondaryStats.put(type, Float.valueOf(value));
            }
        }
        return secondaryStats;
    }

    public static ItemStack setBlessed(ItemStack stack) {
        if (stack.m_41783_() != null) {
            stack.m_41783_().m_128379_("etheria$artifact_blessed", true);
        }
        return stack;
    }

    public static boolean isBlessed(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128441_("etheria$artifact_blessed");
    }

    public static ItemStack setReroll(ItemStack stack) {
        if (stack.m_41783_() != null) {
            stack.m_41783_().m_128379_("etheria$artifact_reroll", true);
        }
        return stack;
    }

    public static ItemStack setStars(ItemStack stack, int stars) {
        if (stack.m_41783_() != null) {
            stack.m_41783_().m_128405_("etheria$stars", stars);
        }
        return stack;
    }

    public static ItemStack resetReroll(ItemStack stack) {
        if (stack.m_41783_() != null) {
            stack.m_41783_().m_128473_("etheria$artifact_reroll");
        }
        return stack;
    }

    public static boolean isReroll(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128441_("etheria$artifact_reroll");
    }

    public static ItemStack init(ItemStack stack) {
        return ArtifactStatsManager.init(stack, 0.0f);
    }

    public static ItemStack init(ItemStack stack, float lvl) {
        float starMultiplier;
        Item item = stack.m_41720_();
        if (!(item instanceof ArtifactItem)) {
            return stack;
        }
        ArtifactItem artefactItem = (ArtifactItem)item;
        CompoundTag tag = stack.m_41784_();
        boolean isNewStats = tag.m_128441_("etheria$main_stats");
        int level = tag.m_128451_("etheria$stats_level");
        if (level == 0) {
            level = 1;
        }
        tag.m_128405_("etheria$stats_level", level);
        int stars = !tag.m_128441_("etheria$stars") ? ArtifactStatsManager.getRandomStars() : tag.m_128451_("etheria$stars");
        tag.m_128405_("etheria$stars", stars);
        switch (stars) {
            case 2: {
                float f = 0.6f;
                break;
            }
            case 3: {
                float f = 1.4f;
                break;
            }
            case 4: {
                float f = 1.8f;
                break;
            }
            case 5: {
                float f = 2.1f;
                break;
            }
            default: {
                float f = starMultiplier = 0.2f;
            }
        }
        if (stars > 5) {
            starMultiplier = 0.6f + 0.1f * (float)(stars - 1);
        }
        if (!isNewStats) {
            float baseValue;
            ArrayList<StatPackType> packTypes = new ArrayList<StatPackType>(STAT_PACKS.keySet());
            StatPackType chosenType = (StatPackType)((Object)packTypes.get(RANDOM.nextInt(packTypes.size())));
            List<StatPack> packs = STAT_PACKS.get((Object)chosenType);
            StatPack chosenPack = packs.get(RANDOM.nextInt(packs.size()));
            ListTag mainStatsList = new ListTag();
            for (StatType mainStat : chosenPack.getPrimaryStats()) {
                CompoundTag mainStatTag = new CompoundTag();
                baseValue = mainStat.getRandomValue();
                baseValue = ArtifactStatsManager.validateBaseValue(mainStat, baseValue);
                mainStatTag.m_128359_("StatType", mainStat.name());
                mainStatTag.m_128350_("BaseValue", baseValue);
                mainStatTag.m_128350_("Value", baseValue * starMultiplier * (1.0f + 0.05f * (float)level));
                mainStatsList.add((Object)mainStatTag);
            }
            tag.m_128365_("etheria$main_stats", (Tag)mainStatsList);
            ListTag secondaryStatsList = new ListTag();
            int secondaryCount = RANDOM.nextInt(2) + 1;
            for (int i = 0; i < secondaryCount; ++i) {
                StatType secondaryStat = chosenPack.getSecondaryStats()[RANDOM.nextInt(chosenPack.getSecondaryStats().length)];
                CompoundTag statTag = new CompoundTag();
                baseValue = secondaryStat.getRandomValue();
                baseValue = ArtifactStatsManager.validateBaseValue(secondaryStat, baseValue);
                statTag.m_128359_("StatType", secondaryStat.name());
                statTag.m_128350_("BaseValue", baseValue);
                statTag.m_128350_("Value", baseValue * starMultiplier * (1.0f + 0.02f * (float)level));
                secondaryStatsList.add((Object)statTag);
            }
            tag.m_128365_("etheria$stats", (Tag)secondaryStatsList);
        } else {
            ListTag secondaryStatsList = tag.m_128437_("etheria$stats", 10);
            for (int i = 0; i < secondaryStatsList.size(); ++i) {
                CompoundTag statTag = secondaryStatsList.m_128728_(i);
                float baseValue = statTag.m_128441_("BaseValue") ? statTag.m_128457_("BaseValue") : statTag.m_128457_("Value");
                baseValue = ArtifactStatsManager.validateBaseValue(StatType.valueOf(statTag.m_128461_("StatType").toUpperCase()), baseValue);
                statTag.m_128350_("BaseValue", baseValue);
                statTag.m_128350_("Value", baseValue * starMultiplier * (1.0f + 0.05f * (float)level));
            }
            tag.m_128365_("etheria$stats", (Tag)secondaryStatsList);
            ListTag mainStatsList = tag.m_128437_("etheria$main_stats", 10);
            for (int i = 0; i < mainStatsList.size(); ++i) {
                CompoundTag mainStatTag = mainStatsList.m_128728_(i);
                float baseValue = mainStatTag.m_128441_("BaseValue") ? mainStatTag.m_128457_("BaseValue") : mainStatTag.m_128457_("Value");
                baseValue = ArtifactStatsManager.validateBaseValue(StatType.valueOf(mainStatTag.m_128461_("StatType").toUpperCase()), baseValue);
                mainStatTag.m_128350_("BaseValue", baseValue);
                mainStatTag.m_128350_("Value", baseValue * starMultiplier * (1.0f + 0.02f * (float)level));
            }
            tag.m_128365_("etheria$main_stats", (Tag)mainStatsList);
        }
        return stack;
    }

    public static float validateBaseValue(StatType statType, float baseValue) {
        float min = ((Float)statType.getMinMaxRange().getFirst()).floatValue();
        float max = ((Float)statType.getMinMaxRange().getSecond()).floatValue();
        return baseValue < min || baseValue > max ? (min + max) / 2.0f : baseValue;
    }

    private static int getRandomStars() {
        int roll = RANDOM.nextInt(100) + 1;
        if (roll <= 10) {
            return 1;
        }
        if (roll <= 50) {
            return 2;
        }
        if (roll <= 75) {
            return 3;
        }
        if (roll <= 90) {
            return 4;
        }
        return 5;
    }

    public static ItemStack transferStats(ItemStack from, ItemStack to) {
        if (!from.m_41782_() || from.m_41783_() == null || !from.m_41783_().m_128425_("etheria$main_stats", 9)) {
            return to;
        }
        CompoundTag fromTag = from.m_41783_();
        CompoundTag toTag = to.m_41784_();
        ListTag mainStatsList = fromTag.m_128437_("etheria$main_stats", 10);
        toTag.m_128365_("etheria$main_stats", (Tag)mainStatsList.m_6426_());
        ListTag secondaryStatsList = fromTag.m_128437_("etheria$stats", 10);
        toTag.m_128365_("etheria$stats", (Tag)secondaryStatsList.m_6426_());
        toTag.m_128405_("etheria$stars", fromTag.m_128451_("etheria$stars"));
        toTag.m_128405_("etheria$stats_level", fromTag.m_128451_("etheria$stats_level"));
        Item item = from.m_41720_();
        if (item instanceof IElementItem) {
            IElementItem item2 = (IElementItem)item;
            if (toTag.m_128441_("etheria$element2") && !toTag.m_128461_("etheria$element2").isEmpty() && !toTag.m_128461_("etheria$element2").equalsIgnoreCase(item2.getElement().name())) {
                toTag.m_128359_("etheria$element2", item2.getElement().name().toLowerCase());
            } else if (toTag.m_128441_("etheria$element") && !toTag.m_128461_("etheria$element").isEmpty() && !toTag.m_128461_("etheria$element").equalsIgnoreCase(item2.getElement().name())) {
                toTag.m_128359_("etheria$element2", item2.getElement().name().toLowerCase());
            } else {
                toTag.m_128359_("etheria$element", item2.getElement().name().toLowerCase());
            }
        }
        return to;
    }

    public static Spell transferStats(ItemStack from, Spell to) {
        if (!from.m_41782_() || from.m_41783_() == null || !from.m_41783_().m_128425_("etheria$main_stats", 9)) {
            return to;
        }
        CompoundTag fromTag = from.m_41783_();
        CompoundTag toTag = to.serializeNBT();
        ListTag mainStatsList = fromTag.m_128437_("etheria$main_stats", 10);
        toTag.m_128365_("etheria$main_stats", (Tag)mainStatsList.m_6426_());
        ListTag secondaryStatsList = fromTag.m_128437_("etheria$stats", 10);
        toTag.m_128365_("etheria$stats", (Tag)secondaryStatsList.m_6426_());
        Item item = from.m_41720_();
        if (item instanceof IElementItem) {
            IElementItem item2 = (IElementItem)item;
            if (toTag.m_128441_("element2") && !toTag.m_128461_("element2").isEmpty() && !toTag.m_128461_("element2").equalsIgnoreCase(item2.getElement().name())) {
                toTag.m_128359_("element2", item2.getElement().name().toLowerCase());
            } else if (toTag.m_128441_("element") && !toTag.m_128461_("element").isEmpty() && !toTag.m_128461_("element").equalsIgnoreCase(item2.getElement().name())) {
                toTag.m_128359_("element2", item2.getElement().name().toLowerCase());
            }
        }
        to.deserializeNBT(toTag);
        return to;
    }

    public static ItemStack levelUpStats(ItemStack itemStack) {
        if (!itemStack.m_41782_() || !itemStack.m_41783_().m_128425_("etheria$main_stats", 9)) {
            return itemStack;
        }
        if (ArtifactStatsManager.isMaxLevel(itemStack)) {
            return itemStack;
        }
        CompoundTag tag = itemStack.m_41783_();
        int level = tag.m_128451_("etheria$stats_level") + 1;
        int stars = tag.m_128441_("etheria$stars") ? tag.m_128451_("etheria$stars") : 1;
        float starMultiplier = switch (stars) {
            case 2 -> 0.6f;
            case 3 -> 1.4f;
            case 4 -> 1.8f;
            case 5 -> 2.1f;
            default -> 0.2f;
        };
        ListTag secondaryStatsList = tag.m_128437_("etheria$stats", 10);
        for (int i = 0; i < secondaryStatsList.size(); ++i) {
            CompoundTag statTag = secondaryStatsList.m_128728_(i);
            float baseValue = statTag.m_128441_("BaseValue") ? statTag.m_128457_("BaseValue") : statTag.m_128457_("Value");
            statTag.m_128350_("BaseValue", baseValue);
            statTag.m_128350_("Value", baseValue * starMultiplier * (1.0f + 0.1f * (float)level));
        }
        tag.m_128365_("etheria$stats", (Tag)secondaryStatsList);
        ListTag mainStatsList = tag.m_128437_("etheria$main_stats", 10);
        for (int i = 0; i < mainStatsList.size(); ++i) {
            CompoundTag mainStatTag = mainStatsList.m_128728_(i);
            float baseValue = mainStatTag.m_128441_("BaseValue") ? mainStatTag.m_128457_("BaseValue") : mainStatTag.m_128457_("Value");
            mainStatTag.m_128350_("BaseValue", baseValue);
            mainStatTag.m_128350_("Value", baseValue * starMultiplier * (1.0f + 0.05f * (float)level));
        }
        tag.m_128365_("etheria$main_stats", (Tag)mainStatsList);
        tag.m_128405_("etheria$stats_level", level);
        return itemStack;
    }

    public static boolean isMaxLevel(ItemStack itemStack) {
        return ArtifactStatsManager.getLevel(itemStack) >= 20;
    }

    public static int getLevel(ItemStack itemStack) {
        return itemStack.m_41783_() != null ? itemStack.m_41783_().m_128451_("etheria$stats_level") : 0;
    }

    static {
        STAT_PACKS.put(StatPackType.RITUAL, Arrays.asList(new StatPack(new StatType[]{StatType.ETHER_COST, StatType.ETHER_OVERLOAD}, new StatType[]{StatType.RITUAL_LUCK, StatType.ETHER_SPLASH, StatType.RITUAL_CRASH}), new StatPack(new StatType[]{StatType.RITUAL_SPEED, StatType.ETHER_SPLASH}, new StatType[]{StatType.RITUAL_STABILITY, StatType.ETHER_COST, StatType.ETHER_OVERLOAD}), new StatPack(new StatType[]{StatType.RITUAL_CRASH, StatType.RITUAL_LUCK}, new StatType[]{StatType.ETHER_COST, StatType.ETHER_REGEN, StatType.RITUAL_STABILITY})));
        STAT_PACKS.put(StatPackType.SPELL, Arrays.asList(new StatPack(new StatType[]{StatType.DAMAGE, StatType.DURATION}, new StatType[]{StatType.ETHER_COST, StatType.RADIUS, StatType.SPELL_SPEED, StatType.MAX_DISTANCE}), new StatPack(new StatType[]{StatType.ETHER_COST, StatType.RADIUS}, new StatType[]{StatType.DAMAGE, StatType.SPELL_SPEED, StatType.COOLDOWN, StatType.ETHER_REGEN}), new StatPack(new StatType[]{StatType.SPELL_SPEED, StatType.MAX_DISTANCE}, new StatType[]{StatType.DAMAGE, StatType.DURATION, StatType.BURN_EFFECT, StatType.ETHER_OVERLOAD})));
        STAT_PACKS.put(StatPackType.WEAPON, Arrays.asList(new StatPack(new StatType[]{StatType.ATTACK_SPEED, StatType.DAMAGE}, new StatType[]{StatType.LIFE_STEAL, StatType.EXP_BOOST, StatType.ETHER_COST, StatType.ATTACK_POWER}), new StatPack(new StatType[]{StatType.ATTACK_SPEED, StatType.CRIT_CHANCE}, new StatType[]{StatType.ATTACK_POWER, StatType.CRIT_DAMAGE, StatType.POISON_CHANCE, StatType.ARMOR_PEN}), new StatPack(new StatType[]{StatType.DAMAGE, StatType.ETHER_REGEN}, new StatType[]{StatType.LIFE_STEAL, StatType.CRIT_CHANCE, StatType.ETHER_REGEN, StatType.POISON_CHANCE}), new StatPack(new StatType[]{StatType.DAMAGE, StatType.CRIT_DAMAGE}, new StatType[]{StatType.CRIT_CHANCE, StatType.EXP_BOOST, StatType.ETHER_REGEN, StatType.ARMOR_PEN}), new StatPack(new StatType[]{StatType.LIFE_STEAL, StatType.EXP_BOOST}, new StatType[]{StatType.ETHER_REGEN, StatType.POISON_CHANCE, StatType.ARMOR_PEN, StatType.CRIT_CHANCE})));
        STAT_PACKS.put(StatPackType.PLAYER, Arrays.asList(new StatPack(new StatType[]{StatType.DAMAGE, StatType.ETHER_REGEN}, new StatType[]{StatType.EXP_BOOST, StatType.LIFE_STEAL, StatType.ELEMENTAL_AMPLIFICATION, StatType.MOVEMENT_SPEED}), new StatPack(new StatType[]{StatType.MOVEMENT_SPEED, StatType.MAX_HEALTH}, new StatType[]{StatType.POISON_CHANCE, StatType.LIFE_STEAL, StatType.ETHER_COST}), new StatPack(new StatType[]{StatType.ATTACK_SPEED, StatType.DAMAGE}, new StatType[]{StatType.EXP_BOOST, StatType.MAX_HEALTH, StatType.ETHER_REGEN, StatType.MOVEMENT_SPEED}), new StatPack(new StatType[]{StatType.MAX_HEALTH, StatType.DAMAGE}, new StatType[]{StatType.POISON_CHANCE, StatType.LIFE_STEAL, StatType.ETHER_REGEN, StatType.MOVEMENT_SPEED})));
        ARTIFACT_LOOT.put((ArtifactItem)ItemRegistry.BURNING_HEART.get(), new LootData().addData("pyro", "basic", 0.03f));
        ARTIFACT_LOOT.put((ArtifactItem)ItemRegistry.HELLFIRE_STAR.get(), new LootData().addData("pyro", "enchanted", 0.04f));
        ARTIFACT_LOOT.put((ArtifactItem)ItemRegistry.FLAME_WINGS.get(), new LootData().addData("pyro", "enchanted", 0.04f));
        ARTIFACT_LOOT.put((ArtifactItem)ItemRegistry.RADIANCE_FIRE.get(), new LootData().addData("pyro", "enchanted", 0.04f));
        ARTIFACT_LOOT.put((ArtifactItem)ItemRegistry.FLAMING_ROSE.get(), new LootData().addData("pyro", "epic", 0.08f));
        ARTIFACT_LOOT.put((ArtifactItem)ItemRegistry.FROSTWIND_MIRROR.get(), new LootData().addData("cryo", "basic", 0.03f));
        ARTIFACT_LOOT.put((ArtifactItem)ItemRegistry.WINGER_PENDANT.get(), new LootData().addData("cryo", "enchanted", 0.045f));
        ARTIFACT_LOOT.put((ArtifactItem)ItemRegistry.ICE_MASK.get(), new LootData().addData("cryo", "enchanted", 0.04f));
        ARTIFACT_LOOT.put((ArtifactItem)ItemRegistry.FROST_SCROLL.get(), new LootData().addData("cryo", "enchanted", 0.04f));
        ARTIFACT_LOOT.put((ArtifactItem)ItemRegistry.SNOW_ROSE.get(), new LootData().addData("cryo", "epic", 0.07f));
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onAttributeModifiers(ItemAttributeModifierEvent event) {
            ItemStack stack = event.getItemStack();
            if (!stack.m_41782_() || stack.m_41783_() != null && !stack.m_41783_().m_128425_("etheria$main_stats", 9)) {
                boolean hasArtifacts;
                if (FMLEnvironment.dist == Dist.CLIENT && !(hasArtifacts = Events.clientHasArtifacts())) {
                    return;
                }
                return;
            }
            if (!(stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof AxeItem || stack.m_41720_() instanceof BowItem || stack.m_41720_() instanceof CrossbowItem || stack.m_41720_() instanceof TridentItem)) {
                return;
            }
            EquipmentSlot slot = event.getSlotType();
            if (slot == EquipmentSlot.MAINHAND && FMLEnvironment.dist == Dist.CLIENT) {
                Events.applyClientModifiers(event, stack);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private static boolean clientHasArtifacts() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            return player != null && !CapabilityRegistry.getCap((Player)player).getArtifacts().isEmpty();
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void applyClientModifiers(ItemAttributeModifierEvent event, ItemStack stack) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            Multimap originalModifiers = event.getOriginalModifiers();
            double baseDamage = originalModifiers.get((Object)Attributes.f_22281_).stream().mapToDouble(AttributeModifier::m_22218_).sum();
            double baseSpeed = originalModifiers.get((Object)Attributes.f_22283_).stream().mapToDouble(AttributeModifier::m_22218_).sum();
            baseDamage += 1.0;
            List<ItemStack> itemStacks = CapabilityRegistry.getCap((Player)player).getArtifacts().values().stream().toList();
            float artifactDamagePercent = ArtifactStatCalculator.getStatValue(itemStacks, StatType.DAMAGE) / 100.0f;
            float artifactAttackSpeedPercent = ArtifactStatCalculator.getStatValue(itemStacks, StatType.ATTACK_SPEED) / 100.0f;
            float totalDamagePercent = artifactDamagePercent + ArtifactStatCalculator.getStatValue(stack, StatType.DAMAGE) / 100.0f;
            float totalAttackSpeedPercent = artifactAttackSpeedPercent + ArtifactStatCalculator.getStatValue(stack, StatType.ATTACK_SPEED) / 100.0f;
            double newDamage = Math.round(baseDamage * (double)(1.0f + totalDamagePercent));
            double newSpeed = 4.0 + (baseSpeed + baseSpeed * (double)totalAttackSpeedPercent);
            event.removeModifier(Attributes.f_22281_, new AttributeModifier(UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF"), "Weapon modifier", 0.0, AttributeModifier.Operation.ADDITION));
            event.removeModifier(Attributes.f_22283_, new AttributeModifier(UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3"), "Weapon modifier", 0.0, AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22281_, new AttributeModifier(UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF"), "Weapon modifier", newDamage, AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22283_, new AttributeModifier(UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3"), "Weapon modifier", newSpeed, AttributeModifier.Operation.ADDITION));
        }

        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            Entity sourceEntity = event.getSource().m_7639_();
            LivingEntity entity = event.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = entity;
                if (sourceEntity instanceof Player) {
                    Player player = (Player)sourceEntity;
                    ItemStack stack = player.m_21205_();
                    float baseDamage = event.getAmount();
                    if (!stack.m_41619_()) {
                        List<ItemStack> artifacts = CapabilityRegistry.getCap(player).getArtifacts().values().stream().toList();
                        Events.applyLifeSteal(player, livingEntity, stack, artifacts);
                        Events.applyEtherRegen(player, stack);
                        Events.applyStun(livingEntity, stack, artifacts);
                        Events.applyPoisonChance(livingEntity, stack, artifacts);
                        float attackBonus = ArtifactStatCalculator.getStatValue(stack, artifacts, StatType.ATTACK_POWER);
                        baseDamage += attackBonus;
                        float chance = ArtifactStatCalculator.getStatValue(stack, artifacts, StatType.CRIT_CHANCE);
                        if (entity.m_9236_().f_46441_.m_188501_() < chance / 100.0f) {
                            float critMultiplier = 1.0f + ArtifactStatCalculator.getStatValue(stack, artifacts, StatType.CRIT_DAMAGE) / 100.0f;
                            baseDamage *= critMultiplier;
                            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                        float armorPen = ArtifactStatCalculator.getStatValue(stack, artifacts, StatType.ARMOR_PEN);
                        float armor = livingEntity.m_21230_();
                        float effectiveArmor = Math.max(0.0f, armor * (1.0f - armorPen / 100.0f));
                        float armorReductionPercentage = Math.min(0.8f, effectiveArmor * 0.04f);
                        float preDamage = baseDamage * (1.0f - armorReductionPercentage);
                        float damageBonus = ArtifactStatCalculator.getStatValue(stack, artifacts, StatType.DAMAGE);
                        float finalDamage = preDamage * (1.0f + damageBonus / 100.0f);
                        event.setAmount(finalDamage);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onExpGain(PlayerXpEvent.PickupXp event) {
            Player player = event.getEntity();
            List<ItemStack> itemStacks = CapabilityRegistry.getCap(player).getArtifacts().values().stream().toList();
            float boost = ArtifactStatCalculator.getStatValue(itemStacks, StatType.EXP_BOOST);
            if (boost > 0.0f) {
                int extraExp = (int)((float)event.getOrb().m_20801_() * (boost / 100.0f));
                player.m_6756_(extraExp);
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(LivingEvent.LivingTickEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                List<ItemStack> itemStacks = CapabilityRegistry.getCap(player).getArtifacts().values().stream().toList();
                float movementSpeedBonus = ArtifactStatCalculator.getStatValue(player.m_21205_(), itemStacks, StatType.MOVEMENT_SPEED) / 100.0f;
                if (movementSpeedBonus != 0.0f) {
                    EntityUtils.resetAttribute((LivingEntity)player, Attributes.f_22279_, "etheria$movement_speed", movementSpeedBonus, AttributeModifier.Operation.MULTIPLY_TOTAL);
                } else if (player.f_19797_ % 20 == 0) {
                    EntityUtils.removeAttribute((LivingEntity)player, Attributes.f_22279_, "etheria$movement_speed");
                }
                float hearts = ArtifactStatCalculator.getStatValue(player.m_21205_(), itemStacks, StatType.MAX_HEALTH);
                EntityUtils.removeAttribute((LivingEntity)player, Attributes.f_22276_, "etheria$artifact$hearts");
                if (hearts > 0.0f) {
                    EntityUtils.resetAttribute((LivingEntity)player, Attributes.f_22276_, "etheria$artifact$hearts", hearts, AttributeModifier.Operation.ADDITION);
                }
            }
        }

        private static void applyLifeSteal(Player player, LivingEntity victimEntity, ItemStack stack, List<ItemStack> artifacts) {
            float chance = ArtifactStatCalculator.getStatValue(stack, artifacts, StatType.LIFE_STEAL);
            if (chance > 0.0f && Math.random() < (double)(chance / 100.0f)) {
                float healthSteal = (float)(1.0 + Math.random() * 1.0);
                victimEntity.m_6469_(player.m_9236_().m_269111_().m_269425_(), healthSteal);
                player.m_5634_(healthSteal);
            }
        }

        private static void applyStun(LivingEntity entity, ItemStack stack, List<ItemStack> artifacts) {
            float chance = ArtifactStatCalculator.getStatValue(stack, artifacts, StatType.STUN);
            if (chance > 0.0f && Math.random() < (double)(chance / 100.0f)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 40, true, false));
            }
        }

        private static void applyPoisonChance(LivingEntity entity, ItemStack stack, List<ItemStack> artifacts) {
            float chance = ArtifactStatCalculator.getStatValue(stack, artifacts, StatType.POISON_CHANCE);
            if (chance > 0.0f && Math.random() < (double)(chance / 100.0f)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 2, true, false));
            }
        }

        private static void applyEtherRegen(Player player, ItemStack stack) {
            float regenPercent;
            ItemStack etherItem = EtherUtils.findEtherVesselMax(player);
            if (!etherItem.m_41619_() && (regenPercent = ArtifactStatCalculator.getStatValue(stack, StatType.ETHER_REGEN)) > 0.0f) {
                int maxEther = EtherUtils.getMaxEther(etherItem);
                int regenAmount = (int)((float)maxEther * (regenPercent / 100.0f));
                int currentEther = EtherUtils.getEther(etherItem);
                if (currentEther < maxEther) {
                    EtherUtils.setEther(etherItem, Math.min(maxEther, currentEther + regenAmount));
                }
            }
        }
    }
}

