/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.blocks;

import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.magic.rituals.utils.RitualManager;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.StartRitualPacket;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.tiles.EtherAltarTile;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

public class EtherAltar
extends Block
implements EntityBlock,
IElementItem,
IMageMiconEntryItem {
    public EtherAltar() {
        super(BlockBehaviour.Properties.m_284310_().m_60953_(s -> 4).m_60999_().m_60978_(3.0f).m_60918_(SoundType.f_56730_).m_60955_());
    }

    @NotNull
    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        return List.of(new ItemStack((ItemLike)this));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, @NotNull BlockState state) {
        return new EtherAltarTile((BlockEntityType)TileRegistry.ETHER_ALTAR.get(), pos, state);
    }

    @Override
    public Element getElement() {
        return Element.ETHER;
    }

    public void m_6810_(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        EtherAltarTile tile;
        ItemStack stack;
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = worldIn.m_7702_(pos)) instanceof EtherAltarTile && (stack = (tile = (EtherAltarTile)blockEntity).getStack()) != null && !stack.m_41619_()) {
            worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof EtherAltarTile) {
                EtherAltarTile tile = (EtherAltarTile)t;
                EtherAltarTile.tick(level, blockPos, blockState, t);
            }
        };
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Stream.of(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)15.0), Block.m_49796_((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), Block.m_49796_((double)2.0, (double)10.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public Chapter getChapter() {
        return MageMiconUtils.getChapter("ether_constructs", "ritual_constructs");
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            BlockPos pos;
            LevelAccessor level = event.getLevel();
            if (!(level.m_7702_(pos = event.getPos()) instanceof EtherAltarTile)) {
                return;
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                RitualManager.breakRitual((Level)serverLevel, event.getPos());
            }
        }

        @SubscribeEvent
        public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
            BlockPos pos;
            LevelAccessor level = event.getLevel();
            BlockEntity blockEntity = level.m_7702_(pos = event.getPos());
            if (!(blockEntity instanceof EtherAltarTile)) {
                return;
            }
            EtherAltarTile tile = (EtherAltarTile)blockEntity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                tile.getRitualManager().init(serverLevel, tile.m_58899_());
            }
        }

        @SubscribeEvent
        public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
            EtherAltarTile tile;
            BlockEntity blockEntity = event.getLevel().m_7702_(event.getPos());
            if (blockEntity instanceof EtherAltarTile && (tile = (EtherAltarTile)blockEntity).getRitualManager().isBlocked()) {
                return;
            }
            InteractionHand hand = event.getHand();
            if (hand != InteractionHand.MAIN_HAND) {
                return;
            }
            if (!(event.getLevel().m_7702_(event.getPos()) instanceof EtherAltarTile)) {
                return;
            }
            Networking.sendToServer(new StartRitualPacket(event.getPos()));
            event.setCanceled(true);
        }
    }
}

