/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.blocks;

import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.ILoomItem;
import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.loom.data.LoomType;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.tiles.EtherLoomTile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

public class EtherLoom
extends Block
implements EntityBlock,
IElementItem,
IMageMiconEntryItem {
    public EtherLoom() {
        super(BlockBehaviour.Properties.m_284310_().m_60953_(s -> 4).m_60978_(1.5f).m_60918_(SoundType.f_56730_).m_60955_());
    }

    @NotNull
    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        return List.of(new ItemStack((ItemLike)this));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, @NotNull BlockState state) {
        return new EtherLoomTile(pos, state);
    }

    @Override
    public Element getElement() {
        return Element.ETHER;
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_60508_) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof EtherLoomTile)) {
            return InteractionResult.FAIL;
        }
        EtherLoomTile tile = (EtherLoomTile)blockEntity;
        BlockState oldState = level.m_8055_(pos);
        if (tile.getEtherLoomManager().isActive) {
            player.m_5661_((Component)Component.m_237115_((String)"etheria.gacha.warn").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        int size = 0;
        Item gachaItem = player.m_21120_(hand).m_41720_();
        if (!player.m_6144_() && tile.getStack().m_41619_() && player.m_21120_(hand).m_41720_() instanceof ILoomItem) {
            if (player.m_21120_(hand).m_41613_() >= 10) {
                size = 10;
                player.m_21120_(hand).m_41774_(10);
            } else {
                size = 1;
                player.m_21120_(hand).m_41774_(1);
            }
            ItemStack itemStack = gachaItem.m_7968_();
            itemStack.m_41764_(size);
            tile.setStack(itemStack);
            player.m_5661_((Component)Component.m_237115_((String)"etheria.gacha.start").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
        }
        if (player.m_6144_()) {
            ItemStack stack2;
            int emptySlots = 0;
            for (ItemStack stack2 : player.m_150109_().f_35974_) {
                if (!stack2.m_41619_()) continue;
                ++emptySlots;
            }
            if (emptySlots < size) {
                player.m_5661_((Component)Component.m_237115_((String)"etheria.gacha.inventory").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
                return InteractionResult.FAIL;
            }
            stack2 = tile.getStack().m_41720_();
            if (stack2 instanceof ILoomItem) {
                ILoomItem item = (ILoomItem)stack2;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    tile.getEtherLoomManager().setup((Level)serverLevel, pos);
                    tile.getEtherLoomManager().start((ServerPlayer)player, LoomType.LEGENDARY, item.getLoomId(), tile.getStack().m_41613_());
                }
            } else {
                tile.setStack(ItemStack.f_41583_);
            }
        }
        tile.m_6596_();
        level.m_7260_(pos, oldState, level.m_8055_(pos), 3);
        return InteractionResult.FAIL;
    }

    public void m_6807_(BlockState p_60566_, Level level, BlockPos pos, BlockState p_60569_, boolean p_60570_) {
        super.m_6807_(p_60566_, level, pos, p_60569_, p_60570_);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof EtherLoomTile)) {
            return;
        }
        EtherLoomTile tile = (EtherLoomTile)blockEntity;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            tile.getEtherLoomManager().setup((Level)serverLevel, tile.m_58899_());
        }
    }

    public void m_6810_(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = worldIn.m_7702_(pos)) instanceof EtherLoomTile) {
            EtherLoomTile tile = (EtherLoomTile)blockEntity;
            ItemStack stack = tile.getStack();
            if (!tile.getEtherLoomManager().isActive && stack != null && !stack.m_41619_()) {
                worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
            }
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TileRegistry.ETHER_LOOM.get() == type ? EtherLoomTile::tick : null;
    }

    @Override
    public Chapter getChapter() {
        return MageMiconUtils.getChapter("ether_constructs", "trials");
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onBlockBreack(BlockEvent.BreakEvent event) {
            BlockPos pos;
            LevelAccessor level = event.getLevel();
            BlockEntity blockEntity = level.m_7702_(pos = event.getPos());
            if (!(blockEntity instanceof EtherLoomTile)) {
                return;
            }
            EtherLoomTile tile = (EtherLoomTile)blockEntity;
            if (tile.getEtherLoomManager().isActive) {
                event.setCanceled(true);
            }
        }
    }
}

