/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.blocks;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.tiles.EtherSourceTile;
import it.mralxart.etheria.utils.ParticleUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EtherSource
extends Block
implements EntityBlock,
IElementItem,
IMageMiconEntryItem {
    public EtherSource() {
        super(BlockBehaviour.Properties.m_284310_().m_60953_(s -> 7).m_60999_().m_60978_(3.0f).m_60918_(SoundType.f_56742_).m_60955_());
    }

    @Override
    public Element getElement() {
        return Element.ETHER;
    }

    @NotNull
    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        return List.of(((Item)ItemRegistry.ETHER_CORE.get()).m_7968_());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EtherSourceTile(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TileRegistry.ETHER_SOURCE.get() == type ? EtherSourceTile::tick : null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        EtherSourceTile tile;
        ItemStack itemStack = p_60506_.m_21120_(p_60507_);
        if (itemStack.m_41720_().equals(ItemRegistry.ETHER_SHARD.get()) && (tile = (EtherSourceTile)p_60504_.m_7702_(p_60505_)) != null && tile.getEther() < tile.getMaxEther()) {
            tile.setEther(tile.getEther() + 2);
            itemStack.m_41774_(1);
            ParticleUtils.createParticle(p_60504_, new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.ETHER), 0.4f, 30, 0.025f), p_60505_.m_252807_().m_82520_(0.0, 0.5, 0.0), 30, 0.0, 0.0, 0.0, 0.01f);
        }
        return super.m_6227_(p_60503_, p_60504_, p_60505_, p_60506_, p_60507_, p_60508_);
    }

    @Override
    public Chapter getChapter() {
        return MageMiconUtils.getChapter("basics", "ether");
    }
}

