/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.bosses.golems;

import it.mralxart.etheria.bosses.BossMonster;
import it.mralxart.etheria.bosses.BossPathNavigation;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.entities.Airflow;
import it.mralxart.etheria.entities.Meteorite;
import it.mralxart.etheria.entities.ShockwaveEntity;
import it.mralxart.etheria.epicora.animations.AnimationStorage;
import it.mralxart.etheria.epicora.animations.base.IAnimatedEntity;
import it.mralxart.etheria.epicora.animations.components.Animation;
import it.mralxart.etheria.epicora.animations.components.AnimationSet;
import it.mralxart.etheria.epicora.animations.components.LoopMode;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.enigma.EnigmaUtils;
import it.mralxart.etheria.magic.spells.entities.ElementalBarrageSpear;
import it.mralxart.etheria.magic.spells.entities.ElementalStorm;
import it.mralxart.etheria.magic.spells.entities.ScreenShakeEntity;
import it.mralxart.etheria.magic.spells.entities.SpellWhirlEntity;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.JavaUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.RandomUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class Aerolith
extends BossMonster
implements IAnimatedEntity {
    public Map<String, Animation> animations = new HashMap<String, Animation>();
    public final AnimationController controller = new AnimationController(this);
    private final ServerBossEvent bossInfo = new ServerBossEvent((Component)Component.m_237113_((String)("" + this.m_19879_())), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_12);
    public static final EntityDataAccessor<String> ACTION = SynchedEntityData.m_135353_(Aerolith.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(Aerolith.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> TICKCOUNT = SynchedEntityData.m_135353_(Aerolith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ACTION_TICK = SynchedEntityData.m_135353_(Aerolith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ACTION_FLAG = SynchedEntityData.m_135353_(Aerolith.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SHIELD = SynchedEntityData.m_135353_(Aerolith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BLACK_HOLE = SynchedEntityData.m_135353_(Aerolith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DIFFICULTY = SynchedEntityData.m_135353_(Aerolith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String ACTION_IDLE = "idle";
    private static final String ACTION_PULL_AND_EXPLODE = "pull_explode";
    private static final String ACTION_METEORITES = "meteorites";
    private static final String ACTION_METEORITES_PLAYER = "meteorites_player";
    private static final String ACTION_AIRFLOW = "airflow";
    private static final String ACTION_STORM = "storm";
    private static final String ACTION_BLADES = "blades";
    private static final String ACTION_SHOCKWAVE = "shockwave";
    private static final String ACTION_AIRFLOW_PLAYER = "airflow_player";
    private static final String ACTION_BARRAGE_SPEAR = "barrage_spear";
    private static final String ACTION_BLACK_HOLE = "black_hole";
    private static final String ACTION_BREAK = "break";
    private static final String ACTION_MOBS = "mobs";
    private String lastAttack;
    private Vec3 savePos;
    private float actionTime = 0.0f;
    private int tickTarget = 0;

    public Animation getCurrentAnimation() {
        if (this.animations.get(this.getAnimation()) == null) {
            return Animation.EMPTY;
        }
        return this.animations.get(this.getAnimation());
    }

    public Aerolith(EntityType entity, Level world) {
        super(entity, world);
        this.m_21557_(false);
        this.m_21530_();
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_((Component)Component.m_237113_((String)"Aerolith"));
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (source == this.m_269291_().m_287172_()) {
            return super.m_6469_(source, damage);
        }
        if (this.getAction().equals(ACTION_BLACK_HOLE)) {
            this.setBlackHole(this.getBlackHole() - 1);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.2, 0.2, 0.2, 0.1);
            }
            return true;
        }
        if (source != this.m_269291_().m_269425_() && !this.getAction().equals(ACTION_IDLE) && !this.getAction().equals(ACTION_BREAK)) {
            return false;
        }
        if (source != this.m_269291_().m_269425_()) {
            if (this.getShield() > 0) {
                return false;
            }
            damage *= 0.5f;
        } else {
            damage = this.getShield() > 0 ? (damage *= 0.25f) : (damage *= 1.25f);
        }
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractGolem) {
            damage *= 0.5f;
        }
        if (this.m_21223_() <= this.m_21233_() / 2.0f) {
            damage *= 0.5f;
        }
        if (this.m_21223_() - damage <= 0.0f) {
            this.m_21153_(1.0f);
            this.setAction(ACTION_BLACK_HOLE);
            return false;
        }
        return super.m_6469_(source, damage);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new AerolithAttackGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 32.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean m_20147_() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
        this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public boolean m_7307_(@NotNull Entity entityIn) {
        if (entityIn == this) {
            return true;
        }
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof Aerolith) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTION, (Object)ACTION_IDLE);
        this.f_19804_.m_135372_(ACTION_TICK, (Object)0);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TICKCOUNT, (Object)0);
        this.f_19804_.m_135372_(SHIELD, (Object)30);
        this.f_19804_.m_135372_(BLACK_HOLE, (Object)0);
        this.f_19804_.m_135372_(DIFFICULTY, (Object)0);
        this.f_19804_.m_135372_(ACTION_FLAG, (Object)false);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_8119_() {
        super.m_8119_();
        this.controller.tick();
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.animations = AnimationStorage.getAnimations("gaiaar").getAnimations();
        if (this.animations != null) {
            Animation actionAnimation;
            String currentAction;
            float yOffset;
            boolean isHitAnimation;
            Animation animation;
            if (this.actionTime > 0.0f) {
                this.actionTime -= 0.05f;
            }
            Vec3 pos = this.m_20182_();
            double moved = Math.sqrt(pos.m_82531_(this.f_19854_, this.f_19855_, this.f_19856_));
            boolean posChanged = Math.abs(pos.f_82479_ - this.f_19854_) >= (double)0.00380625f || Math.abs(pos.f_82481_ - this.f_19856_) >= 0.00390625;
            LivingEntity target = this.m_5448_();
            if (!posChanged) {
                moved = 0.0;
            }
            boolean hasAnimation = (animation = this.getController().getLayer("action").getAnimation().getAnimation()) != Animation.EMPTY;
            boolean bl = isHitAnimation = animation != null && animation.getKey().equals("animation.model.hit");
            if (isHitAnimation) {
                this.f_21345_.m_25355_(Goal.Flag.MOVE);
                if (this.controller.stopAnimation("walk")) {
                    this.controller.stopAnimation("walk");
                }
            } else {
                this.f_21345_.m_25374_(Goal.Flag.MOVE);
                if (moved > 0.0) {
                    if (this.controller.startAnimation("walk", this.animations.get("animation.model.walk"), LoopMode.LOOP)) {
                        this.controller.startAnimation("walk", this.animations.get("animation.model.walk"), LoopMode.LOOP);
                    }
                } else {
                    this.controller.stopAnimation("walk");
                }
            }
            float yCenter = 1.5f;
            int shield = this.getShield();
            if (shield > 0) {
                yOffset = Mth.m_14031_((float)((float)Math.toRadians((float)this.f_19797_ * 2.0f))) * 0.25f;
                ParticleUtils.drawAnimatedCyl(this.m_9236_(), this.m_20182_().m_82520_(0.0, (double)(yCenter + yOffset), 0.0), this.f_19797_, 1.0, 20, 10, ElementsUtils.getRandomColorByElement(Element.AERO));
            }
            if (shield >= 11) {
                yOffset = Mth.m_14031_((float)((float)(-Math.toRadians((float)this.f_19797_ * 2.2f)))) * 0.35f;
                ParticleUtils.drawAnimatedCyl(this.m_9236_(), this.m_20182_().m_82520_(0.0, (double)(yCenter + yOffset), 0.0), this.f_19797_, 1.0, 20, 10, ElementsUtils.getRandomColorByElement(Element.AERO));
            }
            if (shield >= 21) {
                yOffset = Mth.m_14031_((float)((float)Math.toRadians((float)this.f_19797_ * 4.0f))) * 0.2f;
                ParticleUtils.drawAnimatedCyl(this.m_9236_(), this.m_20182_().m_82520_(0.0, (double)(yCenter + yOffset), 0.0), this.f_19797_, 1.0, 20, 10, ElementsUtils.getRandomColorByElement(Element.AERO));
            }
            if (!(currentAction = this.getAction()).equals(ACTION_IDLE)) {
                this.setActionTick(this.getActionTick() + 1);
                this.executeAttack(currentAction);
            }
            if (this.controller.getLayer("action") != null && (actionAnimation = this.animations.get(this.getAction())) != null) {
                this.controller.startAnimation("action", actionAnimation, LoopMode.ONCE);
            }
        }
        if (this.m_5448_() == null) {
            ++this.tickTarget;
            if (this.tickTarget >= 400) {
                this.m_146870_();
            }
        } else {
            this.tickTarget = 0;
        }
    }

    private void executeAttack(String action) {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            this.resetAction();
            return;
        }
        if (!action.equals(ACTION_STORM)) {
            this.controller.stopAnimation("sleep");
        }
        int difficulty = this.getDifficulty() + 1;
        AnimationSet animations = AnimationStorage.getAnimations("gaiaar");
        if (action.equals(ACTION_PULL_AND_EXPLODE)) {
            float radius = 11.0f;
            this.controller.startAnimation("action", animations.get("energy"), LoopMode.ONCE);
            if (this.getActionTick() >= 20 && this.getActionTick() <= 200) {
                if (this.getActionTick() < 24) {
                    this.setActionTick(24);
                    ScreenShakeEntity.summonShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.1f, 160, 30);
                }
                this.pullPlayers(this.m_20182_(), radius, 0.9f, 0.08f);
                ParticleUtils.drawParticlesToCenterWithSpiral(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.AERO), RandomUtils.random().nextFloat(0.2f, 0.6f), 30, 0.025f), this.m_9236_(), this.m_20182_().m_82520_(0.0, 1.0, 0.0), this.m_20182_().f_82480_, 20, radius + 2.0f, 0.65f, 0.5f);
                if (this.getActionTick() % 4 == 0) {
                    ParticleUtils.drawParticlesToCenterWithSpiral((ParticleOptions)ParticleTypes.f_123796_, this.m_9236_(), this.m_20182_().m_82520_(0.0, 1.0, 0.0), this.m_20182_().f_82480_, 20, radius + 2.0f, 0.5f, 0.5f);
                }
                if (this.getActionTick() % 20 / difficulty == 0) {
                    this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(2.0)).forEach(player -> {
                        player.m_6469_(this.m_269291_().m_269425_(), 3.0f);
                        Level patt17241$temp = this.m_9236_();
                        if (patt17241$temp instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)patt17241$temp;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), 5, 0.1, 0.2, 0.1, 0.2);
                        }
                    });
                }
            } else if (this.getActionTick() > 200) {
                this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_((double)radius)).forEach(player -> {
                    double distance = player.m_20270_((Entity)this);
                    if (distance < (double)radius) {
                        float damageMultiplier = (float)(1.0 - distance / (double)radius);
                        float finalDamage = 7.0f * (float)difficulty * damageMultiplier;
                        player.m_6469_(this.m_269291_().m_269036_((Entity)this, (Entity)this), finalDamage);
                    }
                });
                this.m_9236_().m_254849_((Entity)this, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_, 8.0f, Level.ExplosionInteraction.NONE);
                ShockwaveEntity shockwave = new ShockwaveEntity(this.m_9236_(), this.m_20182_(), (LivingEntity)this, 15.0f, 7.0f * (float)difficulty);
                shockwave.setSpeed(RandomUtils.random().nextFloat(0.4f, 0.7f));
                this.m_9236_().m_7967_((Entity)shockwave);
                ScreenShakeEntity.summonShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.15f, 80, 60);
                this.resetAction();
                this.controller.stopAnimation("action");
            }
        } else if (action.equals(ACTION_METEORITES_PLAYER)) {
            if (this.getActionTick() % 30 / difficulty == 0) {
                Meteorite meteorite = new Meteorite((EntityType<? extends Meteorite>)((EntityType)EntityRegistry.METEORITE.get()), this.m_9236_());
                meteorite.setElement((Element)((Object)JavaUtils.getRandomObject(new Object[]{Element.AERO, Element.CRYO, Element.PYRO})));
                meteorite.m_146884_(target.m_20182_().m_82520_(0.0, 20.0, 0.0));
                meteorite.setCenterPos(target.m_20182_());
                meteorite.m_20334_(0.0, -3.0, 0.0);
                meteorite.m_5602_((Entity)this);
                meteorite.setRadius(1.25f);
                meteorite.setDamage(5 * difficulty);
                this.m_9236_().m_7967_((Entity)meteorite);
            }
            if (this.getActionTick() >= 200) {
                this.resetAction();
            }
        } else if (action.equals(ACTION_METEORITES)) {
            Random random = RandomUtils.random();
            int offSet = 2 * difficulty;
            if (this.getActionTick() % random.nextInt(10 - offSet, 20 - offSet) == 0) {
                Vec3 center = this.m_20182_();
                int count = 3 + random.nextInt(8);
                for (int i = 0; i < count; ++i) {
                    double radius = 3.0 + random.nextDouble() * 12.0;
                    double angle = random.nextDouble() * 2.0 * Math.PI;
                    double offsetX = Math.cos(angle) * radius;
                    double offsetZ = Math.sin(angle) * radius;
                    Vec3 spawnPos = center.m_82520_(offsetX, 20.0, offsetZ);
                    Meteorite meteorite = new Meteorite((EntityType<? extends Meteorite>)((EntityType)EntityRegistry.METEORITE.get()), this.m_9236_());
                    meteorite.setElement((Element)((Object)JavaUtils.getRandomObject(new Object[]{Element.AERO, Element.CRYO, Element.PYRO})));
                    meteorite.m_146884_(spawnPos);
                    meteorite.setCenterPos(spawnPos.m_82520_(0.0, -20.0, 0.0));
                    meteorite.m_20334_(0.0, -2.2, 0.0);
                    meteorite.m_5602_((Entity)this);
                    meteorite.setRadius(2.0f);
                    meteorite.setDamage(8 * difficulty);
                    this.m_9236_().m_7967_((Entity)meteorite);
                }
            }
            if (this.getActionTick() >= 200) {
                this.resetAction();
            }
        } else if (action.equals(ACTION_AIRFLOW)) {
            int num = RandomUtils.random().nextInt(1, 3);
            int offSet = 2 * difficulty;
            for (int i = 0; i < num; ++i) {
                double angle = RandomUtils.random().nextDouble() * 2.0 * Math.PI;
                double radius = 4.0 + RandomUtils.random().nextDouble() * 6.0;
                double offsetX = Math.cos(angle) * radius;
                double offsetZ = Math.sin(angle) * radius;
                double spawnX = this.m_20185_() + offsetX;
                double spawnY = this.m_20186_();
                double spawnZ = this.m_20189_() + offsetZ;
                Airflow airflow = new Airflow((EntityType<? extends Projectile>)((EntityType)EntityRegistry.AIRFLOW.get()), this.m_9236_());
                airflow.m_6034_(spawnX, spawnY, spawnZ);
                airflow.setLife(num * 80);
                airflow.setRadius(RandomUtils.random().nextFloat(0.7f, 2.5f));
                airflow.setLvl(RandomUtils.random().nextInt(5, Math.max(6, 15 - offSet)));
                this.m_9236_().m_7967_((Entity)airflow);
            }
            this.controller.stopAnimation("action");
            this.selectAndStartAttack();
        } else if (action.equals(ACTION_STORM)) {
            int num = RandomUtils.random().nextInt(1, 6);
            this.controller.startAnimation("sleep", animations.get("sleep"), LoopMode.LOOP);
            if (this.getActionTick() <= 5) {
                this.setActionTick(6);
                for (int i = 0; i < num; ++i) {
                    double angle = RandomUtils.random().nextDouble() * 2.0 * Math.PI;
                    double radius = 4.0 + RandomUtils.random().nextDouble() * 6.0;
                    double offsetX = Math.cos(angle) * radius;
                    double offsetZ = Math.sin(angle) * radius;
                    double spawnX = this.m_20185_() + offsetX;
                    double spawnY = this.m_20186_();
                    double spawnZ = this.m_20189_() + offsetZ;
                    ElementalStorm storm = new ElementalStorm((EntityType<? extends Projectile>)((EntityType)EntityRegistry.FROZEN_STORM.get()), this.m_9236_());
                    storm.m_6034_(spawnX, spawnY, spawnZ);
                    storm.setRadius(3.0f);
                    storm.m_5602_((Entity)this);
                    storm.setDuration(140.0f);
                    storm.setElement(Element.AERO);
                    storm.setDamage(10 * difficulty);
                    this.m_9236_().m_7967_((Entity)storm);
                }
            }
            if (this.getActionTick() >= 140) {
                this.resetAction();
                this.controller.stopAnimation("sleep");
            }
        } else if (action.equals(ACTION_BLADES)) {
            float animTime;
            if (this.controller.getLayer("action").getAnimation().getAnimation().equals(Animation.EMPTY)) {
                this.controller.startAnimation("action", animations.get("energy2"), LoopMode.ONCE);
            }
            if ((animTime = this.controller.getLayer("action").getAnimTime(this.controller.getLayer("action").getAnimation(), this.controller.getControllerTime(0.0f))) >= 1.0f && animTime <= 2.4f) {
                this.setFlag(false);
            }
            if (!this.isFlag() && animTime >= 2.5f && animTime <= 2.8f) {
                this.setFlag(true);
                SpellWhirlEntity spell = new SpellWhirlEntity((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SPELL_WHIRL.get()), this.m_9236_());
                spell.setElement(((Element)((Object)JavaUtils.getRandomObject(new Object[]{Element.AERO, Element.AERO, Element.CRYO, Element.PYRO}))).name().toUpperCase());
                spell.m_5602_((Entity)this);
                spell.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                spell.m_20242_(true);
                spell.setDamage(8 * difficulty);
                Vec3 direction = new Vec3(target.m_20185_() - this.m_20185_(), target.m_20186_() - this.m_20186_(), target.m_20189_() - this.m_20189_()).m_82541_();
                double speed = 1.75;
                spell.m_20256_(direction.m_82490_(speed));
                this.m_9236_().m_7967_((Entity)spell);
            }
            if (this.getShield() == 0) {
                this.setShield(-1);
                this.resetAction();
                this.setAction(ACTION_BREAK);
            }
            if (this.getActionTick() >= 400) {
                this.resetAction();
            }
        } else if (action.equals(ACTION_AIRFLOW_PLAYER)) {
            this.controller.stopAnimation("action");
            this.controller.startAnimation("action2", animations.get("handup"), LoopMode.ONCE);
            float animTime = this.controller.getLayer("action2").getAnimTime(this.controller.getLayer("action2").getAnimation(), this.controller.getControllerTime(0.0f));
            if (animTime >= 0.25f && animTime <= 0.3f) {
                Airflow airflow = new Airflow((EntityType<? extends Projectile>)((EntityType)EntityRegistry.AIRFLOW.get()), this.m_9236_());
                airflow.m_146884_(target.m_20182_());
                airflow.setLife(60);
                airflow.setRadius(RandomUtils.random().nextFloat(0.7f, 2.5f));
                airflow.setLvl(RandomUtils.random().nextInt(5, Math.max(6, 10 - difficulty)));
                this.m_9236_().m_7967_((Entity)airflow);
                this.selectAndStartAttack();
                this.controller.stopAnimation("action");
            }
        } else if (action.equals(ACTION_SHOCKWAVE)) {
            this.controller.startAnimation("action2", animations.get("handup"), LoopMode.ONCE);
            float animTime = this.controller.getLayer("action2").getAnimTime(this.controller.getLayer("action2").getAnimation(), this.controller.getControllerTime(0.0f));
            if (animTime >= 0.25f && animTime <= 0.3f) {
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 2.0f, 0.5f);
                ShockwaveEntity shockwave = new ShockwaveEntity(this.m_9236_(), this.m_20182_(), (LivingEntity)this, 15.0f, 8 * difficulty);
                shockwave.setSpeed(RandomUtils.random().nextFloat(0.4f, 0.7f));
                this.m_9236_().m_7967_((Entity)shockwave);
                ScreenShakeEntity.summonShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.1f, 40, 60);
            }
            if (this.getActionTick() >= 160) {
                this.resetAction();
                this.controller.stopAnimation("action");
            }
        } else if (action.equals(ACTION_BARRAGE_SPEAR)) {
            if (this.getActionTick() % 20 == 0) {
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 2.0f, 0.5f);
                ElementalBarrageSpear barrageSpear = new ElementalBarrageSpear(this.m_9236_(), (LivingEntity)this, target, (Element)((Object)JavaUtils.getRandomObject(new Object[]{Element.AERO, Element.CRYO, Element.PYRO})), 6 * difficulty);
                barrageSpear.m_20256_(new Vec3(0.0, (double)0.6f, 0.0));
                this.m_9236_().m_7967_((Entity)barrageSpear);
            }
            if (this.getActionTick() >= 140) {
                this.resetAction();
                this.controller.stopAnimation("action");
            }
        } else if (action.equals(ACTION_BREAK)) {
            this.controller.startAnimation("action", animations.get("energy"), LoopMode.ONCE);
            if (this.getActionTick() >= 200) {
                this.resetAction();
                this.controller.stopAnimation("action");
            }
        } else if (action.equals(ACTION_MOBS)) {
            if (this.getActionTick() <= 2) {
                this.setActionTick(3);
                for (int i = 0; i < 2; ++i) {
                    Entity speed;
                    EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("skeleton"));
                    if (entityType == null || !((speed = entityType.m_20615_(this.m_9236_())) instanceof Mob)) continue;
                    Mob mob = (Mob)speed;
                    Vec3 spawnPoint = this.m_20182_().m_82549_(this.getRandomOffset(1.0));
                    double x = spawnPoint.f_82479_;
                    double y = spawnPoint.f_82480_ + 0.2;
                    double z = spawnPoint.f_82481_;
                    ItemStack helmet = new ItemStack((ItemLike)Items.f_42472_);
                    ItemStack chestplate = new ItemStack((ItemLike)Items.f_42473_);
                    ItemStack leggings = new ItemStack((ItemLike)Items.f_42474_);
                    ItemStack boots = new ItemStack((ItemLike)Items.f_42475_);
                    if (RandomUtils.random().nextDouble() < 0.5) {
                        switch (RandomUtils.random().nextInt(4)) {
                            case 0: {
                                this.applyArmorTrim(this.m_9236_().m_9598_(), helmet, RandomUtils.random());
                                mob.m_8061_(EquipmentSlot.HEAD, helmet);
                                break;
                            }
                            case 1: {
                                this.applyArmorTrim(this.m_9236_().m_9598_(), chestplate, RandomUtils.random());
                                mob.m_8061_(EquipmentSlot.CHEST, chestplate);
                                break;
                            }
                            case 2: {
                                this.applyArmorTrim(this.m_9236_().m_9598_(), leggings, RandomUtils.random());
                                mob.m_8061_(EquipmentSlot.LEGS, leggings);
                                break;
                            }
                            case 3: {
                                this.applyArmorTrim(this.m_9236_().m_9598_(), boots, RandomUtils.random());
                                mob.m_8061_(EquipmentSlot.FEET, boots);
                            }
                        }
                    }
                    if (mob instanceof Skeleton && this.f_19796_.m_188500_() < 0.5) {
                        mob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                    }
                    if (this.f_19796_.m_188500_() < 0.25) {
                        ItemStack weapon = new ItemStack((ItemLike)Items.f_42388_);
                        mob.m_8061_(EquipmentSlot.MAINHAND, weapon);
                    }
                    for (ItemStack slot : EquipmentSlot.values()) {
                        ItemStack item = mob.m_6844_((EquipmentSlot)slot);
                        if (item.m_41619_()) continue;
                        mob.m_21409_((EquipmentSlot)slot, 0.0f);
                    }
                    if (this.f_19796_.m_188500_() < 0.3) {
                        mob.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 600));
                    }
                    if (this.f_19796_.m_188500_() < 0.2) {
                        mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600));
                    }
                    if (this.f_19796_.m_188500_() < 0.2) {
                        mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 1, false, true));
                    } else if (this.f_19796_.m_188500_() < 0.1) {
                        mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 300, 1, false, true));
                    }
                    AttributeInstance maxHealthAttr = mob.m_21051_(Attributes.f_22276_);
                    if (maxHealthAttr != null) {
                        double baseHealth = maxHealthAttr.m_22115_();
                        double totalHealth = baseHealth + 50.0;
                        maxHealthAttr.m_22100_(totalHealth);
                        mob.m_21153_((float)totalHealth);
                    }
                    if (this.f_19796_.m_188500_() < 0.4) {
                        mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600));
                    }
                    if (this.f_19796_.m_188500_() < 0.2) {
                        mob.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600));
                    }
                    if (this.f_19796_.m_188500_() < 0.2) {
                        mob.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400));
                    }
                    if (this.f_19796_.m_188500_() < 0.2) {
                        mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 400));
                    }
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 1200));
                    if (this.f_19796_.m_188500_() < 0.4) {
                        mob.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600, 1));
                    }
                    if (this.f_19796_.m_188500_() < 0.3) {
                        mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600, 1));
                    }
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 600, 1));
                    mob.getPersistentData().m_128379_("ignoreArmorChance", true);
                    mob.getPersistentData().m_128379_("hasPiercingDamage", true);
                    mob.m_7678_(x, y, z, RandomUtils.random().nextFloat() * 360.0f, 0.0f);
                    this.m_9236_().m_7967_((Entity)mob);
                    ParticleUtils.createParticle(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123777_, x, y, z, 50, 0.0, 0.0, 0.0, 0.02);
                    ParticleUtils.createParticle(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123744_, x, y, z, 50, 0.0, 0.0, 0.0, 0.02);
                    if (!(target instanceof Player)) continue;
                    Player player1 = (Player)target;
                    ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(ElementsUtils.getColorByElement(ElementsUtils.getElement(player1)), 0.3f, 30, 0.01f), x, y, z, 15, 0.0, 0.0, 0.0, 0.02);
                }
            }
            if (this.getActionTick() >= 400) {
                this.resetAction();
                this.controller.stopAnimation("action");
            }
        } else if (action.equals(ACTION_BLACK_HOLE)) {
            this.controller.stopAnimation("action");
            this.controller.startAnimation(ACTION_BLACK_HOLE, animations.get(ACTION_BLACK_HOLE), LoopMode.ONCE);
            float animTime = this.controller.getLayer(ACTION_BLACK_HOLE).getAnimTime(this.controller.getLayer(ACTION_BLACK_HOLE).getAnimation(), this.controller.getControllerTime(0.0f));
            if (!this.isFlag() || Objects.equals(this.savePos, new Vec3(0.0, 0.0, 0.0))) {
                this.setFlag(true);
                this.setBlackHole(0);
                ScreenShakeEntity.summonShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.1f, 580, 60);
                double radius = 3.0 + this.f_19796_.m_188500_() * 12.0;
                double angle = this.f_19796_.m_188500_() * 2.0 * Math.PI;
                double offsetX = Math.cos(angle) * radius;
                double offsetZ = Math.sin(angle) * radius;
                this.savePos = this.m_20182_().m_82520_(offsetX, 0.0, offsetZ);
            }
            this.setBlackHole(this.getBlackHole() + 1);
            if (this.savePos != null && !Objects.equals(this.savePos, new Vec3(0.0, 0.0, 0.0))) {
                ParticleUtils.drawAnimatedCyl(this.m_9236_(), this.savePos, this.f_19797_, 1.5, 20, 10, ElementsUtils.getRandomColorByElement(Element.AERO));
            }
            if (animTime >= 30.0f) {
                if (this.getBlackHole() >= 400) {
                    AABB damageArea = new AABB(this.m_20183_()).m_82400_(15.0);
                    List potentialTargets = this.m_9236_().m_6443_(LivingEntity.class, damageArea, entity -> entity != this && entity.m_6084_());
                    boolean isSafeZone = !Objects.equals(this.savePos, new Vec3(0.0, 0.0, 0.0));
                    for (LivingEntity entity2 : potentialTargets) {
                        boolean isInSafeZone = false;
                        if (isSafeZone && entity2.m_20182_().m_82557_(this.savePos) <= 2.25) {
                            isInSafeZone = true;
                        }
                        if (isInSafeZone) continue;
                        entity2.m_6469_(this.m_269291_().m_269425_(), 60.0f);
                        Level level = this.m_9236_();
                        if (!(level instanceof ServerLevel)) continue;
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, entity2.m_20185_(), entity2.m_20227_(0.5), entity2.m_20189_(), 2, 0.5, 0.5, 0.5, 0.0);
                    }
                    Level entity2 = this.m_9236_();
                    if (entity2 instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)entity2;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_, 5, 0.0, 0.0, 0.0, 0.0);
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 2.0f, 0.5f);
                        ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(EnigmaUtils.startColor.getRGB(), 0.5f, 200, 0.25f, 1.0f, 0.9f, true, false, false), this.m_20182_().m_82520_(0.0, 5.6, 0.0), 140, 0.1f, 0.1f, 0.1f, 0.5);
                        ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(EnigmaUtils.endColor.getRGB(), 0.5f, 200, 0.25f, 1.0f, 0.9f, true, false, false), this.m_20182_().m_82520_(0.0, 5.6, 0.0), 140, 0.1f, 0.1f, 0.1f, 0.5);
                    }
                    ShockwaveEntity shockwave = new ShockwaveEntity(this.m_9236_(), this.m_20182_(), (LivingEntity)this, 15.0f, 15.0f);
                    shockwave.setSpeed(RandomUtils.random().nextFloat(0.4f, 0.7f));
                    this.m_9236_().m_7967_((Entity)shockwave);
                    ScreenShakeEntity.summonShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.15f, 100, 60);
                    Airflow airflow = new Airflow((EntityType<? extends Projectile>)((EntityType)EntityRegistry.AIRFLOW.get()), this.m_9236_());
                    airflow.m_146884_(target.m_20182_());
                    airflow.setLife(60);
                    airflow.setRadius(RandomUtils.random().nextFloat(1.5f));
                    airflow.setLvl(RandomUtils.random().nextInt(5, 7));
                    this.m_9236_().m_7967_((Entity)airflow);
                    this.m_21153_(this.m_21223_() + 100.0f);
                } else {
                    this.m_6469_(this.m_269291_().m_269425_(), 20.0f);
                }
                this.controller.stopAnimation(ACTION_BLACK_HOLE);
                this.resetAction();
                this.setAction(ACTION_BREAK);
                this.setBlackHole(0);
            }
        }
    }

    private void applyArmorTrim(RegistryAccess registryAccess, ItemStack armor, Random random) {
        List<Holder<TrimMaterial>> trimMaterials = this.getTrimMaterials(registryAccess);
        List<Holder<TrimPattern>> trimPatterns = this.getTrimPatterns(registryAccess);
        Holder<TrimMaterial> material = trimMaterials.get(random.nextInt(trimMaterials.size()));
        Holder<TrimPattern> pattern = trimPatterns.get(random.nextInt(trimPatterns.size()));
        ArmorTrim trim = new ArmorTrim(material, pattern);
        ArmorTrim.m_266570_((RegistryAccess)registryAccess, (ItemStack)armor, (ArmorTrim)trim);
    }

    private List<Holder<TrimMaterial>> getTrimMaterials(RegistryAccess registryAccess) {
        return registryAccess.m_175515_(Registries.f_266076_).m_203611_().collect(Collectors.toList());
    }

    private List<Holder<TrimPattern>> getTrimPatterns(RegistryAccess registryAccess) {
        return registryAccess.m_175515_(Registries.f_266063_).m_203611_().collect(Collectors.toList());
    }

    private Vec3 getRandomOffset(double radius) {
        double angle = new Random().nextDouble() * 2.0 * Math.PI;
        double x = radius * Math.cos(angle);
        double z = radius * Math.sin(angle);
        return new Vec3(x, 0.0, z);
    }

    protected InteractionResult m_6071_(Player p_21472_, InteractionHand p_21473_) {
        this.setShield(-1);
        AnimationSet animations = AnimationStorage.getAnimations("gaiaar");
        this.setAction(ACTION_BLACK_HOLE);
        this.setBlackHole(0);
        this.controller.startAnimation(ACTION_BLACK_HOLE, animations.get(ACTION_BLACK_HOLE), LoopMode.ONCE);
        return super.m_6071_(p_21472_, p_21473_);
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * (this.m_20077_() ? 0.2f : 1.0f));
        if (this.m_21515_() && this.m_20077_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.4));
        } else {
            super.m_7023_(travelVector);
        }
    }

    private void pullPlayers(Vec3 center, double radius, double strength, double factor) {
        AABB area = new AABB(center, center).m_82400_(radius);
        this.m_9236_().m_45976_(Player.class, area).forEach(player -> {
            if (!player.m_7500_() && !player.m_5833_()) {
                Vec3 directionToCenter = center.m_82546_(player.m_20182_()).m_82541_();
                Vec3 targetVelocity = directionToCenter.m_82490_(strength);
                Vec3 currentVelocity = player.m_20184_();
                Vec3 newVelocity = currentVelocity.m_165921_(targetVelocity, factor);
                player.m_20256_(newVelocity);
                player.f_19789_ = 0.0f;
                player.f_19864_ = true;
            }
        });
    }

    private String selectAndStartAttack() {
        String chosenAttack;
        this.setActionTick(0);
        List<String> attackPool = Arrays.asList(ACTION_PULL_AND_EXPLODE, ACTION_METEORITES_PLAYER, ACTION_AIRFLOW, ACTION_STORM, ACTION_BLADES, ACTION_BLADES, ACTION_AIRFLOW_PLAYER, ACTION_SHOCKWAVE, ACTION_BARRAGE_SPEAR);
        if (this.getShield() <= 0) {
            attackPool = Arrays.asList(ACTION_PULL_AND_EXPLODE, ACTION_METEORITES_PLAYER, ACTION_AIRFLOW, ACTION_STORM, ACTION_BLADES, ACTION_METEORITES, ACTION_AIRFLOW_PLAYER, ACTION_SHOCKWAVE, ACTION_BARRAGE_SPEAR);
        }
        if ((chosenAttack = attackPool.get(RandomUtils.random().nextInt(attackPool.size()))).equals(this.lastAttack)) {
            chosenAttack = attackPool.get(RandomUtils.random().nextInt(attackPool.size()));
        }
        this.setAction(chosenAttack);
        this.setLastAttack(chosenAttack);
        return chosenAttack;
    }

    public void resetAction() {
        this.setAction(ACTION_IDLE);
        this.setActionTick(0);
        this.setFlag(false);
    }

    @Override
    public void m_6153_() {
        AnimationSet animations = AnimationStorage.getAnimations("gaiaar");
        this.controller.startAnimation("death", animations.get("energy"), LoopMode.ONCE);
        ++this.f_20919_;
        if (this.f_20919_ == 80) {
            ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(new Color(213, 185, 237).getRGB(), 0.3f, 160, 0.025f, 1.0f, 0.9f, true, false, false), this.m_20182_().m_82520_(0.0, 1.0, 0.0), 80, 0.1f, 0.1f, 0.1f, 0.5);
            ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(new Color(253, 249, 255).getRGB(), 0.3f, 160, 0.025f, 1.0f, 0.9f, true, false, false), this.m_20182_().m_82520_(0.0, 1.0, 0.0), 80, 0.1f, 0.1f, 0.1f, 0.5);
            ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(new Color(190, 153, 222).getRGB(), 0.3f, 160, 0.025f, 1.0f, 0.9f, true, false, false), this.m_20182_().m_82520_(0.0, 1.0, 0.0), 80, 0.1f, 0.1f, 0.1f, 0.5);
            ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(new Color(226, 215, 249).getRGB(), 0.3f, 160, 0.025f, 1.0f, 0.9f, true, false, false), this.m_20182_().m_82520_(0.0, 1.0, 0.0), 80, 0.1f, 0.1f, 0.1f, 0.5);
        }
        if (this.f_20919_ >= 84) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("action", this.getAction());
        tag.m_128405_("tickCount", this.getTickCount());
        tag.m_128405_("action_tick", this.getActionTick());
        tag.m_128405_("shield", this.getShield());
        tag.m_128405_(ACTION_BLACK_HOLE, this.getBlackHole());
        tag.m_128405_("difficulty", this.getDifficulty());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAction(tag.m_128461_("action"));
        this.setTickCount(tag.m_128451_("tickCount"));
        this.setActionTick(tag.m_128451_("action_tick"));
        this.setBlackHole(tag.m_128451_(ACTION_BLACK_HOLE));
        this.setDifficulty(tag.m_128451_("difficulty"));
        if (this.getShield() != 30) {
            this.setShield(tag.m_128451_("shield"));
        }
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level p_21480_) {
        return new BossPathNavigation((Mob)this, p_21480_);
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public Entity getAnimatedEntity() {
        return this;
    }

    public static AttributeSupplier createAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 8.0).m_22265_();
    }

    public void m_7334_(Entity p_21294_) {
    }

    public void m_5997_(double p_20286_, double p_20287_, double p_20288_) {
    }

    public int getTickCount() {
        return (Integer)this.f_19804_.m_135370_(TICKCOUNT);
    }

    public void setTickCount(int tickCount) {
        this.f_19804_.m_135381_(TICKCOUNT, (Object)tickCount);
    }

    public String getAction() {
        return (String)this.f_19804_.m_135370_(ACTION);
    }

    public void setAction(String animation) {
        this.f_19804_.m_135381_(ACTION, (Object)animation);
    }

    public boolean isFlag() {
        return (Boolean)this.f_19804_.m_135370_(ACTION_FLAG);
    }

    public void setFlag(boolean data) {
        this.f_19804_.m_135381_(ACTION_FLAG, (Object)data);
    }

    public String getAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public int getActionTick() {
        return (Integer)this.f_19804_.m_135370_(ACTION_TICK);
    }

    public void setActionTick(int tick) {
        this.f_19804_.m_135381_(ACTION_TICK, (Object)tick);
    }

    public int getDifficulty() {
        return (Integer)this.f_19804_.m_135370_(DIFFICULTY);
    }

    public void setDifficulty(int tick) {
        this.f_19804_.m_135381_(DIFFICULTY, (Object)tick);
    }

    public int getBlackHole() {
        return (Integer)this.f_19804_.m_135370_(BLACK_HOLE);
    }

    public void setBlackHole(int tick) {
        this.f_19804_.m_135381_(BLACK_HOLE, (Object)tick);
    }

    public int getShield() {
        return (Integer)this.f_19804_.m_135370_(SHIELD);
    }

    public void setShield(int data) {
        this.f_19804_.m_135381_(SHIELD, (Object)data);
    }

    public Map<String, Animation> getAnimations() {
        return this.animations;
    }

    public ServerBossEvent getBossInfo() {
        return this.bossInfo;
    }

    public String getLastAttack() {
        return this.lastAttack;
    }

    public Vec3 getSavePos() {
        return this.savePos;
    }

    public float getActionTime() {
        return this.actionTime;
    }

    public int getTickTarget() {
        return this.tickTarget;
    }

    public void setLastAttack(String lastAttack) {
        this.lastAttack = lastAttack;
    }

    public void setSavePos(Vec3 savePos) {
        this.savePos = savePos;
    }

    public void setActionTime(float actionTime) {
        this.actionTime = actionTime;
    }

    public void setTickTarget(int tickTarget) {
        this.tickTarget = tickTarget;
    }

    public void setAnimations(Map<String, Animation> animations) {
        this.animations = animations;
    }

    static class AerolithAttackGoal
    extends Goal {
        private final Aerolith boss;
        private int attackCooldown = 20;
        private int timeLastAttack = 0;

        public AerolithAttackGoal(Aerolith boss) {
            this.boss = boss;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return this.boss.m_5448_() != null;
        }

        public boolean m_8045_() {
            return this.boss.m_5448_() != null && this.boss.m_5448_().m_6084_();
        }

        public void m_8041_() {
            super.m_8041_();
            this.boss.resetAction();
            this.timeLastAttack = 0;
        }

        public void m_8037_() {
            LivingEntity target = this.boss.m_5448_();
            if (target == null) {
                return;
            }
            if (!this.boss.getAction().equals(Aerolith.ACTION_PULL_AND_EXPLODE)) {
                this.boss.m_21563_().m_24946_(target.m_20185_(), target.m_20188_(), target.m_20189_());
            }
            if (this.boss.getAction().equals(Aerolith.ACTION_IDLE)) {
                ++this.timeLastAttack;
                if (this.timeLastAttack >= this.attackCooldown) {
                    if (!this.boss.m_9236_().f_46443_) {
                        this.boss.selectAndStartAttack();
                    }
                    this.timeLastAttack = 0;
                    this.attackCooldown = this.boss.getShield() > 0 ? Mth.m_216271_((RandomSource)this.boss.f_19796_, (int)5, (int)30) : Mth.m_216271_((RandomSource)this.boss.f_19796_, (int)40, (int)80);
                }
            }
        }
    }
}

