/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.capability;

import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.utils.NbtUtils;
import it.mralxart.etheria.utils.annotations.AutoSerialize;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class EntityCapability
implements INBTSerializable<CompoundTag> {
    @AutoSerialize
    boolean isFrozen = false;
    @AutoSerialize
    int timerTick = 0;
    @AutoSerialize
    int enigma = 0;
    private Map<Element, Integer> elements = new HashMap<Element, Integer>();

    public CompoundTag serializeNBT() {
        CompoundTag nbt = NbtUtils.serialize(this);
        CompoundTag elementsTag = new CompoundTag();
        for (Map.Entry<Element, Integer> entry : this.elements.entrySet()) {
            elementsTag.m_128405_(entry.getKey().name(), entry.getValue().intValue());
        }
        nbt.m_128365_("elements", (Tag)elementsTag);
        return nbt;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        NbtUtils.deserialize(this, compoundTag);
        this.elements.clear();
        CompoundTag elementsTag = compoundTag.m_128469_("elements");
        for (String key : elementsTag.m_128431_()) {
            this.elements.put(Element.valueOf(key), elementsTag.m_128451_(key));
        }
    }

    public void addElement(Element element, int duration) {
        this.elements.put(element, duration);
    }

    public void removeElement(Element element) {
        this.elements.remove((Object)element);
    }

    public boolean hasElement(Element element) {
        return this.elements.containsKey((Object)element);
    }

    public boolean hasElementDuration(Element element, int duration) {
        if (!this.elements.containsKey((Object)element)) {
            return false;
        }
        return this.elements.get((Object)element) >= duration;
    }

    public void tickElements() {
        this.elements.entrySet().removeIf(entry -> {
            int newDuration = (Integer)entry.getValue() - 20;
            if (newDuration <= 0) {
                return true;
            }
            entry.setValue(newDuration);
            return false;
        });
    }

    public void tick() {
        if (this.timerTick > 0) {
            --this.timerTick;
        }
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public int getTimerTick() {
        return this.timerTick;
    }

    public int getEnigma() {
        return this.enigma;
    }

    public Map<Element, Integer> getElements() {
        return this.elements;
    }

    public void setFrozen(boolean isFrozen) {
        this.isFrozen = isFrozen;
    }

    public void setTimerTick(int timerTick) {
        this.timerTick = timerTick;
    }

    public void setEnigma(int enigma) {
        this.enigma = enigma;
    }

    public void setElements(Map<Element, Integer> elements) {
        this.elements = elements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityCapability)) {
            return false;
        }
        EntityCapability other = (EntityCapability)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFrozen() != other.isFrozen()) {
            return false;
        }
        if (this.getTimerTick() != other.getTimerTick()) {
            return false;
        }
        if (this.getEnigma() != other.getEnigma()) {
            return false;
        }
        Map<Element, Integer> this$elements = this.getElements();
        Map<Element, Integer> other$elements = other.getElements();
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityCapability;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFrozen() ? 79 : 97);
        result = result * 59 + this.getTimerTick();
        result = result * 59 + this.getEnigma();
        Map<Element, Integer> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        return result;
    }

    public String toString() {
        return "EntityCapability(isFrozen=" + this.isFrozen() + ", timerTick=" + this.getTimerTick() + ", enigma=" + this.getEnigma() + ", elements=" + this.getElements() + ")";
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final EntityCapability backend = new EntityCapability();

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            return CapabilityRegistry.ENTITY.orEmpty(cap, LazyOptional.of(() -> this.backend));
        }

        public CompoundTag serializeNBT() {
            return this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT(nbt);
        }
    }
}

