/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.capability;

import it.mralxart.etheria.leveling.SkillStorage;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.data.CategoryInfo;
import it.mralxart.etheria.leveling.data.SkillData;
import it.mralxart.etheria.leveling.data.SkillInfo;
import it.mralxart.etheria.magemicon.MageMiconStorage;
import it.mralxart.etheria.magemicon.data.ConstellationInfo;
import it.mralxart.etheria.magemicon.data.StarData;
import it.mralxart.etheria.magemicon.data.StarInfo;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.loom.data.LoomType;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.spells.Spell;
import it.mralxart.etheria.magic.spells.SpellsCooldown;
import it.mralxart.etheria.magic.spells.data.SpellData;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.utils.NbtUtils;
import it.mralxart.etheria.utils.annotations.AutoSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class EtheriaCapability
implements INBTSerializable<CompoundTag> {
    Map<String, Spell> spells = new HashMap<String, Spell>();
    Map<String, SpellsCooldown> spellsCooldown = new HashMap<String, SpellsCooldown>();
    List<Chapter> chapters = new ArrayList<Chapter>();
    List<Element> elements = new ArrayList<Element>();
    Map<Integer, ItemStack> artifacts = new HashMap<Integer, ItemStack>();
    List<SkillData> skills = new ArrayList<SkillData>();
    List<StarData> stars = new ArrayList<StarData>();
    int[] smXp = new int[Branches.values().length];
    int[] smLevels = new int[Branches.values().length];
    @AutoSerialize
    boolean isNearSource = false;
    @AutoSerialize
    int skillPoints = 0;
    @AutoSerialize
    boolean isLoomHud = false;
    ItemStack loomItem = ItemStack.f_41583_;
    @AutoSerialize
    LoomType loomRoll = LoomType.COMMON;
    @AutoSerialize
    int legendaryRolls = 0;
    @AutoSerialize
    int epicRolls = 0;
    @AutoSerialize
    int mythicRolls = 0;
    @AutoSerialize
    int commonRolls = 0;
    @AutoSerialize
    Map<String, Integer> activeSpells = new HashMap<String, Integer>();
    @AutoSerialize
    Element element = Element.NONE;
    @AutoSerialize
    Element element2 = Element.NONE;
    @AutoSerialize
    int freezingTime = 0;
    @AutoSerialize
    int korLunar = 0;
    @AutoSerialize
    boolean first = false;

    public CompoundTag serializeNBT() {
        ListTag listTag;
        CompoundTag compoundTag = NbtUtils.serialize(this);
        CompoundTag loomItem = new CompoundTag();
        this.loomItem.m_41739_(loomItem);
        compoundTag.m_128365_("lootItem", (Tag)loomItem);
        ListTag cooldownTag = new ListTag();
        Object hashMap = new HashMap<String, SpellsCooldown>(this.spellsCooldown);
        for (Object data : hashMap.values()) {
            if (data == null) continue;
            cooldownTag.add((Object)((SpellsCooldown)data).serializeNBT());
        }
        compoundTag.m_128365_("cooldownSpells", (Tag)cooldownTag);
        if (this.chapters != null) {
            listTag = new ListTag();
            for (Chapter chapter : this.chapters) {
                if (chapter == null) continue;
                listTag.add((Object)chapter.serializeNBT());
            }
            compoundTag.m_128365_("chapters", (Tag)listTag);
        }
        if (this.elements != null) {
            listTag = new ListTag();
            for (Element element : this.elements) {
                if (element == null) continue;
                listTag.add((Object)StringTag.m_129297_((String)element.name().toLowerCase()));
            }
            compoundTag.m_128365_("elements", (Tag)listTag);
        }
        ListTag spellsTag = new ListTag();
        hashMap = new HashMap<String, Spell>(this.spells);
        for (Object data : hashMap.values()) {
            if (data == null) continue;
            spellsTag.add((Object)((Spell)data).serializeNBT());
        }
        compoundTag.m_128365_("spells", (Tag)spellsTag);
        ListTag artifactsList = new ListTag();
        for (Map.Entry<Integer, ItemStack> entry : this.artifacts.entrySet()) {
            CompoundTag artifactTag = new CompoundTag();
            artifactTag.m_128405_("id", entry.getKey().intValue());
            artifactTag.m_128365_("item", (Tag)entry.getValue().m_41739_(new CompoundTag()));
            artifactsList.add((Object)artifactTag);
        }
        compoundTag.m_128365_("artifacts", (Tag)artifactsList);
        compoundTag.m_128365_("skills", (Tag)this.serializeSkillsList());
        compoundTag.m_128365_("stars", (Tag)this.serializeStarsList());
        for (Branches skill : Branches.values()) {
            compoundTag.m_128405_(skill.name().toLowerCase() + "smXp", this.smXp[skill.ordinal()]);
            compoundTag.m_128405_(skill.name().toLowerCase() + "smLvl", this.smLevels[skill.ordinal()]);
        }
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        Object data;
        String id2;
        Object data2;
        CompoundTag skillTag;
        Object tag;
        Object skillsTag;
        Tag tag2;
        Object data3;
        CompoundTag compoundTag;
        Tag tag3;
        Iterator iterator;
        Object hashMap;
        Object listTag;
        CompoundTag tag4;
        NbtUtils.deserialize(this, nbt);
        Tag tag5 = nbt.m_128423_("lootItem");
        if (tag5 instanceof CompoundTag && !ItemStack.m_41712_((CompoundTag)(tag4 = (CompoundTag)tag5)).m_41619_()) {
            this.loomItem = ItemStack.m_41712_((CompoundTag)tag4);
        }
        List<SpellData> defaultSpellData = SpellsUtils.getDataSpells();
        this.spells.keySet().removeIf(spellId -> defaultSpellData.stream().noneMatch(spellData -> spellData.getId().equals(spellId)));
        this.spellsCooldown.keySet().removeIf(spellId -> defaultSpellData.stream().noneMatch(spellData -> spellData.getId().equals(spellId)));
        if (nbt.m_128425_("cooldownSpells", 9)) {
            listTag = nbt.m_128437_("cooldownSpells", 10);
            hashMap = new HashMap();
            iterator = listTag.iterator();
            while (iterator.hasNext()) {
                tag3 = (Tag)iterator.next();
                compoundTag = (CompoundTag)tag3;
                if (defaultSpellData.stream().noneMatch(spellData -> spellData.getId().equals(compoundTag.m_128461_("id")))) continue;
                data3 = new SpellsCooldown();
                ((SpellsCooldown)data3).deserializeNBT(compoundTag);
                hashMap.put(((SpellsCooldown)data3).getId(), data3);
            }
            this.spellsCooldown.clear();
            this.spellsCooldown.putAll((Map<String, SpellsCooldown>)hashMap);
        }
        if (nbt.m_128425_("spells", 9)) {
            listTag = nbt.m_128437_("spells", 10);
            hashMap = new HashMap();
            iterator = listTag.iterator();
            while (iterator.hasNext()) {
                tag3 = (Tag)iterator.next();
                compoundTag = (CompoundTag)tag3;
                if (defaultSpellData.stream().noneMatch(spellData -> spellData.getId().equals(compoundTag.m_128461_("id")))) continue;
                data3 = new Spell();
                ((Spell)data3).deserializeNBT(compoundTag);
                hashMap.put(((Spell)data3).getId(), data3);
            }
            this.spells.clear();
            this.spells.putAll((Map<String, Spell>)hashMap);
        }
        if (nbt.m_128425_("chapters", 9)) {
            listTag = nbt.m_128437_("chapters", 10);
            this.chapters.clear();
            hashMap = listTag.iterator();
            while (hashMap.hasNext()) {
                tag2 = (Tag)hashMap.next();
                CompoundTag compoundTag2 = (CompoundTag)tag2;
                Chapter chapter = new Chapter();
                chapter.deserializeNBT(compoundTag2);
                this.chapters.add(chapter);
            }
        }
        if (nbt.m_128425_("elements", 9)) {
            listTag = nbt.m_128437_("elements", 8);
            this.elements.clear();
            hashMap = listTag.iterator();
            while (hashMap.hasNext()) {
                tag2 = (Tag)hashMap.next();
                StringTag stringTag = (StringTag)tag2;
                Element element = Element.valueOf(stringTag.m_7916_().toUpperCase());
                this.elements.add(element);
            }
        }
        for (SpellData spellData2 : defaultSpellData) {
            String spellId2 = spellData2.getId();
            if (spellId2 == null) continue;
            this.spells.computeIfAbsent(spellId2, id -> new Spell((String)id, 0, false, false, spellData2.getElement()));
            this.spellsCooldown.computeIfAbsent(spellId2, SpellsCooldown::new);
        }
        this.artifacts.clear();
        ListTag artifactsList = nbt.m_128437_("artifacts", 10);
        for (int i = 0; i < artifactsList.size(); ++i) {
            CompoundTag artifactTag = artifactsList.m_128728_(i);
            int id3 = artifactTag.m_128451_("id");
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)artifactTag.m_128469_("item"));
            this.artifacts.put(id3, itemStack);
        }
        for (Branches skill2 : Branches.values()) {
            this.smXp[skill2.ordinal()] = nbt.m_128451_(skill2.name().toLowerCase() + "smXp");
            this.smLevels[skill2.ordinal()] = nbt.m_128451_(skill2.name().toLowerCase() + "smLvl");
        }
        if (nbt.m_128425_("stars", 9)) {
            skillsTag = nbt.m_128437_("stars", 10);
            ArrayList<StarData> newSkills = new ArrayList<StarData>();
            Iterator id3 = skillsTag.iterator();
            while (id3.hasNext()) {
                tag = (Tag)id3.next();
                skillTag = (CompoundTag)tag;
                data2 = new StarData();
                ((StarData)data2).deserializeNBT(skillTag);
                newSkills.add((StarData)data2);
            }
            this.stars.clear();
            this.stars.addAll(newSkills);
        }
        for (ConstellationInfo info : MageMiconStorage.DATA.getConstellations().values()) {
            Map<String, StarInfo> defaultSkillData = info.getStars();
            for (StarInfo starInfo : defaultSkillData.values()) {
                id2 = starInfo.getId();
                if (!this.stars.isEmpty()) {
                    if (!this.stars.stream().noneMatch(skill -> skill.getId() != null && skill.getId().equals(id2))) continue;
                    data = new StarData();
                    ((StarData)data).setId(id2);
                    ((StarData)data).setActive(false);
                    this.stars.add((StarData)data);
                    continue;
                }
                data = new StarData();
                ((StarData)data).setId(id2);
                ((StarData)data).setActive(false);
                this.stars.add((StarData)data);
            }
        }
        if (nbt.m_128425_("skills", 9)) {
            skillsTag = nbt.m_128437_("skills", 10);
            ArrayList<Object> newSkills = new ArrayList<Object>();
            Iterator defaultSkillData = skillsTag.iterator();
            while (defaultSkillData.hasNext()) {
                tag = (Tag)defaultSkillData.next();
                skillTag = (CompoundTag)tag;
                data2 = new SkillData();
                ((SkillData)data2).deserializeNBT(skillTag);
                newSkills.add(data2);
            }
            this.skills.clear();
            this.skills.addAll(newSkills);
        }
        for (CategoryInfo info : SkillStorage.CATEGORYS.values()) {
            Map<String, SkillInfo> defaultSkillData = info.getSkills();
            for (SkillInfo skillData : defaultSkillData.values()) {
                id2 = skillData.getId();
                if (!this.skills.isEmpty()) {
                    if (!this.skills.stream().noneMatch(skill -> skill.getId() != null && skill.getId().equals(id2))) continue;
                    data = new SkillData();
                    ((SkillData)data).setId(id2);
                    ((SkillData)data).setPurchased(false);
                    ((SkillData)data).setLvl(0);
                    this.skills.add((SkillData)data);
                    continue;
                }
                data = new SkillData();
                ((SkillData)data).setId(id2);
                ((SkillData)data).setPurchased(false);
                ((SkillData)data).setLvl(0);
                this.skills.add((SkillData)data);
            }
        }
    }

    private ListTag serializeSkillsList() {
        ListTag skillsTag = new ListTag();
        if (this.skills.isEmpty()) {
            for (CategoryInfo categoryInfo : SkillStorage.CATEGORYS.values()) {
                Map<String, SkillInfo> map = categoryInfo.getSkills();
                for (SkillInfo skillData : map.values()) {
                    SkillData data;
                    String id = skillData.getId();
                    if (!this.skills.isEmpty()) {
                        if (!this.skills.stream().noneMatch(skill -> skill.getId() != null && skill.getId().equals(id))) continue;
                        data = new SkillData();
                        data.setId(id);
                        data.setPurchased(false);
                        data.setLvl(0);
                        this.skills.add(data);
                        continue;
                    }
                    data = new SkillData();
                    data.setId(id);
                    data.setPurchased(false);
                    data.setLvl(0);
                    this.skills.add(data);
                }
            }
        }
        boolean full = false;
        for (SkillData skillData : this.skills) {
            if (!skillData.getId().equals("combat:2")) continue;
            full = true;
            break;
        }
        if (!full) {
            for (SkillInfo skillInfo : SkillStorage.COMBAT.getSkills().values()) {
                SkillData data = new SkillData();
                data.setId(skillInfo.getId());
                data.setPurchased(false);
                data.setLvl(0);
                this.skills.add(data);
            }
        }
        ArrayList<SkillData> arrayList = new ArrayList<SkillData>(this.skills);
        for (SkillData skill2 : arrayList) {
            if (skill2 == null) continue;
            skillsTag.add((Object)skill2.serializeNBT());
        }
        return skillsTag;
    }

    private ListTag serializeStarsList() {
        ListTag skillsTag = new ListTag();
        if (MageMiconStorage.DATA == null || MageMiconStorage.DATA.getConstellations().isEmpty()) {
            MageMiconStorage.build();
        }
        for (ConstellationInfo info : MageMiconStorage.DATA.getConstellations().values()) {
            Map<String, StarInfo> defaultSkillData = info.getStars();
            for (StarInfo starInfo : defaultSkillData.values()) {
                StarData data;
                String id = starInfo.getId();
                if (!this.stars.isEmpty()) {
                    if (!this.stars.stream().noneMatch(skill -> skill.getId() != null && skill.getId().equals(id))) continue;
                    data = new StarData();
                    data.setId(id);
                    data.setActive(false);
                    this.stars.add(data);
                    continue;
                }
                data = new StarData();
                data.setId(id);
                data.setActive(false);
                this.stars.add(data);
            }
        }
        ArrayList<StarData> skillData = new ArrayList<StarData>(this.stars);
        for (StarData data : skillData) {
            if (data == null) continue;
            skillsTag.add((Object)data.serializeNBT());
        }
        return skillsTag;
    }

    public void setSmLevel(Branches skill, int level) {
        this.smLevels[skill.ordinal()] = level;
    }

    public int getSmLevel(Branches skill) {
        return this.smLevels[skill.ordinal()];
    }

    public void setSmXp(Branches skill, int xp) {
        this.smXp[skill.ordinal()] = xp;
    }

    public int getSmXp(Branches skill) {
        return this.smXp[skill.ordinal()];
    }

    public boolean putChapter(Chapter newChapter) {
        for (Chapter chapter : this.chapters) {
            if (!chapter.equals(newChapter)) continue;
            return false;
        }
        return this.chapters.add(newChapter);
    }

    public Map<String, Spell> getSpells() {
        return this.spells;
    }

    public Map<String, SpellsCooldown> getSpellsCooldown() {
        return this.spellsCooldown;
    }

    public List<Chapter> getChapters() {
        return this.chapters;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public Map<Integer, ItemStack> getArtifacts() {
        return this.artifacts;
    }

    public List<SkillData> getSkills() {
        return this.skills;
    }

    public List<StarData> getStars() {
        return this.stars;
    }

    public int[] getSmXp() {
        return this.smXp;
    }

    public int[] getSmLevels() {
        return this.smLevels;
    }

    public boolean isNearSource() {
        return this.isNearSource;
    }

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public boolean isLoomHud() {
        return this.isLoomHud;
    }

    public ItemStack getLoomItem() {
        return this.loomItem;
    }

    public LoomType getLoomRoll() {
        return this.loomRoll;
    }

    public int getLegendaryRolls() {
        return this.legendaryRolls;
    }

    public int getEpicRolls() {
        return this.epicRolls;
    }

    public int getMythicRolls() {
        return this.mythicRolls;
    }

    public int getCommonRolls() {
        return this.commonRolls;
    }

    public Map<String, Integer> getActiveSpells() {
        return this.activeSpells;
    }

    public Element getElement() {
        return this.element;
    }

    public Element getElement2() {
        return this.element2;
    }

    public int getFreezingTime() {
        return this.freezingTime;
    }

    public int getKorLunar() {
        return this.korLunar;
    }

    public boolean isFirst() {
        return this.first;
    }

    public void setSpells(Map<String, Spell> spells) {
        this.spells = spells;
    }

    public void setSpellsCooldown(Map<String, SpellsCooldown> spellsCooldown) {
        this.spellsCooldown = spellsCooldown;
    }

    public void setChapters(List<Chapter> chapters) {
        this.chapters = chapters;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public void setArtifacts(Map<Integer, ItemStack> artifacts) {
        this.artifacts = artifacts;
    }

    public void setSkills(List<SkillData> skills) {
        this.skills = skills;
    }

    public void setStars(List<StarData> stars) {
        this.stars = stars;
    }

    public void setSmXp(int[] smXp) {
        this.smXp = smXp;
    }

    public void setSmLevels(int[] smLevels) {
        this.smLevels = smLevels;
    }

    public void setNearSource(boolean isNearSource) {
        this.isNearSource = isNearSource;
    }

    public void setSkillPoints(int skillPoints) {
        this.skillPoints = skillPoints;
    }

    public void setLoomHud(boolean isLoomHud) {
        this.isLoomHud = isLoomHud;
    }

    public void setLoomItem(ItemStack loomItem) {
        this.loomItem = loomItem;
    }

    public void setLoomRoll(LoomType loomRoll) {
        this.loomRoll = loomRoll;
    }

    public void setLegendaryRolls(int legendaryRolls) {
        this.legendaryRolls = legendaryRolls;
    }

    public void setEpicRolls(int epicRolls) {
        this.epicRolls = epicRolls;
    }

    public void setMythicRolls(int mythicRolls) {
        this.mythicRolls = mythicRolls;
    }

    public void setCommonRolls(int commonRolls) {
        this.commonRolls = commonRolls;
    }

    public void setActiveSpells(Map<String, Integer> activeSpells) {
        this.activeSpells = activeSpells;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setElement2(Element element2) {
        this.element2 = element2;
    }

    public void setFreezingTime(int freezingTime) {
        this.freezingTime = freezingTime;
    }

    public void setKorLunar(int korLunar) {
        this.korLunar = korLunar;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EtheriaCapability)) {
            return false;
        }
        EtheriaCapability other = (EtheriaCapability)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNearSource() != other.isNearSource()) {
            return false;
        }
        if (this.getSkillPoints() != other.getSkillPoints()) {
            return false;
        }
        if (this.isLoomHud() != other.isLoomHud()) {
            return false;
        }
        if (this.getLegendaryRolls() != other.getLegendaryRolls()) {
            return false;
        }
        if (this.getEpicRolls() != other.getEpicRolls()) {
            return false;
        }
        if (this.getMythicRolls() != other.getMythicRolls()) {
            return false;
        }
        if (this.getCommonRolls() != other.getCommonRolls()) {
            return false;
        }
        if (this.getFreezingTime() != other.getFreezingTime()) {
            return false;
        }
        if (this.getKorLunar() != other.getKorLunar()) {
            return false;
        }
        if (this.isFirst() != other.isFirst()) {
            return false;
        }
        Map<String, Spell> this$spells = this.getSpells();
        Map<String, Spell> other$spells = other.getSpells();
        if (this$spells == null ? other$spells != null : !((Object)this$spells).equals(other$spells)) {
            return false;
        }
        Map<String, SpellsCooldown> this$spellsCooldown = this.getSpellsCooldown();
        Map<String, SpellsCooldown> other$spellsCooldown = other.getSpellsCooldown();
        if (this$spellsCooldown == null ? other$spellsCooldown != null : !((Object)this$spellsCooldown).equals(other$spellsCooldown)) {
            return false;
        }
        List<Chapter> this$chapters = this.getChapters();
        List<Chapter> other$chapters = other.getChapters();
        if (this$chapters == null ? other$chapters != null : !((Object)this$chapters).equals(other$chapters)) {
            return false;
        }
        List<Element> this$elements = this.getElements();
        List<Element> other$elements = other.getElements();
        if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
            return false;
        }
        Map<Integer, ItemStack> this$artifacts = this.getArtifacts();
        Map<Integer, ItemStack> other$artifacts = other.getArtifacts();
        if (this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts)) {
            return false;
        }
        List<SkillData> this$skills = this.getSkills();
        List<SkillData> other$skills = other.getSkills();
        if (this$skills == null ? other$skills != null : !((Object)this$skills).equals(other$skills)) {
            return false;
        }
        List<StarData> this$stars = this.getStars();
        List<StarData> other$stars = other.getStars();
        if (this$stars == null ? other$stars != null : !((Object)this$stars).equals(other$stars)) {
            return false;
        }
        if (!Arrays.equals(this.getSmXp(), other.getSmXp())) {
            return false;
        }
        if (!Arrays.equals(this.getSmLevels(), other.getSmLevels())) {
            return false;
        }
        ItemStack this$loomItem = this.getLoomItem();
        ItemStack other$loomItem = other.getLoomItem();
        if (this$loomItem == null ? other$loomItem != null : !this$loomItem.equals(other$loomItem)) {
            return false;
        }
        LoomType this$loomRoll = this.getLoomRoll();
        LoomType other$loomRoll = other.getLoomRoll();
        if (this$loomRoll == null ? other$loomRoll != null : !((Object)((Object)this$loomRoll)).equals((Object)other$loomRoll)) {
            return false;
        }
        Map<String, Integer> this$activeSpells = this.getActiveSpells();
        Map<String, Integer> other$activeSpells = other.getActiveSpells();
        if (this$activeSpells == null ? other$activeSpells != null : !((Object)this$activeSpells).equals(other$activeSpells)) {
            return false;
        }
        Element this$element = this.getElement();
        Element other$element = other.getElement();
        if (this$element == null ? other$element != null : !((Object)((Object)this$element)).equals((Object)other$element)) {
            return false;
        }
        Element this$element2 = this.getElement2();
        Element other$element2 = other.getElement2();
        return !(this$element2 == null ? other$element2 != null : !((Object)((Object)this$element2)).equals((Object)other$element2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EtheriaCapability;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNearSource() ? 79 : 97);
        result = result * 59 + this.getSkillPoints();
        result = result * 59 + (this.isLoomHud() ? 79 : 97);
        result = result * 59 + this.getLegendaryRolls();
        result = result * 59 + this.getEpicRolls();
        result = result * 59 + this.getMythicRolls();
        result = result * 59 + this.getCommonRolls();
        result = result * 59 + this.getFreezingTime();
        result = result * 59 + this.getKorLunar();
        result = result * 59 + (this.isFirst() ? 79 : 97);
        Map<String, Spell> $spells = this.getSpells();
        result = result * 59 + ($spells == null ? 43 : ((Object)$spells).hashCode());
        Map<String, SpellsCooldown> $spellsCooldown = this.getSpellsCooldown();
        result = result * 59 + ($spellsCooldown == null ? 43 : ((Object)$spellsCooldown).hashCode());
        List<Chapter> $chapters = this.getChapters();
        result = result * 59 + ($chapters == null ? 43 : ((Object)$chapters).hashCode());
        List<Element> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        Map<Integer, ItemStack> $artifacts = this.getArtifacts();
        result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
        List<SkillData> $skills = this.getSkills();
        result = result * 59 + ($skills == null ? 43 : ((Object)$skills).hashCode());
        List<StarData> $stars = this.getStars();
        result = result * 59 + ($stars == null ? 43 : ((Object)$stars).hashCode());
        result = result * 59 + Arrays.hashCode(this.getSmXp());
        result = result * 59 + Arrays.hashCode(this.getSmLevels());
        ItemStack $loomItem = this.getLoomItem();
        result = result * 59 + ($loomItem == null ? 43 : $loomItem.hashCode());
        LoomType $loomRoll = this.getLoomRoll();
        result = result * 59 + ($loomRoll == null ? 43 : ((Object)((Object)$loomRoll)).hashCode());
        Map<String, Integer> $activeSpells = this.getActiveSpells();
        result = result * 59 + ($activeSpells == null ? 43 : ((Object)$activeSpells).hashCode());
        Element $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : ((Object)((Object)$element)).hashCode());
        Element $element2 = this.getElement2();
        result = result * 59 + ($element2 == null ? 43 : ((Object)((Object)$element2)).hashCode());
        return result;
    }

    public String toString() {
        return "EtheriaCapability(spells=" + this.getSpells() + ", spellsCooldown=" + this.getSpellsCooldown() + ", chapters=" + this.getChapters() + ", elements=" + this.getElements() + ", artifacts=" + this.getArtifacts() + ", skills=" + this.getSkills() + ", stars=" + this.getStars() + ", smXp=" + Arrays.toString(this.getSmXp()) + ", smLevels=" + Arrays.toString(this.getSmLevels()) + ", isNearSource=" + this.isNearSource() + ", skillPoints=" + this.getSkillPoints() + ", isLoomHud=" + this.isLoomHud() + ", loomItem=" + this.getLoomItem() + ", loomRoll=" + this.getLoomRoll() + ", legendaryRolls=" + this.getLegendaryRolls() + ", epicRolls=" + this.getEpicRolls() + ", mythicRolls=" + this.getMythicRolls() + ", commonRolls=" + this.getCommonRolls() + ", activeSpells=" + this.getActiveSpells() + ", element=" + this.getElement() + ", element2=" + this.getElement2() + ", freezingTime=" + this.getFreezingTime() + ", korLunar=" + this.getKorLunar() + ", first=" + this.isFirst() + ")";
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final EtheriaCapability backend = new EtheriaCapability();

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            return CapabilityRegistry.ETHERIA.orEmpty(cap, LazyOptional.of(() -> this.backend));
        }

        public CompoundTag serializeNBT() {
            return this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT(nbt);
        }
    }
}

