/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.mralxart.etheria.EtheriaClient;
import it.mralxart.etheria.client.gui.base.ICustomScaledGui;
import it.mralxart.etheria.client.gui.magemicon.widgets.CometWidget;
import it.mralxart.etheria.client.utils.GuiUtils;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.loom.EtherLoomManager;
import it.mralxart.etheria.magic.loom.data.LoomType;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.C2SPacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.utils.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class EtherLoomScreen
extends Screen
implements ICustomScaledGui {
    private static final Minecraft MC = Minecraft.m_91087_();
    private int tickCount = 0;
    private float scale;
    private float offX = 0.0f;
    private long lastTime = 0L;
    private final List<CometWidget> comets = new ArrayList<CometWidget>();
    private static final float ROOT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public EtherLoomScreen() {
        super((Component)Component.m_237119_());
        if (this.f_96541_ == null) {
            this.f_96541_ = Minecraft.m_91087_();
        }
        this.scale = 4.0f;
        Random random = new Random();
        for (int i = 0; i < 5; ++i) {
            this.comets.add(new CometWidget(random.nextFloat() * (float)this.f_96543_ - (float)random.nextInt(400), random.nextFloat() * (float)this.f_96544_ - (float)random.nextInt(400), 1.6f + random.nextFloat() * 0.8f, random.nextInt(300) + random.nextInt(300)));
        }
    }

    public void m_7856_() {
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float ticks) {
        if (this.f_96541_ == null) {
            return;
        }
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        PoseStack poseStack = guiGraphics.m_280168_();
        Window window = MC.m_91268_();
        LocalPlayer player = EtherLoomScreen.MC.f_91074_;
        if (player != null) {
            long currentTime = System.currentTimeMillis();
            long deltaTime = currentTime - this.lastTime;
            this.lastTime = currentTime;
            ++this.tickCount;
            int centerX = window.m_85445_() / 2;
            int centerY = window.m_85446_() / 2;
            ItemStack stack = CapabilityRegistry.getCap((Player)player).getLoomItem().m_41777_();
            if (stack != null) {
                float smoothProgress;
                float progress;
                if (this.offX >= 24.0f) {
                    poseStack.m_85836_();
                    poseStack.m_252880_((float)centerX - 130.0f + 138.0f, (float)centerY - 130.0f + 133.0f, 150.0f);
                    RenderUtils.renderDragonEffect(poseStack, (MultiBufferSource)guiGraphics.m_280091_(), (float)this.tickCount / 2.0f, ticks, 100.0f, 1.0f, 1.0f, 1.0f, stack.m_41778_().length());
                    poseStack.m_85849_();
                }
                float alpha = 1.0f;
                float colorFactor = 0.1f;
                float flashDuration = 80.0f;
                float shakeX = 0.0f;
                float shakeY = 0.0f;
                float scaleFlash = 0.0f;
                if (this.tickCount > 0 && this.tickCount < 60 && this.scale > 2.0f) {
                    progress = (float)this.tickCount / 60.0f;
                    smoothProgress = progress * progress * (3.0f - 2.0f * progress);
                    this.scale = 4.0f / smoothProgress;
                }
                if (this.tickCount >= 60 && this.tickCount < 140) {
                    progress = (float)(this.tickCount - 60) / 80.0f;
                    smoothProgress = progress * progress * (3.0f - 2.0f * progress);
                    this.offX = 25.0f * smoothProgress;
                    if (progress >= 0.7f) {
                        float shakeProgress = (progress - 0.7f) / 0.3f;
                        shakeX = (float)(Math.random() - 0.5) * 2.0f * 5.0f * shakeProgress;
                        shakeY = (float)(Math.random() - 0.5) * 2.0f * 5.0f * shakeProgress;
                    }
                }
                if (this.tickCount >= 140 && (float)this.tickCount < 140.0f + flashDuration) {
                    float flashProgress = (float)(this.tickCount - 140) / flashDuration;
                    float flashIntensity = 1.0f + 5.0f * (1.0f - flashProgress);
                    colorFactor = 0.1f + 0.9f * flashProgress * flashIntensity;
                    scaleFlash = (1.0f - flashProgress) * 0.6f;
                } else if ((float)this.tickCount >= 140.0f + flashDuration) {
                    colorFactor = 1.0f;
                }
                RenderSystem.setShaderColor((float)colorFactor, (float)colorFactor, (float)colorFactor, (float)alpha);
                float splashScale = this.scale / 4.0f + scaleFlash;
                poseStack.m_85836_();
                poseStack.m_85841_(splashScale, splashScale, splashScale);
                poseStack.m_252880_(((float)centerX + shakeX) / splashScale, ((float)centerY + shakeY) / splashScale, 50.0f);
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/roll_item.png"), (int)(-154.0f + this.offX), -130, 0.0f, 0.0f, 260, 260, 260, 260);
                poseStack.m_85849_();
                if (this.offX > 1.0f) {
                    String name = stack.m_41611_().getString().replace("[", "").replace("]", "");
                    Item item = stack.m_41720_();
                    if (item instanceof IElementItem) {
                        IElementItem elementItem = (IElementItem)item;
                        Element element = elementItem.getElement(stack);
                        int xOff = 0;
                        switch (element) {
                            case PYRO: {
                                xOff = 16;
                                break;
                            }
                            case CRYO: {
                                xOff = 8;
                            }
                        }
                        int textX = (int)((float)(centerX - 220 + 11) - this.offX);
                        guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/elements.png"), textX - 10, centerY, (float)xOff, 0.0f, 8, 8, 24, 8);
                    }
                    LoomType roll = CapabilityRegistry.getCap((Player)player).getLoomRoll();
                    GuiUtils.drawString(guiGraphics, EtherLoomScreen.MC.f_91062_, name, (int)((float)(centerX - 220 + 11) - this.offX), centerY, EtherLoomManager.getRollColor(roll.name()).getRGB(), true);
                }
                for (CometWidget comet : this.comets) {
                    comet.update();
                    poseStack.m_85836_();
                    poseStack.m_252880_(comet.x, comet.y, 0.0f);
                    guiGraphics.m_280398_(new ResourceLocation("etheria", "textures/gui/comet.png"), (int)(-19.0f + comet.offX), (int)(-20.0f + comet.offY), 0, 38.0f, 40.0f, 38, 40, 38, 40);
                    poseStack.m_85849_();
                }
                poseStack.m_85836_();
                poseStack.m_85841_(this.scale + scaleFlash, this.scale + scaleFlash, this.scale + scaleFlash);
                poseStack.m_252880_(((float)centerX - 130.0f + 138.0f - 24.0f + this.offX + shakeX) / (this.scale + scaleFlash), ((float)centerY - 130.0f + 132.0f + shakeY) / (this.scale + scaleFlash), 150.0f);
                if (this.tickCount >= 140 && (float)this.tickCount < 140.0f + flashDuration) {
                    RenderUtils.renderDragonEffect(poseStack, (MultiBufferSource)guiGraphics.m_280091_(), (float)this.tickCount / 2.0f, ticks, 150.0f * scaleFlash, 0.6784314f, 0.29411766f, 0.83137256f, stack.m_41778_().length() * 2);
                }
                poseStack.m_252880_(0.0f, 0.0f, 50.0f);
                if (this.tickCount > 0 && this.tickCount < 140) {
                    EtherLoomScreen.renderShadowBlackItem(guiGraphics, stack, -8, -8);
                } else if (this.tickCount >= 140 && (float)this.tickCount < 140.0f + flashDuration) {
                    float flashProgress = (float)(this.tickCount - 140) / flashDuration;
                    colorFactor = 0.1f + 0.9f * flashProgress;
                    EtherLoomScreen.renderShadowItem(guiGraphics, stack, -8, -8, colorFactor, alpha);
                } else {
                    EtherLoomScreen.renderShadowItem(guiGraphics, stack, -8, -8, 1.0f, 1.0f);
                }
                poseStack.m_85849_();
            }
        }
    }

    public static void renderShadowBlackItem(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        RenderSystem.setShaderColor((float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f);
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 201.0f);
        guiGraphics.m_280480_(itemStack, x, y);
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -51.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f);
        guiGraphics.m_280480_(itemStack, x + 1, y);
        guiGraphics.m_280480_(itemStack, x - 1, y);
        guiGraphics.m_280480_(itemStack, x, y + 1);
        guiGraphics.m_280480_(itemStack, x, y - 1);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderShadowItem(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y, float colorFactor, float alpha) {
        RenderSystem.setShaderColor((float)colorFactor, (float)colorFactor, (float)colorFactor, (float)alpha);
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 201.0f);
        guiGraphics.m_280480_(itemStack, x, y);
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -51.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)255.0f, (float)255.0f, (float)255.0f, (float)0.5f);
        guiGraphics.m_280480_(itemStack, x + 1, y);
        guiGraphics.m_280480_(itemStack, x - 1, y);
        guiGraphics.m_280480_(itemStack, x, y + 1);
        guiGraphics.m_280480_(itemStack, x, y - 1);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public int getScale() {
        return 3;
    }

    public void m_7379_() {
        if (this.tickCount > 120) {
            Networking.sendToServer(new C2SPacket(new CompoundTag(), 2));
            super.m_7379_();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public static void dragon(PoseStack mStack, MultiBufferSource buf, double x, double y, double z, float radius, float partialTicks, float r, float g, float b, float randomF) {
        float f5 = 0.5f;
        float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
        Random random = new Random((long)(432.0f + randomF));
        VertexConsumer builder = buf.m_6299_(EtheriaClient.GLOW_EFFECT);
        mStack.m_85836_();
        mStack.m_85837_(x, y, z);
        mStack.m_85841_(10.0f, 10.0f, 10.0f);
        float rotation = partialTicks / 200.0f;
        int i = 0;
        while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
            mStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
            mStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
            mStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f));
            mStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
            mStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
            mStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + rotation * 90.0f));
            float f3 = random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
            Matrix4f mat = mStack.m_85850_().m_252922_();
            float alpha = 1.0f - f7;
            builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            builder.m_252986_(mat, -ROOT_3 * (f4 *= 0.05f * radius), f3 *= 0.05f * radius, -0.5f * f4).m_85950_(r, g, b, 0.0f).m_5752_();
            builder.m_252986_(mat, ROOT_3 * f4, f3, -0.5f * f4).m_85950_(r, g, b, 0.0f).m_5752_();
            builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            builder.m_252986_(mat, ROOT_3 * f4, f3, -0.5f * f4).m_85950_(r, g, b, 0.0f).m_5752_();
            builder.m_252986_(mat, 0.0f, f3, f4).m_85950_(r, g, b, 0.0f).m_5752_();
            builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            builder.m_252986_(mat, 0.0f, f3, f4).m_85950_(r, g, b, 0.0f).m_5752_();
            builder.m_252986_(mat, -ROOT_3 * f4, f3, -0.5f * f4).m_85950_(r, g, b, 0.0f).m_5752_();
            ++i;
        }
        mStack.m_85849_();
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.side != LogicalSide.CLIENT || event.phase != TickEvent.Phase.END) {
                return;
            }
            Player player = event.player;
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (player != null && CapabilityRegistry.getCap(player).isLoomHud() && !(Minecraft.m_91087_().f_91080_ instanceof EtherLoomScreen)) {
                Minecraft.m_91087_().m_91152_((Screen)new EtherLoomScreen());
            }
        }
    }
}

