/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.mralxart.etheria.client.gui.MiconScreen;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ICustomScaledGui;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.magemicon.widgets.CometWidget;
import it.mralxart.etheria.client.gui.widgets.EtherSettingWidget;
import it.mralxart.etheria.client.handlers.ClientTickHandler;
import it.mralxart.etheria.client.particles.ScreenGlowingParticle;
import it.mralxart.etheria.client.particles.data.AbstractParticle;
import it.mralxart.etheria.client.particles.utils.ParticleContainer;
import it.mralxart.etheria.magemicon.ethersetting.data.EtherSettingInfo;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public class EtherSettingScreen
extends Screen
implements ICustomScaledGui {
    private int offX = 0;
    private int offY = 0;
    private float targetOffX = 0.0f;
    private float targetOffY = 0.0f;
    private float time = 0.0f;
    private final List<EtherSettingWidget> stars = new ArrayList<EtherSettingWidget>();
    private final List<CometWidget> comets = new ArrayList<CometWidget>();
    private ParticleContainer particleContainer = new ParticleContainer();
    private SoundInstance instance;
    public EtherSettingInfo info;
    public String unlockStar = "";
    public Screen returnScreen;
    public boolean isFinished = false;
    public float finishTick = -1.0f;
    private final List<ScreenGlowingParticle> lineParticles = new ArrayList<ScreenGlowingParticle>();

    public EtherSettingScreen(EtherSettingInfo info) {
        super((Component)Component.m_237119_());
        if (this.f_96541_ == null) {
            this.f_96541_ = Minecraft.m_91087_();
        }
        this.info = info;
        Random random = new Random();
        for (int i = 0; i < 5; ++i) {
            this.comets.add(new CometWidget(random.nextFloat() * (float)this.f_96543_ - (float)random.nextInt(400), random.nextFloat() * (float)this.f_96544_ - (float)random.nextInt(400), 1.6f + random.nextFloat() * 0.8f, random.nextInt(300) + random.nextInt(300)));
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int index = 1;
        for (Map.Entry<Integer, Vec2> entry : this.info.getPoses().entrySet()) {
            int key = entry.getKey();
            Vec2 vec2 = entry.getValue();
            EtherSettingWidget widget = new EtherSettingWidget((int)((float)centerX + vec2.f_82470_) - 11, (int)((float)centerY + vec2.f_82471_) - 11 + 30, 22, 22, this, key, index, true);
            widget.size = 1.0f;
            this.m_142416_((GuiEventListener)widget);
            ++index;
        }
        int totalWidgets = this.info.getCount() + 2;
        int widgetSize = 22;
        int margin = -24;
        for (int i = 0; i < totalWidgets; ++i) {
            int y;
            int x;
            int widgetIndex = i + 1;
            boolean isBase = false;
            float size = 1.5f;
            if (i == 0) {
                x = margin;
                y = centerY - widgetSize / 2;
                isBase = true;
                size = 1.0f;
            } else if (i == totalWidgets - 1) {
                x = this.f_96543_ - margin - widgetSize;
                y = centerY - widgetSize / 2;
                isBase = true;
                size = 1.0f;
            } else {
                y = 180;
                int intermediateCount = totalWidgets - 2;
                int currentIntermediateIndex = i - 1;
                if (intermediateCount == 1) {
                    x = centerX - widgetSize / 2;
                } else {
                    float totalWidth = (float)this.f_96543_ * 0.3f;
                    float step = totalWidth / (float)(intermediateCount - 1);
                    float startX = (float)centerX - totalWidth / 2.0f;
                    x = (int)(startX + (float)currentIntermediateIndex * step - (float)widgetSize / 2.0f);
                }
            }
            EtherSettingWidget widget = new EtherSettingWidget(x, y + 10, widgetSize, widgetSize, this, i, widgetIndex, false);
            widget.isFixed = isBase;
            widget.size = size;
            this.m_142416_((GuiEventListener)widget);
            this.stars.add(widget);
        }
        this.stars.sort(Comparator.comparingInt(EtherSettingWidget::getIndex));
        this.setupParticles();
    }

    public void m_280273_(@NotNull GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.m_280168_();
        ResourceLocation texture = new ResourceLocation("etheria", "textures/gui/background.png");
        ResourceLocation cometTexture = new ResourceLocation("etheria", "textures/gui/comet.png");
        int size = 576;
        float speed = 0.005f;
        this.time += speed;
        float radius = 50.0f;
        float xOffset = (float)(Math.sin(this.time) * (double)radius * Math.sin((double)this.time * 0.5));
        float yOffset = (float)(Math.cos(this.time) * (double)radius * Math.sin((double)this.time * 0.5));
        poseStack.m_85836_();
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
        poseStack.m_252880_((float)this.f_96543_ / 2.0f - xOffset - 50.0f, (float)this.f_96544_ / 2.0f - yOffset - 80.0f, -100.0f);
        guiGraphics.m_280398_(texture, -(size / 2), -(size / 2), 0, (float)size, (float)size, size, size, size, size);
        int[] offsets = new int[]{-size, 0, size};
        for (int dx : offsets) {
            for (int dy : offsets) {
                guiGraphics.m_280398_(texture, -(size / 2) + dx, -(size / 2) + dy, 0, (float)size, (float)size, size, size, size, size);
            }
        }
        poseStack.m_85849_();
        Object object = this.comets.iterator();
        while (object.hasNext()) {
            CometWidget comet = (CometWidget)object.next();
            comet.update();
            poseStack.m_85836_();
            poseStack.m_252880_(comet.x, comet.y, 0.0f);
            guiGraphics.m_280398_(cometTexture, (int)(-19.0f + comet.offX), (int)(-20.0f + comet.offY), 0, 38.0f, 40.0f, 38, 40, 38, 40);
            poseStack.m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void m_86600_() {
        super.m_86600_();
        for (GuiEventListener listener : this.m_6702_()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ITickWidget)) continue;
            ITickWidget widget = (ITickWidget)button;
            widget.tick();
        }
        boolean flag = true;
        for (GuiEventListener listener : this.m_6702_()) {
            EtherSettingWidget widget;
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof EtherSettingWidget) || !(widget = (EtherSettingWidget)button).isBase() || this.isOnEther(widget, 4.0f)) continue;
            flag = false;
            break;
        }
        if (flag && !this.isFinished) {
            this.finishTick = 0.0f;
            this.isFinished = true;
        }
        this.getParticleContainer().tickParticles(this);
        this.updateParticles();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mX, int mY, float ticks) {
        ICustomRenderWidget widget;
        AbstractButton button;
        super.m_88315_(guiGraphics, mX, mY, ticks);
        this.m_280273_(guiGraphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        for (AbstractParticle particle : this.particleContainer.getParticles()) {
            particle.render(this, guiGraphics, mX, mY, ticks);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ICustomRenderWidget)) continue;
            widget = (ICustomRenderWidget)button;
            widget.render(guiGraphics, ticks, mX, mY);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ICustomRenderWidget) || !(widget = (ICustomRenderWidget)button).isHover()) continue;
            widget.hovered(guiGraphics, mX, mY, ticks);
        }
        poseStack.m_85849_();
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double pDragX, double pDragY) {
        if (button == 0) {
            for (GuiEventListener listener : this.m_6702_()) {
                AbstractButton abstractButton;
                if (!(listener instanceof AbstractButton) || !((abstractButton = (AbstractButton)listener) instanceof EtherSettingWidget)) continue;
                EtherSettingWidget pw = (EtherSettingWidget)abstractButton;
                if (!pw.dragging || pw.isFixed) continue;
                if (this.isFinished) break;
                if (pw.onDrag(mouseX, mouseY)) continue;
            }
        }
        return super.m_7979_(mouseX, mouseY, button, pDragX, pDragY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (GuiEventListener listener : this.m_6702_()) {
                EtherSettingWidget pw;
                AbstractButton abstractButton;
                if (!(listener instanceof AbstractButton) || !((abstractButton = (AbstractButton)listener) instanceof EtherSettingWidget) || !(pw = (EtherSettingWidget)abstractButton).isHover() || pw.isFixed) continue;
                if (this.isFinished) {
                    return true;
                }
                if (pw.isBase()) continue;
                pw.m_5691_();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (GuiEventListener listener : this.m_6702_()) {
                AbstractButton abstractButton;
                if (!(listener instanceof AbstractButton) || !((abstractButton = (AbstractButton)listener) instanceof EtherSettingWidget)) continue;
                EtherSettingWidget pw = (EtherSettingWidget)abstractButton;
                if (pw.isFixed) continue;
                pw.m_7691_(mouseX, mouseY);
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public int getScale() {
        return 0;
    }

    public void m_7379_() {
        super.m_7379_();
        Minecraft.m_91087_().m_91152_(this.returnScreen);
    }

    public static Vec2 catmullRom(Vec2 p0, Vec2 p1, Vec2 p2, Vec2 p3, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        float x = 0.5f * (2.0f * p1.f_82470_ + (-p0.f_82470_ + p2.f_82470_) * t + (2.0f * p0.f_82470_ - 5.0f * p1.f_82470_ + 4.0f * p2.f_82470_ - p3.f_82470_) * t2 + (-p0.f_82470_ + 3.0f * p1.f_82470_ - 3.0f * p2.f_82470_ + p3.f_82470_) * t3);
        float y = 0.5f * (2.0f * p1.f_82471_ + (-p0.f_82471_ + p2.f_82471_) * t + (2.0f * p0.f_82471_ - 5.0f * p1.f_82471_ + 4.0f * p2.f_82471_ - p3.f_82471_) * t2 + (-p0.f_82471_ + 3.0f * p1.f_82471_ - 3.0f * p2.f_82471_ + p3.f_82471_) * t3);
        return new Vec2(x, y);
    }

    private void setupParticles() {
        this.lineParticles.forEach(p -> p.setRemoved(true));
        this.lineParticles.clear();
        if (this.stars.size() < 2) {
            return;
        }
        List<Vec2> points = this.stars.stream().map(widget -> new Vec2((float)(widget.m_252754_() + 11), (float)(widget.m_252907_() + 11))).collect(Collectors.toList());
        float totalLength = 0.0f;
        for (int i = 0; i < points.size() - 1; ++i) {
            totalLength += ((Vec2)points.get(i)).m_165914_((Vec2)points.get(i + 1));
        }
        int particleCount = (int)(totalLength / 64.0f);
        for (int i = 0; i < particleCount; ++i) {
            float globalProgress = (float)i / (float)(particleCount - 1);
            Vec2 pos = this.getPoint(points, globalProgress);
            Color color = ElementsUtils.getColorByElement(Element.ETHER);
            float particleSize = 0.4f;
            ScreenGlowingParticle particle = new ScreenGlowingParticle(pos.f_82470_ - 11.0f, pos.f_82471_ - 11.0f, 0.0f, 0.0f, particleSize, 10000000, 0.0f, color);
            particle.lineProgress = globalProgress;
            this.lineParticles.add(particle);
            this.getParticleContainer().addParticle(particle);
        }
    }

    private void updateParticles() {
        if (this.lineParticles.isEmpty()) {
            return;
        }
        List<Vec2> points = this.stars.stream().map(widget -> new Vec2((float)widget.m_252754_(), (float)widget.m_252907_())).collect(Collectors.toList());
        float time = (float)ClientTickHandler.clientTickCount + this.f_96541_.getPartialTick();
        for (ScreenGlowingParticle particle : this.lineParticles) {
            Vec2 basePos = this.getPoint(points, particle.lineProgress);
            Vec2 tangent = this.getVec2(points, particle.lineProgress);
            Vec2 normal = new Vec2(-tangent.f_82471_, tangent.f_82470_);
            float waveOffset = (float)Math.sin((double)time * 0.1 + (double)(particle.lineProgress * 2.0f));
            float edgeFade = (float)Math.sin((double)particle.lineProgress * Math.PI);
            Vec2 finalPos = basePos.m_165910_(normal.m_165903_(waveOffset *= edgeFade));
            particle.setX(finalPos.f_82470_ + 2.0f);
            particle.setY(finalPos.f_82471_ + 2.0f);
        }
        if (this.isFinished && this.finishTick >= 0.0f) {
            ScreenGlowingParticle particle = new ScreenGlowingParticle(0.0f, 0.0f, 0.0f, 0.0f, 1.75f, 10, 0.025f, ElementsUtils.getRandomColorByElement(Element.ETHER));
            Vec2 basePos = this.getPoint(points, this.finishTick);
            Vec2 tangent = this.getVec2(points, this.finishTick);
            Vec2 normal = new Vec2(-tangent.f_82471_, tangent.f_82470_);
            float waveOffset = (float)Math.sin((double)time * 0.1 + (double)(this.finishTick * 2.0f));
            Vec2 finalPos = basePos.m_165910_(normal.m_165903_(waveOffset));
            particle.setX(finalPos.f_82470_ + 2.0f);
            particle.setY(finalPos.f_82471_ + 2.0f);
            this.finishTick += 0.015f;
            if (this.finishTick > 1.0f) {
                Screen screen = this.returnScreen;
                if (screen instanceof MiconScreen) {
                    MiconScreen screen2 = (MiconScreen)screen;
                    screen2.unlockStar = this.unlockStar;
                }
                this.m_7379_();
                this.finishTick = 0.0f;
            }
            this.getParticleContainer().addParticle(particle);
        }
    }

    private Vec2 getPoint(List<Vec2> points, float globalProgress) {
        Vec2 p3;
        if (points.size() < 2) {
            return Vec2.f_82462_;
        }
        float segmentIndexFloat = globalProgress * (float)(points.size() - 1);
        int segmentIndex = Mth.m_14045_((int)((int)segmentIndexFloat), (int)0, (int)(points.size() - 2));
        float localProgress = segmentIndexFloat - (float)segmentIndex;
        Vec2 p1 = points.get(segmentIndex);
        Vec2 p2 = points.get(segmentIndex + 1);
        Vec2 p0 = segmentIndex > 0 ? points.get(segmentIndex - 1) : p1;
        Vec2 vec2 = p3 = segmentIndex < points.size() - 2 ? points.get(segmentIndex + 2) : p2;
        if (points.size() < 4) {
            return new Vec2(Mth.m_14179_((float)localProgress, (float)p1.f_82470_, (float)p2.f_82470_), Mth.m_14179_((float)localProgress, (float)p1.f_82471_, (float)p2.f_82471_));
        }
        return EtherSettingScreen.catmullRom(p0, p1, p2, p3, localProgress);
    }

    private Vec2 getVec2(List<Vec2> points, float globalProgress) {
        float epsilon = 0.01f;
        Vec2 p1 = this.getPoint(points, Mth.m_14036_((float)(globalProgress - 0.01f), (float)0.0f, (float)1.0f));
        Vec2 p2 = this.getPoint(points, Mth.m_14036_((float)(globalProgress + 0.01f), (float)0.0f, (float)1.0f));
        Vec2 result = new Vec2(p2.f_82470_ - p1.f_82470_, p2.f_82471_ - p1.f_82471_);
        return result.m_165902_();
    }

    public boolean isOnEther(EtherSettingWidget widget, float radius) {
        if (this.lineParticles.isEmpty()) {
            return false;
        }
        Vec2 widgetCenter = new Vec2((float)widget.m_252754_() + (float)widget.m_5711_() / 2.0f / widget.size, (float)widget.m_252907_() + (float)widget.m_93694_() / 2.0f / widget.size);
        float radiusSq = radius * radius;
        List<Vec2> points = this.stars.stream().map(w -> new Vec2((float)(w.m_252754_() + 11), (float)(w.m_252907_() + 11))).collect(Collectors.toList());
        int checkSteps = (int)((float)this.lineParticles.size() / 1.5f);
        for (int i = 0; i < checkSteps; ++i) {
            float globalProgress = (float)i / (float)(checkSteps - 1);
            Vec2 basePos = this.getPoint(points, globalProgress);
            Vec2 tangent = this.getVec2(points, globalProgress);
            Vec2 normal = new Vec2(-tangent.f_82471_, tangent.f_82470_);
            Vec2 currentLinePoint = basePos.m_165910_(normal.m_165903_(1.0f));
            if (!(widgetCenter.m_165914_(currentLinePoint) <= radiusSq)) continue;
            return true;
        }
        return false;
    }

    public int getOffX() {
        return this.offX;
    }

    public int getOffY() {
        return this.offY;
    }

    public float getTargetOffX() {
        return this.targetOffX;
    }

    public float getTargetOffY() {
        return this.targetOffY;
    }

    public float getTime() {
        return this.time;
    }

    public List<EtherSettingWidget> getStars() {
        return this.stars;
    }

    public List<CometWidget> getComets() {
        return this.comets;
    }

    public ParticleContainer getParticleContainer() {
        return this.particleContainer;
    }

    public SoundInstance getInstance() {
        return this.instance;
    }

    public EtherSettingInfo getInfo() {
        return this.info;
    }

    public String getUnlockStar() {
        return this.unlockStar;
    }

    public Screen getReturnScreen() {
        return this.returnScreen;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public float getFinishTick() {
        return this.finishTick;
    }

    public List<ScreenGlowingParticle> getLineParticles() {
        return this.lineParticles;
    }

    public void setOffX(int offX) {
        this.offX = offX;
    }

    public void setOffY(int offY) {
        this.offY = offY;
    }

    public void setTargetOffX(float targetOffX) {
        this.targetOffX = targetOffX;
    }

    public void setTargetOffY(float targetOffY) {
        this.targetOffY = targetOffY;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public void setParticleContainer(ParticleContainer particleContainer) {
        this.particleContainer = particleContainer;
    }

    public void setInstance(SoundInstance instance) {
        this.instance = instance;
    }

    public void setInfo(EtherSettingInfo info) {
        this.info = info;
    }

    public void setUnlockStar(String unlockStar) {
        this.unlockStar = unlockStar;
    }

    public void setReturnScreen(Screen returnScreen) {
        this.returnScreen = returnScreen;
    }

    public void setFinished(boolean isFinished) {
        this.isFinished = isFinished;
    }

    public void setFinishTick(float finishTick) {
        this.finishTick = finishTick;
    }
}

