/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.blocks.EtherAltar;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ICustomScaledGui;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.magemicon.widgets.CometWidget;
import it.mralxart.etheria.client.gui.widgets.ConstellationSelectWidget;
import it.mralxart.etheria.client.gui.widgets.ElementSlotWidget;
import it.mralxart.etheria.client.gui.widgets.ScreenTypeSelectWidget;
import it.mralxart.etheria.client.gui.widgets.SkillConnection;
import it.mralxart.etheria.client.gui.widgets.SkillWidget;
import it.mralxart.etheria.client.gui.widgets.SpellSelectWidget;
import it.mralxart.etheria.client.gui.widgets.StarConnection;
import it.mralxart.etheria.client.gui.widgets.StarType;
import it.mralxart.etheria.client.gui.widgets.StarWidget;
import it.mralxart.etheria.client.particles.ScreenGlowingParticle;
import it.mralxart.etheria.client.particles.ScreenSmokeParticle;
import it.mralxart.etheria.client.particles.data.AbstractParticle;
import it.mralxart.etheria.client.particles.utils.ParticleContainer;
import it.mralxart.etheria.client.utils.GuiUtils;
import it.mralxart.etheria.leveling.SkillStorage;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.data.CategoryInfo;
import it.mralxart.etheria.leveling.data.ConditionType;
import it.mralxart.etheria.leveling.data.ImageType;
import it.mralxart.etheria.leveling.data.SkillInfo;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.magemicon.data.ConstellationInfo;
import it.mralxart.etheria.magemicon.data.StarInfo;
import it.mralxart.etheria.magemicon.utils.StarUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.rituals.RitualRegistry;
import it.mralxart.etheria.magic.rituals.data.RitualData;
import it.mralxart.etheria.magic.spells.data.SpellData;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.C2SPacket;
import it.mralxart.etheria.registry.BlockRegistry;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.registry.SoundsRegistry;
import it.mralxart.etheria.utils.ItemUtils;
import it.mralxart.etheria.utils.RandomUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MiconScreen
extends Screen
implements ICustomScaledGui {
    public List<StarConnection> starConnections = new ArrayList<StarConnection>();
    public List<SkillConnection> skillConnections = new ArrayList<SkillConnection>();
    public float animationProgress = -1.0f;
    public String animationId = "";
    private Map<String, StarWidget> stars = new HashMap<String, StarWidget>();
    private Map<String, SkillWidget> skillWidgets = new HashMap<String, SkillWidget>();
    public Map<String, ConstellationInfo> constellations = new HashMap<String, ConstellationInfo>();
    public String type = "magemicon";
    public String unlockStar = "";
    public String constellation = "basics_path";
    public float animation;
    private int offX = 0;
    private int offY = 0;
    public float zoom = 1.0f;
    public final int BACKGROUND_SIZE = 1024;
    protected int maxScrollX;
    protected int maxScrollY;
    public int starsAmount = 0;
    public Map<String, Float> widgetSize = new HashMap<String, Float>();
    private ParticleContainer particleContainer = new ParticleContainer();
    private ParticleContainer screenParticleContainer = new ParticleContainer();
    private SoundInstance instance;
    private int lastOffX = 0;
    private int lastOffY = 0;
    private final List<CometWidget> comets = new ArrayList<CometWidget>();
    private final List<Vec2> unlockedStars = new ArrayList<Vec2>();
    private final List<Vec2> activeStars = new ArrayList<Vec2>();
    private final List<Vec2> allStars = new ArrayList<Vec2>();
    private float targetOffX = 0.0f;
    private float targetOffY = 0.0f;

    public MiconScreen(Map<String, ConstellationInfo> map, int modifier) {
        super((Component)Component.m_237119_());
        if (this.f_96541_ == null) {
            Minecraft.m_91087_().m_91152_(null);
        }
        this.constellations = new HashMap<String, ConstellationInfo>(map);
    }

    public MiconScreen(Map<String, ConstellationInfo> lvlInfos) {
        super((Component)Component.m_237119_());
        if (this.f_96541_ == null) {
            Minecraft.m_91087_().m_91152_(null);
        }
        this.constellations = new HashMap<String, ConstellationInfo>(lvlInfos);
        Minecraft.m_91087_().m_91106_().m_120391_();
        this.instance = SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)SoundsRegistry.PYRO_1.get()), (float)0.6f);
        Random random = new Random();
        for (int i = 0; i < 5; ++i) {
            this.comets.add(new CometWidget(random.nextFloat() * (float)this.f_96543_ - (float)random.nextInt(400), random.nextFloat() * (float)this.f_96544_ - (float)random.nextInt(400), 1.6f + random.nextFloat() * 0.8f, random.nextInt(300) + random.nextInt(300)));
        }
        this.targetOffX = 40.0f;
        this.targetOffY = -30.0f;
        this.zoom = 0.625f;
    }

    public void m_7379_() {
        super.m_7379_();
        Minecraft.m_91087_().m_91106_().m_120399_(this.instance);
        Minecraft.m_91087_().m_91106_().m_120407_();
    }

    /*
     * WARNING - void declaration
     */
    public void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.skillConnections.clear();
        this.starConnections.clear();
        this.unlockedStars.clear();
        this.activeStars.clear();
        this.allStars.clear();
        this.starsAmount = 1;
        for (ConstellationInfo info : this.constellations.values()) {
            this.starsAmount += info.getStars().values().size();
        }
        int widgetHeight = 32;
        int totalHeight = this.constellations.values().size() * widgetHeight;
        int startY = centerY - totalHeight / 2;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int iii = 0;
        int index = 1;
        ConstellationInfo widgetInfo = ConstellationInfo.builder().id("magemicon").image(ImageType.ITEM, "etheria:magemicon").build();
        this.m_142416_((GuiEventListener)new ScreenTypeSelectWidget(centerX - 19 - 10, this.f_96544_ - 32, this, widgetInfo, 0));
        widgetInfo = ConstellationInfo.builder().id("player").image(ImageType.ITEM, "minecraft:player_head").build();
        this.m_142416_((GuiEventListener)new ScreenTypeSelectWidget(centerX + 19 - 10, this.f_96544_ - 32, this, widgetInfo, 1));
        if (this.type.equals("player")) {
            ConstellationInfo info = ConstellationInfo.builder().id("skills").image(ImageType.ITEM, "minecraft:golden_pickaxe").build();
            this.m_142416_((GuiEventListener)new ConstellationSelectWidget(10, startY + widgetHeight * -1 + 22, this, info, 0));
            info = ConstellationInfo.builder().id("elements").image(ImageType.ITEM, "etheria:scroll").build();
            this.m_142416_((GuiEventListener)new ConstellationSelectWidget(10, startY + 22, this, info, 1));
            info = ConstellationInfo.builder().id("active_spells").image(ImageType.ITEM, "etheria:spell_scroll").build();
            this.m_142416_((GuiEventListener)new ConstellationSelectWidget(10, startY + widgetHeight + 22, this, info, 2));
            if (this.constellation.equals("elements")) {
                record SlotData(int relativeX, int relativeY, Element element, int id) {
                }
                List<SlotData> slotLayout = List.of(new SlotData(54, 44, null, 1), new SlotData(86, 44, null, 2), new SlotData(22, 76, Element.CRYO, 3), new SlotData(118, 76, Element.PYRO, 4), new SlotData(22, 108, null, 5), new SlotData(118, 108, null, 6), new SlotData(54, 140, null, 7), new SlotData(86, 140, null, 8));
                int baseX = 80;
                int baseY = 40;
                Iterator iterator = slotLayout.iterator();
                while (iterator.hasNext()) {
                    SlotData data = (SlotData)iterator.next();
                    int finalX = (int)((float)(baseX + data.relativeX - centerX) * this.zoom + (float)centerX + (float)this.offX);
                    int finalY = (int)((float)(baseY + data.relativeY - centerY) * this.zoom + (float)centerY + (float)this.offY);
                    this.m_142416_((GuiEventListener)new ElementSlotWidget(finalX, finalY, this, data.element(), data.id()));
                }
            }
            if (this.constellation.equals("skills")) {
                for (CategoryInfo categoryInfo : SkillStorage.CATEGORYS.values()) {
                    for (SkillInfo skillInfo : categoryInfo.getSkills().values()) {
                        if (skillInfo.getBlocked().booleanValue()) continue;
                        int widgetX = (int)((float)(skillInfo.getX() - centerX) * this.zoom + (float)centerX + (float)this.offX);
                        int widgetY = (int)((float)(skillInfo.getY() - centerY) * this.zoom + (float)centerY + (float)this.offY) + 60;
                        SkillWidget widget = new SkillWidget(widgetX, widgetY, 22, 22, skillInfo, this, index);
                        this.m_142416_((GuiEventListener)widget);
                        this.skillWidgets.put(skillInfo.getId(), widget);
                        if (!this.widgetSize.containsKey(skillInfo.getId())) {
                            this.widgetSize.put(skillInfo.getId(), Float.valueOf(1.0f));
                        }
                        this.addGatewayConnectionSkills(skillInfo);
                        ++index;
                    }
                }
            }
            if (this.constellation.equals("active_spells")) {
                LinkedHashMap<String, Map> elementSpells = new LinkedHashMap<String, Map>();
                Map<String, Integer> activeSpells = CapabilityRegistry.getCap((Player)Minecraft.m_91087_().f_91074_).getActiveSpells();
                Map<String, SpellData> allSpells = SpellsUtils.getDataSpellsMap();
                for (String spell : activeSpells.keySet()) {
                    allSpells.remove(spell);
                }
                for (SpellData spellData : allSpells.values()) {
                    String elementId = spellData.getElement();
                    String rare = spellData.getRare().toLowerCase();
                    elementSpells.computeIfAbsent(elementId, k -> new LinkedHashMap()).computeIfAbsent(rare, k -> new ArrayList()).add(spellData);
                }
                elementSpells.values().forEach(rarityMap -> rarityMap.values().forEach(spellList -> spellList.sort(Comparator.comparing(SpellData::getId))));
                int n = 40;
                int layoutCenterY = -100;
                int starDist = 50;
                int elementPad = 80;
                for (int ii = 1; ii < 6; ++ii) {
                    Object starInfo = StarInfo.builder().id("base_star").build();
                    this.createSelectSpellWidget((StarInfo)starInfo, 325, 25 + ii * 34, ii, true);
                    for (String spell : activeSpells.keySet()) {
                        if (activeSpells.get(spell) != ii) continue;
                        starInfo = StarInfo.builder().id(spell).type(StarType.SPELL).image(ImageType.ITEM, "etheria:spell_scroll").build();
                        this.createSelectSpellWidget((StarInfo)starInfo, 325, 25 + ii * 34, index++, false);
                    }
                }
                ArrayList sortedElements = new ArrayList(elementSpells.keySet());
                sortedElements.sort(String::compareTo);
                index = 1;
                for (String elementId : sortedElements) {
                    void var17_33;
                    Map spellsInElement = (Map)elementSpells.get(elementId);
                    List commonSpells = spellsInElement.getOrDefault("common", Collections.emptyList());
                    List epicSpells = spellsInElement.getOrDefault("epic", Collections.emptyList());
                    List legendarySpells = spellsInElement.getOrDefault("legendary", Collections.emptyList());
                    ArrayList allSpellsInElement = new ArrayList();
                    allSpellsInElement.addAll(commonSpells);
                    allSpellsInElement.addAll(epicSpells);
                    allSpellsInElement.addAll(legendarySpells);
                    int totalSpells = allSpellsInElement.size();
                    double radius = 0.0;
                    if (totalSpells > 1) {
                        radius = 50.0 / (Math.PI * 2 / (double)totalSpells);
                    }
                    void elementCenterX = var17_33 + (int)radius;
                    String[] parentIds = new String[]{};
                    if (totalSpells > 0) {
                        if (totalSpells == 1) {
                            SpellData spell = (SpellData)allSpellsInElement.get(0);
                            void widgetX = elementCenterX;
                            int widgetY = -100;
                            StarInfo starInfo = StarInfo.builder().id(spell.getId()).x((int)(widgetX - 88)).y(widgetY + 220).type(StarType.SPELL).image(ImageType.ITEM, "etheria:spell_scroll").parents(parentIds).build();
                            this.createSelectSpellWidget(starInfo, (int)(widgetX - 88), widgetY + 220, index++, false);
                        } else {
                            double angleStep = Math.PI * 2 / (double)totalSpells;
                            for (int i = 0; i < totalSpells; ++i) {
                                SpellData spell = (SpellData)allSpellsInElement.get(i);
                                if (commonSpells.contains(spell)) {
                                    parentIds = new String[]{};
                                } else if (epicSpells.contains(spell)) {
                                    parentIds = (String[])commonSpells.stream().map(SpellData::getId).toArray(String[]::new);
                                } else if (legendarySpells.contains(spell)) {
                                    parentIds = (String[])epicSpells.stream().map(SpellData::getId).toArray(String[]::new);
                                }
                                double angle = (double)i * angleStep - 1.5707963267948966;
                                int widgetX = (int)((double)elementCenterX + radius * Math.cos(angle));
                                int widgetY = (int)(-100.0 + radius * Math.sin(angle));
                                StarInfo starInfo = StarInfo.builder().id(spell.getId()).x(widgetX - 88).y(widgetY + 220).type(StarType.SPELL).image(ImageType.ITEM, "etheria:spell_scroll").parents(parentIds).build();
                                this.createSelectSpellWidget(starInfo, widgetX - 88, widgetY + 220, index++, false);
                            }
                        }
                    }
                    var17_33 += (int)(radius * 2.0 + 80.0);
                }
            }
        } else if (this.type.equals("magemicon")) {
            for (ConstellationInfo info : this.constellations.values()) {
                this.m_142416_((GuiEventListener)new ConstellationSelectWidget(10, startY + widgetHeight * (iii - 1) + 22, this, info, iii));
                ++iii;
                if (!info.getId().equals(this.constellation)) continue;
                for (StarInfo starInfo : info.getStars().values()) {
                    if (starInfo.getInfo().getId().equals("etheria:spell_scroll")) continue;
                    int n = (int)((float)(starInfo.getX() - centerX) * this.zoom + (float)centerX + (float)this.offX);
                    int widgetY = (int)((float)(starInfo.getY() - centerY) * this.zoom + (float)centerY + (float)this.offY);
                    StarWidget widget = new StarWidget(n, widgetY, 22, 22, starInfo, this, index);
                    this.m_142416_((GuiEventListener)widget);
                    this.stars.put(starInfo.getId(), widget);
                    if (!this.widgetSize.containsKey(starInfo.getId())) {
                        this.widgetSize.put(starInfo.getId(), Float.valueOf(1.0f));
                    }
                    this.addGatewayConnections(starInfo);
                    ++index;
                    this.allStars.add(new Vec2((float)(n - this.offX), (float)(widgetY - this.offY)));
                    minX = Math.min(minX, widget.m_252754_());
                    minY = Math.min(minY, widget.m_252907_());
                    maxX = Math.max(maxX, widget.m_252754_() + widget.m_5711_());
                    maxY = Math.max(maxY, widget.m_252907_() + widget.m_93694_());
                    if (!StarUtils.isParentStarUnlocked((Player)Minecraft.m_91087_().f_91074_, starInfo.getId())) continue;
                    float x = (float)widget.m_252754_() + (float)widget.m_5711_() / 2.0f;
                    float y = (float)widget.m_252907_() + (float)widget.m_93694_() / 2.0f;
                    this.activeStars.add(new Vec2(x - (float)this.offX, y - (float)this.offY));
                    if (!StarUtils.isStarUnlocked((Player)Minecraft.m_91087_().f_91074_, starInfo.getId())) continue;
                    this.unlockedStars.add(new Vec2(x - (float)this.offX, y - (float)this.offY));
                }
                if (this.constellation.equals("spells")) {
                    Map<String, SpellData> allSpellsInfo = SpellsUtils.getDataSpellsMap();
                    LinkedHashMap<String, Map> spellsByElement = new LinkedHashMap<String, Map>();
                    for (SpellData spellData : allSpellsInfo.values()) {
                        String elementId = spellData.getElement();
                        String rare = spellData.getRare().toLowerCase();
                        spellsByElement.computeIfAbsent(elementId, k -> new LinkedHashMap()).computeIfAbsent(rare, k -> new ArrayList()).add(spellData);
                    }
                    spellsByElement.values().forEach(rarityMap -> rarityMap.values().forEach(spellList -> spellList.sort(Comparator.comparing(SpellData::getId))));
                    int n = -15;
                    ArrayList sortedElementIds = new ArrayList(spellsByElement.keySet());
                    sortedElementIds.sort(String::compareTo);
                    for (String elementId : sortedElementIds) {
                        StarInfo starInfo;
                        int widgetY;
                        void widgetX;
                        int i;
                        void startX;
                        void var17_37;
                        Map spellsInElement = (Map)spellsByElement.get(elementId);
                        List commonSpells = spellsInElement.getOrDefault("common", Collections.emptyList());
                        List epicSpells = spellsInElement.getOrDefault("epic", Collections.emptyList());
                        List legendarySpells = spellsInElement.getOrDefault("legendary", Collections.emptyList());
                        String[] commonIdsInElement = (String[])commonSpells.stream().map(SpellData::getId).toArray(String[]::new);
                        int commonWidth = Math.max(0, commonSpells.size() - 1) * 50;
                        int epicWidth = Math.max(0, epicSpells.size() - 1) * 50;
                        int legendaryWidth = Math.max(0, legendarySpells.size() - 1) * 50;
                        int maxGroupWidth = Math.max(commonWidth, Math.max(epicWidth, legendaryWidth));
                        int currentY = -140;
                        if (!commonSpells.isEmpty()) {
                            startX = var17_37 + (maxGroupWidth - commonWidth) / 2;
                            for (i = 0; i < commonSpells.size(); ++i) {
                                widgetX = startX + i * 50 - 88;
                                widgetY = currentY + 220;
                                starInfo = StarInfo.builder().id(((SpellData)commonSpells.get(i)).getId()).x((int)widgetX).y(widgetY).type(StarType.SPELL).image(ImageType.ITEM, "etheria:spell_scroll").parents(new String[0]).build();
                                this.createSpellWidget(starInfo, (int)widgetX, widgetY, index++);
                            }
                        }
                        currentY += 75;
                        if (!epicSpells.isEmpty()) {
                            startX = var17_37 + (maxGroupWidth - epicWidth) / 2;
                            for (i = 0; i < epicSpells.size(); ++i) {
                                widgetX = startX + i * 50 - 88;
                                widgetY = currentY + 220;
                                starInfo = StarInfo.builder().id(((SpellData)epicSpells.get(i)).getId()).x((int)widgetX).y(widgetY).type(StarType.SPELL).image(ImageType.ITEM, "etheria:spell_scroll").condition(ConditionType.ETHER_SETTING, ((SpellData)epicSpells.get(i)).getId()).parents(commonIdsInElement).build();
                                this.createSpellWidget(starInfo, (int)widgetX, widgetY, index++);
                            }
                        }
                        currentY += 75;
                        if (!legendarySpells.isEmpty()) {
                            startX = var17_37 + (maxGroupWidth - legendaryWidth) / 2;
                            for (i = 0; i < legendarySpells.size(); ++i) {
                                widgetX = startX + i * 50 - 88;
                                widgetY = currentY + 220;
                                starInfo = StarInfo.builder().id(((SpellData)legendarySpells.get(i)).getId()).x((int)widgetX).y(widgetY).type(StarType.SPELL).image(ImageType.ITEM, "etheria:spell_scroll").hint(true).condition(ConditionType.TRIGGER, ((SpellData)legendarySpells.get(i)).getId()).parents(new String[0]).build();
                                this.createSpellWidget(starInfo, (int)widgetX, widgetY, index++);
                            }
                        }
                        var17_37 += maxGroupWidth + 60;
                    }
                    for (StarWidget widget : this.stars.values()) {
                        if (widget.getType() != StarType.SPELL) continue;
                        StarInfo starInfo = widget.getInfo();
                        minX = Math.min(minX, widget.m_252754_());
                        minY = Math.min(minY, widget.m_252907_());
                        maxX = Math.max(maxX, widget.m_252754_() + widget.m_5711_());
                        maxY = Math.max(maxY, widget.m_252907_() + widget.m_93694_());
                        this.allStars.add(new Vec2((float)(widget.m_252754_() - this.offX), (float)(widget.m_252907_() - this.offY)));
                        if (StarUtils.isParentStarUnlocked((Player)Minecraft.m_91087_().f_91074_, starInfo.getId())) {
                            float centerXX = (float)widget.m_252754_() + (float)widget.m_5711_() / 2.0f;
                            float centerYY = (float)widget.m_252907_() + (float)widget.m_93694_() / 2.0f;
                            this.activeStars.add(new Vec2(centerXX - (float)this.offX, centerYY - (float)this.offY));
                            if (StarUtils.isStarUnlocked((Player)Minecraft.m_91087_().f_91074_, starInfo.getId())) {
                                this.unlockedStars.add(new Vec2(centerXX - (float)this.offX, centerYY - (float)this.offY));
                            }
                        }
                        this.addGatewayConnections(starInfo);
                    }
                    continue;
                }
                if (!this.constellation.equals("rituals")) continue;
                Map<String, RitualData> allRitualsInfo = RitualRegistry.getAllRituals();
                EnumMap ritualsByElement = new EnumMap(Element.class);
                for (RitualData ritualData : allRitualsInfo.values()) {
                    ritualsByElement.computeIfAbsent(ritualData.getElement(), k -> new ArrayList()).add(ritualData);
                }
                Comparator<RitualData> comparator = Comparator.comparing(RitualData::getRitualDifficulty).thenComparing(RitualData::getId);
                ritualsByElement.values().forEach(list -> list.sort(sorter));
                int baseCenterX = centerX - 100;
                int baseCenterY = centerY;
                int horizontalSpacing = 280;
                int verticalSpacing = 200;
                int shapeScale = 60;
                List<RitualData> etherRituals = ritualsByElement.getOrDefault((Object)Element.ETHER, Collections.emptyList());
                List<RitualData> pyroRituals = ritualsByElement.getOrDefault((Object)Element.PYRO, Collections.emptyList());
                List<RitualData> cryoRituals = ritualsByElement.getOrDefault((Object)Element.CRYO, Collections.emptyList());
                List<RitualData> aeroRituals = ritualsByElement.getOrDefault((Object)Element.AERO, Collections.emptyList());
                int etherCenterY = baseCenterY - 200;
                int cryoCenterX = baseCenterX - 280;
                int pyroCenterX = baseCenterX + 280;
                int aeroCenterY = baseCenterY + 200;
                index = this.createConstellation(etherRituals, baseCenterX, etherCenterY, 60, index);
                index = this.createConstellation(pyroRituals, pyroCenterX, baseCenterY, 60, index);
                index = this.createConstellation(cryoRituals, cryoCenterX, baseCenterY, 60, index);
                index = this.createConstellation(aeroRituals, baseCenterX, aeroCenterY, 60, index);
                for (StarWidget widget : this.stars.values()) {
                    if (widget.getType() != StarType.RITUAL) continue;
                    StarInfo starInfo = widget.getInfo();
                    minX = Math.min(minX, widget.m_252754_());
                    minY = Math.min(minY, widget.m_252907_());
                    maxX = Math.max(maxX, widget.m_252754_() + widget.m_5711_());
                    maxY = Math.max(maxY, widget.m_252907_() + widget.m_93694_());
                    this.allStars.add(new Vec2((float)(widget.m_252754_() - this.offX), (float)(widget.m_252907_() - this.offY)));
                    if (StarUtils.isParentStarUnlocked((Player)Minecraft.m_91087_().f_91074_, starInfo.getId())) {
                        float centerXX = (float)widget.m_252754_() + (float)widget.m_5711_() / 2.0f;
                        float centerYY = (float)widget.m_252907_() + (float)widget.m_93694_() / 2.0f;
                        this.activeStars.add(new Vec2(centerXX - (float)this.offX, centerYY - (float)this.offY));
                        if (StarUtils.isStarUnlocked((Player)Minecraft.m_91087_().f_91074_, starInfo.getId())) {
                            this.unlockedStars.add(new Vec2(centerXX - (float)this.offX, centerYY - (float)this.offY));
                        }
                    }
                    this.addGatewayConnections(starInfo);
                }
            }
        }
        this.maxScrollX -= this.f_96543_ / 2 - 80;
        this.maxScrollY -= this.f_96544_ / 2 - 80;
        if (this.maxScrollX < 0) {
            this.maxScrollX = 0;
        }
        if (this.maxScrollY < 0) {
            this.maxScrollY = 0;
        }
    }

    private int createConstellation(List<RitualData> rituals, int centerX, int centerY, int scale, int startIndex) {
        if (rituals.isEmpty()) {
            return startIndex;
        }
        Vec2[] shapeOffsets = new Vec2[]{new Vec2(0.0f, 0.0f), new Vec2(-1.0f, -0.3f), new Vec2(1.0f, -0.3f), new Vec2(-0.5f, 1.0f), new Vec2(0.5f, 1.0f), new Vec2(0.0f, -1.2f), new Vec2(1.2f, 0.8f)};
        int widgetIndex = startIndex;
        for (int i = 0; i < rituals.size(); ++i) {
            RitualData ritual = rituals.get(i);
            Vec2 offset = shapeOffsets[i % shapeOffsets.length];
            int widgetX = centerX + (int)(offset.f_82470_ * (float)scale);
            int widgetY = centerY + (int)(offset.f_82471_ * (float)scale);
            this.createRitualWidget(ritual, widgetX, widgetY, widgetIndex++);
        }
        return widgetIndex;
    }

    private void createSelectSpellWidget(StarInfo starInfo, int x, int y, int index, boolean isBase) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int finalWidgetX = (int)((float)(x - centerX) * this.zoom + (float)centerX + (float)this.offX);
        int finalWidgetY = (int)((float)(y - centerY) * this.zoom + (float)centerY + (float)this.offY);
        SpellSelectWidget widget = new SpellSelectWidget(finalWidgetX, finalWidgetY, 22, 22, this, starInfo, index, isBase);
        this.m_142416_((GuiEventListener)widget);
    }

    private void createSpellWidget(StarInfo starInfo, int x, int y, int index) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int finalWidgetX = (int)((float)(x - centerX) * this.zoom + (float)centerX + (float)this.offX);
        int finalWidgetY = (int)((float)(y - centerY) * this.zoom + (float)centerY + (float)this.offY);
        StarWidget widget = new StarWidget(finalWidgetX, finalWidgetY, 22, 22, starInfo, this, index, StarType.SPELL);
        this.m_142416_((GuiEventListener)widget);
        this.stars.put(starInfo.getId(), widget);
    }

    private void createRitualWidget(RitualData data, int x, int y, int index) {
        ItemStack stack = ((EtherAltar)BlockRegistry.ETHER_ALTAR.get()).m_5456_().m_7968_();
        if (!data.getId().isEmpty() && data.getResult().getResultItem() != null) {
            stack = data.getResult().getResultItem();
        }
        StarInfo starInfo = StarInfo.builder().id(data.getId()).x(x).y(y).type(StarType.RITUAL).image(ImageType.ITEM, ItemUtils.convertItemString(stack.m_41778_())).condition(ConditionType.STAR_UNLOCKED, "ritual_fundamentals").build();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int finalWidgetX = (int)((float)(x - centerX) * this.zoom + (float)centerX + (float)this.offX);
        int finalWidgetY = (int)((float)(y - centerY) * this.zoom + (float)centerY + (float)this.offY);
        StarWidget widget = new StarWidget(finalWidgetX, finalWidgetY, 22, 22, starInfo, this, index, StarType.RITUAL);
        this.m_142416_((GuiEventListener)widget);
        this.stars.put(starInfo.getId(), widget);
    }

    private void addGatewayConnections(StarInfo skill) {
        skill.getParents().forEach(connectedSkillId -> this.connectStars(this.starConnections, skill.getId(), (String)connectedSkillId));
    }

    private void addGatewayConnectionSkills(SkillInfo skill) {
        skill.getParents().forEach(connectedSkillId -> this.connectSkills(this.skillConnections, skill.getId(), (String)connectedSkillId));
    }

    protected void connectSkills(List<SkillConnection> connections, String skillId1, String skillId2) {
        SkillWidget button1 = this.skillWidgets.get(skillId1);
        SkillWidget button2 = this.skillWidgets.get(skillId2);
        if (button1 != null && button2 != null) {
            connections.add(new SkillConnection(button2, button1));
        }
    }

    protected void connectStars(List<StarConnection> connections, String skillId1, String skillId2) {
        StarWidget button1 = this.stars.get(skillId1);
        StarWidget button2 = this.stars.get(skillId2);
        if (button1 != null && button2 != null) {
            connections.add(new StarConnection(button2, button1));
        }
    }

    private void renderFog() {
        if (this.allStars.size() == this.unlockedStars.size()) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            Vec2 randomStarCenter = this.allStars.get(RandomUtils.random().nextInt(this.allStars.size()));
            double angle = RandomUtils.random().nextDouble() * 2.0 * Math.PI;
            double radius = RandomUtils.random().nextDouble() * 50.0 * (double)this.zoom;
            float spawnX = (float)((double)randomStarCenter.f_82470_ + Math.cos(angle) * radius);
            float spawnY = (float)((double)randomStarCenter.f_82471_ + Math.sin(angle) * radius) + 2.0f;
            boolean canSpawn = true;
            for (Vec2 vec2 : this.activeStars) {
                Vec2 vec22 = new Vec2(spawnX + 6.5f, spawnY + 6.5f);
                if (!(vec2.m_165914_(vec22) < 28.0f * this.zoom * 28.0f * this.zoom)) continue;
                canSpawn = false;
                break;
            }
            boolean optimize = false;
            for (Vec2 activeCenter3 : this.activeStars) {
                Vec2 vec2 = new Vec2(spawnX + 6.5f, spawnY + 6.5f);
                if (!(activeCenter3.m_165914_(vec2) < 40.0f * this.zoom * 40.0f * this.zoom)) continue;
                optimize = true;
                break;
            }
            if (!canSpawn) continue;
            float f = 0.4f * this.zoom + RandomUtils.random().nextFloat() * (optimize ? 0.1f : 0.6f);
            int lifeTime = 15 + RandomUtils.random().nextInt(optimize ? 2 : 40);
            this.getParticleContainer().addParticle(new ScreenSmokeParticle(spawnX, spawnY, 0.0f, 0.0f, f, lifeTime, 0.0f, new Color(0xFFFFFF)));
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mX, int mY, float ticks) {
        ICustomRenderWidget widget;
        AbstractButton button;
        if (this.f_96541_ == null) {
            return;
        }
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int barY = this.f_96544_ - centerY / 4 - 10;
        PoseStack poseStack = guiGraphics.m_280168_();
        this.animation += ticks;
        this.m_280273_(guiGraphics);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.m_85836_();
        this.starConnections.forEach(connection -> this.renderStarConnection(guiGraphics, (StarConnection)connection));
        poseStack.m_85849_();
        poseStack.m_85836_();
        this.skillConnections.forEach(connection -> this.renderSkillConnection(guiGraphics, (SkillConnection)connection));
        poseStack.m_85849_();
        poseStack.m_85836_();
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ICustomRenderWidget) || (widget = (ICustomRenderWidget)button) instanceof ConstellationSelectWidget) continue;
            widget.render(guiGraphics, ticks, mX, mY);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ICustomRenderWidget) || !((widget = (ICustomRenderWidget)button) instanceof ConstellationSelectWidget)) continue;
            poseStack.m_252880_(0.0f, 0.0f, 1000.0f);
            widget.render(guiGraphics, ticks, mX, mY);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.offX, (float)this.offY, 0.0f);
        for (AbstractParticle particle : this.particleContainer.getParticles()) {
            particle.render(this, guiGraphics, mX, mY, ticks);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        for (AbstractParticle particle : this.screenParticleContainer.getParticles()) {
            particle.render(this, guiGraphics, mX, mY, ticks);
        }
        poseStack.m_85849_();
        poseStack.m_252880_(0.0f, 0.0f, 600.0f);
        GuiUtils.drawBorderTexture(guiGraphics, new ResourceLocation("etheria", "textures/gui/border_paper.png"), centerX - 30 - 9, this.f_96544_ - 32 - 6, 60, 13);
        poseStack.m_85836_();
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ICustomRenderWidget) || !((widget = (ICustomRenderWidget)button) instanceof ScreenTypeSelectWidget)) continue;
            widget.render(guiGraphics, ticks, mX, mY);
        }
        poseStack.m_85849_();
        if (this.constellation.equals("skills")) {
            this.renderBars(guiGraphics, mX, mY);
        }
        poseStack.m_85836_();
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ICustomRenderWidget) || !(widget = (ICustomRenderWidget)button).isHover()) continue;
            widget.hovered(guiGraphics, mX, mY, ticks);
        }
        poseStack.m_85849_();
        super.m_88315_(guiGraphics, mX, mY, ticks);
    }

    public void renderBars(GuiGraphics guiGraphics, int mX, int mY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int barY = this.f_96544_ - centerY / 4 - 4;
        int step = -190;
        int branchcount = 0;
        for (Branches branch : Branches.values()) {
            if (branch.equals((Object)Branches.NONE)) continue;
            if (branchcount == 2 || branchcount == 6) {
                step += 73;
            }
            if (branchcount == 4) {
                step = -190;
                barY += 18;
            }
            if (branch.equals((Object)Branches.EXPLORATION) && !ModList.get().isLoaded("etheria_addition")) {
                step += 102;
                ++branchcount;
                continue;
            }
            float percentage = 0.0f;
            int skillXp = SkillsUtils.getXp((Player)this.f_96541_.f_91074_, branch);
            int lvl = SkillsUtils.getLvl((Player)this.f_96541_.f_91074_, branch);
            int requiredXpForNextLevel = lvl * 100 + 150;
            if (skillXp != 0) {
                percentage = (float)skillXp / (float)requiredXpForNextLevel * 100.0f;
            }
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 350.0f);
            RenderSystem.setShaderColor((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/widget/small_xp_background.png"), centerX - 45 + step, barY, 0.0f, 0.0f, 91, 6, 91, 6);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/widget/small_xp_line.png"), centerX - 44 - 1 + step, barY + 1, 0.0f, 0.0f, (int)Math.ceil(percentage / 100.0f * 89.0f), 4, 89, 4);
            boolean xpHovered = MiconScreen.isHovered(centerX - 44 + step, barY, 89, 4, mX, mY);
            this.getScreenParticleContainer().addParticle(new ScreenGlowingParticle(centerX - 6 + step + (new Random().nextInt(44) - new Random().nextInt(44)), barY - 4, 0.0f, -0.2f, 0.25f, 5 + new Random().nextInt(60), 3.0f, new Color(0xB7B7B7)));
            float color = (float)((double)0.85f + Math.sin((double)System.currentTimeMillis() / 100.0 * Math.ceil(2.0) * (double)0.075f) * (double)0.3f);
            if (xpHovered) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)1);
                RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/widget/small_xp_highlight.png"), centerX - 45 + step, barY - 1, 0.0f, 0.0f, 91, 8, 91, 8);
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ArrayList description = Lists.newArrayList();
                ArrayList tooltip = Lists.newArrayList();
                int maxWidth = 180;
                int renderWidth = 0;
                int yOff = 0;
                description = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237115_((String)"etheria.skillbar.title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131162_(Boolean.valueOf(true)))});
                description.add(Component.m_237115_((String)("etheria.xp." + branch.name().toLowerCase())));
                description.add(Component.m_237115_((String)"etheria.skillbar.description"));
                description.add(Component.m_237110_((String)"etheria.skillbar.points", (Object[])new Object[]{CapabilityRegistry.getCap((Player)this.f_96541_.f_91074_).getSkillPoints()}));
                for (MutableComponent entry : description) {
                    int entryWidth = this.f_96541_.f_91062_.m_92852_((FormattedText)entry) / 2;
                    if (entryWidth > renderWidth) {
                        renderWidth = Math.min(entryWidth, maxWidth);
                    }
                    tooltip.addAll(this.f_96541_.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
                }
                int heightTip = Math.round((float)tooltip.size() * 4.5f);
                poseStack.m_85836_();
                TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)(mX - renderWidth / 2), (int)(mY - heightTip - 3), (int)renderWidth, (int)heightTip, (int)1300, (int)-267386864, (int)-267386864, (int)-395521, (int)-2320649);
                poseStack.m_85849_();
                poseStack.m_85836_();
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                poseStack.m_252880_((float)(mX * 2), (float)(mY - heightTip - 3) * 2.0f, 3500.0f);
                for (FormattedCharSequence entry : tooltip) {
                    guiGraphics.m_280649_(this.f_96541_.f_91062_, entry, -(this.f_96541_.f_91062_.m_92724_(entry) / 2), yOff * 2, 14928378, false);
                    yOff += 5;
                }
                poseStack.m_85849_();
            }
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/skill_point.png"), centerX - 22 + 16 + step, barY - 6, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.enableBlend();
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            RenderSystem.setShaderColor((float)227.0f, (float)201.0f, (float)250.0f, (float)1.0f);
            guiGraphics.m_280480_(Branches.getItem(branch), (centerX - 22 + 20 + step) * 2 + 1, (barY - 6 + 4) * 2);
            guiGraphics.m_280480_(Branches.getItem(branch), (centerX - 22 + 20 + step) * 2 - 1, (barY - 6 + 4) * 2);
            guiGraphics.m_280480_(Branches.getItem(branch), (centerX - 22 + 20 + step) * 2, (barY - 6 + 4) * 2 + 1);
            guiGraphics.m_280480_(Branches.getItem(branch), (centerX - 22 + 20 + step) * 2, (barY - 6 + 4) * 2 - 1);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280480_(Branches.getItem(branch), (centerX - 22 + 20 + step) * 2, (barY - 6 + 4) * 2);
            poseStack.m_85849_();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            if (xpHovered) {
                RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
            }
            guiGraphics.m_280056_(this.f_96541_.f_91062_, "" + SkillsUtils.getLvl((Player)this.f_96541_.f_91074_, branch), centerX - 45 - 2 + step, barY - 1, new Color(12683758).getRGB(), true);
            guiGraphics.m_280056_(this.f_96541_.f_91062_, "" + (SkillsUtils.getLvl((Player)this.f_96541_.f_91074_, branch) + 1), centerX + 45 - 2 + step, barY - 1, new Color(12683758).getRGB(), true);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            poseStack.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            step += 102;
            ++branchcount;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderStarConnection(GuiGraphics guiGraphics, StarConnection connection) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        double connectionX = (float)connection.getWidget1().m_252754_() + (float)connection.getWidget1().m_5711_() / 2.0f;
        double connectionY = (float)connection.getWidget1().m_252907_() + (float)connection.getWidget1().m_93694_() / 2.0f;
        float rotation = MiconScreen.getAngleBetweenButtons(connection.getWidget1(), connection.getWidget2());
        poseStack.m_85837_(connectionX + 1.0, connectionY + 1.0, 0.0);
        poseStack.m_252781_(Axis.f_252403_.m_252961_(rotation));
        poseStack.m_85841_(this.zoom, this.zoom, 1.0f);
        int length = (int)(MiconScreen.getDistanceBetweenButtons(connection.getWidget1(), connection.getWidget2()) / this.zoom);
        boolean highlighted = StarUtils.isStarUnlocked((Player)Minecraft.m_91087_().f_91074_, connection.getWidget1().info.getId());
        guiGraphics.m_280411_(new ResourceLocation("etheria", "textures/gui/widget/conection_line.png"), 0, -3, length, 6, -this.animation, highlighted ? 0.0f : 6.0f, length, 6, 30, 12);
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderSkillConnection(GuiGraphics guiGraphics, SkillConnection connection) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        double connectionX = (float)connection.getWidget1().m_252754_() + (float)connection.getWidget1().m_5711_() / 2.0f;
        double connectionY = (float)connection.getWidget1().m_252907_() + (float)connection.getWidget1().m_93694_() / 2.0f;
        float rotation = MiconScreen.getAngleBetweenButtons(connection.getWidget1(), connection.getWidget2());
        poseStack.m_85837_(connectionX + 1.0, connectionY + 1.0, 0.0);
        poseStack.m_252781_(Axis.f_252403_.m_252961_(rotation));
        poseStack.m_85841_(this.zoom, this.zoom, 1.0f);
        int length = (int)(MiconScreen.getDistanceBetweenButtons(connection.getWidget1(), connection.getWidget2()) / this.zoom);
        boolean highlighted = StarUtils.isStarUnlocked((Player)Minecraft.m_91087_().f_91074_, connection.getWidget1().info.getId());
        guiGraphics.m_280411_(new ResourceLocation("etheria", "textures/gui/widget/conection_line.png"), 0, -3, length, 6, -this.animation, highlighted ? 0.0f : 6.0f, length, 6, 30, 12);
        guiGraphics.m_280168_().m_85849_();
    }

    public static float getAngleBetweenButtons(AbstractButton widget1, AbstractButton widget2) {
        float x1 = (float)widget1.m_252754_() + (float)widget1.m_5711_() / 2.0f;
        float y1 = (float)widget1.m_252907_() + (float)widget1.m_93694_() / 2.0f;
        float x2 = (float)widget2.m_252754_() + (float)widget2.m_5711_() / 2.0f;
        float y2 = (float)widget2.m_252907_() + (float)widget2.m_93694_() / 2.0f;
        return (float)Mth.m_14136_((double)(y2 - y1), (double)(x2 - x1));
    }

    public static float getDistanceBetweenButtons(AbstractButton widget1, AbstractButton widget2) {
        float x1 = (float)widget1.m_252754_() + (float)widget1.m_5711_() / 2.0f;
        float y1 = (float)widget1.m_252907_() + (float)widget1.m_93694_() / 2.0f;
        float x2 = (float)widget2.m_252754_() + (float)widget2.m_5711_() / 2.0f;
        float y2 = (float)widget2.m_252907_() + (float)widget2.m_93694_() / 2.0f;
        return Mth.m_14116_((float)((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)));
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton == 0) {
            for (GuiEventListener listener : this.m_6702_()) {
                AbstractButton abstractButton;
                if (!(listener instanceof AbstractButton) || !((abstractButton = (AbstractButton)listener) instanceof SpellSelectWidget)) continue;
                SpellSelectWidget pw = (SpellSelectWidget)abstractButton;
                if (!pw.dragging || pw.isFixed || !pw.onDrag(pMouseX, pMouseY)) continue;
                return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
            }
        }
        this.m_232761_();
        this.targetOffX += (float)pDragX;
        this.targetOffY += (float)pDragY;
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        float newZoom = (float)((double)this.zoom + amount * 0.05);
        this.zoom = newZoom = Math.min(Math.max(newZoom, 0.625f), 2.0f);
        for (AbstractParticle particle : new ArrayList<AbstractParticle>(this.getParticleContainer().getParticles())) {
            if (particle instanceof ScreenSmokeParticle) continue;
            particle.setRemoved(true);
        }
        this.m_232761_();
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void m_86600_() {
        ITickWidget widget;
        AbstractButton button;
        super.m_86600_();
        if (!this.unlockStar.isEmpty()) {
            StarUtils.unlockStarById((Player)Minecraft.m_91087_().f_91074_, this.unlockStar, true);
            for (GuiEventListener listener : this.m_6702_()) {
                if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof StarWidget)) continue;
                widget = (StarWidget)button;
                if (!((StarWidget)widget).info.getId().equals(this.unlockStar)) continue;
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("id", ((StarWidget)widget).info.getId());
                if (((StarWidget)widget).getType().equals((Object)StarType.SPELL)) {
                    Networking.sendToServer(new C2SPacket(tag, 759));
                }
                Networking.sendToServer(new C2SPacket(tag, 1104));
                ((StarWidget)widget).createParticleBurst();
            }
            this.unlockStar = "";
        }
        if (this.constellation.equals("active_spells")) {
            HashMap activeSpells = new HashMap();
            for (GuiEventListener listener : this.m_6702_()) {
                if (!(listener instanceof SpellSelectWidget) || ((SpellSelectWidget)(widget = (SpellSelectWidget)listener)).isBase()) continue;
                for (GuiEventListener listener2 : this.m_6702_()) {
                    int deltaY;
                    int deltaX;
                    int distanceSquared;
                    SpellSelectWidget base;
                    if (!(listener2 instanceof SpellSelectWidget) || !(base = (SpellSelectWidget)listener2).isBase() || (distanceSquared = (deltaX = widget.m_252754_() - base.m_252754_() - 2) * deltaX + (deltaY = widget.m_252907_() - base.m_252907_() - 2) * deltaY) > 144) continue;
                    activeSpells.put(((SpellSelectWidget)widget).getInfo().getId(), base.getIndex());
                }
            }
            if (!CapabilityRegistry.getCap((Player)Minecraft.m_91087_().f_91074_).getActiveSpells().equals(activeSpells)) {
                CompoundTag spellsTag = new CompoundTag();
                activeSpells.forEach((arg_0, arg_1) -> ((CompoundTag)spellsTag).m_128405_(arg_0, arg_1));
                Networking.sendToServer(new C2SPacket(spellsTag, 406));
            }
        }
        this.renderFog();
        this.getParticleContainer().tickParticles(this);
        this.getScreenParticleContainer().tickParticles(this);
        if (this.animationProgress >= 0.0f) {
            this.animationProgress += 0.04f;
            if (this.animationProgress > 1.0f) {
                this.animationProgress = -1.0f;
            }
        }
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ITickWidget)) continue;
            widget = (ITickWidget)button;
            widget.tick();
        }
        int oX = this.offX;
        int oY = this.offY;
        float smoothFactor = 0.2f;
        this.offX += (int)((this.targetOffX - (float)this.offX) * smoothFactor);
        this.offY += (int)((this.targetOffY - (float)this.offY) * smoothFactor);
        float result = 0.0f;
        if ((double)this.zoom > 0.625) {
            result = this.zoom * 1.4f * 60.0f;
        }
        if ((double)this.zoom > 0.674 && (double)this.zoom < 0.676) {
            result -= 60.0f;
        }
        int maxOffX = (int)(512.0 - (double)this.f_96543_ / 2.0 / (double)this.zoom + (double)result);
        int maxOffY = (int)(512.0 - (double)this.f_96544_ / 2.0 / (double)this.zoom);
        this.offX = Math.max(-maxOffX, Math.min(this.offX, maxOffX));
        this.offY = Math.max(-maxOffY, Math.min(this.offY, maxOffY));
        if (this.offX != oX || this.offY != oY) {
            this.m_232761_();
        }
        Minecraft.m_91087_().m_91106_().m_120389_(false);
        if (!Minecraft.m_91087_().m_91106_().m_120403_(this.instance)) {
            int i = new Random().nextInt(1, 3);
            int ii = new Random().nextInt(1, 2);
            float randomPitch = switch (ii) {
                case 1 -> 0.9f;
                case 2 -> 1.1f;
                default -> 1.0f;
            };
            switch (i) {
                case 1: {
                    this.instance = SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsRegistry.MAGE_MICON_1.get()), (float)randomPitch, (float)0.5f);
                    break;
                }
                case 2: {
                    this.instance = SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsRegistry.MAGE_MICON_2.get()), (float)randomPitch, (float)0.5f);
                    break;
                }
                case 3: {
                    this.instance = SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsRegistry.MAGE_MICON_3.get()), (float)randomPitch, (float)0.5f);
                }
            }
            Minecraft.m_91087_().m_91106_().m_120367_(this.instance);
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.m_280168_();
        ResourceLocation texture = new ResourceLocation("etheria", "textures/gui/background.png");
        int size = 1024;
        poseStack.m_85836_();
        poseStack.m_85841_(this.zoom, this.zoom, 1.0f);
        poseStack.m_252880_((float)this.f_96543_ / 2.0f / this.zoom, (float)this.f_96544_ / 2.0f / this.zoom, 0.0f);
        guiGraphics.m_280398_(texture, -(size / 2) + this.offX / 2, -(size / 2) + this.offY / 2, 0, (float)size, (float)size, size, size, size, size);
        int[] offsets = new int[]{-size, 0, size};
        for (int dx : offsets) {
            for (int dy : offsets) {
                guiGraphics.m_280398_(texture, (int)(-((float)size / 2.0f) + (float)this.offX / 2.0f) + dx, (int)(-((float)size / 2.0f) + (float)this.offY / 2.0f) + dy, 0, (float)size, (float)size, size, size, size, size);
            }
        }
        poseStack.m_85849_();
        Object object = this.comets.iterator();
        while (object.hasNext()) {
            CometWidget comet = (CometWidget)object.next();
            comet.update();
            poseStack.m_85836_();
            poseStack.m_252880_(comet.x, comet.y, 0.0f);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            guiGraphics.m_280398_(new ResourceLocation("etheria", "textures/gui/comet.png"), (int)(-19.0f + comet.offX + (float)this.offX), (int)(-20.0f + comet.offY + (float)this.offY), 0, 38.0f, 40.0f, 38, 40, 38, 40);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (GuiEventListener listener : this.m_6702_()) {
                SpellSelectWidget pw;
                AbstractButton abstractButton;
                if (!(listener instanceof AbstractButton) || !((abstractButton = (AbstractButton)listener) instanceof SpellSelectWidget) || !(pw = (SpellSelectWidget)abstractButton).isHover() || pw.isFixed || pw.isBase()) continue;
                pw.m_5691_();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (GuiEventListener listener : this.m_6702_()) {
                AbstractButton abstractButton;
                if (!(listener instanceof AbstractButton) || !((abstractButton = (AbstractButton)listener) instanceof SpellSelectWidget)) continue;
                SpellSelectWidget pw = (SpellSelectWidget)abstractButton;
                if (pw.isFixed) continue;
                pw.m_7691_(mouseX, mouseY);
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public static boolean isHovered(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    @Override
    public int getScale() {
        return 0;
    }

    public void m_232761_() {
        super.m_232761_();
    }

    public List<StarConnection> getStarConnections() {
        return this.starConnections;
    }

    public List<SkillConnection> getSkillConnections() {
        return this.skillConnections;
    }

    public float getAnimationProgress() {
        return this.animationProgress;
    }

    public String getAnimationId() {
        return this.animationId;
    }

    public Map<String, StarWidget> getStars() {
        return this.stars;
    }

    public Map<String, SkillWidget> getSkillWidgets() {
        return this.skillWidgets;
    }

    public Map<String, ConstellationInfo> getConstellations() {
        return this.constellations;
    }

    public String getType() {
        return this.type;
    }

    public String getUnlockStar() {
        return this.unlockStar;
    }

    public String getConstellation() {
        return this.constellation;
    }

    public float getAnimation() {
        return this.animation;
    }

    public int getOffX() {
        return this.offX;
    }

    public int getOffY() {
        return this.offY;
    }

    public float getZoom() {
        return this.zoom;
    }

    public int getBACKGROUND_SIZE() {
        return this.BACKGROUND_SIZE;
    }

    public int getMaxScrollX() {
        return this.maxScrollX;
    }

    public int getMaxScrollY() {
        return this.maxScrollY;
    }

    public int getStarsAmount() {
        return this.starsAmount;
    }

    public Map<String, Float> getWidgetSize() {
        return this.widgetSize;
    }

    public ParticleContainer getParticleContainer() {
        return this.particleContainer;
    }

    public ParticleContainer getScreenParticleContainer() {
        return this.screenParticleContainer;
    }

    public SoundInstance getInstance() {
        return this.instance;
    }

    public int getLastOffX() {
        return this.lastOffX;
    }

    public int getLastOffY() {
        return this.lastOffY;
    }

    public List<CometWidget> getComets() {
        return this.comets;
    }

    public List<Vec2> getUnlockedStars() {
        return this.unlockedStars;
    }

    public List<Vec2> getActiveStars() {
        return this.activeStars;
    }

    public List<Vec2> getAllStars() {
        return this.allStars;
    }

    public float getTargetOffX() {
        return this.targetOffX;
    }

    public float getTargetOffY() {
        return this.targetOffY;
    }

    public void setStarConnections(List<StarConnection> starConnections) {
        this.starConnections = starConnections;
    }

    public void setSkillConnections(List<SkillConnection> skillConnections) {
        this.skillConnections = skillConnections;
    }

    public void setAnimationProgress(float animationProgress) {
        this.animationProgress = animationProgress;
    }

    public void setAnimationId(String animationId) {
        this.animationId = animationId;
    }

    public void setStars(Map<String, StarWidget> stars) {
        this.stars = stars;
    }

    public void setSkillWidgets(Map<String, SkillWidget> skillWidgets) {
        this.skillWidgets = skillWidgets;
    }

    public void setConstellations(Map<String, ConstellationInfo> constellations) {
        this.constellations = constellations;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUnlockStar(String unlockStar) {
        this.unlockStar = unlockStar;
    }

    public void setConstellation(String constellation) {
        this.constellation = constellation;
    }

    public void setAnimation(float animation) {
        this.animation = animation;
    }

    public void setOffX(int offX) {
        this.offX = offX;
    }

    public void setOffY(int offY) {
        this.offY = offY;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public void setMaxScrollX(int maxScrollX) {
        this.maxScrollX = maxScrollX;
    }

    public void setMaxScrollY(int maxScrollY) {
        this.maxScrollY = maxScrollY;
    }

    public void setStarsAmount(int starsAmount) {
        this.starsAmount = starsAmount;
    }

    public void setWidgetSize(Map<String, Float> widgetSize) {
        this.widgetSize = widgetSize;
    }

    public void setParticleContainer(ParticleContainer particleContainer) {
        this.particleContainer = particleContainer;
    }

    public void setScreenParticleContainer(ParticleContainer screenParticleContainer) {
        this.screenParticleContainer = screenParticleContainer;
    }

    public void setInstance(SoundInstance instance) {
        this.instance = instance;
    }

    public void setLastOffX(int lastOffX) {
        this.lastOffX = lastOffX;
    }

    public void setLastOffY(int lastOffY) {
        this.lastOffY = lastOffY;
    }

    public void setTargetOffX(float targetOffX) {
        this.targetOffX = targetOffX;
    }

    public void setTargetOffY(float targetOffY) {
        this.targetOffY = targetOffY;
    }
}

