/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.mralxart.etheria.client.utils.GuiUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.spells.SpellsCooldown;
import it.mralxart.etheria.magic.spells.TickingSpells;
import it.mralxart.etheria.magic.spells.data.SpellData;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.CastSpellPacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.registry.KeybindsRegistry;
import it.mralxart.etheria.utils.ItemUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

public class SpellsHud {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static List<String> spells = new ArrayList<String>();
    private static int mousedDelta = 0;
    private static int animationDelta = 0;
    private static int selectedMarker = 0;
    public static Map<String, SpellsCooldown> spellsCooldown = new HashMap<String, SpellsCooldown>();

    public static void renderHud(GuiGraphics guiGraphics, float partialTicks) {
        if (animationDelta <= 0) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        Window window = minecraft.m_91268_();
        LocalPlayer player = SpellsHud.minecraft.f_91074_;
        if (player == null || spells.isEmpty()) {
            return;
        }
        if (!ItemUtils.onHand((Player)player, (Item)ItemRegistry.MAGIC_STICK.get())) {
            return;
        }
        int x = window.m_85445_() / 2;
        int y = window.m_85446_() / 2;
        x -= 9;
        poseStack.m_85836_();
        float wobbleOffset = (float)Math.sin((double)animationDelta * 0.3) * 10.0f;
        float offsetX = (float)animationDelta * 4.0f;
        poseStack.m_252880_(offsetX - 2.0f, wobbleOffset - 5.0f, 0.0f);
        int baseX = -20;
        int baseY = y - 115;
        SpellsHud.renderSpellCard(guiGraphics, baseX - 5, (float)mousedDelta / 10.0f + (float)baseY + 5.0f, -2);
        SpellsHud.renderSpellCard(guiGraphics, baseX - 2, (float)mousedDelta / 5.0f + (float)baseY + 50.0f, -1);
        SpellsHud.renderSpellCard(guiGraphics, baseX, (float)mousedDelta / 2.0f + (float)baseY + 105.0f, 0);
        SpellsHud.renderSpellCard(guiGraphics, baseX - 2, (float)mousedDelta / 5.0f + (float)baseY + 160.0f, 1);
        SpellsHud.renderSpellCard(guiGraphics, baseX - 5, (float)mousedDelta / 10.0f + (float)baseY + 205.0f, 2);
        poseStack.m_85849_();
    }

    private static void renderSpellCard(GuiGraphics guiGraphics, float x, float y, int marker) {
        String spell = SpellsHud.getSpellByMarker(SpellsHud.getRelativeIndex(marker));
        if (spell == null) {
            return;
        }
        float scale = 0.0f;
        if (marker == 1 || marker == -1) {
            scale = (float)animationDelta * 0.01f;
        }
        if (marker == 1 || marker == -1) {
            scale = (float)animationDelta * 0.02f;
        }
        if (marker == 0) {
            scale = (float)animationDelta * 0.03f;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        ResourceLocation spellCard = new ResourceLocation("etheria", "textures/magic/spells/" + spell + ".png");
        ResourceLocation paper = new ResourceLocation("etheria", "textures/gui/spell_paper.png");
        ResourceLocation element = new ResourceLocation("etheria", "textures/gui/line_" + SpellsUtils.getSpellElement(spell).toLowerCase() + ".png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)spellCard);
        RenderSystem.enableBlend();
        if (marker == 0) {
            int textWidth = SpellsHud.minecraft.f_91062_.m_92852_((FormattedText)GuiUtils.translate("mage_micon.spell." + spell));
            int adjustedX = (int)x + 40 + textWidth / 2;
            GuiUtils.drawString(guiGraphics, SpellsHud.minecraft.f_91062_, GuiUtils.translate("mage_micon.spell." + spell), adjustedX, (int)y + 10, 0xFFFFFF, true);
        }
        int cooldown = SpellsHud.getSpellCooldown(spell);
        int cap = SpellsHud.getSpellCooldownCap(spell);
        poseStack.m_85836_();
        if (marker == 0) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.1f + scale));
            GuiUtils.blit(guiGraphics, paper, x - 4.0f, y - 2.0f, 0, 0, 31, 40, 31, 40, 1.25f + scale);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f + scale));
            GuiUtils.blit(guiGraphics, element, x - 7.0f, y - 5.0f, 0, 0, 31, 40, 31, 40, 1.25f + scale);
            GuiUtils.blit(guiGraphics, paper, x - 7.0f, y - 5.0f, 0, 0, 31, 40, 31, 40, 1.25f + scale);
            GuiUtils.blit(guiGraphics, spellCard, x, y, 0, 0, 18, 27, 18, 27, 1.25f + scale);
            if (cooldown > 0) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)spellCard);
                RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)0.2f);
                float percentage = (float)cooldown / ((float)cap / 100.0f) / 100.0f;
                int height = (int)(40.0f * percentage);
                GuiUtils.blit(guiGraphics, paper, x - 7.0f, y - 5.0f, 0, 40 - height, 31, height, 31, 40, 1.25f + scale);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        } else {
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.1f + scale));
            GuiUtils.blit(guiGraphics, paper, x - 4.0f, y - 2.0f, 0, 0, 31, 40, 31, 40, 1.0f + scale);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f + scale));
            GuiUtils.blit(guiGraphics, element, x - 7.0f, y - 5.0f, 0, 0, 31, 40, 31, 40, 1.0f + scale);
            GuiUtils.blit(guiGraphics, paper, x - 7.0f, y - 5.0f, 0, 0, 31, 40, 31, 40, 1.0f + scale);
            GuiUtils.blit(guiGraphics, spellCard, x, y, 0, 0, 18, 27, 18, 27, 1.0f + scale);
            if (cooldown > 0) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)spellCard);
                RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)0.2f);
                float percentage = (float)cooldown / ((float)cap / 100.0f) / 100.0f;
                int height = (int)(40.0f * percentage);
                GuiUtils.blit(guiGraphics, paper, x - 7.0f, y - 5.0f, 0, 40 - height, 31, height, 31, 40, 1.0f + scale);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    @Nullable
    private static String getSpellByMarker(int marker) {
        if (spells.isEmpty()) {
            return null;
        }
        return spells.get(Mth.m_14045_((int)marker, (int)0, (int)(spells.size() - 1)));
    }

    private static int getRelativeIndex(int offset) {
        int current = selectedMarker;
        int sum = current + offset;
        int max = spells.size() - 1;
        return sum > max ? Math.min(max, sum - (max + 1)) : (sum < 0 ? Math.max(0, sum + (max + 1)) : sum);
    }

    private static void updateHud(Player player) {
        if (animationDelta == 0) {
            return;
        }
        spells = new ArrayList<String>(CapabilityRegistry.getCap(player).getActiveSpells().keySet());
        if (selectedMarker > spells.size() || selectedMarker < 0) {
            selectedMarker = 0;
        }
        if (mousedDelta > 0) {
            --mousedDelta;
        } else if (mousedDelta < 0) {
            ++mousedDelta;
        }
        List<SpellData> defaultSpellData = SpellsUtils.getDataSpells();
        for (SpellData spellData : defaultSpellData) {
            String spellId2 = spellData.getId();
            if (spellId2 == null) continue;
            Element element = Element.ofString(spellData.getElement());
            if (spells.contains(spellId2) && !CapabilityRegistry.getCap(player).getElement().equals((Object)element) && !CapabilityRegistry.getCap(player).getElement2().equals((Object)element)) {
                spells.remove(spellId2);
            }
            spellsCooldown.computeIfAbsent(spellId2, SpellsCooldown::new);
        }
        spellsCooldown.keySet().removeIf(spellId -> defaultSpellData.stream().noneMatch(spellData -> spellData.getId().equals(spellId)));
    }

    private static void setDelta(int delta) {
        int current = selectedMarker;
        int sum = current + delta;
        int max = spells.size() - 1;
        selectedMarker = sum > max ? sum - max - 1 : (sum < 0 ? max : sum);
    }

    public static int getSpellCooldown(String spell) {
        return spellsCooldown.values().stream().filter(spellCooldown -> spellCooldown.getId().equals(spell)).map(SpellsCooldown::getCooldown).findFirst().orElse(0);
    }

    public static void setSpellCooldownWithCap(String spell, int cooldown) {
        spellsCooldown.compute(spell, (key, existing) -> {
            if (existing == null) {
                return new SpellsCooldown(spell, cooldown);
            }
            existing.setCooldown(cooldown);
            existing.setCap(cooldown);
            return existing;
        });
    }

    public static void setSpellCooldown(String spell, int cooldown) {
        spellsCooldown.compute(spell, (key, existing) -> {
            if (existing == null) {
                return new SpellsCooldown(spell, cooldown);
            }
            existing.setCooldown(cooldown);
            return existing;
        });
    }

    public static int getSpellCooldownCap(String spell) {
        return spellsCooldown.values().stream().filter(spellCooldown -> spellCooldown.getId().equals(spell)).map(SpellsCooldown::getCap).findFirst().orElse(0);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class GeneralEvents {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
            if (!KeybindsRegistry.SPELLS.m_90857_() || spells.isEmpty()) {
                return;
            }
            int current = selectedMarker;
            SpellsHud.setDelta(event.getScrollDelta() > 0.0 ? -1 : 1);
            if (current != selectedMarker) {
                mousedDelta = event.getScrollDelta() > 0.0 ? -10 : 10;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    player.m_5496_(SoundEvents.f_11713_, 0.5f, 1.0f + player.m_217043_().m_188501_() * 0.25f);
                }
            }
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.side != LogicalSide.CLIENT || event.phase != TickEvent.Phase.END) {
                return;
            }
            Player player = event.player;
            if (!(player instanceof LocalPlayer)) {
                return;
            }
            for (SpellsCooldown cooldown : spellsCooldown.values()) {
                if (cooldown.getCooldown() <= 0) continue;
                SpellsHud.setSpellCooldown(cooldown.getId(), cooldown.getCooldown() - 1);
            }
            if (!ItemUtils.onHand(player, (Item)ItemRegistry.MAGIC_STICK.get())) {
                return;
            }
            if (KeybindsRegistry.SPELLS.m_90857_()) {
                GeneralEvents.handleSpellSelection(player);
            } else {
                GeneralEvents.handleSpellDeselection();
            }
            if (animationDelta == 0) {
                return;
            }
            SpellsHud.updateHud(player);
            if (selectedMarker > spells.size() || selectedMarker < 0) {
                selectedMarker = 0;
            }
        }

        @SubscribeEvent
        public static void onKeyPressed(InputEvent.MouseButton.Pre event) {
            if (animationDelta == 0 || event.getAction() != 1 || event.getButton() != 0) {
                return;
            }
            Minecraft MC = Minecraft.m_91087_();
            if (MC.f_91080_ != null) {
                return;
            }
            LocalPlayer player = MC.f_91074_;
            if (player == null) {
                return;
            }
            if (!ItemUtils.onHand((Player)player, (Item)ItemRegistry.MAGIC_STICK.get())) {
                return;
            }
            event.setCanceled(true);
            String spell = SpellsHud.getSpellByMarker(selectedMarker);
            if (spell == null) {
                return;
            }
            int cooldown = SpellsHud.getSpellCooldown(spell);
            if (cooldown > 0) {
                return;
            }
            Networking.sendToServer(new CastSpellPacket(spell));
        }

        private static void handleSpellSelection(Player player) {
            String spell = SpellsHud.getSpellByMarker(selectedMarker);
            if (spell != null) {
                TickingSpells.tick(player, spell);
            }
            if (animationDelta < 10) {
                ++animationDelta;
            }
        }

        private static void handleSpellDeselection() {
            if (animationDelta > 0) {
                --animationDelta;
            }
        }
    }
}

