/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui.magemicon.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import it.mralxart.etheria.capability.EtheriaCapability;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.base.WidgetBase;
import it.mralxart.etheria.client.particles.ScreenGlowingParticle;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.magemicon.MageMicon;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.C2SPacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementSlotWidget
extends WidgetBase
implements ICustomRenderWidget,
ITickWidget {
    private final MageMicon micon;
    private float scale = 1.0f;
    private float xOff = 1.0f;
    public boolean hovered = false;
    @Nullable
    public Element element;

    public ElementSlotWidget(int x, int y, MageMicon micon, @Nullable Element element) {
        super(x, y, 18, 18);
        this.micon = micon;
        this.element = element;
    }

    @Override
    public void m_7435_(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.3f));
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    @Override
    public void m_5691_() {
        if (this.element != null && CapabilityRegistry.getCap((Player)Minecraft.m_91087_().f_91074_).getElements().contains((Object)this.element) && !CapabilityRegistry.getCap((Player)Minecraft.m_91087_().f_91074_).getElement().equals((Object)this.element)) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("element", this.element.name().toLowerCase());
            Networking.sendToServer(new C2SPacket(tag, 1));
            this.micon.updatePages();
            this.micon.resetScreen();
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        this.hovered = this.isHovered(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), pMouseX, pMouseY);
        poseStack.m_85836_();
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / this.scale, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / this.scale, 200.0f);
        EtheriaCapability cap = CapabilityRegistry.getCap((Player)Minecraft.m_91087_().f_91074_);
        if (this.element != null && cap.getElements().contains((Object)this.element)) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), -9, -9, 0.0f, 0.0f, 18, 18, 18, 18);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/item/scroll_" + this.element.name().toLowerCase() + ".png"), -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
            if (this.micon.tickCount % 2 == 0) {
                this.micon.getParticleContainer().addParticle(new ScreenGlowingParticle((float)(this.m_252754_() - 8) + (float)this.f_93618_ / 2.0f / this.scale + (new Random().nextFloat() - new Random().nextFloat()) * 7.0f, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f / this.scale, 0.0f, -0.3f, 0.3f, (int)(20.0f + new Random().nextFloat() * 32.0f), 3.0f, ElementsUtils.getColorByElement(this.element)));
            }
        } else if (this.element != null && !cap.getElements().contains((Object)this.element)) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/locked_widget.png"), -9, -9, 0.0f, 0.0f, 18, 18, 18, 18);
            if (this.micon.tickCount % 2 == 0) {
                this.micon.getParticleContainer().addParticle(new ScreenGlowingParticle((float)(this.m_252754_() - 8) + (float)this.f_93618_ / 2.0f / this.scale + (new Random().nextFloat() - new Random().nextFloat()) * 7.0f, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f / this.scale, 0.0f, -0.3f, 0.3f, (int)(20.0f + new Random().nextFloat() * 26.0f), 3.0f, ElementsUtils.getColorByElement(this.element)));
            }
        } else if (this.element == null) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/locked_widget.png"), -9, -9, 0.0f, 0.0f, 18, 18, 18, 18);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/lock.png"), -10, -10, 0.0f, 0.0f, 20, 20, 20, 20);
        }
        if (this.element != null && cap.getElement().equals((Object)this.element)) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget_hover.png"), -10, -10, 0.0f, 0.0f, 20, 20, 20, 20);
        }
        poseStack.m_85849_();
    }

    @Override
    public void tick() {
        float maxScale = 1.1f;
        float minScale = 1.0f;
        if (this.hovered) {
            if (this.xOff < maxScale) {
                this.xOff = Math.min(maxScale, this.xOff + (maxScale - this.xOff) * 0.25f);
            }
        } else if (this.xOff != minScale) {
            this.xOff = Math.max(minScale, this.xOff - 0.5f);
        }
        this.scale = this.xOff;
    }

    @Override
    public boolean isHover() {
        return this.hovered;
    }
}

