/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui.magemicon.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.base.WidgetBase;
import it.mralxart.etheria.client.utils.GuiUtils;
import it.mralxart.etheria.magic.magemicon.MageMicon;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class KorLunarSlotWidget
extends WidgetBase
implements ICustomRenderWidget,
ITickWidget {
    public final Predicate<ItemStack> itemFilter;
    private final MageMicon micon;
    private float scale = 1.0f;
    private float xOff = 1.0f;
    public int id;
    public ItemStack selectedItem = ItemStack.f_41583_;
    public int selectedSlotIndex = -1;
    public boolean hovered = false;
    public boolean open;

    public KorLunarSlotWidget(int x, int y, MageMicon micon, int id, Predicate<ItemStack> itemFilter) {
        super(x, y, 18, 18);
        this.micon = micon;
        this.itemFilter = itemFilter;
        this.id = id;
    }

    @Override
    public void m_7435_(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.3f));
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    public boolean isItemValid(ItemStack stack) {
        return this.itemFilter.test(stack);
    }

    @Override
    public void render(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        this.hovered = this.isHovered(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), pMouseX, pMouseY);
        poseStack.m_85836_();
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / this.scale, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / this.scale, 0.0f);
        guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), -9, -9, 0.0f, 0.0f, 18, 18, 18, 18);
        if (this.selectedSlotIndex != -1 && Minecraft.m_91087_().f_91074_ != null) {
            this.selectedItem = (ItemStack)Minecraft.m_91087_().f_91074_.m_150109_().f_35974_.get(this.selectedSlotIndex);
        }
        if (!this.selectedItem.m_41619_()) {
            guiGraphics.m_280480_(this.selectedItem, -8, -8);
            if (this.selectedItem.m_41613_() > 1) {
                String countText = String.valueOf(this.selectedItem.m_41613_());
                int xOffset = 12 - Minecraft.m_91087_().f_91062_.m_92895_(countText) / 2;
                int yOffset = 2;
                poseStack.m_252880_(0.0f, 0.0f, 200.0f);
                GuiUtils.drawStringWithShadow(guiGraphics, Minecraft.m_91087_().f_91062_, countText, xOffset, yOffset, 14003075, 9858892);
            }
        }
        poseStack.m_85849_();
        if (!this.selectedItem.m_41619_() && this.isHover()) {
            guiGraphics.m_280153_(Minecraft.m_91087_().f_91062_, this.selectedItem, pMouseX, pMouseY);
        }
        if (this.open) {
            this.renderInventoryByItem(guiGraphics, pMouseX, pMouseY);
        }
    }

    private void renderInventoryByItem(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        ArrayList<ItemStack> filteredItems = new ArrayList<ItemStack>();
        if (Minecraft.m_91087_().f_91074_ != null) {
            for (ItemStack item : Minecraft.m_91087_().f_91074_.m_150109_().f_35974_) {
                if (!this.isItemValid(item)) continue;
                filteredItems.add(item);
            }
        }
        if (filteredItems.isEmpty()) {
            return;
        }
        int columns = Math.min(9, filteredItems.size());
        int rows = (int)Math.ceil((double)filteredItems.size() / (double)columns);
        int cellSize = 16;
        int padding = 1;
        int width = columns * cellSize + (columns - 1) * padding;
        int height = rows * cellSize + (rows - 1) * padding;
        int centerX = this.m_252754_();
        int centerY = this.m_252907_();
        int startX = centerX - width / 2;
        int startY = centerY + this.m_93694_();
        KorLunarSlotWidget.drawTexturedTooltipBorder(guiGraphics, new ResourceLocation("etheria", "textures/gui/border_paper.png"), width - 8, height - 8, startX + 4, startY);
        for (int i = 0; i < filteredItems.size(); ++i) {
            int row = i / columns;
            int col = i % columns;
            int itemX = startX + col * (cellSize + padding) + 8;
            int itemY = startY + row * (cellSize + padding) + 3;
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), itemX, itemY + 1, 0.0f, 0.0f, 18, 18, 18, 18);
            GuiUtils.renderItemWithTooltip(guiGraphics, (ItemStack)filteredItems.get(i), itemX + 1, itemY + 2, 1.0f, pMouseX, pMouseY, true, false);
        }
    }

    public static void drawTexturedTooltipBorder(GuiGraphics guiGraphics, ResourceLocation texture, int width, int height, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        Minecraft.m_91087_().m_91097_().m_174784_(texture);
        int texSize = 19;
        int cornerSize = 9;
        guiGraphics.m_280411_(texture, x, y, cornerSize, cornerSize, 0.0f, 0.0f, cornerSize, cornerSize, texSize, texSize);
        guiGraphics.m_280411_(texture, x + cornerSize, y, width, cornerSize, (float)cornerSize, 0.0f, 1, cornerSize, texSize, texSize);
        guiGraphics.m_280411_(texture, x + cornerSize + width, y, cornerSize, cornerSize, (float)(cornerSize + 1), 0.0f, cornerSize, cornerSize, texSize, texSize);
        guiGraphics.m_280411_(texture, x, y + cornerSize, cornerSize, height, 0.0f, (float)cornerSize, cornerSize, 1, texSize, texSize);
        guiGraphics.m_280411_(texture, x + width + cornerSize, y + cornerSize, cornerSize, height, (float)(cornerSize + 1), (float)cornerSize, cornerSize, 1, texSize, texSize);
        guiGraphics.m_280411_(texture, x + cornerSize, y + cornerSize, width, height, (float)(cornerSize + 1), (float)(cornerSize + 1), 1, 1, texSize, texSize);
        guiGraphics.m_280411_(texture, x, y + height + cornerSize, cornerSize, cornerSize, 0.0f, (float)(cornerSize + 1), cornerSize, cornerSize, texSize, texSize);
        guiGraphics.m_280411_(texture, x + cornerSize, y + height + cornerSize, width, cornerSize, (float)cornerSize, (float)(cornerSize + 1), 1, cornerSize, texSize, texSize);
        guiGraphics.m_280411_(texture, x + cornerSize + width, y + cornerSize + height, cornerSize, cornerSize, (float)(cornerSize + 1), (float)(cornerSize + 1), cornerSize, cornerSize, texSize, texSize);
    }

    @Override
    public void tick() {
        float maxScale = 1.1f;
        float minScale = 1.0f;
        if (this.hovered) {
            if (this.xOff < maxScale) {
                this.xOff = Math.min(maxScale, this.xOff + (maxScale - this.xOff) * 0.55f);
            }
        } else if (this.xOff != minScale) {
            this.xOff = Math.max(minScale, this.xOff - 0.5f);
        }
        this.scale = this.xOff;
    }

    private boolean isMouseOverItem(double mouseX, double mouseY, int itemX, int itemY, int cellSize) {
        return mouseX >= (double)itemX && mouseX < (double)(itemX + cellSize) && mouseY >= (double)itemY && mouseY < (double)(itemY + cellSize);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int button) {
        ArrayList<ItemStack> filteredItems = new ArrayList<ItemStack>();
        if (this.isHovered(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), (int)pMouseX, (int)pMouseY)) {
            for (GuiEventListener listener : this.micon.m_6702_()) {
                KorLunarSlotWidget widget1;
                ICustomRenderWidget widget;
                AbstractButton b;
                if (!(listener instanceof AbstractButton) || !((b = (AbstractButton)listener) instanceof ICustomRenderWidget) || !((widget = (ICustomRenderWidget)b) instanceof KorLunarSlotWidget) || (widget1 = (KorLunarSlotWidget)widget) == this) continue;
                widget1.open = false;
            }
            boolean bl = this.open = !this.open;
        }
        if (Minecraft.m_91087_().f_91074_ != null) {
            for (ItemStack item : Minecraft.m_91087_().f_91074_.m_150109_().f_35974_) {
                if (!this.isItemValid(item)) continue;
                filteredItems.add(item);
            }
        }
        if (!this.open) {
            return false;
        }
        int columns = Math.min(9, filteredItems.size());
        int cellSize = 16;
        int padding = 1;
        int width = columns * cellSize + (columns - 1) * padding;
        int centerX = this.m_252754_();
        int centerY = this.m_252907_();
        int startX = centerX - width / 2;
        int startY = centerY + this.m_93694_();
        for (int i = 0; i < filteredItems.size(); ++i) {
            int col = i % columns;
            int itemX = startX + col * (cellSize + padding) + 8;
            int row = i / columns;
            int itemY = startY + row * (cellSize + padding) + 3;
            if (!this.isMouseOverItem((int)pMouseX, (int)pMouseY, itemX, itemY, cellSize)) continue;
            for (GuiEventListener listener : this.micon.m_6702_()) {
                KorLunarSlotWidget widget1;
                ICustomRenderWidget widget;
                AbstractButton b;
                if (!(listener instanceof AbstractButton) || !((b = (AbstractButton)listener) instanceof ICustomRenderWidget) || !((widget = (ICustomRenderWidget)b) instanceof KorLunarSlotWidget) || (widget1 = (KorLunarSlotWidget)widget) == this) continue;
                widget1.open = false;
            }
            this.selectedItem = ((ItemStack)filteredItems.get(i)).m_41777_();
            this.selectedSlotIndex = this.findItemSlotIndex(this.selectedItem);
            this.open = !this.open;
        }
        return false;
    }

    private int findItemSlotIndex(ItemStack item) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            for (int i = 0; i < Minecraft.m_91087_().f_91074_.m_150109_().f_35974_.size(); ++i) {
                ItemStack stackInSlot = (ItemStack)Minecraft.m_91087_().f_91074_.m_150109_().f_35974_.get(i);
                if (!ItemStack.m_150942_((ItemStack)item, (ItemStack)stackInSlot)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean isHover() {
        return this.hovered;
    }
}

