/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui.magemicon.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.base.WidgetBase;
import it.mralxart.etheria.client.gui.magemicon.widgets.KorLunarSlotWidget;
import it.mralxart.etheria.client.particles.KorLunarParticle;
import it.mralxart.etheria.client.particles.ScreenGlowingParticle;
import it.mralxart.etheria.magic.korlunar.KorLunarLevels;
import it.mralxart.etheria.magic.korlunar.data.KorLunarLevel;
import it.mralxart.etheria.magic.magemicon.MageMicon;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.KorLunarUpPacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.utils.ColorUtils;
import it.mralxart.etheria.utils.ItemUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class KorLunarUpWidget
extends WidgetBase
implements ICustomRenderWidget,
ITickWidget {
    private final MageMicon micon;
    private float scale = 1.0f;
    private float xOff = 1.0f;
    public boolean hovered = false;

    public KorLunarUpWidget(int x, int y, MageMicon micon) {
        super(x, y, 46, 46);
        this.micon = micon;
    }

    @Override
    public void m_7435_(SoundManager handler) {
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    @Override
    public void m_5691_() {
        KorLunarLevel lunarLevel = KorLunarLevels.getLevel(CapabilityRegistry.getCap((Player)Minecraft.m_91087_().f_91074_).getKorLunar());
        if (!lunarLevel.getRitual().isEmpty()) {
            return;
        }
        List<ItemStack> levelList = lunarLevel.getIngredients();
        List<ItemStack> slotsItems = this.getItemsInSlots();
        if (slotsItems.size() < levelList.size()) {
            return;
        }
        boolean itemsMatch = true;
        for (int i = 0; i < levelList.size(); ++i) {
            ItemStack slotItem;
            ItemStack levelItem = levelList.get(i);
            if (ItemStack.m_150942_((ItemStack)levelItem, (ItemStack)(slotItem = slotsItems.get(i))) && slotItem.m_41613_() >= levelItem.m_41613_()) continue;
            itemsMatch = false;
            break;
        }
        if (itemsMatch) {
            Networking.sendToServer(new KorLunarUpPacket(1));
            Random random = new Random();
            float startX = (float)this.micon.f_96543_ / 2.0f - (float)this.micon.backgroundHeight / 2.0f + 152.0f + 8.0f + 67.0f;
            float startY = (float)this.micon.f_96544_ / 2.0f - (float)this.micon.backgroundWidth / 2.0f + 60.0f;
            for (int i = 0; i < 100; ++i) {
                float offsetX = (float)(random.nextGaussian() * 0.2);
                float offsetY = (float)(random.nextGaussian() * 0.2);
                float speedX = (float)(random.nextGaussian() * 2.0);
                float speedY = (float)(random.nextGaussian() * 2.0);
                this.micon.getParticleContainer().addParticle(new ScreenGlowingParticle(startX + offsetX, startY + offsetY, speedX, speedY, 0.6f, 60, 2.0f, new Color(this.getRandomEtherColor())));
            }
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_276532_, (float)1.3f));
            if (Minecraft.m_91087_().f_91074_ != null) {
                for (ItemStack itemStack : levelList) {
                    ItemUtils.removeItemsFromInventory(Minecraft.m_91087_().f_91074_.m_150109_(), itemStack);
                }
            }
        }
        this.micon.updatePages();
        this.micon.resetScreen();
    }

    public List<? extends GuiEventListener> getSlots() {
        return this.micon.m_6702_().stream().filter(this::isKorLunarSlotWidget).toList();
    }

    private boolean isKorLunarSlotWidget(GuiEventListener widget) {
        return widget instanceof KorLunarSlotWidget;
    }

    public List<ItemStack> getItemsInSlots() {
        List<? extends GuiEventListener> widgets = this.getSlots();
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (GuiEventListener guiEventListener : widgets) {
            if (!(guiEventListener instanceof KorLunarSlotWidget)) continue;
            KorLunarSlotWidget korLunarSlotWidget = (KorLunarSlotWidget)guiEventListener;
            itemStacks.add(korLunarSlotWidget.selectedItem);
        }
        return itemStacks;
    }

    @Override
    public void render(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        this.hovered = this.isHovered(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), pMouseX, pMouseY);
        poseStack.m_85836_();
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / this.scale, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / this.scale, 0.0f);
        guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/kor_lunar.png"), -23, -23, 0.0f, 0.0f, 46, 46, 46, 46);
        poseStack.m_85849_();
        KorLunarLevel lunarLevel = KorLunarLevels.getLevel(CapabilityRegistry.getCap((Player)Minecraft.m_91087_().f_91074_).getKorLunar());
        int slotSize = this.getSlots().size();
        int itemsSize = lunarLevel.getIngredients().size();
        if (slotSize != itemsSize) {
            this.micon.updatePages();
            this.micon.resetScreen();
        }
        if (this.micon.tickCount % 5 == 0) {
            float startX = (float)this.micon.f_96543_ / 2.0f - (float)this.micon.backgroundHeight / 2.0f + 152.0f + 8.0f + 67.0f;
            float startY = (float)this.micon.f_96544_ / 2.0f - (float)this.micon.backgroundWidth / 2.0f + 60.0f;
            float directionX = (float)pMouseX - startX;
            float directionY = (float)pMouseY - startY;
            float magnitude = (float)Math.sqrt(directionX * directionX + directionY * directionY);
            float unitX = directionX / magnitude;
            float unitY = directionY / magnitude;
            float speed = 0.5f;
            float velocityX = unitX * speed;
            float velocityY = unitY * speed;
            this.micon.getParticleContainer().addParticle(new KorLunarParticle(startX + (float)new Random().nextInt(-20, 20), startY, velocityX, velocityY, 0.3f, 80, 2.0f, Color.WHITE));
            this.micon.getParticleContainer().addParticle(new ScreenGlowingParticle(startX + (float)new Random().nextInt(-20, 20), startY, 0.0f, 0.5f, 0.4f, 60, 2.0f, new Color(this.getRandomEtherColor())));
        }
    }

    private int getRandomEtherColor() {
        return ColorUtils.getRandomColorRGB(new Color(213, 185, 237), new Color(253, 249, 255), new Color(190, 153, 222), new Color(226, 215, 249));
    }

    @Override
    public void tick() {
        float maxScale = 1.1f;
        float minScale = 1.0f;
        if (this.hovered) {
            if (this.xOff < maxScale) {
                this.xOff = Math.min(maxScale, this.xOff + (maxScale - this.xOff) * 0.25f);
            }
        } else if (this.xOff != minScale) {
            this.xOff = Math.max(minScale, this.xOff - 0.5f);
        }
        this.scale = this.xOff;
    }

    @Override
    public boolean isHover() {
        return this.hovered;
    }
}

