/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui.magemicon.widgets;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.vertex.PoseStack;
import it.mralxart.etheria.artifacts.ArtifactStatsManager;
import it.mralxart.etheria.capability.EtheriaCapability;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.base.WidgetBase;
import it.mralxart.etheria.client.gui.magemicon.widgets.SlotWidget;
import it.mralxart.etheria.items.SpellScrollItem;
import it.mralxart.etheria.magic.magemicon.MageMicon;
import it.mralxart.etheria.magic.spells.Spell;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.SlotChangePacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.utils.ItemUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SlotOutWidget
extends WidgetBase
implements ICustomRenderWidget,
ITickWidget {
    private final MageMicon micon;
    private float scale = 1.0f;
    private float xOff = 1.0f;
    private ItemStack selectedItem = ItemStack.f_41583_;
    public boolean hovered = false;
    private ItemStack firstSlotStack = ItemStack.f_41583_;
    private ItemStack secondSlotStack = ItemStack.f_41583_;

    public SlotOutWidget(int x, int y, MageMicon micon) {
        super(x, y, 18, 18);
        this.micon = micon;
    }

    @Override
    public void m_7435_(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.3f));
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    @Override
    public void render(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        this.hovered = this.isHovered(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), pMouseX, pMouseY);
        EtheriaCapability cap = CapabilityRegistry.getCap((Player)Minecraft.m_91087_().f_91074_);
        poseStack.m_85836_();
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / this.scale, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / this.scale, 0.0f);
        guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), -9, -9, 0.0f, 0.0f, 18, 18, 18, 18);
        if (!this.selectedItem.m_41619_()) {
            guiGraphics.m_280480_(this.selectedItem, -8, -8);
            guiGraphics.m_280370_(Minecraft.m_91087_().f_91062_, this.selectedItem, -8, -8);
        }
        poseStack.m_85849_();
        if (!this.selectedItem.m_41619_() && this.isHover()) {
            guiGraphics.m_280153_(Minecraft.m_91087_().f_91062_, this.selectedItem, pMouseX, pMouseY);
        }
    }

    @Override
    public void tick() {
        float maxScale = 1.1f;
        float minScale = 1.0f;
        if (this.hovered) {
            if (this.xOff < maxScale) {
                this.xOff = Math.min(maxScale, this.xOff + (maxScale - this.xOff) * 0.55f);
            }
        } else if (!this.selectedItem.m_41619_()) {
            float pulseSpeed = 3.0f;
            float pulseAmplitude = 0.15f;
            this.xOff = minScale + pulseAmplitude * (float)Math.sin(Blaze3D.m_83640_() * (double)pulseSpeed);
        } else if (this.xOff != minScale) {
            this.xOff = Math.max(minScale, this.xOff - 0.5f);
        }
        this.scale = this.xOff;
        if (this.getFirstSlot() != null && this.getSecondSlot() != null) {
            this.firstSlotStack = this.getFirstSlot().selectedItem;
            this.secondSlotStack = this.getSecondSlot().selectedItem;
            switch (this.micon.chapter.index) {
                case "anvil_artifacts": {
                    if (!this.firstSlotStack.m_41619_() && !this.secondSlotStack.m_41619_()) {
                        if (ArtifactStatsManager.isMaxLevel(this.firstSlotStack.m_41777_())) {
                            this.selectedItem = this.firstSlotStack.m_41777_();
                            break;
                        }
                        this.selectedItem = ArtifactStatsManager.levelUpStats(this.firstSlotStack.m_41777_());
                        break;
                    }
                    this.selectedItem = ItemStack.f_41583_;
                    break;
                }
                case "anvil_weapon": 
                case "anvil_spells": {
                    if (!this.firstSlotStack.m_41619_() && !this.secondSlotStack.m_41619_()) {
                        this.selectedItem = ArtifactStatsManager.transferStats(this.secondSlotStack.m_41777_(), this.firstSlotStack.m_41777_());
                        break;
                    }
                    this.selectedItem = ItemStack.f_41583_;
                    break;
                }
                case "reroll_artifacts": {
                    if (!this.firstSlotStack.m_41619_() && !this.secondSlotStack.m_41619_()) {
                        this.selectedItem = ArtifactStatsManager.setReroll(this.firstSlotStack.m_41777_());
                        break;
                    }
                    this.selectedItem = ItemStack.f_41583_;
                    break;
                }
                case "spell_upgrade": {
                    if (!this.firstSlotStack.m_41619_() && !this.secondSlotStack.m_41619_()) {
                        if (this.firstSlotStack.m_41783_() != null) {
                            this.firstSlotStack.m_41783_().m_128473_("etheria$spell_upgrade");
                        }
                        if (this.firstSlotStack.m_41782_() && this.firstSlotStack.m_41783_() != null && this.firstSlotStack.m_41783_().m_128441_("spell_id") && !SpellsUtils.isMaxLevel((Player)Minecraft.m_91087_().f_91074_, this.firstSlotStack.m_41783_().m_128461_("spell_id"))) {
                            ItemStack upgradeSpell = this.firstSlotStack.m_41777_();
                            upgradeSpell.m_41784_().m_128379_("etheria$spell_upgrade", true);
                            this.selectedItem = upgradeSpell;
                            break;
                        }
                        this.selectedItem = this.firstSlotStack.m_41777_();
                        break;
                    }
                    this.selectedItem = ItemStack.f_41583_;
                }
            }
        }
    }

    public SlotWidget getFirstSlot() {
        return this.micon.m_6702_().stream().filter(widget -> widget instanceof SlotWidget).filter(widget -> ((SlotWidget)widget).id == 1).findFirst().orElse(null);
    }

    public SlotWidget getSecondSlot() {
        return this.micon.m_6702_().stream().filter(widget -> widget instanceof SlotWidget).filter(widget -> ((SlotWidget)widget).id == 2).findFirst().orElse(null);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int button) {
        if (this.isHovered(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), (int)pMouseX, (int)pMouseY)) {
            this.firstSlotStack.m_41784_().m_128405_("etheria$slot_id", this.getFirstSlot().selectedSlotIndex);
            switch (this.micon.chapter.index) {
                case "anvil_artifacts": {
                    Networking.INSTANCE.sendToServer((Object)new SlotChangePacket(1, 0, this.firstSlotStack, this.secondSlotStack));
                    break;
                }
                case "anvil_weapon": {
                    Networking.INSTANCE.sendToServer((Object)new SlotChangePacket(1, 1, this.firstSlotStack, this.secondSlotStack));
                    break;
                }
                case "anvil_spells": {
                    Networking.INSTANCE.sendToServer((Object)new SlotChangePacket(1, 2, this.firstSlotStack, this.secondSlotStack));
                    break;
                }
                case "spell_upgrade": {
                    Networking.INSTANCE.sendToServer((Object)new SlotChangePacket(1, 4, this.firstSlotStack, this.secondSlotStack));
                }
            }
            if (Minecraft.m_91087_().f_91074_ != null) {
                switch (this.micon.chapter.index) {
                    case "anvil_artifacts": {
                        if (ArtifactStatsManager.isMaxLevel(this.firstSlotStack)) {
                            return false;
                        }
                        ItemStack upgradedItem = ArtifactStatsManager.levelUpStats(this.firstSlotStack.m_41777_());
                        ItemUtils.replaceItemInInventory(Minecraft.m_91087_().f_91074_.m_150109_(), this.getFirstSlot().selectedSlotIndex, upgradedItem);
                        ItemUtils.removeItemsFromInventory(Minecraft.m_91087_().f_91074_.m_150109_(), this.secondSlotStack, 1);
                        break;
                    }
                    case "anvil_weapon": {
                        ItemStack transferItem = ArtifactStatsManager.transferStats(this.secondSlotStack.m_41777_(), this.firstSlotStack.m_41777_());
                        ItemUtils.replaceItemInInventory(Minecraft.m_91087_().f_91074_.m_150109_(), this.firstSlotStack.m_41777_(), transferItem);
                        ItemUtils.removeItemsFromInventory(Minecraft.m_91087_().f_91074_.m_150109_(), this.secondSlotStack.m_41777_(), 1);
                        break;
                    }
                    case "anvil_spells": {
                        if (!(this.firstSlotStack.m_41720_() instanceof SpellScrollItem) || !this.firstSlotStack.m_41782_() || this.firstSlotStack.m_41783_() == null || !this.firstSlotStack.m_41783_().m_128441_("spell_id")) break;
                        Spell spell = ArtifactStatsManager.transferStats(this.secondSlotStack.m_41777_(), SpellsUtils.getSpell((Player)Minecraft.m_91087_().f_91074_, this.firstSlotStack.m_41783_().m_128461_("spell_id")));
                        SpellsUtils.putSpell((Player)Minecraft.m_91087_().f_91074_, spell);
                        ItemUtils.removeItemsFromInventory(Minecraft.m_91087_().f_91074_.m_150109_(), this.secondSlotStack.m_41777_(), 1);
                        break;
                    }
                    case "reroll_artifacts": {
                        if (ArtifactStatsManager.getLevel(this.firstSlotStack.m_41777_()) > 0) break;
                        ItemStack transferItem = ArtifactStatsManager.init(this.firstSlotStack.m_41777_());
                        ArtifactStatsManager.resetReroll(transferItem);
                        Networking.INSTANCE.sendToServer((Object)new SlotChangePacket(1, 3, transferItem, this.secondSlotStack));
                        ItemUtils.replaceItemInInventory(Minecraft.m_91087_().f_91074_.m_150109_(), this.firstSlotStack.m_41777_(), transferItem);
                        ItemUtils.removeItemsFromInventory(Minecraft.m_91087_().f_91074_.m_150109_(), this.secondSlotStack.m_41777_(), 1);
                        break;
                    }
                    case "spell_upgrade": {
                        if (!(this.firstSlotStack.m_41720_() instanceof SpellScrollItem) || !this.firstSlotStack.m_41782_() || this.firstSlotStack.m_41783_() == null || !this.firstSlotStack.m_41783_().m_128441_("spell_id") || SpellsUtils.isMaxLevel((Player)Minecraft.m_91087_().f_91074_, this.firstSlotStack.m_41783_().m_128461_("spell_id"))) break;
                        Spell spell = SpellsUtils.getSpell((Player)Minecraft.m_91087_().f_91074_, this.firstSlotStack.m_41783_().m_128461_("spell_id"));
                        spell.setLevel(spell.getLevel() + 1);
                        SpellsUtils.putSpell((Player)Minecraft.m_91087_().f_91074_, spell);
                        ItemUtils.removeItemsFromInventory(Minecraft.m_91087_().f_91074_.m_150109_(), this.secondSlotStack.m_41777_(), 1);
                    }
                }
            }
            if (this.micon.chapter.index.equals("anvil_weapon") || this.micon.chapter.index.equals("anvil_spells")) {
                this.getFirstSlot().selectedItem = ItemStack.f_41583_;
                this.getSecondSlot().selectedItem = ItemStack.f_41583_;
            }
        }
        return false;
    }

    @Override
    public boolean isHover() {
        return this.hovered;
    }
}

