/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MageMiconToast
implements Toast {
    public ResourceLocation TEXTURE = new ResourceLocation("etheria", "textures/gui/toast.png");
    private ItemStack itemStack;
    private String icon;
    private String text;

    public MageMiconToast(ItemStack itemStack, String icon, String text) {
        this.icon = icon;
        this.itemStack = itemStack;
        this.text = text;
    }

    public int m_7828_() {
        return 140;
    }

    @NotNull
    public Toast.Visibility m_7172_(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(this.TEXTURE, 0, 0, 0.0f, 0.0f, this.m_7828_(), this.m_94899_(), this.m_7828_(), 32);
        if (!this.itemStack.m_41619_()) {
            guiGraphics.m_280480_(this.itemStack, 4, 8);
        } else {
            guiGraphics.m_280163_(new ResourceLocation("etheria", this.icon), 4, 8, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        List<String> splitByNewline = List.of(this.text.split("\n"));
        ArrayList lines = new ArrayList();
        for (String part : splitByNewline) {
            List splitLines = Minecraft.m_91087_().f_91062_.m_92865_().m_92414_((FormattedText)Component.m_237113_((String)part), 136, Style.f_131099_);
            lines.addAll(splitLines);
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(0.8f, 0.8f, 0.8f);
        int yOff = 1;
        for (FormattedText line : lines) {
            if (yOff >= 4) break;
            String rawText = line.getString();
            boolean isBold = rawText.contains("\u00a7l");
            if (isBold) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(1.2f, 1.2f, 1.2f);
            }
            int adjustedX = isBold ? Math.round(20.8f) : 26;
            int adjustedY = isBold ? Math.round((float)(6 + 9 * yOff - 9) / 1.25f) : 6 + 9 * yOff - 9;
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, rawText, adjustedX + 2, adjustedY + 2, 14003075, false);
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, rawText, adjustedX + 1, adjustedY + 1, 9858892, false);
            if (isBold) {
                guiGraphics.m_280168_().m_85849_();
            }
            ++yOff;
        }
        guiGraphics.m_280168_().m_85849_();
        return (double)timeSinceLastVisible >= 5000.0 * toastComponent.m_264542_() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public ResourceLocation getTEXTURE() {
        return this.TEXTURE;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getText() {
        return this.text;
    }

    public void setTEXTURE(ResourceLocation TEXTURE) {
        this.TEXTURE = TEXTURE;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MageMiconToast)) {
            return false;
        }
        MageMiconToast other = (MageMiconToast)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResourceLocation this$TEXTURE = this.getTEXTURE();
        ResourceLocation other$TEXTURE = other.getTEXTURE();
        if (this$TEXTURE == null ? other$TEXTURE != null : !this$TEXTURE.equals(other$TEXTURE)) {
            return false;
        }
        ItemStack this$itemStack = this.getItemStack();
        ItemStack other$itemStack = other.getItemStack();
        if (this$itemStack == null ? other$itemStack != null : !this$itemStack.equals(other$itemStack)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MageMiconToast;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceLocation $TEXTURE = this.getTEXTURE();
        result = result * 59 + ($TEXTURE == null ? 43 : $TEXTURE.hashCode());
        ItemStack $itemStack = this.getItemStack();
        result = result * 59 + ($itemStack == null ? 43 : $itemStack.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String toString() {
        return "MageMiconToast(TEXTURE=" + this.getTEXTURE() + ", itemStack=" + this.getItemStack() + ", icon=" + this.getIcon() + ", text=" + this.getText() + ")";
    }
}

