/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.client.gui.MiconScreen;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.base.WidgetBase;
import it.mralxart.etheria.client.handlers.ClientTickHandler;
import it.mralxart.etheria.client.particles.ScreenGlowingParticle;
import it.mralxart.etheria.leveling.data.ConditionInfo;
import it.mralxart.etheria.leveling.data.ConditionType;
import it.mralxart.etheria.magemicon.data.StarData;
import it.mralxart.etheria.magemicon.data.StarInfo;
import it.mralxart.etheria.magemicon.utils.StarUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.enigma.EnigmaUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.C2SPacket;
import it.mralxart.etheria.utils.ItemUtils;
import it.mralxart.etheria.utils.RandomUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SpellSelectWidget
extends WidgetBase
implements ICustomRenderWidget,
ITickWidget {
    private Minecraft MC = Minecraft.m_91087_();
    private final MiconScreen screen;
    private boolean hovered = false;
    private boolean isBase = false;
    private StarInfo info;
    public float size = 0.25f;
    private float sizeOff = 0.1f;
    private int index;
    public boolean isFixed;
    public boolean dragging = false;
    public int dragOffsetX;
    public int dragOffsetY;

    public SpellSelectWidget(int p_93365_, int p_93366_, int p_93367_, int p_93368_, MiconScreen screen, StarInfo info, int index, boolean isBase) {
        super(p_93365_, p_93366_, p_93367_, p_93368_);
        this.screen = screen;
        this.index = index;
        this.isBase = isBase;
        this.info = info;
    }

    @Override
    public void m_5691_() {
        super.m_5691_();
        if (!StarUtils.isStarUnlocked((Player)Minecraft.m_91087_().f_91074_, this.info.getId()) && StarUtils.isParentStarUnlocked((Player)Minecraft.m_91087_().f_91074_, this.info.getId()) && StarUtils.isConditionsCompleted((Player)Minecraft.m_91087_().f_91074_, this.info.getId())) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("id", this.info.getId());
            Networking.sendToServer(new C2SPacket(tag, 1104));
            this.screen.animationProgress = 0.0f;
            this.createParticleBurst();
            Networking.sendToServer(new C2SPacket(tag, 759));
        } else {
            Optional<StarData> starOptional = StarUtils.getStarById((Player)this.MC.f_91074_, this.info.getId());
            StarData star = starOptional.orElse(null);
            if (!this.isBase && !this.isFixed && star != null && star.isActive()) {
                this.dragging = true;
            }
        }
    }

    public void createParticleBurst() {
        float centerX = (float)this.m_252754_() + (float)this.f_93618_ / 2.0f - (float)this.screen.getOffX();
        float centerY = (float)this.m_252907_() + (float)this.f_93619_ / 2.0f - (float)this.screen.getOffY();
        Color particleColor = new Color(15516037);
        for (int i = 0; i < 40; ++i) {
            float angle = RandomUtils.random().nextFloat() * 2.0f * (float)Math.PI;
            float speed = 1.5f + RandomUtils.random().nextFloat() * 2.5f;
            float velX = (float)Math.cos(angle) * speed;
            float velY = (float)Math.sin(angle) * speed;
            this.screen.getParticleContainer().addParticle(new ScreenGlowingParticle(centerX - 9.0f, centerY - 11.0f, velX, velY, 0.3f + RandomUtils.random().nextFloat() * 0.4f, 20 + RandomUtils.random().nextInt(30), -0.1f, particleColor));
        }
    }

    public void m_7691_(double p_93669_, double p_93670_) {
        super.m_7691_(p_93669_, p_93670_);
        this.dragging = false;
    }

    public boolean onDrag(double mouseX, double mouseY) {
        if (this.dragging && !this.isBase && !this.isFixed) {
            this.m_252865_((int)mouseX - this.dragOffsetX - 11);
            this.m_253211_((int)mouseY - this.dragOffsetY - 11);
            return true;
        }
        return false;
    }

    public void m_88315_(GuiGraphics p_282421_, int p_93658_, int p_93659_, float p_93660_) {
    }

    @Override
    public void tick() {
        float maxScale = 0.25f;
        float minScale = 0.1f;
        if (this.hovered) {
            if (this.sizeOff < maxScale) {
                this.sizeOff = Math.min(maxScale, this.sizeOff + (maxScale - this.sizeOff) * 0.25f);
            }
        } else if (this.sizeOff != minScale) {
            this.sizeOff = Math.max(minScale, this.sizeOff - 0.05f);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, float ticks, int mX, int mY) {
        if (this.info.getId().equals("base_star")) {
            this.size = this.screen.zoom * 1.5f;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            PoseStack poseStack = guiGraphics.m_280168_();
            int color = 14456567;
            if (ClientTickHandler.clientTickCount % 6 == 0) {
                this.screen.getParticleContainer().addParticle(new ScreenGlowingParticle((float)this.m_252754_() + (float)this.f_93618_ / 2.0f - 9.0f - (float)this.screen.getOffX() + (float)(new Random().nextInt(6) - new Random().nextInt(6)) * this.size, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f - 11.0f - (float)this.screen.getOffY(), 0.0f, -0.15f, 0.2f * this.size, 10 + new Random().nextInt(60), 3.0f, new Color(color)));
            }
            poseStack.m_85836_();
            poseStack.m_85841_(this.size, this.size, 1.0f);
            poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / this.size, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / this.size, 0.0f);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/star_item_widget.png"), -9, -9, 0.0f, 0.0f, 18, 18, 18, 18);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        } else {
            float flashAlpha;
            this.hovered = this.isHovered(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), mX, mY);
            float offSize = 1.0f;
            if (this.screen.widgetSize.containsKey(this.info.getId()) && this.screen.widgetSize.get(this.info.getId()).floatValue() != 1.0f) {
                offSize = this.screen.widgetSize.get(this.info.getId()).floatValue();
            }
            this.size = this.screen.zoom * 1.5f + offSize - 1.0f + this.sizeOff;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            if (!StarUtils.isStarUnlocked((Player)Minecraft.m_91087_().f_91074_, this.info.getId())) {
                RenderSystem.setShaderColor((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f);
            }
            PoseStack poseStack = guiGraphics.m_280168_();
            int[] numbers = new int[]{1, 2, 3, 4};
            int cyclicIndex = (this.index - 1) % numbers.length;
            int color = 14456567;
            ResourceLocation skill_template = new ResourceLocation("etheria", "textures/gui/widget/star" + numbers[cyclicIndex] + ".png");
            if (StarUtils.isStarUnlocked((Player)Minecraft.m_91087_().f_91074_, this.info.getId())) {
                skill_template = new ResourceLocation("etheria", "textures/gui/widget/active_star" + (this.index % 2 == 0 ? "" : "2") + ".png");
                color = 15516037;
            } else {
                skill_template = new ResourceLocation("etheria", "textures/gui/widget/star_gray.png");
                color = 0xB7B7B7;
            }
            if (StarUtils.isStarUnlocked((Player)Minecraft.m_91087_().f_91074_, this.info.getId()) && ClientTickHandler.clientTickCount % 6 == 0) {
                this.screen.getParticleContainer().addParticle(new ScreenGlowingParticle((float)this.m_252754_() + (float)this.f_93618_ / 2.0f - 9.0f - (float)this.screen.getOffX() + (float)(new Random().nextInt(6) - new Random().nextInt(6)) * this.size, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f - 11.0f - (float)this.screen.getOffY(), 0.0f, -0.15f, 0.2f * this.size, 10 + new Random().nextInt(60), 3.0f, new Color(color)));
            }
            poseStack.m_85836_();
            float finalScale = this.size;
            if (this.screen.animationProgress >= 0.0f && this.screen.animationId.equals(this.info.getId())) {
                float pulse = (float)Math.sin((double)this.screen.animationProgress * Math.PI);
                float extraScale = 1.05f * pulse;
                finalScale += extraScale;
            }
            poseStack.m_85841_(finalScale, finalScale, 1.0f);
            poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / finalScale, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / finalScale, 0.0f);
            if (this.screen.animationProgress >= 0.0f && this.screen.animationId.equals(this.info.getId()) && (flashAlpha = (float)Math.sin((double)this.screen.animationProgress * Math.PI)) > 0.0f) {
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)0.95f, (float)0.8f, (float)flashAlpha);
                ResourceLocation flashTexture = new ResourceLocation("etheria", "textures/gui/widget/active_star.png");
                guiGraphics.m_280163_(flashTexture, -16, -16, 0.0f, 0.0f, 32, 32, 32, 32);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            long currentTimeMillis = System.currentTimeMillis();
            long period = 10000L;
            float rotation = (float)(Math.sin(Math.PI * 2 * (double)currentTimeMillis * ((double)this.index * 0.1) / (double)period) * 30.0);
            if (this.index % 2 == 0) {
                rotation -= 45.0f;
            }
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation));
            guiGraphics.m_280163_(skill_template, -11, -11, 0.0f, 0.0f, 22, 22, 22, 22);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
            if (this.info.getInfo().getId().equals("etheria:spell_scroll")) {
                poseStack.m_85836_();
                poseStack.m_85841_(this.size / 2.0f, this.size / 2.0f, 1.0f);
                poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / (this.size / 2.0f), ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / (this.size / 2.0f), 0.0f);
                RenderSystem.setShaderColor((float)227.0f, (float)201.0f, (float)250.0f, (float)(StarUtils.isStarUnlocked((Player)Minecraft.m_91087_().f_91074_, this.info.getId()) ? 1.0f : 0.5f));
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/item/spells/" + this.info.getId() + ".png"), -7, -8, 0.0f, 0.0f, 16, 16, 16, 16);
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/item/spells/" + this.info.getId() + ".png"), -9, -8, 0.0f, 0.0f, 16, 16, 16, 16);
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/item/spells/" + this.info.getId() + ".png"), -8, -7, 0.0f, 0.0f, 16, 16, 16, 16);
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/item/spells/" + this.info.getId() + ".png"), -8, -9, 0.0f, 0.0f, 16, 16, 16, 16);
                if (!StarUtils.isStarUnlocked((Player)Minecraft.m_91087_().f_91074_, this.info.getId())) {
                    RenderSystem.setShaderColor((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f);
                } else {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/item/spells/" + this.info.getId() + ".png"), -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
                poseStack.m_85849_();
            }
        }
    }

    public boolean m_6375_(double p_93641_, double p_93642_, int type) {
        return super.m_6375_(p_93641_, p_93642_, type);
    }

    @Override
    public boolean isHover() {
        return this.hovered;
    }

    @Override
    public void hovered(GuiGraphics guiGraphics, int mX, int mY, float partTicks) {
        if (!this.isBase) {
            int color = 14928378;
            boolean isEnigma = StarUtils.isParentStarUnlocked((Player)Minecraft.m_91087_().f_91074_, this.info.getId());
            if (!isEnigma) {
                color = EnigmaUtils.getEnigmaStartColor(ClientTickHandler.clientTickCount).getRGB();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Optional<StarData> starOptional = StarUtils.getStarById((Player)this.MC.f_91074_, this.info.getId());
            StarData star = starOptional.orElse(null);
            if (star != null) {
                boolean isActive = star.isActive();
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                Style style = Style.f_131099_.m_131148_(TextColor.m_131266_((int)color)).m_131136_(Boolean.valueOf(true)).m_131162_(Boolean.valueOf(true));
                boolean canBeUnlocked = !StarUtils.isStarUnlocked((Player)player, this.info.getId()) && StarUtils.isParentStarUnlocked((Player)player, this.info.getId()) && StarUtils.isConditionsCompleted((Player)player, this.info.getId());
                MutableComponent titleComponent = isActive || canBeUnlocked ? Component.m_237115_((String)("mage_micon.spell." + this.info.getId())) : Component.m_237113_((String)"???");
                tooltip.add(titleComponent.m_130948_(style));
                style = Style.f_131099_.m_131148_(TextColor.m_131266_((int)color));
                if (!isActive) {
                    boolean isShiftDown = KeyBindsScreen.m_96638_();
                    if (canBeUnlocked) {
                        tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.ready_to_unlock").m_130948_(style));
                        tooltip.add(Component.m_237113_((String)" "));
                        MutableComponent lmbKey = Component.m_237115_((String)"mage_micon.key.lmb").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD});
                        tooltip.add(Component.m_237110_((String)"mage_micon.tooltip.hint.activate", (Object[])new Object[]{lmbKey}).m_130948_(style));
                        tooltip.add(Component.m_237113_((String)" "));
                    } else {
                        tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.locked").m_130948_(style));
                        tooltip.add(Component.m_237113_((String)" "));
                        if ((this.info.getParents().isEmpty() || StarUtils.isParentStarUnlocked((Player)Minecraft.m_91087_().f_91074_, this.info.getId())) && !this.info.getConditions().isEmpty()) {
                            tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.unlock_conditions").m_130948_(style.m_178520_(ElementsUtils.getEndColorByElement(Element.ETHER).getRGB())));
                            if (this.info.isHint()) {
                                MutableComponent shortHint = Component.m_237115_((String)("mage_micon.hint." + this.info.getId()));
                                tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.hint_bullet").m_130940_(ChatFormatting.GOLD).m_7220_((Component)shortHint.m_130940_(ChatFormatting.WHITE)));
                                tooltip.add(Component.m_237113_((String)" "));
                                if (isShiftDown) {
                                    tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.separator").m_130940_(ChatFormatting.DARK_GRAY));
                                    tooltip.add(Component.m_237113_((String)" "));
                                    MutableComponent description = Component.m_237115_((String)("mage_micon.hint." + this.info.getId() + ".description"));
                                    tooltip.add(description.m_130948_(style.m_131155_(Boolean.valueOf(true))));
                                    tooltip.add(Component.m_237113_((String)" "));
                                } else {
                                    tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.separator").m_130948_(style));
                                    MutableComponent shiftKey = Component.m_237115_((String)"mage_micon.key.shift").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD});
                                    tooltip.add(Component.m_237110_((String)"mage_micon.tooltip.hint.shift_hint", (Object[])new Object[]{shiftKey}).m_130940_(ChatFormatting.DARK_GRAY));
                                }
                            } else {
                                for (ConditionInfo condition : this.info.getConditions()) {
                                    if (condition.getType().equals((Object)ConditionType.ITEM)) {
                                        MutableComponent itemName = Component.m_237115_((String)ItemUtils.byIdString(condition.getId()).m_5524_());
                                        tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.hint_bullet").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)"mage_micon.hint.item").m_7220_((Component)itemName).m_130940_(ChatFormatting.WHITE)));
                                        tooltip.add(Component.m_237113_((String)" "));
                                        continue;
                                    }
                                    if (condition.getType().equals((Object)ConditionType.STAR_UNLOCKED)) {
                                        MutableComponent starName = Component.m_237115_((String)("mage_micon.chapter." + condition.getId()));
                                        tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.hint_bullet").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)"mage_micon.hint.star").m_7220_((Component)starName).m_130940_(ChatFormatting.WHITE)));
                                        tooltip.add(Component.m_237113_((String)" "));
                                        continue;
                                    }
                                    if (!condition.getType().equals((Object)ConditionType.ETHER_SETTING)) continue;
                                    MutableComponent shortHint = Component.m_237115_((String)"mage_micon.hint.elemental_search");
                                    tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.hint_bullet").m_130940_(ChatFormatting.GOLD).m_7220_((Component)shortHint.m_130940_(ChatFormatting.WHITE)));
                                    tooltip.add(Component.m_237113_((String)" "));
                                    if (isShiftDown) {
                                        tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.separator").m_130940_(ChatFormatting.DARK_GRAY));
                                        tooltip.add(Component.m_237113_((String)" "));
                                        MutableComponent description = Component.m_237115_((String)"mage_micon.hint.elemental_search.description");
                                        tooltip.add(description.m_130948_(style.m_131155_(Boolean.valueOf(true))));
                                        tooltip.add(Component.m_237113_((String)" "));
                                        continue;
                                    }
                                    tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.separator").m_130948_(style));
                                    MutableComponent shiftKey = Component.m_237115_((String)"mage_micon.key.shift").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD});
                                    tooltip.add(Component.m_237110_((String)"mage_micon.tooltip.hint.shift_hint", (Object[])new Object[]{shiftKey}).m_130940_(ChatFormatting.DARK_GRAY));
                                }
                                tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.separator").m_130948_(style));
                            }
                        }
                    }
                } else {
                    tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.separator").m_130940_(ChatFormatting.DARK_GRAY));
                    MutableComponent lmbKey = Component.m_237115_((String)"mage_micon.key.lmb").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD});
                    tooltip.add(Component.m_237110_((String)"mage_micon.tooltip.hint.move", (Object[])new Object[]{lmbKey}).m_130940_(ChatFormatting.DARK_GRAY));
                }
                ArrayList result = new ArrayList();
                for (MutableComponent entry : tooltip) {
                    result.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, 270));
                }
                int tooltipWidth = 270;
                int n = result.size();
                Objects.requireNonNull(this.MC.f_91062_);
                int tooltipHeight = n * (9 + 2);
                int tooltipX = mX - tooltipWidth / 2;
                int tooltipY = mY;
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
                int scaledX = tooltipX * 2;
                int scaledY = tooltipY * 2;
                int scaledWidth = tooltipWidth * 2;
                int scaledHeight = tooltipHeight * 2;
                if (isEnigma) {
                    TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)(scaledX + 135), (int)scaledY, (int)(scaledWidth / 2), (int)(scaledHeight / 2), (int)1300, (int)-267386864, (int)-267386864, (int)-395521, (int)-2320649);
                } else {
                    int startColor = EnigmaUtils.getEnigmaStartColor(ClientTickHandler.clientTickCount).getRGB();
                    int endColor = EnigmaUtils.getEnigmaEndColor(ClientTickHandler.clientTickCount).getRGB();
                    TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)(scaledX + 135), (int)scaledY, (int)(scaledWidth / 2), (int)(scaledHeight / 2), (int)1300, (int)-267386864, (int)-267386864, (int)startColor, (int)endColor);
                }
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 3500.0f);
                for (FormattedCharSequence entry : result) {
                    int textWidth = this.MC.f_91062_.m_92724_(entry);
                    guiGraphics.m_280648_(this.MC.f_91062_, entry, scaledX + (270 - textWidth / 2), scaledY, color);
                    Objects.requireNonNull(this.MC.f_91062_);
                    scaledY += 9 + 2;
                }
                guiGraphics.m_280168_().m_85849_();
            }
        }
    }

    @Override
    protected void m_168797_(@NotNull NarrationElementOutput p_259858_) {
    }

    private void drawItem(PoseStack matrix, ItemStack stack, int x, int y) {
        boolean useItemLight;
        Minecraft mc = Minecraft.m_91087_();
        int color = Integer.parseInt("d9ace5", 16) | 0xFF000000;
        BakedModel model = mc.m_91291_().m_174264_(stack, null, null, 0);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        mc.m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.m_252880_((float)x, (float)y, 0.0f);
        matrix.m_85841_(1.0f, -1.0f, 2.0f);
        matrix.m_85841_(12.0f, 12.0f, 12.0f);
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = useItemLight = !model.m_7547_();
        if (useItemLight) {
            Lighting.m_84930_();
        }
        mc.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, matrix, (MultiBufferSource)renderTypeBuffer, 0xF000F0, OverlayTexture.f_118083_, model);
        renderTypeBuffer.m_109911_();
        matrix.m_85841_(1.0f, 1.0f, 1.0f);
        RenderSystem.enableDepthTest();
        if (useItemLight) {
            Lighting.m_84931_();
        }
    }

    public Minecraft getMC() {
        return this.MC;
    }

    public MiconScreen getScreen() {
        return this.screen;
    }

    public boolean m_274382_() {
        return this.hovered;
    }

    public boolean isBase() {
        return this.isBase;
    }

    public StarInfo getInfo() {
        return this.info;
    }

    public float getSize() {
        return this.size;
    }

    public float getSizeOff() {
        return this.sizeOff;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public int getDragOffsetX() {
        return this.dragOffsetX;
    }

    public int getDragOffsetY() {
        return this.dragOffsetY;
    }
}

