/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import it.mralxart.etheria.client.gui.MiconScreen;
import it.mralxart.etheria.client.gui.magemicon.widgets.ChapterWidget;
import it.mralxart.etheria.client.handlers.ClientTickHandler;
import it.mralxart.etheria.client.utils.GuiUtils;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.magemicon.MageMiconStorage;
import it.mralxart.etheria.magemicon.data.ConstellationInfo;
import it.mralxart.etheria.magemicon.utils.StarUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.enigma.EnigmaUtils;
import it.mralxart.etheria.magic.magemicon.Category;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMicon;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.registry.BlockRegistry;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="etheria", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TooltipsHandler {
    private static boolean isAlt = false;
    private static int animTick = 0;

    @SubscribeEvent
    public static void onTooltipColorEvent(RenderTooltipEvent.Color event) {
        BlockItem blockItem;
        Item endColor3;
        Item endColor22;
        int startColor;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("etheria$element")) {
            startColor = ElementsUtils.getColorByElement(Element.valueOf(stack.m_41783_().m_128461_("etheria$element").toUpperCase())).getRGB();
            int endColor22 = ElementsUtils.getEndColorByElement(Element.valueOf(stack.m_41783_().m_128461_("etheria$element").toUpperCase())).getRGB();
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("etheria$element2")) {
                endColor22 = ElementsUtils.getEndColorByElement(Element.ofString(stack.m_41783_().m_128461_("etheria$element2"))).getRGB();
            }
            event.setBorderStart(startColor);
            event.setBorderEnd(endColor22);
        }
        if ((endColor22 = stack.m_41720_()) instanceof IElementItem) {
            IElementItem item = (IElementItem)endColor22;
            int startColor2 = ElementsUtils.getColorByElement(item.getElement(stack)).getRGB();
            int endColor3 = ElementsUtils.getEndColorByElement(item.getElement(stack)).getRGB();
            event.setBorderStart(startColor2);
            event.setBorderEnd(endColor3);
        }
        if ((endColor3 = stack.m_41720_()) instanceof BlockItem && (endColor3 = (blockItem = (BlockItem)endColor3).m_40614_()) instanceof IElementItem) {
            IElementItem item = (IElementItem)endColor3;
            int startColor3 = ElementsUtils.getColorByElement(item.getElement(stack)).getRGB();
            int endColor4 = ElementsUtils.getEndColorByElement(item.getElement(stack)).getRGB();
            event.setBorderStart(startColor3);
            event.setBorderEnd(endColor4);
        }
        if (EnigmaUtils.isEnigma(stack)) {
            startColor = EnigmaUtils.getEnigmaStartColor(ClientTickHandler.clientTickCount).getRGB();
            int endColor5 = EnigmaUtils.getEnigmaEndColor(ClientTickHandler.clientTickCount).getRGB();
            event.setBorderStart(startColor);
            event.setBorderEnd(endColor5);
        }
    }

    @SubscribeEvent
    public static void onTooltipGatherComponents(RenderTooltipEvent.GatherComponents event) {
        Either firstElement;
        BlockItem blockItem;
        Item item;
        ItemStack stack = event.getItemStack();
        var ref = new Object(){
            int nameColor = 0xFFFFFF;
        };
        Item item2 = stack.m_41720_();
        if (item2 instanceof IElementItem) {
            IElementItem item3 = (IElementItem)item2;
            ref.nameColor = ElementsUtils.getColorByElement(item3.getElement(stack)).getRGB();
        }
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("etheria$element")) {
            ref.nameColor = ElementsUtils.getColorByElement(Element.valueOf(stack.m_41783_().m_128461_("etheria$element").toUpperCase())).getRGB();
        }
        if ((item = stack.m_41720_()) instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof IElementItem) {
            IElementItem item4 = (IElementItem)item;
            ref.nameColor = ElementsUtils.getColorByElement(item4.getElement(stack)).getRGB();
        }
        if (EnigmaUtils.isEnigma(stack)) {
            ref.nameColor = new Color(12344296).getRGB();
        }
        if (ref.nameColor == 0xFFFFFF) {
            return;
        }
        List tooltips = event.getTooltipElements();
        if (!tooltips.isEmpty() && (firstElement = (Either)tooltips.get(0)).left().isPresent()) {
            FormattedText originalText = (FormattedText)firstElement.left().get();
            MutableComponent coloredText = Component.m_237113_((String)originalText.getString()).m_130938_(style -> style.m_178520_(ref.nameColor));
            tooltips.set(0, Either.left((Object)coloredText));
        }
    }

    @SubscribeEvent
    public static void onRenderTooltip(RenderTooltipEvent.Pre event) {
        BlockItem blockItem;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !player.m_150109_().m_36063_(((Item)BlockRegistry.MAGEMICON.get()).m_7968_())) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof IMageMiconEntryItem || item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof IMageMiconEntryItem) {
            GuiGraphics guiGraphics = event.getGraphics();
            PoseStack poseStack = guiGraphics.m_280168_();
            int x = event.getX();
            int y = event.getY();
            int startColor = new Color(-267386864).getRGB();
            int endColor = new Color(-263192512).getRGB();
            float progress = Math.min((float)animTick / 30.0f, 1.0f);
            int bgColor = TooltipsHandler.interpolateColor(startColor, endColor, progress);
            int borderColor1 = TooltipsHandler.interpolateColor(ElementsUtils.getColorByElement(Element.ETHER).getRGB(), -1, progress);
            int borderColor2 = TooltipsHandler.interpolateColor(ElementsUtils.getEndColorByElement(Element.ETHER).getRGB(), -1, progress);
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)(x - 26), (int)(y - 12), (int)16, (int)22, (int)400, (int)bgColor, (int)bgColor, (int)borderColor1, (int)borderColor2);
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 400.0f);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/item/magemicon.png"), event.getX() - 26, event.getY() - 12, 0.0f, 0.0f, 16, 16, 16, 16);
            GuiUtils.drawStringWithShadow(guiGraphics, Minecraft.m_91087_().f_91062_, "Alt", x - 17, y + 5, ElementsUtils.getEndColorByElement(Element.ETHER).getRGB(), ElementsUtils.getColorByElement(Element.ETHER).getRGB());
            poseStack.m_85849_();
            if (isAlt && animTick >= 30) {
                BlockItem item1;
                Block block;
                isAlt = false;
                MageMicon micon = new MageMicon(String::isEmpty, false);
                micon.setReturnScreen(new MiconScreen(new HashMap<String, ConstellationInfo>(MageMiconStorage.DATA.getConstellations())));
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof MageMicon) {
                    MageMicon micon1;
                    micon = micon1 = (MageMicon)screen;
                }
                Chapter chapter = null;
                if (item instanceof IMageMiconEntryItem) {
                    IMageMiconEntryItem item12 = (IMageMiconEntryItem)item;
                    chapter = item12.getChapter();
                } else if (item instanceof BlockItem && (block = (item1 = (BlockItem)item).m_40614_()) instanceof IMageMiconEntryItem) {
                    IMageMiconEntryItem itemR = (IMageMiconEntryItem)block;
                    chapter = itemR.getChapter();
                }
                if (chapter != null) {
                    Category category = MageMiconUtils.getCategoryByChapterId(chapter.index);
                    if (category != null) {
                        if (!StarUtils.isStarUnlocked((Player)Minecraft.m_91087_().f_91074_, chapter.index)) {
                            return;
                        }
                        micon.category = category;
                    }
                    if (!chapter.text.isEmpty()) {
                        chapter.setPages(ChapterWidget.constructPages(micon, chapter));
                    }
                    micon.chapter = chapter;
                    micon.pagesIndex = 0;
                    micon.indexPage1 = 0;
                    micon.indexPage2 = 1;
                }
                Minecraft.m_91087_().m_91152_((Screen)micon);
            }
        }
    }

    @SubscribeEvent
    public static void pressAlt(InputEvent.Key event) {
        boolean isAltPressed = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)342);
        if (isAltPressed) {
            isAlt = true;
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null && Screen.m_96639_() && animTick < 30) {
            ++animTick;
        } else if (animTick > 1) {
            animTick -= 4;
        }
        if (animTick <= 0) {
            isAlt = false;
        }
    }

    private static int interpolateColor(int color1, int color2, float progress) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * progress);
        int r = (int)((float)r1 + (float)(r2 - r1) * progress);
        int g = (int)((float)g1 + (float)(g2 - g1) * progress);
        int b = (int)((float)b1 + (float)(b2 - b1) * progress);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

