/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.mralxart.etheria.client.particles.GlowingParticle;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BlockParticle
extends TextureSheetParticle {
    private final float rotationSpeed;
    private final float initialSize;
    private boolean isOptimized;
    private boolean isStaticSize;
    private boolean isPhysic = false;

    public BlockParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, float rotationSpeed, Color color, float diameter, int lifeTime, float alpha, boolean small, boolean isOptimized, boolean isPhysic) {
        super(level, x, y, z);
        this.m_107253_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        this.m_107250_(diameter, diameter);
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.rotationSpeed = rotationSpeed;
        this.f_107226_ = 0.0f;
        this.f_107225_ = lifeTime;
        this.f_107663_ = diameter;
        this.initialSize = diameter;
        this.f_107230_ = alpha;
        this.setScaleModificator(1.0f);
        this.isStaticSize = small;
        this.isOptimized = isOptimized;
        this.isPhysic = isPhysic;
    }

    public void m_5989_() {
        this.applyRotation();
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.isPhysic) {
            this.f_107216_ -= 0.03;
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (this.f_107663_ <= 0.05f) {
            this.m_107274_();
            return;
        }
        if (++this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    private boolean isNearCamera(Vec3 cameraPos) {
        double distanceSquared = cameraPos != null ? cameraPos.m_82531_(this.f_107212_, this.f_107213_, this.f_107214_) : 0.0;
        return distanceSquared < 256.0;
    }

    private void applyRotation() {
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.rotationSpeed;
    }

    public void m_5744_(@NotNull VertexConsumer buffer, Camera camera, float partialTicks) {
        float distance = (float)this.getPos().m_82554_(camera.m_90583_());
        if (this.isOptimized) {
            if (distance < 10.0f) {
                this.setScaleModificator(1.0f);
                this.renderParticle(buffer, camera, partialTicks);
            } else if (distance < 25.0f) {
                this.setScaleModificator(0.5f);
                this.renderParticle(buffer, camera, partialTicks);
            } else if (this.isNearCamera(camera.m_90583_())) {
                this.setScaleModificator(0.25f);
                this.renderParticle(buffer, camera, partialTicks);
            }
        } else {
            this.setScaleModificator(1.0f);
            this.renderParticle(buffer, camera, partialTicks);
        }
    }

    private void setScaleModificator(float scaleModificator) {
        if (!this.isStaticSize) {
            this.f_107663_ = this.initialSize;
        } else {
            float sizeFactor = Math.max(0.0f, (float)(this.f_107225_ - this.f_107224_) / (float)this.f_107225_);
            this.f_107663_ = this.initialSize * sizeFactor * scaleModificator;
        }
    }

    public void renderParticle(@NotNull VertexConsumer buffer, Camera camera, float partialTicks) {
        Vec3 cameraPos = camera.m_90583_();
        float xPos = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
        float yPos = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_());
        float zPos = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
        Vector3f[] corners = new Vector3f[]{new Vector3f(-0.5f, -0.5f, -0.5f), new Vector3f(0.5f, -0.5f, -0.5f), new Vector3f(0.5f, 0.5f, -0.5f), new Vector3f(-0.5f, 0.5f, -0.5f), new Vector3f(-0.5f, -0.5f, 0.5f), new Vector3f(0.5f, -0.5f, 0.5f), new Vector3f(0.5f, 0.5f, 0.5f), new Vector3f(-0.5f, 0.5f, 0.5f)};
        Quaternionf rotation = new Quaternionf();
        rotation.rotateZ(Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_));
        float size = this.m_5902_(partialTicks);
        for (Vector3f corner : corners) {
            corner.rotate((Quaternionfc)rotation);
            corner.mul(size);
            corner.add(xPos, yPos, zPos);
        }
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        int light = 0xF000F0;
        this.addQuad(buffer, corners[4], corners[7], corners[6], corners[5], minU, maxU, minV, maxV, light);
        this.addQuad(buffer, corners[1], corners[2], corners[3], corners[0], minU, maxU, minV, maxV, light);
        this.addQuad(buffer, corners[7], corners[3], corners[2], corners[6], minU, maxU, minV, maxV, light);
        this.addQuad(buffer, corners[4], corners[5], corners[1], corners[0], minU, maxU, minV, maxV, light);
        this.addQuad(buffer, corners[5], corners[6], corners[2], corners[1], minU, maxU, minV, maxV, light);
        this.addQuad(buffer, corners[0], corners[3], corners[7], corners[4], minU, maxU, minV, maxV, light);
    }

    private void addQuad(VertexConsumer buffer, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, float minU, float maxU, float minV, float maxV, int light) {
        buffer.m_5483_((double)v1.x(), (double)v1.y(), (double)v1.z()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)v2.x(), (double)v2.y(), (double)v2.z()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)v3.x(), (double)v3.y(), (double)v3.z()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)v4.x(), (double)v4.y(), (double)v4.z()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return GlowRenderType.RENDERER;
    }

    private static class GlowRenderType
    implements ParticleRenderType {
        public static final GlowRenderType RENDERER = new GlowRenderType();

        private GlowRenderType() {
        }

        public void m_6505_(BufferBuilder buffer, @NotNull TextureManager manager) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFunc((int)770, (int)1);
            buffer.m_166779_(GlowingParticle.ADDITIVE_PARTICLE.m_173186_(), GlowingParticle.ADDITIVE_PARTICLE.m_110508_());
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }

        public String toString() {
            return "etheria:glowing";
        }
    }
}

