/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.mralxart.etheria.EtheriaClient;
import it.mralxart.etheria.utils.RenderUtils;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GlowingParticle
extends TextureSheetParticle {
    private final float rotationSpeed;
    private final float initialSize;
    private boolean isOptimized;
    private boolean isStaticSize;
    private boolean isPhysic = false;
    private float modify = 1.0f;
    public static final RenderType ADDITIVE_PARTICLE = RenderType.m_173215_((String)"etheria:additive_particle", (VertexFormat)DefaultVertexFormat.f_85813_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110687_(new RenderStateShard.WriteMaskStateShard(true, false)).m_110671_(new RenderStateShard.LightmapStateShard(false)).m_110685_(RenderUtils.ADDITIVE_TRANSPARENCY).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.f_118260_, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(EtheriaClient::getGlowParticle)).m_110691_(true));

    public GlowingParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, float rotationSpeed, Color color, float diameter, int lifeTime, float alpha, boolean small, boolean isOptimized, boolean isPhysic, float modify) {
        super(level, x, y, z);
        this.m_107253_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        this.m_107250_(diameter, diameter);
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.rotationSpeed = rotationSpeed;
        this.f_107226_ = 0.0f;
        this.f_107225_ = lifeTime;
        this.f_107663_ = diameter;
        this.initialSize = diameter;
        this.f_107230_ = alpha;
        this.setScaleModificator(1.0f);
        this.isStaticSize = small;
        this.isOptimized = isOptimized;
        this.isPhysic = isPhysic;
        this.modify = modify;
    }

    public void m_5989_() {
        this.applyRotation();
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.modify != 1.0f) {
            this.f_107215_ *= (double)this.modify;
            this.f_107216_ *= (double)this.modify;
            this.f_107217_ *= (double)this.modify;
        }
        if (this.isPhysic) {
            this.f_107216_ -= 0.03;
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (this.f_107663_ <= 0.05f) {
            this.m_107274_();
            return;
        }
        if (++this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    private boolean isNearCamera(Vec3 cameraPos) {
        double distanceSquared = cameraPos != null ? cameraPos.m_82531_(this.f_107212_, this.f_107213_, this.f_107214_) : 0.0;
        return distanceSquared < 256.0;
    }

    private void applyRotation() {
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.rotationSpeed;
    }

    public void m_5744_(@NotNull VertexConsumer buffer, Camera camera, float partialTicks) {
        float distance = (float)this.getPos().m_82554_(camera.m_90583_());
        if (this.isOptimized) {
            if (distance < 10.0f) {
                this.setScaleModificator(1.0f);
                this.renderParticle(buffer, camera, partialTicks);
            } else if (distance < 25.0f) {
                this.setScaleModificator(0.5f);
                this.renderParticle(buffer, camera, partialTicks);
            } else if (this.isNearCamera(camera.m_90583_())) {
                this.setScaleModificator(0.25f);
                this.renderParticle(buffer, camera, partialTicks);
            }
        } else {
            this.setScaleModificator(1.0f);
            this.renderParticle(buffer, camera, partialTicks);
        }
    }

    private void setScaleModificator(float scaleModificator) {
        if (!this.isStaticSize) {
            this.f_107663_ = this.initialSize;
        } else {
            float sizeFactor = Math.max(0.0f, (float)(this.f_107225_ - this.f_107224_) / (float)this.f_107225_);
            this.f_107663_ = this.initialSize * sizeFactor * scaleModificator;
        }
    }

    public void renderParticle(@NotNull VertexConsumer buffer, Camera camera, float partialTicks) {
        Vector3f[] vertices;
        Vec3 cameraPos = camera.m_90583_();
        float xPos = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
        float yPos = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_());
        float zPos = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
        Quaternionf rotation = new Quaternionf((Quaternionfc)camera.m_253121_());
        rotation.rotateZ(Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_));
        float size = this.m_5902_(partialTicks);
        for (Vector3f vertex : vertices = new Vector3f[]{new Vector3f(-0.5f, -0.5f, 0.0f), new Vector3f(-0.5f, 0.5f, 0.0f), new Vector3f(0.5f, 0.5f, 0.0f), new Vector3f(0.5f, -0.5f, 0.0f)}) {
            vertex.rotate((Quaternionfc)rotation);
            vertex.mul(size);
            vertex.add(xPos, yPos, zPos);
        }
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        int light = 0xF000F0;
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        Matrix4f poseMatrix = poseStack.m_85850_().m_252922_();
        buffer.m_252986_(poseMatrix, vertices[0].x(), vertices[0].y(), vertices[0].z()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_252986_(poseMatrix, vertices[1].x(), vertices[1].y(), vertices[1].z()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_252986_(poseMatrix, vertices[2].x(), vertices[2].y(), vertices[2].z()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_252986_(poseMatrix, vertices[3].x(), vertices[3].y(), vertices[3].z()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        poseStack.m_85849_();
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return GlowRenderType.RENDERER;
    }

    private static class GlowRenderType
    implements ParticleRenderType {
        public static final GlowRenderType RENDERER = new GlowRenderType();

        private GlowRenderType() {
        }

        public void m_6505_(BufferBuilder buffer, @NotNull TextureManager manager) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFunc((int)770, (int)1);
            buffer.m_166779_(ADDITIVE_PARTICLE.m_173186_(), ADDITIVE_PARTICLE.m_110508_());
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }

        public String toString() {
            return "etheria:glowing";
        }
    }
}

