/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.renderer.bosses;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import it.mralxart.etheria.EtheriaClient;
import it.mralxart.etheria.bosses.golems.Aerolith;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.client.renderer.tiles.BeamEmitterRenderer;
import it.mralxart.etheria.epicora.animations.AnimationStorage;
import it.mralxart.etheria.epicora.animations.components.AnimationSet;
import it.mralxart.etheria.epicora.animations.components.GeometryChanges;
import it.mralxart.etheria.epicora.animations.components.LoopMode;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.epicora.geometry.GeometryStorage;
import it.mralxart.etheria.epicora.geometry.components.GeometryBone;
import it.mralxart.etheria.epicora.geometry.data.GeometryData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.RandomUtils;
import it.mralxart.etheria.utils.RenderUtils;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GaiaarRenderer
extends EntityRenderer<Aerolith> {
    public GaiaarRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(Aerolith p_114485_, float p_114486_, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        poseStack.m_85836_();
        GeometryData model = GeometryStorage.getGeometry("gaiaar");
        AnimationController controller = p_114485_.getController();
        AnimationSet animations = AnimationStorage.getAnimations("gaiaar");
        p_114485_.animations = animations.getAnimations();
        controller.startAnimation("idle", animations.get("animation.model.idle"), LoopMode.LOOP);
        GeometryChanges changes = controller.apply(partialTicks);
        model.applyAnimChanges(changes);
        this.headLook(p_114485_, model, partialTicks);
        model.getBone((String)"right_placeholder").callback = (allBones, bone, poseStack1, worldPos) -> {
            float animTime;
            Vec3 entityPos = p_114485_.m_20182_();
            worldPos.add((float)entityPos.f_82479_, (float)entityPos.f_82480_, (float)entityPos.f_82481_);
            Vec3 pos = new Vec3((double)worldPos.x, (double)worldPos.y, (double)worldPos.z);
            if (controller.getLayer("action").getAnimation().getAnimation().getKey().equals("animation.model.energy2") && (animTime = controller.getLayer("action").getAnimTime(controller.getLayer("action").getAnimation(), controller.getControllerTime(0.0f))) >= 0.25f && animTime <= 2.5f) {
                ParticleUtils.drawParticlesToCenter(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.AERO).getRGB(), Math.max(0.1f, RandomUtils.random().nextFloat() / 6.0f), 10 + RandomUtils.random().nextInt(3, 30), 0.025f, 1.0f), (Level)Minecraft.m_91087_().f_91073_, pos, 20, 0.3f, 0.01f, 0.01f);
            }
        };
        model.getBone((String)"black_hole").callback = (allBones, bone, poseStack1, worldPos) -> {
            if (Minecraft.m_91087_().m_91104_()) {
                return;
            }
            Vec3 entityPos = p_114485_.m_20182_();
            worldPos.add((float)entityPos.f_82479_, (float)entityPos.f_82480_, (float)entityPos.f_82481_);
            Vec3 pos = new Vec3((double)worldPos.x, (double)worldPos.y, (double)worldPos.z);
            float animTime = controller.getLayer("black_hole").getAnimTime(controller.getLayer("black_hole").getAnimation(), controller.getControllerTime(0.0f));
            if (controller.getLayer("black_hole").getAnimation().getAnimation().getKey().equals("animation.model.black_hole") && animTime >= 0.25f) {
                ShaderInstance BLACK_HOLE_SHADER;
                ParticleUtils.drawParticlesToCenterWithSpiral(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.AERO), RandomUtils.random().nextFloat(0.2f, 0.6f), (int)(60.0f + animTime * 0.5f), 0.025f + animTime * 0.005f), (Level)Minecraft.m_91087_().f_91073_, pos, p_114485_.m_20182_().f_82480_, (int)(5.0f + animTime * 0.8f), 12.0f, 0.01f + animTime * 0.01f, 0.5f);
                if (animTime >= 20.0f) {
                    ParticleUtils.drawParticlesToCenterWithSpiral(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.PYRO), RandomUtils.random().nextFloat(0.2f, 0.6f), (int)(60.0f + animTime * 0.5f), 0.025f + animTime * 0.005f), (Level)Minecraft.m_91087_().f_91073_, pos, p_114485_.m_20182_().f_82480_, (int)(1.0f + animTime * 0.8f), 12.0f, 0.01f + animTime * 0.01f, 0.5f);
                }
                if ((BLACK_HOLE_SHADER = EtheriaClient.getBLACK_HOLE_SHADER()) == null) {
                    try {
                        BLACK_HOLE_SHADER = EtheriaClient.BLACK_HOLE_SHADER = new ShaderInstance((ResourceProvider)Minecraft.m_91087_().m_91098_(), new ResourceLocation("etheria", "black_hole"), DefaultVertexFormat.f_85814_);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                Minecraft mc = Minecraft.m_91087_();
                Camera camera = mc.f_91063_.m_109153_();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.activeTexture((int)33986);
                int textureId = mc.m_91097_().m_118506_(new ResourceLocation("etheria", "textures/noise.png")).m_117963_();
                RenderSystem.bindTexture((int)textureId);
                RenderSystem.setShaderTexture((int)1, (int)mc.m_91385_().m_83980_());
                ShaderInstance finalBLACK_HOLE_SHADER = BLACK_HOLE_SHADER;
                RenderSystem.setShader(() -> finalBLACK_HOLE_SHADER);
                BLACK_HOLE_SHADER.m_173356_("NoiseSampler").m_142617_(2);
                BLACK_HOLE_SHADER.m_173356_("DepthSampler").m_142617_(1);
                Vec3 cameraPos = camera.m_90583_();
                Vec3 corePos = pos;
                float blackHoleScale = 0.6f + Math.min(8.0f, animTime * 0.07f);
                BLACK_HOLE_SHADER.m_173356_("CameraPosition").m_5889_((float)(cameraPos.f_82479_ - corePos.f_82479_), (float)(cameraPos.f_82480_ - corePos.f_82480_), (float)(cameraPos.f_82481_ - corePos.f_82481_));
                Matrix3f rotationMatrix = new Matrix3f().identity();
                rotationMatrix.rotateX((float)Math.toRadians(15.0));
                rotationMatrix.rotateY((float)Math.toRadians(10.0));
                rotationMatrix.rotateZ((float)Math.toRadians(-25.0));
                BLACK_HOLE_SHADER.m_173356_("BlackHoleRotation").m_200759_(rotationMatrix);
                if (mc.f_91073_ != null) {
                    BLACK_HOLE_SHADER.m_173356_("STime").m_5985_(((float)mc.f_91073_.m_46467_() + partialTicks) / 20.0f);
                }
                float breakProgress = 0.0f;
                if (animTime >= 10.0f) {
                    breakProgress = animTime * 0.1f - 1.0f;
                }
                BLACK_HOLE_SHADER.m_173356_("Quality").m_142617_(0);
                BLACK_HOLE_SHADER.m_173356_("BreakingProgress").m_5985_(breakProgress);
                BLACK_HOLE_SHADER.m_173356_("BlackHoleScale").m_5985_(blackHoleScale);
                BLACK_HOLE_SHADER.m_173356_("InverseTransformMatrix").m_5679_(new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_()).invert());
                int fbWidth = mc.m_91268_().m_85441_();
                int fbHeight = mc.m_91268_().m_85442_();
                double windowRatio = (double)fbWidth / (double)fbHeight;
                double fov = Math.tan(Math.toRadians((double)((Integer)mc.f_91066_.m_231837_().m_231551_()).intValue() / 2.0)) * 0.05;
                double finalRatio = fov * windowRatio;
                Vector3f front = camera.m_253058_().mul(0.05f, new Vector3f());
                Vector3f left = camera.m_252775_().mul((float)finalRatio, new Vector3f());
                Vector3f up = camera.m_253028_().mul((float)fov, new Vector3f());
                Quaternionf yawRotation = new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, EtheriaClient.ForgeEvents.lastShakeYaw);
                Quaternionf pitchRotation = new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, EtheriaClient.ForgeEvents.lastShakePitch);
                Quaternionf rollRotation = new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, EtheriaClient.ForgeEvents.lastShakeRoll);
                front.rotate((Quaternionfc)yawRotation).rotate((Quaternionfc)pitchRotation).rotate((Quaternionfc)rollRotation);
                left.rotate((Quaternionfc)yawRotation).rotate((Quaternionfc)pitchRotation).rotate((Quaternionfc)rollRotation);
                up.rotate((Quaternionfc)yawRotation).rotate((Quaternionfc)pitchRotation).rotate((Quaternionfc)rollRotation);
                BLACK_HOLE_SHADER.m_173356_("CameraFront").m_5889_(front.x(), front.y(), front.z());
                BLACK_HOLE_SHADER.m_173356_("CameraLeft").m_5889_(left.x(), left.y(), left.z());
                BLACK_HOLE_SHADER.m_173356_("CameraUp").m_5889_(up.x(), up.y(), up.z());
                BLACK_HOLE_SHADER.m_173356_("OutSize").m_7971_((float)fbWidth, (float)fbHeight);
                BLACK_HOLE_SHADER.m_173356_("ViewPort").m_142492_(0, 0, fbWidth, fbHeight);
                Matrix4f backupProjection = RenderSystem.getProjectionMatrix();
                RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)fbWidth, (float)fbHeight, 0.0f, 1000.0f, 3000.0f), (VertexSorting)VertexSorting.f_276633_);
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder buffer = tessellator.m_85915_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                buffer.m_5483_(0.0, (double)fbHeight, 0.0).m_5752_();
                buffer.m_5483_((double)fbWidth, (double)fbHeight, 0.0).m_5752_();
                buffer.m_5483_((double)fbWidth, 0.0, 0.0).m_5752_();
                buffer.m_5483_(0.0, 0.0, 0.0).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
                RenderSystem.setProjectionMatrix((Matrix4f)backupProjection, (VertexSorting)VertexSorting.f_276633_);
                RenderSystem.enableDepthTest();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.disableBlend();
            }
        };
        poseStack.m_252781_(Axis.f_252392_.m_252977_(p_114485_.f_20883_ - 180.0f));
        model.renderModel(poseStack, bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation("etheria", "textures/entity/aerolith.png"))), packedLightIn, OverlayTexture.f_118083_);
        if (p_114485_.getShield() > 0) {
            Function function = Util.m_143827_(textureGlow -> {
                RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(textureGlow, false, false);
                return RenderType.m_173215_((String)"glowing_layer", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(BeamEmitterRenderer.SHADER_STATE).m_173290_((RenderStateShard.EmptyTextureStateShard)textureState).m_110685_(RenderUtils.ADDITIVE_TRANSPARENCY).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureGlow, false, false)).m_110687_(BeamEmitterRenderer.WRITE_MASK).m_110691_(false));
            });
            RenderType glowRenderType = (RenderType)function.apply(new ResourceLocation("etheria", "textures/entity/aerolith_emissive.png"));
            model.renderModel(poseStack, bufferSource.m_6299_(glowRenderType), 0xF00000, OverlayTexture.f_118083_);
        }
        poseStack.m_85849_();
        PoseStack poseStack2 = new PoseStack();
        poseStack2.m_252781_(Axis.f_252392_.m_252977_(p_114485_.f_20883_ - 180.0f));
        model.renderModel(poseStack2);
    }

    public void headLook(Aerolith entity, GeometryData model, float partialTicks) {
        Entity entity2;
        GeometryBone bone = model.getBone("head");
        if (bone == null) {
            return;
        }
        boolean falling = entity.m_21256_() > 4;
        boolean swimming = entity.m_6067_();
        Vector3f headRotCopy = bone.getRotation();
        Vector3f headRot = bone.getRotation();
        float swimAmount = entity.m_20998_(partialTicks);
        float headPitch = -Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        boolean shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        float bodyYaw = -Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
        float headYaw = -Mth.m_14189_((float)partialTicks, (float)entity.f_20886_, (float)entity.f_20885_);
        float netHeadYaw = headYaw - bodyYaw;
        if (shouldSit && (entity2 = entity.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity2;
            bodyYaw = -Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            netHeadYaw = headYaw - bodyYaw;
            float wrapped = Mth.m_14177_((float)netHeadYaw);
            if (wrapped < -85.0f) {
                wrapped = -85.0f;
            }
            if (wrapped >= 85.0f) {
                wrapped = 85.0f;
            }
            bodyYaw = headYaw - wrapped;
            if (wrapped * wrapped > 2500.0f) {
                bodyYaw += wrapped * 0.2f;
            }
            netHeadYaw = headYaw - bodyYaw;
        }
        headRot.add(0.0f, (float)Math.PI / 180 * netHeadYaw, 0.0f);
        if (falling) {
            headRot.add(0.7853982f, 0.0f, 0.0f);
        } else if (swimAmount > 0.0f) {
            if (swimming) {
                headRot.add(this.rotlerpRad(swimAmount, headRot.x(), 0.7853982f), 0.0f, 0.0f);
            } else {
                headRot.add(this.rotlerpRad(swimAmount, headRot.x(), (float)Math.PI / 180 * headPitch), 0.0f, 0.0f);
            }
        } else {
            headRot.add((float)Math.PI / 180 * headPitch, 0.0f, 0.0f);
        }
        bone.setRotation(this.lerp(headRotCopy, headRot, 1.0f));
    }

    private Vector3f lerp(Vector3f start, Vector3f end, float progress) {
        return start != null && end != null && !Float.isNaN(progress) ? new Vector3f(Mth.m_14179_((float)progress, (float)start.x(), (float)end.x()), Mth.m_14179_((float)progress, (float)start.y(), (float)end.y()), Mth.m_14179_((float)progress, (float)start.z(), (float)end.z())) : new Vector3f(0.0f, 0.0f, 0.0f);
    }

    private float rotlerpRad(float angleIn, float maxAngleIn, float mulIn) {
        float f = (mulIn - maxAngleIn) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return maxAngleIn + angleIn * f;
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull Aerolith entity) {
        return new ResourceLocation("etheria", "textures/bosses/golems/gaiaar.png");
    }
}

