/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.renderer.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.epicora.animations.components.GeometryChanges;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.epicora.base.CustomTileRenderer;
import it.mralxart.etheria.epicora.geometry.GeometryStorage;
import it.mralxart.etheria.epicora.geometry.data.GeometryData;
import it.mralxart.etheria.tiles.SenderTile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class EtherSenderRenderer
extends CustomTileRenderer<SenderTile> {
    public EtherSenderRenderer(BlockEntityRendererProvider.Context context) {
        super("ether_sender");
    }

    public void render(SenderTile tile, float p_112308_, PoseStack poseStack, MultiBufferSource p_112310_, int p_112311_, int p_112312_) {
        long gameTime = tile.m_58904_() != null ? tile.m_58904_().m_46467_() : 0L;
        double frequency = 0.05;
        double amplitude = 0.02;
        double offsetX = Math.sin((double)gameTime * frequency) * amplitude;
        double offsetZ = Math.sin((double)gameTime * frequency * 2.0) * amplitude / 2.0;
        double offsetY = Math.cos((double)gameTime * frequency) * amplitude / 2.0 + 0.1;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_85837_(offsetX, offsetY, offsetZ);
        float rotationAngle = (float)((double)gameTime * frequency * 20.0 % 360.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationAngle));
        GeometryData model = GeometryStorage.getGeometry(this.getModelLocation(tile));
        AnimationController controller = tile.getController();
        GeometryChanges changes = controller.apply(p_112308_);
        model.applyAnimChanges(changes);
        model.renderModel(poseStack, p_112310_.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(tile))), p_112311_);
        poseStack.m_85849_();
    }
}

