/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.utils;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.mralxart.etheria.client.particles.ScreenGlowingParticle;
import it.mralxart.etheria.client.particles.utils.ParticleContainer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class GuiUtils {
    private static float depthOffset = 0.0f;

    public static void drawString(GuiGraphics guiGraphics, Font font, String string, int x, int y, int color, boolean shadow) {
        guiGraphics.m_280056_(font, string, x, y, color, shadow);
    }

    public static void drawCenteredString(GuiGraphics guiGraphics, Font font, String string, int x, int y, int color, boolean shadow) {
        guiGraphics.m_280056_(font, string, x - font.m_92895_(string) / 2, y, color, shadow);
    }

    public static void drawStringShadow(GuiGraphics guiGraphics, Font font, String string, int x, int y, int color, int color2) {
        guiGraphics.m_280056_(font, string, x, y, color, false);
        guiGraphics.m_280056_(font, string, x - 1, y - 1, color2, false);
    }

    public static void drawStringWithShadow(GuiGraphics guiGraphics, Font font, String string, int x, int y, int color, int color2) {
        guiGraphics.m_280056_(font, string, x - font.m_92895_(string) / 2, y, color, false);
        guiGraphics.m_280056_(font, string, x - 1 - font.m_92895_(string) / 2, y - 1, color2, false);
    }

    public static void drawString(GuiGraphics guiGraphics, Font font, FormattedCharSequence charSequence, int x, int y, int color, boolean shadow) {
        guiGraphics.m_280649_(font, charSequence, x - font.m_92724_(charSequence) / 2, y, color, shadow);
    }

    public static void drawString(GuiGraphics guiGraphics, Font font, Component string, int x, int y, int color, boolean shadow) {
        FormattedCharSequence charSequence = string.m_7532_();
        guiGraphics.m_280649_(font, charSequence, x - font.m_92724_(charSequence) / 2, y, color, shadow);
    }

    public static void renderItemWithTooltip(GuiGraphics guiGraphics, Item item, int x, int y, float scale, float pMouseX, float pMouseY) {
        GuiUtils.renderItemWithTooltip(guiGraphics, new ItemStack((ItemLike)item), x, y, scale, pMouseX, pMouseY, true, false);
    }

    public static void renderItemWithTooltip(GuiGraphics guiGraphics, ItemStack item, int x, int y, float scale, float pMouseX, float pMouseY, boolean isStatic, boolean isUp) {
        PoseStack poseStack = guiGraphics.m_280168_();
        Minecraft mc = Minecraft.m_91087_();
        BakedModel model = mc.m_91291_().m_174264_(item, (Level)mc.f_91073_, (LivingEntity)mc.f_91074_, 0);
        ItemRenderer renderer = mc.m_91291_();
        if (isStatic) {
            poseStack.m_85836_();
            poseStack.m_252880_((float)x, (float)y, 0.0f);
            poseStack.m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280480_(item, 0, 0);
            poseStack.m_85849_();
        } else {
            boolean needsFlatLighting;
            float prevRotation = model.m_7442_().f_111792_.f_111755_.y;
            poseStack.m_85836_();
            poseStack.m_252880_((float)x + 8.0f * scale, (float)y + 8.0f * scale, 100.0f + (depthOffset += 50.0f));
            poseStack.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            poseStack.m_85841_(16.0f * scale, 16.0f * scale, 16.0f * scale);
            if (model.m_7547_()) {
                model.m_7442_().f_111792_.f_111755_.y = (float)(Blaze3D.m_83640_() * 40.0);
            } else {
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)Blaze3D.m_83640_() * 40.0f));
            }
            boolean bl = needsFlatLighting = !model.m_7547_();
            if (needsFlatLighting) {
                Lighting.m_84930_();
            }
            renderer.m_115143_(item, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)mc.m_91269_().m_110104_(), 0xF000F0, OverlayTexture.f_118083_, model);
            RenderSystem.disableDepthTest();
            mc.m_91269_().m_110104_().m_109911_();
            RenderSystem.enableDepthTest();
            if (needsFlatLighting) {
                Lighting.m_84931_();
            }
            poseStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            model.m_7442_().f_111792_.f_111755_.y = prevRotation;
            depthOffset -= 50.0f;
        }
        int dimension = (int)(10.0f * scale);
        if (GuiUtils.isHovered(x + 2, y + 2, dimension, dimension, (int)pMouseX, (int)pMouseY)) {
            guiGraphics.m_280153_(Minecraft.m_91087_().f_91062_, item, (int)pMouseX, (int)pMouseY);
        }
    }

    public static Component translate(String string) {
        return Component.m_237115_((String)string);
    }

    public static Component translate(String prefix, String string) {
        return Component.m_237115_((String)(prefix + "." + string));
    }

    public static boolean isHovered(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public static void blit(GuiGraphics guiGraphics, ResourceLocation resourceLocation, float x, float y, int i, int i1, int i2, int i3, int i4, int i5, float scale) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_((x + (float)i4 / 2.0f) / scale, (y + (float)i5 / 2.0f) / scale, 0.0f);
        guiGraphics.m_280163_(resourceLocation, -(i4 / 2), -(i5 / 2), (float)i, (float)i1, i2, i3, i4, i5);
        poseStack.m_85849_();
    }

    public static void renderCustomTooltip(GuiGraphics guiGraphics, Font font, List<? extends Component> lines, int mouseX, int mouseY) {
        GuiUtils.renderCustomTooltip(guiGraphics, font, lines, mouseX, mouseY, 0x600000FF, 0x600000FF);
    }

    public static void renderCustomTooltip(GuiGraphics guiGraphics, Font font, List<? extends Component> lines, int mouseX, int mouseY, int borderTop, int borderBottom) {
        int n;
        if (lines.isEmpty()) {
            return;
        }
        int tooltipWidth = 0;
        for (Component component : lines) {
            int lineWidth = font.m_92852_((FormattedText)component);
            if (lineWidth <= tooltipWidth) continue;
            tooltipWidth = lineWidth;
        }
        int tooltipHeight = 10;
        if (lines.size() > 1) {
            tooltipHeight += (lines.size() - 1) * 10;
        }
        int n2 = mouseX + 12;
        int y = mouseY - 12;
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        if (n2 + tooltipWidth > screenWidth) {
            n = n2 - (28 + tooltipWidth);
        }
        if (y + tooltipHeight + 6 > screenHeight) {
            y = screenHeight - tooltipHeight - 6;
        }
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)n, (int)y, (int)tooltipWidth, (int)(tooltipHeight - 1), (int)400, (int)-267386864, (int)-267386864, (int)borderTop, (int)borderBottom);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        for (Component component : lines) {
            guiGraphics.m_280614_(font, component, n, y, 0xFFFFFF, true);
            y += 10;
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public static Object getObjectByTime(int ticksPerObject, Object ... objects) {
        if (objects == null || objects.length == 0 || ticksPerObject <= 0) {
            throw new IllegalArgumentException("Objects array must not be empty.");
        }
        long currentTick = (long)(Blaze3D.m_83640_() * 20.0);
        int index = (int)(currentTick / (long)ticksPerObject % (long)objects.length);
        return objects[index];
    }

    public static void createWavyLine(ParticleContainer container, Vec2 start, Vec2 end, int tickCount, int maxTime, double density, double amplitude, long seed, Color particleColor) {
        double progress = Math.min(1.0, (double)tickCount / (double)maxTime);
        List<Vec2> linePoints = GuiUtils.generateGuiSmoothSpiralLine(start, end, density, amplitude, seed);
        int pointsToDisplay = (int)((double)linePoints.size() * progress);
        for (int i = 0; i < pointsToDisplay; ++i) {
            Vec2 point = linePoints.get(i);
            container.addParticle(new ScreenGlowingParticle(point.f_82470_, point.f_82471_, 0.0f, 0.0f, 0.3f, 2, 2.0f, particleColor));
        }
    }

    private static List<Vec2> generateGuiSmoothSpiralLine(Vec2 start, Vec2 end, double density, double amplitude, long seed) {
        Random random = new Random(seed);
        ArrayList<Vec2> points = new ArrayList<Vec2>();
        Vec2 direction = new Vec2(end.f_82470_ - start.f_82470_, end.f_82471_ - start.f_82471_);
        double totalLength = Math.sqrt(direction.f_82470_ * direction.f_82470_ + direction.f_82471_ * direction.f_82471_);
        Vec2 normalizedDirection = new Vec2((float)((double)direction.f_82470_ / totalLength), (float)((double)direction.f_82471_ / totalLength));
        double amplitudeVariation = 0.5 + (double)random.nextFloat() * 1.5;
        double adjustedAmplitude = amplitude * amplitudeVariation;
        int totalPoints = (int)(totalLength * density);
        points.add(start);
        for (int i = 1; i < totalPoints; ++i) {
            double t = (double)i / (double)totalPoints;
            double scaledAmplitude = adjustedAmplitude * GuiUtils.smoothStep(t);
            Vec2 pointOnLine = new Vec2((float)((double)start.f_82470_ + (double)normalizedDirection.f_82470_ * t * totalLength), (float)((double)start.f_82471_ + (double)normalizedDirection.f_82471_ * t * totalLength));
            Vec2 offset = GuiUtils.generateGuiSpiralOffset(t, scaledAmplitude);
            Vec2 finalPoint = new Vec2(pointOnLine.f_82470_ + offset.f_82470_, pointOnLine.f_82471_ + offset.f_82471_);
            points.add(finalPoint);
        }
        points.add(end);
        return points;
    }

    private static Vec2 generateGuiSpiralOffset(double t, double amplitude) {
        double angle = t * Math.PI * 2.0;
        double offsetX = Math.sin(angle) * amplitude;
        double offsetY = Math.cos(angle) * amplitude;
        return new Vec2((float)offsetX, (float)offsetY);
    }

    private static double smoothStep(double t) {
        return t * (1.0 - t) * 4.0;
    }

    public static void drawBorderTexture(GuiGraphics guiGraphics, ResourceLocation location, int x, int y, int width, int height) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int corner = 9;
        int size = 19;
        guiGraphics.m_280411_(location, x, y, corner, corner, 0.0f, 0.0f, corner, corner, size, size);
        guiGraphics.m_280411_(location, x + corner, y, width, corner, (float)corner, 0.0f, 1, corner, size, size);
        guiGraphics.m_280411_(location, x + corner + width, y, corner, corner, (float)(corner + 1), 0.0f, corner, corner, size, size);
        guiGraphics.m_280411_(location, x, y + corner, corner, height, 0.0f, (float)corner, corner, 1, size, size);
        guiGraphics.m_280411_(location, x + width + corner, y + corner, corner, height, (float)(corner + 1), (float)corner, corner, 1, size, size);
        guiGraphics.m_280411_(location, x + corner, y + corner, width, height, (float)(corner + 1), (float)(corner + 1), 1, 1, size, size);
        guiGraphics.m_280411_(location, x, y + height + corner, corner, corner, 0.0f, (float)(corner + 1), corner, corner, size, size);
        guiGraphics.m_280411_(location, x + corner, y + height + corner, width, corner, (float)corner, (float)(corner + 1), 1, corner, size, size);
        guiGraphics.m_280411_(location, x + corner + width, y + corner + height, corner, corner, (float)(corner + 1), (float)(corner + 1), corner, corner, size, size);
    }

    public static void drawParticleLine(ParticleContainer container, Vec2 start, Vec2 end, int particleCount, float velocityCap, float posCap, float spread, Color particleColor) {
        float deltaX = end.f_82470_ - start.f_82470_;
        float deltaY = end.f_82471_ - start.f_82471_;
        Random random = new Random();
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)particleCount;
            float baseX = (float)((double)start.f_82470_ + (double)deltaX * progress);
            float baseY = (float)((double)start.f_82471_ + (double)deltaY * progress);
            float offsetX = (float)(random.nextGaussian() * (double)spread * (double)posCap);
            float offsetY = (float)(random.nextGaussian() * (double)spread * (double)posCap);
            float x = baseX + offsetX;
            float y = baseY + offsetY;
            float motionX = (float)(random.nextGaussian() * (double)velocityCap);
            float motionY = (float)(random.nextGaussian() * (double)velocityCap);
            container.addParticle(new ScreenGlowingParticle(x, y, motionX, motionY, 0.3f, 40, 2.0f, particleColor));
        }
    }

    public static void addParticles(ParticleContainer container, float startX, float startY, float targetX, float targetY, int particleCount, float velocityScale, float spreadRadius, int lifetime, float size, Color color) {
        float directionX = targetX - startX;
        float directionY = targetY - startY;
        float magnitude = (float)Math.sqrt(directionX * directionX + directionY * directionY);
        float unitX = directionX / magnitude;
        float unitY = directionY / magnitude;
        Random random = new Random();
        for (int i = 0; i < particleCount; ++i) {
            float offsetX = (float)(random.nextGaussian() * (double)spreadRadius);
            float offsetY = (float)(random.nextGaussian() * (double)spreadRadius);
            float x = startX + offsetX;
            float y = startY + offsetY;
            float velocityX = unitX * velocityScale + (float)(random.nextGaussian() * (double)0.1f);
            float velocityY = unitY * velocityScale + (float)(random.nextGaussian() * (double)0.1f);
            container.addParticle(new ScreenGlowingParticle(x, y, velocityX, velocityY, size, lifetime, 0.025f, color));
        }
    }

    private void blitWithAlpha(Matrix4f matrix, int x, int y, int z, int u, int v, int width, int height, int textureWidth, int textureHeight, float alpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix, (float)x, (float)(y + height), (float)z).m_7421_((float)u / (float)textureWidth, (float)(v + height) / (float)textureHeight).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)(x + width), (float)(y + height), (float)z).m_7421_((float)(u + width) / (float)textureWidth, (float)(v + height) / (float)textureHeight).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)(x + width), (float)y, (float)z).m_7421_((float)(u + width) / (float)textureWidth, (float)v / (float)textureHeight).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x, (float)y, (float)z).m_7421_((float)u / (float)textureWidth, (float)v / (float)textureHeight).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

