/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.entities;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.EntityVelocityPacket;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class Airflow
extends Projectile {
    private int lvl;
    private float radius;
    private int ticks = 0;
    private int life;

    public Airflow(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public Airflow(Level level, int lvl, int radius) {
        super((EntityType)EntityRegistry.AIRFLOW.get(), level);
        this.lvl = lvl;
        this.radius = radius;
        this.m_20242_(true);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.ticks;
        Level level = this.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        int resetTime = 80;
        if (this.ticks >= resetTime) {
            this.ticks = 0;
        }
        if (this.lvl == 0) {
            this.lvl = 1;
        }
        if (this.f_19797_ % 2 == 0) {
            ParticleUtils.drawAnimatedCyl(level, (ParticleOptions)ParticleTypes.f_123796_, this.m_20182_(), this.f_19797_, this.radius, 10);
        }
        int numParticles = 4;
        float totalHeight = (float)this.lvl / 2.0f;
        for (int i = 0; i < numParticles; ++i) {
            float particleOffset = (float)i / (float)numParticles * (float)resetTime;
            float currentTicks = ((float)this.ticks + particleOffset) % (float)resetTime;
            float heightOffset = currentTicks / (float)resetTime * totalHeight;
            Vec3 positionWithHeight = this.m_20182_().m_82520_(0.0, (double)heightOffset, 0.0);
            ParticleUtils.drawAnimatedCyl(level, new GlowingParticleData(Color.WHITE, 0.25f, 2, 0.02f), positionWithHeight, this.f_19797_, this.radius, 10);
            if (this.f_19797_ % 2 != 0) continue;
            ParticleUtils.drawAnimatedCyl(level, (ParticleOptions)ParticleTypes.f_123796_, positionWithHeight, this.f_19797_, this.radius, 10);
        }
        List players = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_((double)(this.radius - 1.0f)));
        for (Entity player : players) {
            double currentHeight = player.m_20186_();
            double targetHeight = this.m_20186_() + (double)this.lvl;
            if (player.m_20096_()) {
                double heightDifference = targetHeight - currentHeight;
                double initialImpulseY = Math.sqrt(0.2 * heightDifference);
                Vec3 initialImpulse = new Vec3(0.0, initialImpulseY, 0.0);
                player.m_20256_(initialImpulse);
                player.m_6853_(false);
                player.f_19864_ = true;
                player.f_19812_ = true;
                if (player instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)player;
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 10 * this.lvl, 2));
                }
            }
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Networking.sendToClient(serverPlayer, new EntityVelocityPacket(player.m_20184_().m_7096_(), player.m_20184_().m_7098_(), player.m_20184_().m_7094_()));
        }
    }

    public void m_6043_() {
        super.m_6043_();
        if (this.life != -1 && this.f_19797_ >= this.life) {
            this.m_146870_();
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        this.lvl = compound.m_128451_("lvl");
        this.radius = compound.m_128457_("radius");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("lvl", this.lvl);
        compound.m_128350_("radius", this.radius);
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getLvl() {
        return this.lvl;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getLife() {
        return this.life;
    }

    public void setLvl(int lvl) {
        this.lvl = lvl;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public void setLife(int life) {
        this.life = life;
    }
}

