/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.entities;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.animations.base.IAnimatedEntity;
import it.mralxart.etheria.epicora.animations.components.GeometryChanges;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.epicora.geometry.GeometryStorage;
import it.mralxart.etheria.epicora.geometry.data.GeometryData;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.RenderUtils;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class EnigmaCrystal
extends Projectile
implements IAnimatedEntity {
    AnimationController controller = new AnimationController(this);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(EnigmaCrystal.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> ELEMENT = SynchedEntityData.m_135353_(EnigmaCrystal.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public EnigmaCrystal(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
    }

    public EnigmaCrystal(Level level, float damage, String element) {
        super((EntityType)EntityRegistry.SHADOW_NIHILIS.get(), level);
        this.setDamage(damage);
        this.setElement(element);
        this.m_20242_(true);
    }

    public void m_8119_() {
        super.m_8119_();
        this.controller.tick();
        Level level = this.m_9236_();
        if (!level.m_5776_()) {
            return;
        }
        long time = System.currentTimeMillis();
        float angle = (float)(time % 3600L) / 10.0f;
        float yOffset = Mth.m_14031_((float)((float)Math.toRadians(angle))) * 0.1f;
        ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(new Color(10899648), 0.2f + new Random().nextFloat() / 4.0f, 10, 0.03f), this.m_20185_(), this.m_20186_() + (double)yOffset + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 10, 0.03, 0.1, 0.03, 0.04);
        Vec3 pos = this.m_20318_(0.0f).m_82520_(0.0, 0.5 + (double)yOffset, 0.0);
        ParticleUtils.drawAnimatedCyl(level, this.m_20318_(0.0f).m_82520_(0.0, (double)(0.5f + yOffset), 0.0), this.f_19797_, 0.8, new Color(10899648));
        ParticleUtils.createWavyLine(level, new GlowingParticleData(new Color(10899648), 0.2f, 2, 0.025f), pos.m_82520_(-1.0, (double)(8.0f - yOffset), -1.0), pos, this.f_19797_, 0, 15.0, 0.3f, new Random().nextLong(1L, 200L), false);
        ParticleUtils.createWavyLine(level, new GlowingParticleData(new Color(10899648), 0.2f, 2, 0.025f), pos.m_82520_(1.0, (double)(8.0f - yOffset), 1.0), pos, this.f_19797_, 0, 15.0, -0.5, new Random().nextLong(1L, 200L), false);
        ParticleUtils.createWavyLine(level, new GlowingParticleData(new Color(10899648), 0.2f, 5, 0.025f), pos.m_82520_(-1.0, (double)(8.0f - yOffset), 1.0), pos, this.f_19797_, 0, 15.0, 0.4f, new Random().nextLong(1L, 200L), false);
        ParticleUtils.createWavyLine(level, new GlowingParticleData(new Color(10899648), 0.2f, 5, 0.025f), pos.m_82520_(1.0, (double)(8.0f - yOffset), -1.0), pos, this.f_19797_, 0, 15.0, 0.2f, new Random().nextLong(1L, 200L), false);
        ParticleUtils.createSpringSpiral(level, new GlowingParticleData(new Color(10899648), 0.3f, 5, 0.025f), pos.m_82520_(0.0, 6.5 - (double)yOffset, 0.0), pos, this.f_19797_, 0, 35.0, 0.2f, 2.0, 12345L, false);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ELEMENT, (Object)"CRYO");
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(8.0f));
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setElement(tag.m_128461_("element"));
        this.setDamage(tag.m_128457_("damage"));
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("element", this.getElement());
        tag.m_128350_("damage", this.getDamage());
    }

    public void setDamage(float value) {
        this.m_20088_().m_135381_(DAMAGE, (Object)Float.valueOf(value));
    }

    public void setElement(String value) {
        this.m_20088_().m_135381_(ELEMENT, (Object)value);
    }

    public float getDamage() {
        return ((Float)this.m_20088_().m_135370_(DAMAGE)).floatValue();
    }

    public String getElement() {
        return (String)this.m_20088_().m_135370_(ELEMENT);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public Entity getAnimatedEntity() {
        return this;
    }

    public static class Render
    extends EntityRenderer<EnigmaCrystal> {
        private ShaderInstance BLACK_HOLE_SHADER;
        private static final ResourceLocation NOISE_TEXTURE = new ResourceLocation("etheria", "textures/noise.png");
        private static final ResourceLocation DUST_TEXTURE = new ResourceLocation("etheria", "textures/dust.png");
        private static final Matrix4f projectionMatrix = new Matrix4f();

        public Render(EntityRendererProvider.Context renderManager) {
            super(renderManager);
        }

        public void render(@NotNull EnigmaCrystal entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLightIn) {
            GeometryData model = GeometryStorage.getGeometry(new ResourceLocation("etheria", "geometry/shadow_of_nihilis.geo.json"));
            AnimationController controller = entityIn.getController();
            GeometryChanges changes = controller.apply(partialTicks);
            model.applyAnimChanges(changes);
            long time = System.currentTimeMillis();
            float angle = (float)(time % 3600L) / 10.0f;
            float yOffset = Mth.m_14031_((float)((float)Math.toRadians(angle))) * 0.1f;
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)yOffset - 0.5, 0.0);
            poseStack.m_252781_(Axis.f_252436_.m_252961_((float)Blaze3D.m_83640_()));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTextureLocation(entityIn));
            Minecraft.m_91087_().m_91097_().m_174784_(this.getTextureLocation(entityIn));
            RenderType glowingEffect = RenderUtils.getGlowingEffect(this.getTextureLocation(entityIn));
            model.renderModel(poseStack, buffer.m_6299_(glowingEffect), packedLightIn, OverlayTexture.f_118083_, 0.7f);
            poseStack.m_85849_();
        }

        @NotNull
        public ResourceLocation getTextureLocation(EnigmaCrystal entityIn) {
            return new ResourceLocation("etheria", "textures/entity/shadow_of_nihilis.png");
        }
    }
}

