/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.entities;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.RandomUtils;
import java.awt.Color;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Meteorite
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> DAMAGE = SynchedEntityData.m_135353_(Meteorite.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vec3 move = Vec3.f_82478_;
    private Vec3 prevPos = Vec3.f_82478_;
    private Element element = Element.AERO;
    private Vec3 centerPos = Vec3.f_82478_;
    private float radius = 2.0f;
    private Color color = Color.WHITE;

    public Meteorite(EntityType<? extends Meteorite> entityType, Level level) {
        super(entityType, level);
    }

    public void setDamage(int baseDamage) {
        this.m_20088_().m_135381_(DAMAGE, (Object)baseDamage);
    }

    public int getDamage() {
        return (Integer)this.m_20088_().m_135370_(DAMAGE);
    }

    public void m_8119_() {
        super.m_8119_();
        this.move = this.m_20184_();
        if (this.element == null) {
            this.element = Element.AERO;
        }
        if (this.centerPos == null) {
            this.m_146870_();
            return;
        }
        this.color = ElementsUtils.getRandomColorByElement(this.element);
        if (!this.m_9236_().f_46443_) {
            double distance = this.m_20182_().m_82554_(this.prevPos == null ? this.m_20182_() : this.prevPos);
            ParticleUtils.drawParticleLine(new GlowingParticleData(this.color, RandomUtils.random().nextFloat(0.2f, 0.4f), 20, 0.85f), this.m_9236_(), this.prevPos == null ? this.m_20182_() : this.prevPos, this.m_20182_(), (int)Math.round(distance * (double)this.f_19797_ * (double)this.f_19797_ / 156.0 + 2.0), 0.3f);
            if (this.f_19797_ % 2 == 0) {
                ParticleUtils.drawParticleLine((ParticleOptions)ParticleTypes.f_123796_, this.m_9236_(), this.prevPos == null ? this.m_20182_() : this.prevPos, this.m_20182_(), (int)Math.round(distance * (double)this.f_19797_ * (double)this.f_19797_ / 156.0 + 2.0), 0.3f);
            }
            ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(this.color, RandomUtils.random().nextFloat(0.3f, 0.8f), 20, 0.85f), this.m_20182_(), 20, 0.05, 0.05, 0.05, 0.05);
            ParticleUtils.drawAnimatedCyl(this.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.PYRO), 0.25f, 20, 0.025f), this.centerPos, this.f_19797_, this.radius, 10);
        }
        this.prevPos = this.m_20182_();
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.m_19749_() == null || !entity.equals((Object)this.m_19749_())) {
                entity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), (float)this.getDamage());
                ElementHandler.addElement(livingEntity, this.getElement(), this.getDamage(), 500, true);
                entity.f_19802_ = 0;
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82520_(0.0, -5.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK && !this.m_9236_().f_46443_) {
            AABB area = new AABB(this.centerPos, this.centerPos).m_82400_((double)this.radius);
            this.m_9236_().m_45976_(Player.class, area).forEach(player -> {
                player.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), (float)this.getDamage() / 2.0f);
                ElementHandler.addElement((LivingEntity)player, this.getElement(), this.getDamage(), 200, true);
            });
            ParticleUtils.drawParticleLine(new GlowingParticleData(this.color, 0.1f, 20, 0.9f), this.m_9236_(), this.m_20182_(), hitResult.m_82450_(), (int)Math.round(Math.sqrt(this.m_20182_().m_82554_(hitResult.m_82450_())) * (double)this.f_19797_ * (double)this.f_19797_ / 156.0 + 2.0), 0.0f);
            ParticleUtils.createAABB(this.m_9236_(), new GlowingParticleData(this.color, 0.2f, 20, 0.65f), new AABB(hitResult.m_82450_(), hitResult.m_82450_()), 5, 0.1);
            ParticleUtils.createAABB(this.m_9236_(), new GlowingParticleData(this.color, 0.2f, 20, 0.65f), new AABB(hitResult.m_82450_(), hitResult.m_82450_()), 5, 0.1);
        }
        this.m_146870_();
    }

    public void m_6043_() {
        if (this.f_19797_ > 240) {
            this.m_146870_();
        }
    }

    public boolean m_6087_() {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)2);
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("damage", this.getDamage());
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDamage(compound.m_128451_("damage"));
    }

    public Vec3 getMove() {
        return this.move;
    }

    public Vec3 getPrevPos() {
        return this.prevPos;
    }

    public Element getElement() {
        return this.element;
    }

    public Vec3 getCenterPos() {
        return this.centerPos;
    }

    public float getRadius() {
        return this.radius;
    }

    public Color getColor() {
        return this.color;
    }

    public void setMove(Vec3 move) {
        this.move = move;
    }

    public void setPrevPos(Vec3 prevPos) {
        this.prevPos = prevPos;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setCenterPos(Vec3 centerPos) {
        this.centerPos = centerPos;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

