/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.entities;

import it.mralxart.etheria.entities.FlyingBlockEntity;
import it.mralxart.etheria.registry.EntityRegistry;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class ShockwaveEntity
extends Entity {
    private float radius = 0.5f;
    private float maxRadius = 15.0f;
    private float speed = 0.5f;
    private float damage = 15.0f;
    private LivingEntity owner;
    private final Set<UUID> hitEntities = new HashSet<UUID>();
    private final Set<BlockPos> hitBlocks = new HashSet<BlockPos>();

    public ShockwaveEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
    }

    public ShockwaveEntity(Level level, Vec3 position, LivingEntity owner, float maxRadius, float damage) {
        this((EntityType)EntityRegistry.SHOCKWAVE.get(), level);
        this.m_146884_(position);
        this.owner = owner;
        this.maxRadius = maxRadius;
        this.damage = damage;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        float previousRadius = this.radius;
        this.radius += this.speed;
        if (this.radius > this.maxRadius) {
            this.m_146870_();
            return;
        }
        int particleCount = (int)(this.radius * 4.0f);
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double dx = Math.cos(angle) * (double)this.radius;
            double dz = Math.sin(angle) * (double)this.radius;
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + dx, this.m_20186_(), this.m_20189_() + dz, 1, 0.0, 0.0, 0.0, 0.0);
        }
        double waveHeight = 1.5;
        AABB damageBox = new AABB(this.m_20185_() - (double)this.radius, this.m_20186_(), this.m_20189_() - (double)this.radius, this.m_20185_() + (double)this.radius, this.m_20186_() + waveHeight, this.m_20189_() + (double)this.radius);
        this.m_9236_().m_6443_(Player.class, damageBox, player -> !this.hitEntities.contains(player.m_20148_())).forEach(player -> {
            double distanceSq = player.m_20275_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            double radiusSq = this.radius * this.radius;
            double prevRadiusSq = previousRadius * previousRadius;
            if (distanceSq <= radiusSq && distanceSq > prevRadiusSq && player.m_20096_() && player.m_20186_() < this.m_20186_() + waveHeight) {
                player.m_6469_(this.m_269291_().m_269425_(), this.damage);
                Vec3 knockbackDir = player.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                player.m_20256_(player.m_20184_().m_82520_(knockbackDir.f_82479_ * 1.5, 0.6, knockbackDir.f_82481_ * 1.5));
                player.f_19864_ = true;
                this.hitEntities.add(player.m_20148_());
            }
        });
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int blockCheckCount = (int)(this.radius * 6.0f);
        for (int i = 0; i < blockCheckCount; ++i) {
            BlockPos originalPos;
            double angle = Math.PI * 2 * (double)i / (double)blockCheckCount;
            double x = this.m_20185_() + Math.cos(angle) * (double)this.radius;
            double z = this.m_20189_() + Math.sin(angle) * (double)this.radius;
            mutablePos.m_122169_(x, this.m_20186_() + 2.0, z);
            BlockState state = this.m_9236_().m_8055_((BlockPos)mutablePos);
            while (state.m_60795_() && mutablePos.m_123342_() > this.m_9236_().m_141937_()) {
                mutablePos.m_122184_(0, -1, 0);
                state = this.m_9236_().m_8055_((BlockPos)mutablePos);
            }
            if (state.m_60795_() || !(state.m_60800_((BlockGetter)this.m_9236_(), (BlockPos)mutablePos) >= 0.0f) || state.m_60734_() instanceof LiquidBlock || this.hitBlocks.contains(originalPos = mutablePos.m_7949_())) continue;
            this.hitBlocks.add(originalPos);
            FlyingBlockEntity flyingBlock = new FlyingBlockEntity(this.m_9236_(), originalPos, state);
            double baseLift = 0.3;
            double upBlock = 0.01;
            double yOff = baseLift + (double)this.radius * upBlock;
            flyingBlock.m_20334_(0.0, yOff, 0.0);
            this.m_9236_().m_7967_((Entity)flyingBlock);
            this.m_9236_().m_5594_(null, originalPos, state.m_60734_().getSoundType(state, (LevelReader)this.m_9236_(), originalPos, null).m_56775_(), SoundSource.BLOCKS, 1.0f, 0.8f);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)originalPos.m_123341_() + 0.5, (double)originalPos.m_123342_() + 0.5, (double)originalPos.m_123343_() + 0.5, 30, 0.3, 0.3, 0.3, 0.1);
        }
    }

    protected void m_7378_(CompoundTag compoundTag) {
    }

    protected void m_7380_(CompoundTag compoundTag) {
    }

    protected void m_8097_() {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setMaxRadius(float maxRadius) {
        this.maxRadius = maxRadius;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }
}

