/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.animations.components;

import it.mralxart.etheria.epicora.animations.components.bone.BoneAnimation;
import java.util.HashMap;
import java.util.Map;
import org.joml.Vector3f;

public class Animation {
    private String key;
    private Map<String, BoneAnimation> bones;
    private float animationLength;
    public static Animation EMPTY = new Animation("empty", new HashMap<String, BoneAnimation>(), 0.0f);

    public Animation(String key, Map<String, BoneAnimation> bones, float animationLength) {
        this.key = key;
        this.bones = bones;
        this.animationLength = animationLength;
    }

    public Vector3f getRotationAtTime(String boneName, float time) {
        BoneAnimation boneData = this.bones.get(boneName);
        if (boneData != null) {
            return boneData.getRotationAtTime(time);
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public Vector3f getPositionAtTime(String boneName, float time) {
        BoneAnimation boneData = this.bones.get(boneName);
        if (boneData != null) {
            return boneData.getPositionAtTime(time);
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public Vector3f getScaleAtTime(String boneName, float time) {
        BoneAnimation boneData = this.bones.get(boneName);
        if (boneData != null) {
            return boneData.getScaleAtTime(time);
        }
        return new Vector3f(1.0f, 1.0f, 1.0f);
    }

    public boolean same(Animation animation) {
        return this.key.equals(animation.getKey()) && this.bones.equals(animation.bones) && this.animationLength == animation.animationLength;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Animation animation = (Animation)obj;
        return this.key.equals(animation.key);
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, BoneAnimation> getBones() {
        return this.bones;
    }

    public float getAnimationLength() {
        return this.animationLength;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setBones(Map<String, BoneAnimation> bones) {
        this.bones = bones;
    }

    public void setAnimationLength(float animationLength) {
        this.animationLength = animationLength;
    }

    public String toString() {
        return "Animation(key=" + this.getKey() + ", bones=" + this.getBones() + ", animationLength=" + this.getAnimationLength() + ")";
    }

    public Animation() {
    }
}

