/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.animations.components.bone;

import it.mralxart.etheria.epicora.animations.components.InterpolationType;
import it.mralxart.etheria.epicora.animations.components.bone.Keyframe;
import it.mralxart.etheria.epicora.animations.molang.MolangParser;
import it.mralxart.etheria.epicora.animations.molang.MolangVector3f;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class BoneAnimation {
    private String name;
    private Map<Float, Keyframe> rotation = new HashMap<Float, Keyframe>();
    private Map<Float, Keyframe> position = new HashMap<Float, Keyframe>();
    private Map<Float, Keyframe> scale = new HashMap<Float, Keyframe>();

    public Vector3f getRotationAtTime(float time) {
        return this.interpolateKeyframes(this.rotation, time, false);
    }

    public Vector3f getPositionAtTime(float time) {
        return this.interpolateKeyframes(this.position, time, false);
    }

    public Vector3f getScaleAtTime(float time) {
        return this.interpolateKeyframes(this.scale, time, true);
    }

    private Vector3f interpolateKeyframes(Map<Float, Keyframe> keyframes, float time, boolean isScale) {
        Keyframe nextNextKeyframe;
        Keyframe previousPreviousKeyframe;
        Keyframe nextKeyframe;
        if (keyframes.isEmpty()) {
            return isScale ? new Vector3f(1.0f, 1.0f, 1.0f) : new Vector3f(0.0f, 0.0f, 0.0f);
        }
        TreeMap<Float, Keyframe> sortedKeyframes = new TreeMap<Float, Keyframe>(keyframes);
        Map.Entry<Float, Keyframe> previousEntry = sortedKeyframes.floorEntry(Float.valueOf(time));
        Map.Entry<Float, Keyframe> nextEntry = sortedKeyframes.ceilingEntry(Float.valueOf(time));
        Keyframe previousKeyframe = previousEntry != null ? previousEntry.getValue() : null;
        Keyframe keyframe = nextKeyframe = nextEntry != null ? nextEntry.getValue() : null;
        Keyframe keyframe2 = previousEntry != null ? (sortedKeyframes.lowerEntry(previousEntry.getKey()) != null ? sortedKeyframes.lowerEntry(previousEntry.getKey()).getValue() : null) : (previousPreviousKeyframe = null);
        Keyframe keyframe3 = nextEntry != null ? (sortedKeyframes.higherEntry(nextEntry.getKey()) != null ? sortedKeyframes.higherEntry(nextEntry.getKey()).getValue() : null) : (nextNextKeyframe = null);
        if (previousKeyframe == null) {
            return this.computeVector(nextKeyframe, time);
        }
        if (nextKeyframe == null) {
            return this.computeVector(previousKeyframe, time);
        }
        float progress = (time - previousKeyframe.getTime()) / (nextKeyframe.getTime() - previousKeyframe.getTime());
        return this.interpolateWithMolang(previousPreviousKeyframe, previousKeyframe, nextKeyframe, nextNextKeyframe, progress, time);
    }

    private Vector3f computeVector(Keyframe keyframe, float time) {
        Vector3f fallback = keyframe.getVector() != null ? keyframe.getVector() : new Vector3f(0.0f, 0.0f, 0.0f);
        MolangVector3f molang = keyframe.getMolangVector3f();
        float x = molang != null && molang.getX() != null ? MolangParser.count(molang.getX(), time) : fallback.x();
        float y = molang != null && molang.getY() != null ? MolangParser.count(molang.getY(), time) : fallback.y();
        float z = molang != null && molang.getZ() != null ? MolangParser.count(molang.getZ(), time) : fallback.z();
        return new Vector3f(x, y, z);
    }

    private Vector3f interpolateWithMolang(Keyframe p0, Keyframe p1, Keyframe p2, Keyframe p3, float progress, float time) {
        InterpolationType interpolation = p1.getInterpolation();
        Vector3f vectorP0 = p0 != null ? this.computeVector(p0, time) : this.computeVector(p1, time);
        Vector3f vectorP1 = this.computeVector(p1, time);
        Vector3f vectorP2 = this.computeVector(p2, time);
        Vector3f vectorP3 = p3 != null ? this.computeVector(p3, time) : this.computeVector(p2, time);
        return switch (interpolation) {
            case InterpolationType.LINEAR -> this.interpolate(vectorP1, vectorP2, progress);
            case InterpolationType.CATMULLROM -> this.catmullRomInterpolate(vectorP0, vectorP1, vectorP2, vectorP3, progress);
            default -> this.interpolate(vectorP1, vectorP2, progress);
        };
    }

    private Vector3f interpolate(Keyframe p0, Keyframe p1, Keyframe p2, Keyframe p3, float progress) {
        InterpolationType interpolation = InterpolationType.CATMULLROM;
        Vector3f vectorP0 = p0 != null ? p0.getVector() : p1.getVector();
        Vector3f vectorP1 = p1.getVector();
        Vector3f vectorP2 = p2 != null ? p2.getVector() : p1.getVector();
        Vector3f vectorP3 = p3 != null ? p3.getVector() : p2.getVector();
        return switch (interpolation) {
            case InterpolationType.LINEAR -> this.interpolate(vectorP1, vectorP2, progress);
            case InterpolationType.CATMULLROM -> this.catmullRomInterpolate(vectorP0, vectorP1, vectorP2, vectorP3, progress);
            default -> this.interpolate(vectorP1, vectorP2, progress);
        };
    }

    private Vector3f interpolate(Vector3f start, Vector3f end, float progress) {
        return new Vector3f(Mth.m_14179_((float)progress, (float)start.x(), (float)end.x()), Mth.m_14179_((float)progress, (float)start.y(), (float)end.y()), Mth.m_14179_((float)progress, (float)start.z(), (float)end.z()));
    }

    private Vector3f catmullRomInterpolate(Vector3f p0, Vector3f p1, Vector3f p2, Vector3f p3, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        float x = 0.5f * (2.0f * p1.x() + (-p0.x() + p2.x()) * t + (2.0f * p0.x() - 5.0f * p1.x() + 4.0f * p2.x() - p3.x()) * t2 + (-p0.x() + 3.0f * p1.x() - 3.0f * p2.x() + p3.x()) * t3);
        float y = 0.5f * (2.0f * p1.y() + (-p0.y() + p2.y()) * t + (2.0f * p0.y() - 5.0f * p1.y() + 4.0f * p2.y() - p3.y()) * t2 + (-p0.y() + 3.0f * p1.y() - 3.0f * p2.y() + p3.y()) * t3);
        float z = 0.5f * (2.0f * p1.z() + (-p0.z() + p2.z()) * t + (2.0f * p0.z() - 5.0f * p1.z() + 4.0f * p2.z() - p3.z()) * t2 + (-p0.z() + 3.0f * p1.z() - 3.0f * p2.z() + p3.z()) * t3);
        return new Vector3f(x, y, z);
    }

    private Vector3f linearInterpolate(Vector3f start, Vector3f end, float progress) {
        return new Vector3f(start.x + (end.x - start.x) * progress, start.y + (end.y - start.y) * progress, start.z + (end.z - start.z) * progress);
    }

    public String getName() {
        return this.name;
    }

    public Map<Float, Keyframe> getRotation() {
        return this.rotation;
    }

    public Map<Float, Keyframe> getPosition() {
        return this.position;
    }

    public Map<Float, Keyframe> getScale() {
        return this.scale;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRotation(Map<Float, Keyframe> rotation) {
        this.rotation = rotation;
    }

    public void setPosition(Map<Float, Keyframe> position) {
        this.position = position;
    }

    public void setScale(Map<Float, Keyframe> scale) {
        this.scale = scale;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoneAnimation)) {
            return false;
        }
        BoneAnimation other = (BoneAnimation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<Float, Keyframe> this$rotation = this.getRotation();
        Map<Float, Keyframe> other$rotation = other.getRotation();
        if (this$rotation == null ? other$rotation != null : !((Object)this$rotation).equals(other$rotation)) {
            return false;
        }
        Map<Float, Keyframe> this$position = this.getPosition();
        Map<Float, Keyframe> other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        Map<Float, Keyframe> this$scale = this.getScale();
        Map<Float, Keyframe> other$scale = other.getScale();
        return !(this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BoneAnimation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<Float, Keyframe> $rotation = this.getRotation();
        result = result * 59 + ($rotation == null ? 43 : ((Object)$rotation).hashCode());
        Map<Float, Keyframe> $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        Map<Float, Keyframe> $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        return result;
    }

    public String toString() {
        return "BoneAnimation(name=" + this.getName() + ", rotation=" + this.getRotation() + ", position=" + this.getPosition() + ", scale=" + this.getScale() + ")";
    }

    public BoneAnimation(String name, Map<Float, Keyframe> rotation, Map<Float, Keyframe> position, Map<Float, Keyframe> scale) {
        this.name = name;
        this.rotation = rotation;
        this.position = position;
        this.scale = scale;
    }

    public BoneAnimation() {
    }
}

