/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.animations.controller;

import it.mralxart.etheria.epicora.animations.AnimationStorage;
import it.mralxart.etheria.epicora.animations.components.Animation;
import it.mralxart.etheria.epicora.animations.components.AnimationInstance;
import it.mralxart.etheria.epicora.animations.components.BlendMode;
import it.mralxart.etheria.epicora.animations.components.GeometryChanges;
import it.mralxart.etheria.epicora.animations.components.LoopMode;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class AnimationLayer
implements INBTSerializable<CompoundTag> {
    public String id;
    public float startTime;
    public LoopMode loopMode = LoopMode.ONCE;
    public AnimationController controller;
    public BlendMode mode = BlendMode.ADD;
    @Nullable
    public AnimationInstance lastAnimation;
    @Nullable
    public AnimationInstance currentAnimation;

    public AnimationLayer(String id, AnimationController controller) {
        this.id = id;
        this.controller = controller;
    }

    public void tick(float tickCount) {
        float progress = 1.0f - Math.min(tickCount - this.startTime, 0.3f) / 0.3f;
        if (this.getLastAnimation() != null && progress <= 0.0f) {
            this.setLastAnimation(null);
        }
        if (this.getCurrentAnimation() != null && this.getLoopMode() == LoopMode.ONCE && this.controller.getControllerTime(0.0f) - this.startTime + 0.1f >= this.getCurrentAnimation().getAnimation().getAnimationLength()) {
            this.stopAnimation();
        }
    }

    public GeometryChanges apply(GeometryChanges geometryChanges, float controllerTime) {
        float progress;
        float animTime;
        if (this.getLastAnimation() != null) {
            animTime = this.getAnimTime(this.getLastAnimation(), controllerTime);
            progress = 1.0f - Math.min(controllerTime - this.startTime, 0.3f) / 0.3f;
            geometryChanges.apply(this.getLastAnimation().animation, this.mode, animTime, progress);
        }
        if (this.getCurrentAnimation() != null) {
            animTime = this.getAnimTime(this.getCurrentAnimation(), controllerTime);
            progress = Math.min(controllerTime - this.startTime, 0.3f) / 0.3f;
            geometryChanges.apply(this.getCurrentAnimation().animation, this.mode, animTime, progress);
        }
        return geometryChanges;
    }

    public float getAnimTime(AnimationInstance animationInstance, float controllerTime) {
        float animationLength = animationInstance.getAnimation().getAnimationLength();
        float time = controllerTime - this.startTime;
        switch (this.loopMode) {
            case ONCE: {
                return time;
            }
            case LOOP: {
                return animationLength > 0.0f ? time % animationLength : 0.0f;
            }
            case LAST_FRAME: {
                return Math.min(time, animationLength);
            }
        }
        return time;
    }

    public boolean startAnimation(Animation animation) {
        if (animation == null) {
            return false;
        }
        if (this.getCurrentAnimation() != null && this.getCurrentAnimation().animation.equals(animation)) {
            return false;
        }
        this.setLastAnimation(this.getCurrentAnimation());
        this.setStartTime(this.controller.getControllerTime(0.0f));
        this.setCurrentAnimation(new AnimationInstance(animation, this.getStartTime()));
        this.controller.trySync();
        return true;
    }

    @NotNull
    public AnimationInstance getAnimation() {
        if (this.getCurrentAnimation() == null) {
            return new AnimationInstance(Animation.EMPTY, this.controller.getControllerTime(0.0f));
        }
        return this.getCurrentAnimation();
    }

    public boolean stopAnimation() {
        return this.startAnimation(Animation.EMPTY);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", this.id != null ? this.id : "");
        tag.m_128350_("startTime", this.startTime);
        tag.m_128359_("loopMode", this.loopMode != null ? this.loopMode.name() : LoopMode.ONCE.name());
        if (this.lastAnimation != null) {
            tag.m_128365_("lastAnimation", (Tag)this.serializeInstance(this.lastAnimation));
        }
        if (this.currentAnimation != null) {
            tag.m_128365_("currentAnimation", (Tag)this.serializeInstance(this.currentAnimation));
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.id = tag.m_128461_("id");
        this.startTime = tag.m_128457_("startTime");
        this.loopMode = LoopMode.valueOf(tag.m_128461_("loopMode"));
        this.lastAnimation = tag.m_128441_("lastAnimation") ? this.deserializeInstance(tag.m_128469_("lastAnimation")) : null;
        this.currentAnimation = tag.m_128441_("currentAnimation") ? this.deserializeInstance(tag.m_128469_("currentAnimation")) : null;
    }

    private CompoundTag serializeInstance(AnimationInstance instance) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("animationKey", instance.animation.getKey());
        tag.m_128350_("animationLength", instance.animation.getAnimationLength());
        tag.m_128350_("startTime", instance.startTime);
        return tag;
    }

    private AnimationInstance deserializeInstance(CompoundTag tag) {
        String key = tag.m_128461_("animationKey");
        float animationLength = tag.m_128457_("animationLength");
        Animation animation = AnimationStorage.getAnimationByKey(key, animationLength);
        return new AnimationInstance(animation, tag.m_128457_("startTime"));
    }

    public String getId() {
        return this.id;
    }

    public float getStartTime() {
        return this.startTime;
    }

    public LoopMode getLoopMode() {
        return this.loopMode;
    }

    public AnimationController getController() {
        return this.controller;
    }

    public BlendMode getMode() {
        return this.mode;
    }

    @Nullable
    public AnimationInstance getLastAnimation() {
        return this.lastAnimation;
    }

    @Nullable
    public AnimationInstance getCurrentAnimation() {
        return this.currentAnimation;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStartTime(float startTime) {
        this.startTime = startTime;
    }

    public void setLoopMode(LoopMode loopMode) {
        this.loopMode = loopMode;
    }

    public void setController(AnimationController controller) {
        this.controller = controller;
    }

    public void setMode(BlendMode mode) {
        this.mode = mode;
    }

    public void setLastAnimation(@Nullable AnimationInstance lastAnimation) {
        this.lastAnimation = lastAnimation;
    }

    public void setCurrentAnimation(@Nullable AnimationInstance currentAnimation) {
        this.currentAnimation = currentAnimation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnimationLayer)) {
            return false;
        }
        AnimationLayer other = (AnimationLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getStartTime(), other.getStartTime()) != 0) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LoopMode this$loopMode = this.getLoopMode();
        LoopMode other$loopMode = other.getLoopMode();
        if (this$loopMode == null ? other$loopMode != null : !((Object)((Object)this$loopMode)).equals((Object)other$loopMode)) {
            return false;
        }
        AnimationController this$controller = this.getController();
        AnimationController other$controller = other.getController();
        if (this$controller == null ? other$controller != null : !this$controller.equals(other$controller)) {
            return false;
        }
        BlendMode this$mode = this.getMode();
        BlendMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        AnimationInstance this$lastAnimation = this.getLastAnimation();
        AnimationInstance other$lastAnimation = other.getLastAnimation();
        if (this$lastAnimation == null ? other$lastAnimation != null : !((Object)this$lastAnimation).equals(other$lastAnimation)) {
            return false;
        }
        AnimationInstance this$currentAnimation = this.getCurrentAnimation();
        AnimationInstance other$currentAnimation = other.getCurrentAnimation();
        return !(this$currentAnimation == null ? other$currentAnimation != null : !((Object)this$currentAnimation).equals(other$currentAnimation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnimationLayer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getStartTime());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LoopMode $loopMode = this.getLoopMode();
        result = result * 59 + ($loopMode == null ? 43 : ((Object)((Object)$loopMode)).hashCode());
        AnimationController $controller = this.getController();
        result = result * 59 + ($controller == null ? 43 : $controller.hashCode());
        BlendMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        AnimationInstance $lastAnimation = this.getLastAnimation();
        result = result * 59 + ($lastAnimation == null ? 43 : ((Object)$lastAnimation).hashCode());
        AnimationInstance $currentAnimation = this.getCurrentAnimation();
        result = result * 59 + ($currentAnimation == null ? 43 : ((Object)$currentAnimation).hashCode());
        return result;
    }

    public String toString() {
        return "AnimationLayer(id=" + this.getId() + ", startTime=" + this.getStartTime() + ", loopMode=" + this.getLoopMode() + ", controller=" + this.getController() + ", mode=" + this.getMode() + ", lastAnimation=" + this.getLastAnimation() + ", currentAnimation=" + this.getCurrentAnimation() + ")";
    }
}

