/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.animations.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.mralxart.etheria.Etheria;
import it.mralxart.etheria.epicora.animations.AnimationStorage;
import it.mralxart.etheria.epicora.animations.components.Animation;
import it.mralxart.etheria.epicora.animations.components.InterpolationType;
import it.mralxart.etheria.epicora.animations.components.bone.BoneAnimation;
import it.mralxart.etheria.epicora.animations.components.bone.Keyframe;
import it.mralxart.etheria.epicora.animations.molang.MolangVector3f;
import it.mralxart.etheria.epicora.geometry.util.GeometryLoader;
import it.mralxart.etheria.registry.AnimationRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public class AnimationsLoader {
    public static void init() {
        ((CompletableFuture)AnimationRegistry.waitForAllRegistrations().thenCompose(aVoid -> AnimationsLoader.loadAnimations())).thenRun(() -> Etheria.LOGGER.info("All controller loaded successfully."));
    }

    public static CompletableFuture<Void> loadAnimations() {
        return CompletableFuture.runAsync(() -> AnimationRegistry.getRegistry().forEach((key, path) -> {
            ResourceLocation location = new ResourceLocation(key.m_135827_(), path);
            String jsonString = AnimationsLoader.getJsonStringFromResource(location);
            if (jsonString != null) {
                JsonObject jsonObject = (JsonObject)new Gson().fromJson(jsonString, JsonObject.class);
                Etheria.LOGGER.info("Loaded animation JSON for {}", key);
                AnimationStorage.storeAnimation(key, AnimationsLoader.parseAnimations(location, jsonObject));
            } else {
                Etheria.LOGGER.error("Failed to load animation JSON from resource: {}", (Object)location);
            }
        }));
    }

    public static Map<String, Animation> parseAnimations(ResourceLocation location, JsonObject jsonObject) {
        try {
            JsonObject animations = jsonObject.getAsJsonObject("animations");
            HashMap<String, Animation> animationMap = new HashMap<String, Animation>();
            for (Map.Entry entry : animations.entrySet()) {
                String animationName = (String)entry.getKey();
                JsonObject animationObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                float animationLength = animationObject.has("animation_length") ? animationObject.get("animation_length").getAsFloat() : 0.0f;
                JsonObject bones = animationObject.getAsJsonObject("bones");
                Map<String, BoneAnimation> boneAnimations = bones.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, boneEntry -> AnimationsLoader.parseBoneAnimation(location, ((JsonElement)boneEntry.getValue()).getAsJsonObject(), (String)boneEntry.getKey())));
                animationMap.put(animationName, new Animation(animationName, boneAnimations, animationLength));
            }
            return animationMap;
        }
        catch (Exception e) {
            Etheria.LOGGER.error("Failed to parse animation from resource {}: {}", (Object)location, (Object)e.getMessage());
            return null;
        }
    }

    private static BoneAnimation parseBoneAnimation(ResourceLocation location, JsonObject boneObject, String name) {
        try {
            BoneAnimation boneAnimation = new BoneAnimation();
            boneAnimation.setName(name);
            if (boneObject.has("rotation")) {
                JsonElement rotationElement = boneObject.get("rotation");
                boneAnimation.setRotation(AnimationsLoader.parseKeyframes(rotationElement));
            }
            if (boneObject.has("position")) {
                JsonElement positionElement = boneObject.get("position");
                boneAnimation.setPosition(AnimationsLoader.parseKeyframes(positionElement));
            }
            if (boneObject.has("scale")) {
                JsonElement scaleElement = boneObject.get("scale");
                boneAnimation.setScale(AnimationsLoader.parseKeyframes(scaleElement));
            }
            return boneAnimation;
        }
        catch (Exception e) {
            Etheria.LOGGER.error("Failed to parse BoneAnimation by anim key: {}, from resource {}: {}", (Object)location, (Object)boneObject, (Object)e.getMessage());
            return new BoneAnimation();
        }
    }

    private static Map<Float, Keyframe> parseKeyframes(JsonElement keyframesElement) {
        HashMap<Float, Keyframe> keyframes = new HashMap<Float, Keyframe>();
        if (keyframesElement.isJsonArray()) {
            JsonArray arr = keyframesElement.getAsJsonArray();
            if (arr.size() == 3) {
                if (AnimationsLoader.hasString(arr)) {
                    MolangVector3f molang = AnimationsLoader.parseMolangVector(arr);
                    keyframes.put(Float.valueOf(0.0f), new Keyframe(0.0f, null, molang, "linear", InterpolationType.LINEAR));
                } else {
                    Vector3f vector = AnimationsLoader.parseVector(arr);
                    keyframes.put(Float.valueOf(0.0f), new Keyframe(0.0f, vector, null, "linear", InterpolationType.LINEAR));
                }
            }
        } else if (keyframesElement.isJsonObject()) {
            JsonObject keyframesJson = keyframesElement.getAsJsonObject();
            for (Map.Entry entry : keyframesJson.entrySet()) {
                JsonArray arr;
                float time;
                try {
                    time = Float.parseFloat((String)entry.getKey());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                JsonElement value = (JsonElement)entry.getValue();
                Vector3f vector = null;
                MolangVector3f molang = null;
                String easing = "linear";
                InterpolationType interpolation = InterpolationType.LINEAR;
                if (value.isJsonObject()) {
                    JsonArray arr2;
                    JsonObject keyframeObject = value.getAsJsonObject();
                    if (keyframeObject.has("vector")) {
                        arr2 = keyframeObject.getAsJsonArray("vector");
                        if (arr2.size() == 3) {
                            if (AnimationsLoader.hasString(arr2)) {
                                molang = AnimationsLoader.parseMolangVector(arr2);
                            } else {
                                vector = AnimationsLoader.parseVector(arr2);
                            }
                        }
                    } else if (keyframeObject.has("post") && (arr2 = keyframeObject.getAsJsonArray("post")).size() == 3) {
                        if (AnimationsLoader.hasString(arr2)) {
                            molang = AnimationsLoader.parseMolangVector(arr2);
                        } else {
                            vector = AnimationsLoader.parseVector(arr2);
                        }
                    }
                    if (keyframeObject.has("easing")) {
                        easing = keyframeObject.get("easing").getAsString();
                    }
                    if (keyframeObject.has("lerp_mode")) {
                        interpolation = InterpolationType.fromString(keyframeObject.get("lerp_mode").getAsString());
                    }
                } else if (value.isJsonArray() && (arr = value.getAsJsonArray()).size() == 3) {
                    if (AnimationsLoader.hasString(arr)) {
                        molang = AnimationsLoader.parseMolangVector(arr);
                    } else {
                        vector = AnimationsLoader.parseVector(arr);
                    }
                }
                keyframes.put(Float.valueOf(time), new Keyframe(time, vector, molang, easing, interpolation));
            }
        }
        return keyframes;
    }

    private static boolean hasString(JsonArray arr) {
        for (JsonElement el : arr) {
            if (!el.isJsonPrimitive() || !el.getAsJsonPrimitive().isString()) continue;
            return true;
        }
        return false;
    }

    private static MolangVector3f parseMolangVector(JsonArray arr) {
        String x = AnimationsLoader.parseMolangComponent(arr.get(0));
        String y = AnimationsLoader.parseMolangComponent(arr.get(1));
        String z = AnimationsLoader.parseMolangComponent(arr.get(2));
        return new MolangVector3f(x, y, z);
    }

    private static String parseMolangComponent(JsonElement el) {
        if (el.isJsonPrimitive()) {
            if (el.getAsJsonPrimitive().isString()) {
                return el.getAsString();
            }
            if (el.getAsJsonPrimitive().isNumber()) {
                return Float.toString(el.getAsFloat());
            }
        }
        return "";
    }

    private static Vector3f parseVector(JsonArray vectorArray) {
        if (vectorArray.size() >= 3) {
            float x = vectorArray.get(0).getAsFloat();
            float y = vectorArray.get(1).getAsFloat();
            float z = vectorArray.get(2).getAsFloat();
            return new Vector3f(x, y, z);
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    private static String getJsonStringFromResource(ResourceLocation path) {
        String string;
        String resourcePath = "assets/" + path.m_135827_() + "/" + path.m_135815_();
        InputStream inputStream = GeometryLoader.class.getClassLoader().getResourceAsStream(resourcePath);
        if (inputStream == null) {
            Etheria.LOGGER.error("Resource not found: {}", (Object)resourcePath);
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            String line;
            StringBuilder jsonString = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                jsonString.append(line).append(System.lineSeparator());
            }
            string = jsonString.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Etheria.LOGGER.error("Error reading resource: {}", (Object)resourcePath, (Object)e);
                return null;
            }
        }
        reader.close();
        return string;
    }
}

