/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.geometry.components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.mralxart.etheria.epicora.animations.components.bone.BoneRenderCallback;
import it.mralxart.etheria.epicora.geometry.components.GeometryCube;
import it.mralxart.etheria.epicora.geometry.data.BoneSnapshot;
import it.mralxart.etheria.utils.NbtUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class GeometryBone
implements INBTSerializable<CompoundTag> {
    private String name;
    private Vector3f pos;
    private Vector3f pivot;
    private Vector3f rotation;
    public Vector3f scale;
    private String parent = "";
    private List<GeometryCube> cubes;
    private List<GeometryBone> children;
    private BoneSnapshot snapshot;
    private BoneSnapshot initialSnapshot;
    public BoneRenderCallback callback = null;
    public BoneRenderCallback callback2 = null;
    public Vector3f worldPos = new Vector3f();
    private boolean rotChanged;
    private boolean posChanged;
    private boolean scaleChanged;

    public GeometryBone(String name, Vector3f pivot, Vector3f rotation, Vector3f scale) {
        this.pos = new Vector3f(0.0f, 0.0f, 0.0f);
        this.name = name;
        this.pivot = pivot;
        this.rotation = rotation;
        this.scale = scale;
        this.cubes = new ArrayList<GeometryCube>();
        this.children = new ArrayList<GeometryBone>();
        this.snapshot = new BoneSnapshot(rotation, this.pos, scale);
        this.initialSnapshot = new BoneSnapshot(rotation, this.pos, scale);
    }

    public GeometryBone copy() {
        GeometryBone copy = new GeometryBone(this.name, new Vector3f(this.pivot.x, this.pivot.y, this.pivot.z), new Vector3f(this.rotation.x, this.rotation.y, this.rotation.z), new Vector3f(this.scale.x, this.scale.y, this.scale.z));
        for (GeometryCube cube : this.cubes) {
            copy.addCube(cube);
        }
        copy.setParent(this.parent);
        for (GeometryBone child : this.children) {
            GeometryBone childCopy = child.copy();
            childCopy.setParent(copy.name);
            copy.addChildBone(childCopy);
        }
        return copy;
    }

    public GeometryBone copy(GeometryBone bone) {
        this.name = bone.name;
        this.pos = bone.pos;
        this.pivot = bone.pivot;
        this.rotation = bone.rotation;
        this.scale = bone.scale;
        this.parent = bone.parent;
        this.cubes = bone.cubes;
        this.children = bone.children;
        if (bone.callback != null) {
            this.callback = bone.callback;
        }
        return this;
    }

    public void resetToInitial() {
        this.snapshot.updateRotation(this.initialSnapshot.getCurrentRotation());
        this.snapshot.updatePosition(this.initialSnapshot.getCurrentPosition());
        this.snapshot.updateScale(this.initialSnapshot.getCurrentScale());
    }

    public void reset() {
        this.setRotation(this.initialSnapshot.getCurrentRotation());
        this.setPos(new Vector3f(0.0f, 0.0f, 0.0f));
        this.setScale(new Vector3f(1.0f, 1.0f, 1.0f));
    }

    public void addCube(GeometryCube cube) {
        this.cubes.add(cube);
    }

    public void addChildBone(GeometryBone child) {
        this.children.add(child);
    }

    public void renderBone(Map<String, GeometryBone> allBones, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (allBones.containsKey(this.getName())) {
            this.copy(allBones.get(this.getName()));
        }
        poseStack.m_85836_();
        if (!this.pos.equals((Object)new Vector3f(0.0f, 0.0f, 0.0f))) {
            poseStack.m_252880_(-this.pos.x / 16.0f, -this.pos.y / 16.0f, this.pos.z / 16.0f);
        }
        poseStack.m_252880_(this.pivot.x() / 16.0f, this.pivot.y() / 16.0f, this.pivot.z() / 16.0f);
        Vector3f rot = this.getRotation();
        Quaternionf rotationQuat = new Quaternionf().rotateZYX(rot.z(), -rot.y(), rot.x());
        poseStack.m_252781_(rotationQuat);
        if (this.scale.x() != 0.0f && this.scale.y() != 0.0f && this.scale.z() != 0.0f) {
            if (this.scale.x() != 1.0f || this.scale.y() != 1.0f || this.scale.z() != 1.0f) {
                poseStack.m_85841_(this.scale.x(), this.scale.y(), this.scale.z());
            } else {
                poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            }
        } else {
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        }
        poseStack.m_252880_(-this.pivot.x() / 16.0f, -this.pivot.y() / 16.0f, -this.pivot.z() / 16.0f);
        this.renderCubes(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        for (GeometryBone childBone : this.children) {
            childBone.renderBone(allBones, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        poseStack.m_85849_();
    }

    public void renderBone(Map<String, GeometryBone> allBones, PoseStack poseStack) {
        if (allBones.containsKey(this.getName())) {
            this.copy(allBones.get(this.getName()));
        }
        poseStack.m_85836_();
        if (!this.pos.equals((Object)new Vector3f(0.0f, 0.0f, 0.0f))) {
            poseStack.m_252880_(-this.pos.x / 16.0f, -this.pos.y / 16.0f, this.pos.z / 16.0f);
        }
        poseStack.m_252880_(this.pivot.x() / 16.0f, this.pivot.y() / 16.0f, this.pivot.z() / 16.0f);
        Vector3f rot = this.getRotation();
        Quaternionf rotationQuat = new Quaternionf().rotateZYX(rot.z(), -rot.y(), rot.x());
        poseStack.m_252781_(rotationQuat);
        if (this.scale.x() != 0.0f && this.scale.y() != 0.0f && this.scale.z() != 0.0f) {
            if (this.scale.x() != 1.0f || this.scale.y() != 1.0f || this.scale.z() != 1.0f) {
                poseStack.m_85841_(this.scale.x(), this.scale.y(), this.scale.z());
            } else {
                poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            }
        } else {
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        }
        if (this.callback != null) {
            Matrix4f finalMatrix = poseStack.m_85850_().m_252922_();
            Vector4f posVec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            posVec.mul((Matrix4fc)finalMatrix);
            this.worldPos = new Vector3f(posVec.x, posVec.y, posVec.z);
            this.callback.callback(allBones, this, poseStack, this.worldPos);
        }
        if (this.callback2 != null) {
            this.callback2.callback(allBones, this, poseStack, this.worldPos);
        }
        poseStack.m_252880_(-this.pivot.x() / 16.0f, -this.pivot.y() / 16.0f, -this.pivot.z() / 16.0f);
        for (GeometryBone childBone : this.children) {
            childBone.renderBone(allBones, poseStack);
        }
        poseStack.m_85849_();
    }

    private void renderCubes(PoseStack matrixEntryIn, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        for (GeometryCube cube : this.cubes) {
            matrixEntryIn.m_85836_();
            cube.render(matrixEntryIn, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixEntryIn.m_85849_();
        }
    }

    public void setScaleX(float x) {
        this.scale = new Vector3f(x, this.scale.y, this.scale.z);
    }

    public void setScaleY(float y) {
        this.scale = new Vector3f(this.scale.x, y, this.scale.z);
    }

    public void setScaleZ(float z) {
        this.scale = new Vector3f(this.scale.x, this.scale.y, z);
    }

    public void setRotationX(float x) {
        this.rotation = new Vector3f(x, this.rotation.y, this.rotation.z);
    }

    public void setRotationY(float y) {
        this.rotation = new Vector3f(this.rotation.x, y, this.rotation.z);
    }

    public void setRotationZ(float z) {
        this.rotation = new Vector3f(this.rotation.x, this.rotation.y, z);
    }

    public void setPosX(float x) {
        this.pos = new Vector3f(x, this.pos.y, this.pos.z);
    }

    public void setPosY(float y) {
        this.pos = new Vector3f(this.pos.x, y, this.pos.z);
    }

    public void setPosZ(float z) {
        this.pos = new Vector3f(this.pos.x, this.pos.y, z);
    }

    public void setPivotX(float x) {
        this.pivot = new Vector3f(x, this.pivot.y, this.pivot.z);
    }

    public void setPivotY(float y) {
        this.pivot = new Vector3f(this.pivot.x, y, this.pivot.z);
    }

    public void setPivotZ(float z) {
        this.pivot = new Vector3f(this.pivot.x, this.pivot.y, z);
    }

    public Vector3f getWorldPosition(Map<String, GeometryBone> allBones) {
        PoseStack poseStack = new PoseStack();
        this.applyBoneTransformations(this, allBones, poseStack);
        Matrix4f worldMatrix = poseStack.m_85850_().m_252922_();
        Vector4f localPosition = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        localPosition.mul((Matrix4fc)worldMatrix);
        return new Vector3f(localPosition.x(), localPosition.y(), localPosition.z());
    }

    private void applyBoneTransformations(GeometryBone bone, Map<String, GeometryBone> allBones, PoseStack poseStack) {
        if (bone == null) {
            return;
        }
        if (!bone.parent.isEmpty()) {
            GeometryBone parentBone = allBones.get(bone.parent);
            this.applyBoneTransformations(parentBone, allBones, poseStack);
        }
        poseStack.m_85836_();
        if (!bone.pos.equals((Object)new Vector3f(0.0f, 0.0f, 0.0f))) {
            poseStack.m_252880_(-bone.pos.x() / 16.0f, -bone.pos.y() / 16.0f, bone.pos.z() / 16.0f);
        }
        poseStack.m_252880_(bone.pivot.x() / 16.0f, bone.pivot.y() / 16.0f, bone.pivot.z() / 16.0f);
        Vector3f rot = bone.getRotation();
        Quaternionf rotationQuat = new Quaternionf().rotateZYX((float)Math.toRadians(rot.z()), (float)Math.toRadians(-rot.y()), (float)Math.toRadians(-rot.x()));
        poseStack.m_252781_(rotationQuat);
        if (bone.scale.x() != 0.0f && bone.scale.y() != 0.0f && bone.scale.z() != 0.0f) {
            if (bone.scale.x() != 1.0f || bone.scale.y() != 1.0f || bone.scale.z() != 1.0f) {
                poseStack.m_85841_(bone.scale.x(), bone.scale.y(), bone.scale.z());
            }
        } else {
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        }
        poseStack.m_252880_(-bone.pivot.x() / 16.0f, -bone.pivot.y() / 16.0f, -bone.pivot.z() / 16.0f);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", this.name);
        tag.m_128365_("pos", (Tag)NbtUtils.writeVector3f(this.pos));
        tag.m_128365_("pivot", (Tag)NbtUtils.writeVector3f(this.pivot));
        tag.m_128365_("rotation", (Tag)NbtUtils.writeVector3f(this.rotation));
        tag.m_128365_("scale", (Tag)NbtUtils.writeVector3f(this.scale));
        tag.m_128359_("parent", this.parent);
        ListTag cubesTag = new ListTag();
        for (GeometryCube cube : this.cubes) {
            cubesTag.add((Object)cube.serializeNBT());
        }
        tag.m_128365_("cubes", (Tag)cubesTag);
        ListTag childrenTag = new ListTag();
        for (GeometryBone child : this.children) {
            childrenTag.add((Object)child.serializeNBT());
        }
        tag.m_128365_("children", (Tag)childrenTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.name = tag.m_128461_("name");
        this.pos = NbtUtils.readVector3f(tag.m_128469_("pos"));
        this.pivot = NbtUtils.readVector3f(tag.m_128469_("pivot"));
        this.rotation = NbtUtils.readVector3f(tag.m_128469_("rotation"));
        this.scale = NbtUtils.readVector3f(tag.m_128469_("scale"));
        this.parent = tag.m_128461_("parent");
        ListTag cubesTag = tag.m_128437_("cubes", 10);
        this.cubes = new ArrayList<GeometryCube>();
        for (Tag cubeTag : cubesTag) {
            GeometryCube cube = new GeometryCube();
            cube.deserializeNBT((CompoundTag)cubeTag);
            this.cubes.add(cube);
        }
        ListTag childrenTag = tag.m_128437_("children", 10);
        this.children = new ArrayList<GeometryBone>();
        for (Tag childTag : childrenTag) {
            GeometryBone child = new GeometryBone();
            child.deserializeNBT((CompoundTag)childTag);
            this.children.add(child);
        }
    }

    public String getName() {
        return this.name;
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public Vector3f getPivot() {
        return this.pivot;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public String getParent() {
        return this.parent;
    }

    public List<GeometryCube> getCubes() {
        return this.cubes;
    }

    public List<GeometryBone> getChildren() {
        return this.children;
    }

    public BoneSnapshot getSnapshot() {
        return this.snapshot;
    }

    public BoneSnapshot getInitialSnapshot() {
        return this.initialSnapshot;
    }

    public BoneRenderCallback getCallback() {
        return this.callback;
    }

    public BoneRenderCallback getCallback2() {
        return this.callback2;
    }

    public Vector3f getWorldPos() {
        return this.worldPos;
    }

    public boolean isRotChanged() {
        return this.rotChanged;
    }

    public boolean isPosChanged() {
        return this.posChanged;
    }

    public boolean isScaleChanged() {
        return this.scaleChanged;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPos(Vector3f pos) {
        this.pos = pos;
    }

    public void setPivot(Vector3f pivot) {
        this.pivot = pivot;
    }

    public void setRotation(Vector3f rotation) {
        this.rotation = rotation;
    }

    public void setScale(Vector3f scale) {
        this.scale = scale;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public void setCubes(List<GeometryCube> cubes) {
        this.cubes = cubes;
    }

    public void setChildren(List<GeometryBone> children) {
        this.children = children;
    }

    public void setSnapshot(BoneSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public void setInitialSnapshot(BoneSnapshot initialSnapshot) {
        this.initialSnapshot = initialSnapshot;
    }

    public void setCallback(BoneRenderCallback callback) {
        this.callback = callback;
    }

    public void setCallback2(BoneRenderCallback callback2) {
        this.callback2 = callback2;
    }

    public void setWorldPos(Vector3f worldPos) {
        this.worldPos = worldPos;
    }

    public void setRotChanged(boolean rotChanged) {
        this.rotChanged = rotChanged;
    }

    public void setPosChanged(boolean posChanged) {
        this.posChanged = posChanged;
    }

    public void setScaleChanged(boolean scaleChanged) {
        this.scaleChanged = scaleChanged;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeometryBone)) {
            return false;
        }
        GeometryBone other = (GeometryBone)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRotChanged() != other.isRotChanged()) {
            return false;
        }
        if (this.isPosChanged() != other.isPosChanged()) {
            return false;
        }
        if (this.isScaleChanged() != other.isScaleChanged()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Vector3f this$pos = this.getPos();
        Vector3f other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        Vector3f this$pivot = this.getPivot();
        Vector3f other$pivot = other.getPivot();
        if (this$pivot == null ? other$pivot != null : !this$pivot.equals(other$pivot)) {
            return false;
        }
        Vector3f this$rotation = this.getRotation();
        Vector3f other$rotation = other.getRotation();
        if (this$rotation == null ? other$rotation != null : !this$rotation.equals(other$rotation)) {
            return false;
        }
        Vector3f this$scale = this.getScale();
        Vector3f other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !this$scale.equals(other$scale)) {
            return false;
        }
        String this$parent = this.getParent();
        String other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        List<GeometryCube> this$cubes = this.getCubes();
        List<GeometryCube> other$cubes = other.getCubes();
        if (this$cubes == null ? other$cubes != null : !((Object)this$cubes).equals(other$cubes)) {
            return false;
        }
        List<GeometryBone> this$children = this.getChildren();
        List<GeometryBone> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        BoneSnapshot this$snapshot = this.getSnapshot();
        BoneSnapshot other$snapshot = other.getSnapshot();
        if (this$snapshot == null ? other$snapshot != null : !((Object)this$snapshot).equals(other$snapshot)) {
            return false;
        }
        BoneSnapshot this$initialSnapshot = this.getInitialSnapshot();
        BoneSnapshot other$initialSnapshot = other.getInitialSnapshot();
        if (this$initialSnapshot == null ? other$initialSnapshot != null : !((Object)this$initialSnapshot).equals(other$initialSnapshot)) {
            return false;
        }
        BoneRenderCallback this$callback = this.getCallback();
        BoneRenderCallback other$callback = other.getCallback();
        if (this$callback == null ? other$callback != null : !this$callback.equals(other$callback)) {
            return false;
        }
        BoneRenderCallback this$callback2 = this.getCallback2();
        BoneRenderCallback other$callback2 = other.getCallback2();
        if (this$callback2 == null ? other$callback2 != null : !this$callback2.equals(other$callback2)) {
            return false;
        }
        Vector3f this$worldPos = this.getWorldPos();
        Vector3f other$worldPos = other.getWorldPos();
        return !(this$worldPos == null ? other$worldPos != null : !this$worldPos.equals(other$worldPos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeometryBone;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRotChanged() ? 79 : 97);
        result = result * 59 + (this.isPosChanged() ? 79 : 97);
        result = result * 59 + (this.isScaleChanged() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Vector3f $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        Vector3f $pivot = this.getPivot();
        result = result * 59 + ($pivot == null ? 43 : $pivot.hashCode());
        Vector3f $rotation = this.getRotation();
        result = result * 59 + ($rotation == null ? 43 : $rotation.hashCode());
        Vector3f $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : $scale.hashCode());
        String $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        List<GeometryCube> $cubes = this.getCubes();
        result = result * 59 + ($cubes == null ? 43 : ((Object)$cubes).hashCode());
        List<GeometryBone> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        BoneSnapshot $snapshot = this.getSnapshot();
        result = result * 59 + ($snapshot == null ? 43 : ((Object)$snapshot).hashCode());
        BoneSnapshot $initialSnapshot = this.getInitialSnapshot();
        result = result * 59 + ($initialSnapshot == null ? 43 : ((Object)$initialSnapshot).hashCode());
        BoneRenderCallback $callback = this.getCallback();
        result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
        BoneRenderCallback $callback2 = this.getCallback2();
        result = result * 59 + ($callback2 == null ? 43 : $callback2.hashCode());
        Vector3f $worldPos = this.getWorldPos();
        result = result * 59 + ($worldPos == null ? 43 : $worldPos.hashCode());
        return result;
    }

    public String toString() {
        return "GeometryBone(name=" + this.getName() + ", pos=" + this.getPos() + ", pivot=" + this.getPivot() + ", rotation=" + this.getRotation() + ", scale=" + this.getScale() + ", parent=" + this.getParent() + ", cubes=" + this.getCubes() + ", children=" + this.getChildren() + ", snapshot=" + this.getSnapshot() + ", initialSnapshot=" + this.getInitialSnapshot() + ", callback=" + this.getCallback() + ", callback2=" + this.getCallback2() + ", worldPos=" + this.getWorldPos() + ", rotChanged=" + this.isRotChanged() + ", posChanged=" + this.isPosChanged() + ", scaleChanged=" + this.isScaleChanged() + ")";
    }

    public GeometryBone() {
    }
}

