/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.geometry.components;

import it.mralxart.etheria.epicora.geometry.data.TexVertex;
import it.mralxart.etheria.utils.NbtUtils;
import java.util.Arrays;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import org.joml.Vector3f;

public class GeometryQuad
implements INBTSerializable<CompoundTag> {
    private TexVertex[] texVertices;
    private Direction direction;
    private Vector3f normal;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag texVerticesTag = new ListTag();
        for (TexVertex vertex : this.texVertices) {
            texVerticesTag.add((Object)vertex.serializeNBT());
        }
        tag.m_128365_("texVertices", (Tag)texVerticesTag);
        tag.m_128359_("direction", this.direction.m_122433_());
        tag.m_128365_("normal", (Tag)NbtUtils.writeVector3f(this.normal));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag texVerticesTag = tag.m_128437_("texVertices", 10);
        this.texVertices = new TexVertex[texVerticesTag.size()];
        for (int i = 0; i < texVerticesTag.size(); ++i) {
            TexVertex vertex = new TexVertex();
            vertex.deserializeNBT((CompoundTag)texVerticesTag.get(i));
            this.texVertices[i] = vertex;
        }
        this.direction = Direction.m_122402_((String)tag.m_128461_("direction"));
        this.normal = NbtUtils.readVector3f(tag.m_128469_("normal"));
    }

    public TexVertex[] getTexVertices() {
        return this.texVertices;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public void setTexVertices(TexVertex[] texVertices) {
        this.texVertices = texVertices;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setNormal(Vector3f normal) {
        this.normal = normal;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeometryQuad)) {
            return false;
        }
        GeometryQuad other = (GeometryQuad)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTexVertices(), other.getTexVertices())) {
            return false;
        }
        Direction this$direction = this.getDirection();
        Direction other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !this$direction.equals(other$direction)) {
            return false;
        }
        Vector3f this$normal = this.getNormal();
        Vector3f other$normal = other.getNormal();
        return !(this$normal == null ? other$normal != null : !this$normal.equals(other$normal));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeometryQuad;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getTexVertices());
        Direction $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : $direction.hashCode());
        Vector3f $normal = this.getNormal();
        result = result * 59 + ($normal == null ? 43 : $normal.hashCode());
        return result;
    }

    public String toString() {
        return "GeometryQuad(texVertices=" + Arrays.deepToString(this.getTexVertices()) + ", direction=" + this.getDirection() + ", normal=" + this.getNormal() + ")";
    }

    public GeometryQuad(TexVertex[] texVertices, Direction direction, Vector3f normal) {
        this.texVertices = texVertices;
        this.direction = direction;
        this.normal = normal;
    }

    public GeometryQuad() {
    }
}

