/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.geometry.data;

import it.mralxart.etheria.epicora.geometry.components.GeometryBone;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BoneSnapshot {
    private GeometryBone bone;
    private Vector3f previousRotation;
    private Vector3f currentRotation;
    private Vector3f previousPosition;
    private Vector3f currentPosition;
    private Vector3f previousScale;
    private Vector3f currentScale;
    private boolean rotationChanged;
    private boolean positionChanged;
    private boolean scaleChanged;
    private boolean posProgress;
    private boolean rotProgress;
    private boolean scaleProgress;
    private float resetRotTick = 0.0f;
    private float resetPosTick = 0.0f;
    private float resetScaleTick = 0.0f;

    public BoneSnapshot(Vector3f initialRotation, Vector3f initialPosition, Vector3f initialScale) {
        this.previousRotation = initialRotation;
        this.currentRotation = initialRotation;
        this.previousPosition = initialPosition;
        this.currentPosition = initialPosition;
        this.previousScale = initialScale;
        this.currentScale = initialScale;
    }

    public BoneSnapshot(GeometryBone bone, Vector3f initialRotation, Vector3f initialPosition, Vector3f initialScale) {
        this.bone = bone;
        this.previousRotation = initialRotation;
        this.currentRotation = initialRotation;
        this.previousPosition = initialPosition;
        this.currentPosition = initialPosition;
        this.previousScale = initialScale;
        this.currentScale = initialScale;
    }

    public void updateRotation(Vector3f newRotation) {
        if (newRotation.equals((Object)new Vector3f())) {
            return;
        }
        this.previousRotation = this.currentRotation;
        this.currentRotation = newRotation;
        this.rotationChanged = !newRotation.equals((Object)this.previousRotation);
    }

    public void updatePosition(Vector3f newPosition) {
        if (newPosition.equals((Object)new Vector3f())) {
            return;
        }
        this.previousPosition = this.currentPosition;
        this.currentPosition = newPosition;
        this.positionChanged = !newPosition.equals((Object)this.previousPosition);
    }

    public void updateScale(Vector3f newScale) {
        if (newScale.equals((Object)new Vector3f())) {
            return;
        }
        this.previousScale = this.currentScale;
        this.currentScale = newScale;
        this.scaleChanged = !newScale.equals((Object)this.previousScale);
    }

    public void startPosAnim() {
        this.posProgress = true;
    }

    public void stopPosAnim(float tick) {
        this.posProgress = false;
        this.resetPosTick = tick;
    }

    public void startRotAnim() {
        this.rotProgress = true;
    }

    public void stopRotAnim(float tick) {
        this.rotProgress = false;
        this.resetRotTick = tick;
    }

    public void startScaleAnim() {
        this.scaleProgress = true;
    }

    public void stopScaleAnim(float tick) {
        this.scaleProgress = false;
        this.resetScaleTick = tick;
    }

    public BoneSnapshot copy() {
        BoneSnapshot copy = new BoneSnapshot();
        copy.bone = this.bone;
        copy.previousRotation = this.previousRotation != null ? new Vector3f((Vector3fc)this.previousRotation) : null;
        copy.currentRotation = this.currentRotation != null ? new Vector3f((Vector3fc)this.currentRotation) : null;
        copy.previousPosition = this.previousPosition != null ? new Vector3f((Vector3fc)this.previousPosition) : null;
        copy.currentPosition = this.currentPosition != null ? new Vector3f((Vector3fc)this.currentPosition) : null;
        copy.previousScale = this.previousScale != null ? new Vector3f((Vector3fc)this.previousScale) : null;
        copy.currentScale = this.currentScale != null ? new Vector3f((Vector3fc)this.currentScale) : null;
        copy.rotationChanged = this.rotationChanged;
        copy.positionChanged = this.positionChanged;
        copy.scaleChanged = this.scaleChanged;
        copy.posProgress = this.posProgress;
        copy.rotProgress = this.rotProgress;
        copy.scaleProgress = this.scaleProgress;
        copy.resetRotTick = this.resetRotTick;
        copy.resetPosTick = this.resetPosTick;
        copy.resetScaleTick = this.resetScaleTick;
        return copy;
    }

    public GeometryBone getBone() {
        return this.bone;
    }

    public Vector3f getPreviousRotation() {
        return this.previousRotation;
    }

    public Vector3f getCurrentRotation() {
        return this.currentRotation;
    }

    public Vector3f getPreviousPosition() {
        return this.previousPosition;
    }

    public Vector3f getCurrentPosition() {
        return this.currentPosition;
    }

    public Vector3f getPreviousScale() {
        return this.previousScale;
    }

    public Vector3f getCurrentScale() {
        return this.currentScale;
    }

    public boolean isRotationChanged() {
        return this.rotationChanged;
    }

    public boolean isPositionChanged() {
        return this.positionChanged;
    }

    public boolean isScaleChanged() {
        return this.scaleChanged;
    }

    public boolean isPosProgress() {
        return this.posProgress;
    }

    public boolean isRotProgress() {
        return this.rotProgress;
    }

    public boolean isScaleProgress() {
        return this.scaleProgress;
    }

    public float getResetRotTick() {
        return this.resetRotTick;
    }

    public float getResetPosTick() {
        return this.resetPosTick;
    }

    public float getResetScaleTick() {
        return this.resetScaleTick;
    }

    public void setBone(GeometryBone bone) {
        this.bone = bone;
    }

    public void setPreviousRotation(Vector3f previousRotation) {
        this.previousRotation = previousRotation;
    }

    public void setCurrentRotation(Vector3f currentRotation) {
        this.currentRotation = currentRotation;
    }

    public void setPreviousPosition(Vector3f previousPosition) {
        this.previousPosition = previousPosition;
    }

    public void setCurrentPosition(Vector3f currentPosition) {
        this.currentPosition = currentPosition;
    }

    public void setPreviousScale(Vector3f previousScale) {
        this.previousScale = previousScale;
    }

    public void setCurrentScale(Vector3f currentScale) {
        this.currentScale = currentScale;
    }

    public void setRotationChanged(boolean rotationChanged) {
        this.rotationChanged = rotationChanged;
    }

    public void setPositionChanged(boolean positionChanged) {
        this.positionChanged = positionChanged;
    }

    public void setScaleChanged(boolean scaleChanged) {
        this.scaleChanged = scaleChanged;
    }

    public void setPosProgress(boolean posProgress) {
        this.posProgress = posProgress;
    }

    public void setRotProgress(boolean rotProgress) {
        this.rotProgress = rotProgress;
    }

    public void setScaleProgress(boolean scaleProgress) {
        this.scaleProgress = scaleProgress;
    }

    public void setResetRotTick(float resetRotTick) {
        this.resetRotTick = resetRotTick;
    }

    public void setResetPosTick(float resetPosTick) {
        this.resetPosTick = resetPosTick;
    }

    public void setResetScaleTick(float resetScaleTick) {
        this.resetScaleTick = resetScaleTick;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoneSnapshot)) {
            return false;
        }
        BoneSnapshot other = (BoneSnapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRotationChanged() != other.isRotationChanged()) {
            return false;
        }
        if (this.isPositionChanged() != other.isPositionChanged()) {
            return false;
        }
        if (this.isScaleChanged() != other.isScaleChanged()) {
            return false;
        }
        if (this.isPosProgress() != other.isPosProgress()) {
            return false;
        }
        if (this.isRotProgress() != other.isRotProgress()) {
            return false;
        }
        if (this.isScaleProgress() != other.isScaleProgress()) {
            return false;
        }
        if (Float.compare(this.getResetRotTick(), other.getResetRotTick()) != 0) {
            return false;
        }
        if (Float.compare(this.getResetPosTick(), other.getResetPosTick()) != 0) {
            return false;
        }
        if (Float.compare(this.getResetScaleTick(), other.getResetScaleTick()) != 0) {
            return false;
        }
        GeometryBone this$bone = this.getBone();
        GeometryBone other$bone = other.getBone();
        if (this$bone == null ? other$bone != null : !((Object)this$bone).equals(other$bone)) {
            return false;
        }
        Vector3f this$previousRotation = this.getPreviousRotation();
        Vector3f other$previousRotation = other.getPreviousRotation();
        if (this$previousRotation == null ? other$previousRotation != null : !this$previousRotation.equals(other$previousRotation)) {
            return false;
        }
        Vector3f this$currentRotation = this.getCurrentRotation();
        Vector3f other$currentRotation = other.getCurrentRotation();
        if (this$currentRotation == null ? other$currentRotation != null : !this$currentRotation.equals(other$currentRotation)) {
            return false;
        }
        Vector3f this$previousPosition = this.getPreviousPosition();
        Vector3f other$previousPosition = other.getPreviousPosition();
        if (this$previousPosition == null ? other$previousPosition != null : !this$previousPosition.equals(other$previousPosition)) {
            return false;
        }
        Vector3f this$currentPosition = this.getCurrentPosition();
        Vector3f other$currentPosition = other.getCurrentPosition();
        if (this$currentPosition == null ? other$currentPosition != null : !this$currentPosition.equals(other$currentPosition)) {
            return false;
        }
        Vector3f this$previousScale = this.getPreviousScale();
        Vector3f other$previousScale = other.getPreviousScale();
        if (this$previousScale == null ? other$previousScale != null : !this$previousScale.equals(other$previousScale)) {
            return false;
        }
        Vector3f this$currentScale = this.getCurrentScale();
        Vector3f other$currentScale = other.getCurrentScale();
        return !(this$currentScale == null ? other$currentScale != null : !this$currentScale.equals(other$currentScale));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BoneSnapshot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRotationChanged() ? 79 : 97);
        result = result * 59 + (this.isPositionChanged() ? 79 : 97);
        result = result * 59 + (this.isScaleChanged() ? 79 : 97);
        result = result * 59 + (this.isPosProgress() ? 79 : 97);
        result = result * 59 + (this.isRotProgress() ? 79 : 97);
        result = result * 59 + (this.isScaleProgress() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getResetRotTick());
        result = result * 59 + Float.floatToIntBits(this.getResetPosTick());
        result = result * 59 + Float.floatToIntBits(this.getResetScaleTick());
        GeometryBone $bone = this.getBone();
        result = result * 59 + ($bone == null ? 43 : ((Object)$bone).hashCode());
        Vector3f $previousRotation = this.getPreviousRotation();
        result = result * 59 + ($previousRotation == null ? 43 : $previousRotation.hashCode());
        Vector3f $currentRotation = this.getCurrentRotation();
        result = result * 59 + ($currentRotation == null ? 43 : $currentRotation.hashCode());
        Vector3f $previousPosition = this.getPreviousPosition();
        result = result * 59 + ($previousPosition == null ? 43 : $previousPosition.hashCode());
        Vector3f $currentPosition = this.getCurrentPosition();
        result = result * 59 + ($currentPosition == null ? 43 : $currentPosition.hashCode());
        Vector3f $previousScale = this.getPreviousScale();
        result = result * 59 + ($previousScale == null ? 43 : $previousScale.hashCode());
        Vector3f $currentScale = this.getCurrentScale();
        result = result * 59 + ($currentScale == null ? 43 : $currentScale.hashCode());
        return result;
    }

    public String toString() {
        return "BoneSnapshot(bone=" + this.getBone() + ", previousRotation=" + this.getPreviousRotation() + ", currentRotation=" + this.getCurrentRotation() + ", previousPosition=" + this.getPreviousPosition() + ", currentPosition=" + this.getCurrentPosition() + ", previousScale=" + this.getPreviousScale() + ", currentScale=" + this.getCurrentScale() + ", rotationChanged=" + this.isRotationChanged() + ", positionChanged=" + this.isPositionChanged() + ", scaleChanged=" + this.isScaleChanged() + ", posProgress=" + this.isPosProgress() + ", rotProgress=" + this.isRotProgress() + ", scaleProgress=" + this.isScaleProgress() + ", resetRotTick=" + this.getResetRotTick() + ", resetPosTick=" + this.getResetPosTick() + ", resetScaleTick=" + this.getResetScaleTick() + ")";
    }

    public BoneSnapshot() {
    }
}

