/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.geometry.data;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.mralxart.etheria.epicora.animations.components.GeometryChanges;
import it.mralxart.etheria.epicora.animations.components.bone.BoneTransform;
import it.mralxart.etheria.epicora.geometry.components.GeometryBone;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import org.joml.Vector3f;

public class GeometryData
implements INBTSerializable<CompoundTag> {
    private String identifier;
    private int textureWidth;
    private int textureHeight;
    private Map<String, GeometryBone> bones;
    private Map<String, GeometryBone> topBones;

    public GeometryData(String identifier, int textureWidth, int textureHeight) {
        this.identifier = identifier;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.bones = new HashMap<String, GeometryBone>();
        this.topBones = new HashMap<String, GeometryBone>();
    }

    public GeometryData(GeometryData data) {
        this.identifier = data.identifier;
        this.textureWidth = data.textureWidth;
        this.textureHeight = data.textureHeight;
        this.bones = new HashMap<String, GeometryBone>(data.bones);
        this.topBones = GeometryData.getTopBones(new HashMap<String, GeometryBone>(data.getBones()));
    }

    public static GeometryData clone(GeometryData data) {
        GeometryData newData = new GeometryData("geometry.empty", 64, 64);
        if (data == null) {
            return newData;
        }
        newData.identifier = data.identifier;
        newData.textureWidth = data.textureWidth;
        newData.textureHeight = data.textureHeight;
        newData.bones = new HashMap<String, GeometryBone>();
        for (Map.Entry<String, GeometryBone> entry : data.bones.entrySet()) {
            newData.bones.put(entry.getKey(), entry.getValue().copy());
        }
        newData.topBones = GeometryData.getTopBones(new HashMap<String, GeometryBone>(newData.bones));
        return newData;
    }

    public void applyAnimChanges(GeometryChanges changes) {
        Map<String, BoneTransform> boneTransforms = changes.getBoneTransforms();
        for (Map.Entry<String, BoneTransform> entry : boneTransforms.entrySet()) {
            BoneTransform boneTransform;
            GeometryBone bone = this.bones.get(entry.getKey());
            if (bone == null || (boneTransform = boneTransforms.get(entry.getKey())) == null) continue;
            bone.reset();
            Vector3f position = boneTransform.getPosition();
            Vector3f rotation = boneTransform.getRotation().mul((float)Math.PI / 180);
            Vector3f scale = boneTransform.getScale();
            bone.setPos(bone.getPos().add(position.x, -position.y, position.z));
            bone.setRotation(bone.getRotation().sub(rotation.x, -rotation.y, -rotation.z));
            bone.setScale(bone.getScale().mul(scale.x, scale.y, scale.z));
        }
    }

    public static Map<String, GeometryBone> getTopBones(Map<String, GeometryBone> bones) {
        HashMap<String, GeometryBone> topBones = new HashMap<String, GeometryBone>();
        for (GeometryBone bone : bones.values()) {
            if (!bone.getParent().isEmpty()) continue;
            topBones.put(bone.getName(), bone);
        }
        return topBones;
    }

    public void addBone(GeometryBone bone) {
        this.bones.put(bone.getName(), bone);
    }

    public GeometryBone getBone(String name) {
        return this.bones.get(name);
    }

    public boolean hasBone(String name) {
        return this.bones.containsKey(name);
    }

    public void renderModel(PoseStack poseStack) {
        poseStack.m_85836_();
        for (GeometryBone topBone : this.topBones.values()) {
            topBone.renderBone(this.bones, poseStack);
        }
        poseStack.m_85849_();
    }

    public void renderModel(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        Color color = Color.WHITE;
        for (GeometryBone topBone : this.topBones.values()) {
            topBone.renderBone(this.bones, poseStack, buffer, packedLight, packedOverlay, color.getRed(), color.getGreen(), color.getBlue(), 1.0f);
        }
        poseStack.m_85849_();
    }

    public void renderModel(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float alpha) {
        poseStack.m_85836_();
        Color color = Color.WHITE;
        for (GeometryBone topBone : this.topBones.values()) {
            topBone.renderBone(this.bones, poseStack, buffer, packedLight, packedOverlay, color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }
        poseStack.m_85849_();
    }

    public void renderModel(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, Color color, float alpha) {
        poseStack.m_85836_();
        for (GeometryBone topBone : this.topBones.values()) {
            topBone.renderBone(this.bones, poseStack, buffer, packedLight, packedOverlay, color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }
        poseStack.m_85849_();
    }

    public void renderModel(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        for (GeometryBone topBone : this.topBones.values()) {
            topBone.renderBone(this.bones, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        poseStack.m_85849_();
    }

    public void renderModel(PoseStack poseStack, VertexConsumer buffer, int packedLight) {
        this.renderModel(poseStack, buffer, packedLight, OverlayTexture.f_118083_, 255.0f, 255.0f, 255.0f, 1.0f);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("identifier", this.identifier);
        tag.m_128405_("textureWidth", this.textureWidth);
        tag.m_128405_("textureHeight", this.textureHeight);
        CompoundTag bonesTag = new CompoundTag();
        for (Map.Entry<String, GeometryBone> entry : this.bones.entrySet()) {
            bonesTag.m_128365_(entry.getKey(), (Tag)entry.getValue().serializeNBT());
        }
        tag.m_128365_("bones", (Tag)bonesTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.identifier = tag.m_128461_("identifier");
        this.textureWidth = tag.m_128451_("textureWidth");
        this.textureHeight = tag.m_128451_("textureHeight");
        CompoundTag bonesTag = tag.m_128469_("bones");
        this.bones = new HashMap<String, GeometryBone>();
        for (String key : bonesTag.m_128431_()) {
            GeometryBone bone = new GeometryBone();
            bone.deserializeNBT(bonesTag.m_128469_(key));
            this.bones.put(key, bone);
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public Map<String, GeometryBone> getBones() {
        return this.bones;
    }

    public Map<String, GeometryBone> getTopBones() {
        return this.topBones;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setTextureWidth(int textureWidth) {
        this.textureWidth = textureWidth;
    }

    public void setTextureHeight(int textureHeight) {
        this.textureHeight = textureHeight;
    }

    public void setBones(Map<String, GeometryBone> bones) {
        this.bones = bones;
    }

    public void setTopBones(Map<String, GeometryBone> topBones) {
        this.topBones = topBones;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeometryData)) {
            return false;
        }
        GeometryData other = (GeometryData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTextureWidth() != other.getTextureWidth()) {
            return false;
        }
        if (this.getTextureHeight() != other.getTextureHeight()) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        Map<String, GeometryBone> this$bones = this.getBones();
        Map<String, GeometryBone> other$bones = other.getBones();
        if (this$bones == null ? other$bones != null : !((Object)this$bones).equals(other$bones)) {
            return false;
        }
        Map<String, GeometryBone> this$topBones = this.getTopBones();
        Map<String, GeometryBone> other$topBones = other.getTopBones();
        return !(this$topBones == null ? other$topBones != null : !((Object)this$topBones).equals(other$topBones));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeometryData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTextureWidth();
        result = result * 59 + this.getTextureHeight();
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        Map<String, GeometryBone> $bones = this.getBones();
        result = result * 59 + ($bones == null ? 43 : ((Object)$bones).hashCode());
        Map<String, GeometryBone> $topBones = this.getTopBones();
        result = result * 59 + ($topBones == null ? 43 : ((Object)$topBones).hashCode());
        return result;
    }

    public String toString() {
        return "GeometryData(identifier=" + this.getIdentifier() + ", textureWidth=" + this.getTextureWidth() + ", textureHeight=" + this.getTextureHeight() + ", bones=" + this.getBones() + ", topBones=" + this.getTopBones() + ")";
    }

    public GeometryData() {
    }
}

