/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.geometry.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.mralxart.etheria.Etheria;
import it.mralxart.etheria.epicora.geometry.GeometryStorage;
import it.mralxart.etheria.epicora.geometry.components.GeometryBone;
import it.mralxart.etheria.epicora.geometry.components.GeometryCube;
import it.mralxart.etheria.epicora.geometry.data.GeoUVs;
import it.mralxart.etheria.epicora.geometry.data.GeometryData;
import it.mralxart.etheria.epicora.geometry.data.GeometryUV;
import it.mralxart.etheria.epicora.geometry.data.TexVertex;
import it.mralxart.etheria.registry.GeometryRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GeometryLoader {
    public static void init() {
        ((CompletableFuture)GeometryRegistry.waitForAllRegistrations().thenCompose(aVoid -> GeometryLoader.loadModels())).thenRun(() -> Etheria.LOGGER.info("All models loaded."));
    }

    public static CompletableFuture<Void> loadModels() {
        return CompletableFuture.runAsync(() -> GeometryRegistry.getRegistry().forEach((key, path) -> {
            ResourceLocation location = new ResourceLocation(key.m_135827_(), path);
            String jsonString = GeometryLoader.getJsonStringFromResource(location);
            if (jsonString != null) {
                JsonObject jsonObject = (JsonObject)new Gson().fromJson(jsonString, JsonObject.class);
                Etheria.LOGGER.info("Loaded geometry for {}", key);
                GeometryStorage.storeGeometry(key, GeometryLoader.parseGeometry(location, jsonObject));
            } else {
                Etheria.LOGGER.error("Failed to load JSON from resource: {}", (Object)location);
            }
        }));
    }

    private static String getJsonStringFromResource(ResourceLocation path) {
        String string;
        String resourcePath = "assets/" + path.m_135827_() + "/" + path.m_135815_();
        InputStream inputStream = GeometryLoader.class.getClassLoader().getResourceAsStream(resourcePath);
        if (inputStream == null) {
            Etheria.LOGGER.error("Resource not found: {}", (Object)resourcePath);
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            String line;
            StringBuilder jsonString = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                jsonString.append(line).append(System.lineSeparator());
            }
            string = jsonString.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Etheria.LOGGER.error("Error reading resource: {}", (Object)resourcePath, (Object)e);
                return null;
            }
        }
        reader.close();
        return string;
    }

    private static GeometryData parseGeometry(ResourceLocation location, JsonObject geometryObject) {
        JsonArray geometryArray = geometryObject.getAsJsonArray("minecraft:geometry");
        if (geometryArray == null || geometryArray.isEmpty()) {
            Etheria.LOGGER.error("Missing or invalid 'minecraft:geometry' in geometry object: {}, {}", (Object)location, (Object)geometryObject);
            return null;
        }
        JsonObject firstGeometry = geometryArray.get(0).getAsJsonObject();
        JsonObject description = firstGeometry.getAsJsonObject("description");
        if (description == null) {
            Etheria.LOGGER.error("Missing or invalid 'description' in geometry object: {}, {}", (Object)location, (Object)firstGeometry);
            return null;
        }
        String identifier = description.get("identifier").getAsString();
        int textureWidth = description.get("texture_width").getAsInt();
        int textureHeight = description.get("texture_height").getAsInt();
        GeometryData geometryData = new GeometryData(identifier, textureWidth, textureHeight);
        JsonArray bonesArray = firstGeometry.getAsJsonArray("bones");
        if (bonesArray != null) {
            HashMap<String, GeometryBone> boneMap = new HashMap<String, GeometryBone>();
            for (JsonElement boneElement : bonesArray) {
                JsonObject boneObject = boneElement.getAsJsonObject();
                GeometryBone bone = GeometryLoader.parseBone(location, boneObject, textureWidth, textureHeight);
                boneMap.put(bone.getName(), bone);
                geometryData.addBone(bone);
            }
            for (GeometryBone bone : boneMap.values()) {
                if (bone.getParent() != null && !bone.getParent().isEmpty()) {
                    GeometryBone parentBone = (GeometryBone)boneMap.get(bone.getParent());
                    if (parentBone == null) continue;
                    parentBone.addChildBone(bone);
                    continue;
                }
                geometryData.getBones().put(bone.getName(), bone);
            }
        } else {
            Etheria.LOGGER.error("Missing or invalid 'bones' in geometry object: {}, {}", (Object)location, (Object)firstGeometry);
        }
        return geometryData;
    }

    private static GeometryBone parseBone(ResourceLocation location, JsonObject boneObject, int textureWidth, int textureHeight) {
        JsonArray childrenArray;
        JsonArray cubesArray;
        String name = boneObject.get("name").getAsString();
        JsonArray pivotArray = boneObject.getAsJsonArray("pivot");
        Vector3f pivot = new Vector3f(pivotArray.get(0).getAsFloat(), pivotArray.get(1).getAsFloat(), pivotArray.get(2).getAsFloat());
        JsonArray rotationArray = boneObject.getAsJsonArray("rotation");
        Vector3f rotation = new Vector3f(0.0f, 0.0f, 0.0f);
        if (rotationArray != null) {
            rotation = new Vector3f((float)Math.PI / 180 * rotationArray.get(0).getAsFloat(), (float)Math.PI / 180 * rotationArray.get(1).getAsFloat(), (float)Math.PI / 180 * rotationArray.get(2).getAsFloat());
        }
        rotation.mul(-1.0f, -1.0f, 1.0f);
        JsonArray scaleArray = boneObject.getAsJsonArray("scale");
        Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
        if (scaleArray != null) {
            scale = new Vector3f(scaleArray.get(0).getAsFloat(), scaleArray.get(1).getAsFloat(), scaleArray.get(2).getAsFloat());
        }
        GeometryBone bone = new GeometryBone(name, pivot, rotation, scale);
        bone.setPivot(new Vector3f(-pivot.x, pivot.y, pivot.z));
        if (boneObject.has("parent")) {
            String parent = boneObject.get("parent").getAsString();
            bone.setParent(parent);
        }
        if ((cubesArray = boneObject.getAsJsonArray("cubes")) != null) {
            for (JsonElement cubeElement : cubesArray) {
                JsonObject cubeObject = cubeElement.getAsJsonObject();
                GeometryCube cube = GeometryLoader.parseCube(cubeObject, textureWidth, textureHeight);
                bone.addCube(cube);
            }
        }
        if ((childrenArray = boneObject.getAsJsonArray("children")) != null) {
            for (JsonElement childElement : childrenArray) {
                JsonObject childObject = childElement.getAsJsonObject();
                GeometryBone childBone = GeometryLoader.parseBone(location, childObject, textureWidth, textureHeight);
                bone.addChildBone(childBone);
            }
        }
        return bone;
    }

    private static GeometryCube parseCube(JsonObject cubeObject, int textureWidth, int textureHeight) {
        Vector3f origin = GeometryLoader.parseVector3f(cubeObject.getAsJsonArray("origin"));
        Vector3f size = GeometryLoader.parseVector3f(cubeObject.getAsJsonArray("size"));
        Vector3f pivot = cubeObject.has("pivot") ? GeometryLoader.parseVector3f(cubeObject.getAsJsonArray("pivot")) : new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f rotation = cubeObject.has("rotation") ? GeometryLoader.parseVector3f(cubeObject.getAsJsonArray("rotation")) : new Vector3f(0.0f, 0.0f, 0.0f);
        float inflate = cubeObject.has("inflate") ? cubeObject.get("inflate").getAsFloat() : 0.0f;
        origin = new Vector3f(-(origin.x + size.x) / 16.0f, origin.y / 16.0f, origin.z / 16.0f);
        pivot = new Vector3f(-pivot.x, pivot.y, pivot.z);
        rotation.set((float)Math.toRadians(-rotation.x), (float)Math.toRadians(-rotation.y), (float)Math.toRadians(rotation.z));
        Vector3f vertexSize = new Vector3f((Vector3fc)size).mul(0.0625f);
        GeometryCube cube = new GeometryCube(origin, size, pivot, rotation, 0.0, textureWidth, textureHeight);
        if (cubeObject.has("uv")) {
            JsonElement uvElement = cubeObject.get("uv");
            HashMap<String, GeometryUV> uvMap = new HashMap();
            if (uvElement.isJsonObject()) {
                uvMap = GeometryLoader.parseUvMap(uvElement.getAsJsonObject());
                cube.setUvs(new GeoUVs(uvMap, false));
            } else if (uvElement.isJsonArray()) {
                float[] uv = GeometryLoader.parseFloatArray(uvElement.getAsJsonArray());
                uvMap.put("default", new GeometryUV("default", uv, new float[]{0.0f, 0.0f}));
                cube.setUvs(new GeoUVs(uvMap, true));
            }
        }
        TexVertex[] texVertices = GeometryLoader.createTexVertices(origin, vertexSize, inflate / 16.0f);
        cube.setupQuads(texVertices);
        return cube;
    }

    private static Vector3f parseVector3f(JsonArray array) {
        return new Vector3f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
    }

    private static float[] parseFloatArray(JsonArray array) {
        return new float[]{array.get(0).getAsFloat(), array.get(1).getAsFloat()};
    }

    private static Map<String, GeometryUV> parseUvMap(JsonObject uvObject) {
        HashMap<String, GeometryUV> uvMap = new HashMap<String, GeometryUV>();
        for (Map.Entry entry : uvObject.entrySet()) {
            JsonObject uvData = ((JsonElement)entry.getValue()).getAsJsonObject();
            float[] uv = GeometryLoader.parseFloatArray(uvData.getAsJsonArray("uv"));
            float[] uvSize = GeometryLoader.parseFloatArray(uvData.getAsJsonArray("uv_size"));
            uvMap.put(((String)entry.getKey()).toLowerCase(Locale.ROOT), new GeometryUV((String)entry.getKey(), uv, uvSize));
        }
        return uvMap;
    }

    private static TexVertex[] createTexVertices(Vector3f origin, Vector3f vertexSize, float inflation) {
        return new TexVertex[]{new TexVertex(origin.x - inflation, origin.y - inflation, origin.z - inflation), new TexVertex(origin.x - inflation, origin.y - inflation, origin.z + vertexSize.z + inflation), new TexVertex(origin.x - inflation, origin.y + vertexSize.y + inflation, origin.z - inflation), new TexVertex(origin.x - inflation, origin.y + vertexSize.y + inflation, origin.z + vertexSize.z + inflation), new TexVertex(origin.x + vertexSize.x + inflation, origin.y + vertexSize.y + inflation, origin.z - inflation), new TexVertex(origin.x + vertexSize.x + inflation, origin.y + vertexSize.y + inflation, origin.z + vertexSize.z + inflation), new TexVertex(origin.x + vertexSize.x + inflation, origin.y - inflation, origin.z - inflation), new TexVertex(origin.x + vertexSize.x + inflation, origin.y - inflation, origin.z + vertexSize.z + inflation)};
    }

    public static JsonObject geometryToJson(GeometryData geometryData) {
        JsonObject geometryObject = new JsonObject();
        JsonArray geometryArray = new JsonArray();
        JsonObject firstGeometry = new JsonObject();
        JsonObject description = new JsonObject();
        description.addProperty("identifier", geometryData.getIdentifier());
        description.addProperty("texture_width", (Number)geometryData.getTextureWidth());
        description.addProperty("texture_height", (Number)geometryData.getTextureHeight());
        firstGeometry.add("description", (JsonElement)description);
        JsonArray bonesArray = new JsonArray();
        for (GeometryBone bone : geometryData.getBones().values()) {
            JsonObject boneObject = GeometryLoader.boneToJson(bone);
            bonesArray.add((JsonElement)boneObject);
        }
        firstGeometry.add("bones", (JsonElement)bonesArray);
        geometryArray.add((JsonElement)firstGeometry);
        geometryObject.add("minecraft:geometry", (JsonElement)geometryArray);
        return geometryObject;
    }

    private static JsonObject boneToJson(GeometryBone bone) {
        JsonObject boneObject = new JsonObject();
        boneObject.addProperty("name", bone.getName());
        JsonArray pivotArray = GeometryLoader.vector3fToJsonArray(bone.getPivot());
        boneObject.add("pivot", (JsonElement)pivotArray);
        if (bone.getRotation() != null) {
            JsonArray rotationArray = GeometryLoader.vector3fToJsonArray(bone.getRotation());
            boneObject.add("rotation", (JsonElement)rotationArray);
        }
        if (bone.getScale() != null) {
            JsonArray scaleArray = GeometryLoader.vector3fToJsonArray(bone.getScale());
            boneObject.add("scale", (JsonElement)scaleArray);
        }
        if (bone.getParent() != null) {
            boneObject.addProperty("parent", bone.getParent());
        }
        if (!bone.getCubes().isEmpty()) {
            JsonArray cubesArray = new JsonArray();
            for (GeometryCube cube : bone.getCubes()) {
                JsonObject cubeObject = GeometryLoader.cubeToJson(cube);
                cubesArray.add((JsonElement)cubeObject);
            }
            boneObject.add("cubes", (JsonElement)cubesArray);
        }
        if (!bone.getChildren().isEmpty()) {
            JsonArray childrenArray = new JsonArray();
            for (GeometryBone child : bone.getChildren()) {
                JsonObject childObject = GeometryLoader.boneToJson(child);
                childrenArray.add((JsonElement)childObject);
            }
            boneObject.add("children", (JsonElement)childrenArray);
        }
        return boneObject;
    }

    private static JsonObject cubeToJson(GeometryCube cube) {
        GeoUVs uvs;
        JsonObject cubeObject = new JsonObject();
        cubeObject.add("origin", (JsonElement)GeometryLoader.vector3fToJsonArray(cube.getOrigin()));
        cubeObject.add("size", (JsonElement)GeometryLoader.vector3fToJsonArray(cube.getSize()));
        cubeObject.add("pivot", (JsonElement)GeometryLoader.vector3fToJsonArray(cube.getPivot()));
        if (cube.getRotation() != null) {
            cubeObject.add("rotation", (JsonElement)GeometryLoader.vector3fToJsonArray(cube.getRotation()));
        }
        if (cube.getInflate() != 0.0) {
            cubeObject.addProperty("inflate", (Number)cube.getInflate());
        }
        if ((uvs = cube.getUvs()) != null) {
            if (uvs.isBoxUv()) {
                GeometryUV defaultUv = uvs.getUvMap().get("default");
                JsonArray uvArray = GeometryLoader.floatArrayToJsonArray(defaultUv.getUv());
                cubeObject.add("uv", (JsonElement)uvArray);
            } else {
                JsonObject uvObject = new JsonObject();
                for (Map.Entry<String, GeometryUV> entry : uvs.getUvMap().entrySet()) {
                    JsonObject uvData = new JsonObject();
                    uvData.add("uv", (JsonElement)GeometryLoader.floatArrayToJsonArray(entry.getValue().getUv()));
                    uvData.add("uv_size", (JsonElement)GeometryLoader.floatArrayToJsonArray(entry.getValue().getUvSize()));
                    uvObject.add(entry.getKey(), (JsonElement)uvData);
                }
                cubeObject.add("uv", (JsonElement)uvObject);
            }
        }
        return cubeObject;
    }

    private static JsonArray vector3fToJsonArray(Vector3f vector) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(vector.x()));
        array.add((Number)Float.valueOf(vector.y()));
        array.add((Number)Float.valueOf(vector.z()));
        return array;
    }

    private static JsonArray floatArrayToJsonArray(float[] array) {
        JsonArray jsonArray = new JsonArray();
        for (float value : array) {
            jsonArray.add((Number)Float.valueOf(value));
        }
        return jsonArray;
    }
}

