/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.events;

import it.mralxart.etheria.bosses.golems.Aerolith;
import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.epicora.animations.base.IAnimated;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.handlers.AchievementHandler;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.S2CPacket;
import it.mralxart.etheria.registry.BlockRegistry;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.registry.EntityRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class CommonSetup {

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="etheria")
    public static class GameEvents {
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="etheria")
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onTrackingEntity(PlayerEvent.StartTracking event) {
            Entity entity = event.getTarget();
            if (entity instanceof IAnimated) {
                IAnimated iAnimated = (IAnimated)entity;
                AnimationController controller = iAnimated.getController();
                CompoundTag tag = controller.serializeNBT();
                Networking.sendTrackingEntity(event.getTarget(), new S2CPacket(tag, 112));
            }
        }

        @SubscribeEvent
        public static void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AchievementHandler.grantAdvancement(serverPlayer, "magemicon");
            }
            if (!CapabilityRegistry.getCap(player).isFirst()) {
                CapabilityRegistry.getCap(player).setFirst(true);
                SyncCapabilityManager.sync(player);
                player.m_36356_(((Item)BlockRegistry.MAGEMICON.get()).m_7968_());
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="etheria")
    public static class ModEvents {
        @SubscribeEvent
        public static void onAttributeCreation(EntityAttributeCreationEvent event) {
            event.put((EntityType)EntityRegistry.AEROLITH.get(), Aerolith.createAttributes());
        }
    }
}

