/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.events;

import it.mralxart.etheria.magic.spells.SpellsRegistry;
import it.mralxart.etheria.magic.spells.data.SpellData;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ItemModelGenerator
extends ItemModelProvider {
    private static final List<String> itemIds = new ArrayList<String>();
    private static final List<String> blockItemIds = new ArrayList<String>();

    public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "etheria", existingFileHelper);
    }

    public static <T extends Item> RegistryObject<T> registerItem(String itemId, Supplier<T> itemSupplier) {
        itemIds.add(itemId);
        return ItemRegistry.ITEMS.register(itemId, itemSupplier);
    }

    public static <T extends Item> RegistryObject<T> registerBlock(DeferredRegister<Item> items, String itemId, Supplier<T> itemSupplier) {
        blockItemIds.add(itemId);
        return items.register(itemId, itemSupplier);
    }

    public static DeferredRegister<Item> getItems() {
        return ItemRegistry.ITEMS;
    }

    protected void registerModels() {
        for (String itemId : ItemModelGenerator.getItemIds()) {
            this.item(itemId);
        }
        for (String itemId : ItemModelGenerator.getBlockItemIds()) {
            this.block(itemId);
        }
        for (SpellData data : SpellsRegistry.createSpellsList().getSpells().getSpells().values()) {
            this.spell(data.getId());
        }
        this.generateSpellScrollModel();
    }

    private void item(String name) {
        ((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", new ResourceLocation("etheria", "item/" + name));
    }

    private void spell(String name) {
        ((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", new ResourceLocation("etheria", "item/spells/" + name));
    }

    private void block(String name) {
        this.withExistingParent(name, new ResourceLocation("etheria", "block/" + name));
    }

    private void generateSpellScrollModel() {
        ItemModelBuilder baseModel = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("spell_scroll", "item/generated")).texture("layer0", new ResourceLocation("etheria", "item/spells/icy_spear"));
        for (SpellData data : SpellsUtils.getSortedSpells()) {
            String spellId = data.getId();
            ModelFile.ExistingModelFile modelFile = this.getExistingFile(new ResourceLocation("etheria", "item/" + spellId));
            int id = SpellsUtils.getIntIdSpell(spellId);
            baseModel.override().predicate(new ResourceLocation("etheria", "spell_id"), (float)id * 0.1f).model((ModelFile)modelFile).end();
        }
    }

    public static List<String> getItemIds() {
        return itemIds;
    }

    public static List<String> getBlockItemIds() {
        return blockItemIds;
    }
}

