/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.handlers;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class IceFreezeHandler {
    private static final Random RANDOM = new Random();
    private static final Map<Integer, FreezeQueue> freezeQueues = new HashMap<Integer, FreezeQueue>();
    private static int tickCounter = 0;

    public static void start(Level level, BlockPos startPos, Predicate<BlockState> statePredicate, int distance) {
        if (level.f_46443_) {
            return;
        }
        IceFreezeHandler.start(level, startPos, statePredicate, distance, null, null);
    }

    public static void start(Level level, BlockPos startPos, Predicate<BlockState> statePredicate, int distance, @Nullable BlockState state, @Nullable Color color) {
        if (level.f_46443_) {
            return;
        }
        int queueId = startPos.hashCode();
        if (!freezeQueues.containsKey(queueId)) {
            FreezeQueue freezeQueue = new FreezeQueue(startPos, distance, statePredicate);
            freezeQueue.queue.add(startPos);
            freezeQueue.visited.add(startPos);
            freezeQueue.state = state;
            freezeQueue.color = color;
            freezeQueues.put(queueId, freezeQueue);
        }
    }

    public static void tick(Level level) {
        if (level.f_46443_) {
            return;
        }
        if (freezeQueues.isEmpty()) {
            return;
        }
        if (tickCounter++ < 4) {
            return;
        }
        tickCounter = 0;
        HashMap<Integer, FreezeQueue> currentQueues = new HashMap<Integer, FreezeQueue>(freezeQueues);
        Random random = new Random();
        for (Map.Entry entry : currentQueues.entrySet()) {
            FreezeQueue freezeQueue = (FreezeQueue)entry.getValue();
            int blocksPerTick = 40;
            for (int i = 0; i < blocksPerTick && !freezeQueue.queue.isEmpty(); ++i) {
                boolean isSolid;
                BlockPos currentPos = freezeQueue.queue.poll();
                if (currentPos == null) continue;
                BlockState currentState = level.m_8055_(currentPos);
                if (currentState.m_60795_()) {
                    LevelChunk levelchunk = level.m_6325_(SectionPos.m_123171_((int)currentPos.m_123341_()), SectionPos.m_123171_((int)currentPos.m_123343_()));
                    currentState = levelchunk.m_8055_(currentPos);
                }
                if (currentPos.equals((Object)freezeQueue.startBlockPos)) {
                    currentState = level.m_8055_(currentPos.m_7495_());
                }
                boolean blockTest = !freezeQueue.blockPredicate.test(currentState);
                boolean isFrozen = !IceFreezeHandler.isFrozen(currentState, freezeQueue.state);
                boolean isAir = !currentState.m_60795_();
                boolean isVoid = currentState.m_60734_() != Blocks.f_50454_;
                boolean bl = isSolid = !IceFreezeHandler.isSolidBlock(currentState);
                if (freezeQueue.blockPredicate.test(currentState) || IceFreezeHandler.isFrozen(currentState, freezeQueue.state) || currentState.m_60795_() || currentState.m_60734_() == Blocks.f_50454_ || IceFreezeHandler.isSolidBlock(currentState)) continue;
                BlockState newState = IceFreezeHandler.getRandomIceBlock();
                if (freezeQueue.state != null) {
                    newState = freezeQueue.state;
                }
                level.m_7731_(currentPos, newState, 3);
                level.m_7260_(currentPos, currentState, newState, 3);
                Color color = ElementsUtils.getColorByElement(Element.CRYO);
                if (freezeQueue.color != null) {
                    color = freezeQueue.color;
                }
                ParticleUtils.createAABB(level, new GlowingParticleData(color, 0.2f + random.nextFloat() * 0.1f, 60, 1.0f), new AABB((double)currentPos.m_123341_(), (double)(currentPos.m_123342_() + 1), (double)currentPos.m_123343_(), (double)(currentPos.m_123341_() + 1), (double)(currentPos.m_123342_() + 1), (double)(currentPos.m_123343_() + 1)), 10, 0.005f);
                Iterable<BlockPos> neighbors = IceFreezeHandler.getDirectNeighbors(currentPos);
                block2: for (BlockPos neighbor : neighbors) {
                    if (freezeQueue.blockPredicate.test(currentState) || freezeQueue.visited.contains(neighbor) || freezeQueue.startBlockPos.m_123333_((Vec3i)neighbor) > freezeQueue.maxDistance) continue;
                    BlockState neighborState = level.m_8055_(neighbor);
                    if (neighborState.m_60795_()) {
                        for (BlockPos airNeighbor : IceFreezeHandler.getDirectNeighbors(neighbor)) {
                            BlockState airNeighborState = level.m_8055_(airNeighbor);
                            if (airNeighborState.m_60795_() || IceFreezeHandler.isFrozen(airNeighborState, freezeQueue.state)) continue;
                            freezeQueue.queue.add(airNeighbor);
                            freezeQueue.visited.add(airNeighbor);
                            continue block2;
                        }
                        continue;
                    }
                    if (IceFreezeHandler.isFrozen(neighborState, freezeQueue.state)) continue;
                    freezeQueue.queue.add(neighbor);
                    freezeQueue.visited.add(neighbor);
                }
            }
            if (!freezeQueue.queue.isEmpty()) continue;
            freezeQueues.remove(entry.getKey());
        }
    }

    private static boolean isSolidBlock(BlockState state) {
        if (state.m_60734_() instanceof SnowLayerBlock) {
            return true;
        }
        if (state.m_60734_() instanceof CarpetBlock) {
            return true;
        }
        return state.m_60734_() instanceof TallGrassBlock;
    }

    private static Iterable<BlockPos> getDirectNeighbors(BlockPos pos) {
        return Set.of(pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_(), pos.m_7494_(), pos.m_7495_());
    }

    private static BlockState getRandomIceBlock() {
        Block block = switch (RANDOM.nextInt(3)) {
            case 0 -> Blocks.f_50354_;
            default -> Blocks.f_50568_;
        };
        return block.m_49966_();
    }

    private static boolean isFrozen(BlockState state, BlockState blockState) {
        if (blockState != null) {
            return state.equals(blockState);
        }
        return state.m_60713_(Blocks.f_50354_) || state.m_60713_(Blocks.f_50568_);
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ServerLevel level = event.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            IceFreezeHandler.tick((Level)level);
        }
    }

    private static class FreezeQueue {
        public final Deque<BlockPos> queue = new ArrayDeque<BlockPos>();
        public final Set<BlockPos> visited = new HashSet<BlockPos>();
        public int tickDelay = 0;
        private BlockPos startBlockPos;
        private int maxDistance;
        private Predicate<BlockState> blockPredicate;
        private BlockState state = null;
        private Color color = null;

        public FreezeQueue(BlockPos blockPos, int distance, Predicate<BlockState> predicate) {
            this.startBlockPos = blockPos;
            this.maxDistance = distance;
            this.blockPredicate = predicate;
        }

        public FreezeQueue(BlockPos blockPos, int distance, Predicate<BlockState> predicate, BlockState state, Color color) {
            this.startBlockPos = blockPos;
            this.maxDistance = distance;
            this.blockPredicate = predicate;
            this.state = state;
            this.color = color;
        }

        public Deque<BlockPos> getQueue() {
            return this.queue;
        }

        public Set<BlockPos> getVisited() {
            return this.visited;
        }

        public int getTickDelay() {
            return this.tickDelay;
        }

        public BlockPos getStartBlockPos() {
            return this.startBlockPos;
        }

        public int getMaxDistance() {
            return this.maxDistance;
        }

        public Predicate<BlockState> getBlockPredicate() {
            return this.blockPredicate;
        }

        public BlockState getState() {
            return this.state;
        }

        public Color getColor() {
            return this.color;
        }

        public void setTickDelay(int tickDelay) {
            this.tickDelay = tickDelay;
        }

        public void setStartBlockPos(BlockPos startBlockPos) {
            this.startBlockPos = startBlockPos;
        }

        public void setMaxDistance(int maxDistance) {
            this.maxDistance = maxDistance;
        }

        public void setBlockPredicate(Predicate<BlockState> blockPredicate) {
            this.blockPredicate = blockPredicate;
        }

        public void setState(BlockState state) {
            this.state = state;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FreezeQueue)) {
                return false;
            }
            FreezeQueue other = (FreezeQueue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTickDelay() != other.getTickDelay()) {
                return false;
            }
            if (this.getMaxDistance() != other.getMaxDistance()) {
                return false;
            }
            Deque<BlockPos> this$queue = this.getQueue();
            Deque<BlockPos> other$queue = other.getQueue();
            if (this$queue == null ? other$queue != null : !this$queue.equals(other$queue)) {
                return false;
            }
            Set<BlockPos> this$visited = this.getVisited();
            Set<BlockPos> other$visited = other.getVisited();
            if (this$visited == null ? other$visited != null : !((Object)this$visited).equals(other$visited)) {
                return false;
            }
            BlockPos this$startBlockPos = this.getStartBlockPos();
            BlockPos other$startBlockPos = other.getStartBlockPos();
            if (this$startBlockPos == null ? other$startBlockPos != null : !this$startBlockPos.equals(other$startBlockPos)) {
                return false;
            }
            Predicate<BlockState> this$blockPredicate = this.getBlockPredicate();
            Predicate<BlockState> other$blockPredicate = other.getBlockPredicate();
            if (this$blockPredicate == null ? other$blockPredicate != null : !this$blockPredicate.equals(other$blockPredicate)) {
                return false;
            }
            BlockState this$state = this.getState();
            BlockState other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            Color this$color = this.getColor();
            Color other$color = other.getColor();
            return !(this$color == null ? other$color != null : !((Object)this$color).equals(other$color));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FreezeQueue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTickDelay();
            result = result * 59 + this.getMaxDistance();
            Deque<BlockPos> $queue = this.getQueue();
            result = result * 59 + ($queue == null ? 43 : $queue.hashCode());
            Set<BlockPos> $visited = this.getVisited();
            result = result * 59 + ($visited == null ? 43 : ((Object)$visited).hashCode());
            BlockPos $startBlockPos = this.getStartBlockPos();
            result = result * 59 + ($startBlockPos == null ? 43 : $startBlockPos.hashCode());
            Predicate<BlockState> $blockPredicate = this.getBlockPredicate();
            result = result * 59 + ($blockPredicate == null ? 43 : $blockPredicate.hashCode());
            BlockState $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            Color $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
            return result;
        }

        public String toString() {
            return "IceFreezeHandler.FreezeQueue(queue=" + this.getQueue() + ", visited=" + this.getVisited() + ", tickDelay=" + this.getTickDelay() + ", startBlockPos=" + this.getStartBlockPos() + ", maxDistance=" + this.getMaxDistance() + ", blockPredicate=" + this.getBlockPredicate() + ", state=" + this.getState() + ", color=" + this.getColor() + ")";
        }
    }
}

