/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TriggerHandler {
    private static final Map<String, Trigger> triggers = new HashMap<String, Trigger>();

    public static void registerTrigger(String id, Trigger trigger) {
        triggers.put(id, trigger);
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        triggers.values().forEach(trigger -> {
            if (trigger instanceof BlockRightClickTrigger) {
                trigger.checkAndExecute(player, pos, event.getLevel());
            }
        });
    }

    @SubscribeEvent
    public void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        Player player = event.getEntity();
        Item item = event.getStack().m_41720_();
        triggers.values().forEach(trigger -> {
            if (trigger instanceof ItemPickupTrigger) {
                trigger.checkAndExecute(player, item);
            }
        });
    }

    @SubscribeEvent
    public void onTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!player.m_9236_().f_46443_ && player.f_19797_ % 100 == 0) {
            triggers.values().forEach(trigger -> {
                if (trigger instanceof DungeonEntryTrigger) {
                    trigger.checkAndExecute(player, player.m_9236_());
                }
            });
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_()) continue;
                triggers.values().forEach(trigger -> {
                    if (trigger instanceof ItemPickupTrigger) {
                        trigger.checkAndExecute(player, stack.m_41720_());
                    }
                });
            }
        }
    }

    public static class ItemPickupTrigger
    extends Trigger {
        private Item targetItem;
        private Class<? extends Item> clazz;

        public ItemPickupTrigger(Class<? extends Item> clazz, BiConsumer<Player, Object[]> action) {
            super(action);
            this.clazz = clazz;
        }

        public ItemPickupTrigger(Item targetItem, BiConsumer<Player, Object[]> action) {
            super(action);
            this.targetItem = targetItem;
        }

        @Override
        public void checkAndExecute(Player player, Object ... params) {
            Item item = (Item)params[0];
            if (this.clazz != null) {
                if (this.clazz.isInstance(item)) {
                    this.action.accept(player, params);
                }
            } else if (item.equals(this.targetItem)) {
                this.action.accept(player, params);
            }
        }
    }

    public static abstract class Trigger {
        protected final BiConsumer<Player, Object[]> action;

        public Trigger(BiConsumer<Player, Object[]> action) {
            this.action = action;
        }

        public abstract void checkAndExecute(Player var1, Object ... var2);
    }

    public static class DungeonEntryTrigger
    extends Trigger {
        private final ResourceLocation dungeonId;
        private ResourceLocation[] dungeonIds;

        public DungeonEntryTrigger(ResourceLocation dungeonId, BiConsumer<Player, Object[]> action) {
            super(action);
            this.dungeonId = dungeonId;
        }

        public DungeonEntryTrigger(ResourceLocation[] dungeonIds, BiConsumer<Player, Object[]> action) {
            super(action);
            this.dungeonIds = dungeonIds;
            this.dungeonId = dungeonIds[0];
        }

        @Override
        public void checkAndExecute(Player player, Object ... params) {
            ServerLevel level = (ServerLevel)params[0];
            if (this.dungeonIds != null) {
                Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
                for (ResourceLocation dungeonId : this.dungeonIds) {
                    Optional structureHolder = structureRegistry.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)dungeonId));
                    if (structureHolder.isEmpty()) {
                        return;
                    }
                    StructureManager structureManager = level.m_215010_();
                    Optional<StructureStart> structureStart = Optional.of(structureManager.m_220494_(player.m_20183_(), (Structure)((Holder.Reference)structureHolder.get()).m_203334_()));
                    StructureStart start = structureStart.get();
                    boolean isInside = false;
                    try {
                        isInside = start.m_73601_().m_71051_((Vec3i)player.m_20183_());
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    if (!isInside) continue;
                    this.action.accept(player, params);
                    break;
                }
            } else {
                Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
                Optional structureHolder = structureRegistry.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)this.dungeonId));
                if (structureHolder.isEmpty()) {
                    return;
                }
                StructureManager structureManager = level.m_215010_();
                Optional<StructureStart> structureStart = Optional.of(structureManager.m_220494_(player.m_20183_(), (Structure)((Holder.Reference)structureHolder.get()).m_203334_()));
                StructureStart start = structureStart.get();
                boolean isInside = false;
                try {
                    isInside = start.m_73601_().m_71051_((Vec3i)player.m_20183_());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (isInside) {
                    this.action.accept(player, params);
                }
            }
        }
    }

    public static class BlockRightClickTrigger
    extends Trigger {
        private final BlockPos targetPos;

        public BlockRightClickTrigger(BlockPos targetPos, BiConsumer<Player, Object[]> action) {
            super(action);
            this.targetPos = targetPos;
        }

        @Override
        public void checkAndExecute(Player player, Object ... params) {
            BlockPos pos = (BlockPos)params[0];
            if (pos.equals((Object)this.targetPos)) {
                this.action.accept(player, params);
            }
        }
    }
}

