/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.items;

import it.mralxart.etheria.artifacts.ArtifactStatsManager;
import it.mralxart.etheria.artifacts.StatType;
import it.mralxart.etheria.items.base.IArtefactItem;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ArtifactItem
extends Item
implements IArtefactItem,
IElementItem,
IMageMiconEntryItem {
    private Element element;

    public ArtifactItem(Element element) {
        super(new Item.Properties().m_41487_(1));
        this.element = element;
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        Map<StatType, Float> mainStats = ArtifactStatsManager.getMainStats(stack);
        Map<StatType, Float> stats = ArtifactStatsManager.getSecondaryStats(stack);
        boolean isReroll = ArtifactStatsManager.isReroll(stack);
        if (!mainStats.isEmpty() && !stats.isEmpty()) {
            String formattedValue;
            MutableComponent formatted;
            String translateName;
            float value;
            StatType stat;
            tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"etheria.curve").getString() + ":")).m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getEndColorByElement(this.element).getRGB())));
            for (Map.Entry<StatType, Float> entry : mainStats.entrySet()) {
                stat = entry.getKey();
                if (stat.equals((Object)StatType.NONE)) continue;
                value = entry.getValue().floatValue();
                translateName = Component.m_237115_((String)("etheria.stat." + stat.getName())).getString();
                if (isReroll) {
                    formatted = Component.m_237113_((String)"11.11%").m_6270_(Style.f_131099_.m_178524_(Boolean.valueOf(true)));
                    tooltip.add((Component)Component.m_237113_((String)("\u00b7 \u00a7r" + translateName + ": ")).m_7220_((Component)formatted));
                    continue;
                }
                formattedValue = String.format("%s%.1f%%", value >= 0.0f ? "+" : "", Float.valueOf(value));
                tooltip.add((Component)Component.m_237113_((String)("\u00b7 \u00a7r" + translateName + ": \u00a7r" + formattedValue)));
            }
            for (Map.Entry<StatType, Float> entry : stats.entrySet()) {
                stat = entry.getKey();
                if (stat.equals((Object)StatType.NONE)) continue;
                value = entry.getValue().floatValue();
                translateName = Component.m_237115_((String)("etheria.stat." + stat.getName())).getString();
                if (isReroll) {
                    formatted = Component.m_237113_((String)"new_stat_art").m_6270_(Style.f_131099_.m_178524_(Boolean.valueOf(true)));
                    MutableComponent formattedValue2 = Component.m_237113_((String)"11.11%").m_6270_(Style.f_131099_.m_178524_(Boolean.valueOf(true)));
                    tooltip.add((Component)Component.m_237113_((String)"\u00a77\u00a7o").m_7220_((Component)formatted).m_130946_(" ").m_7220_((Component)formattedValue2));
                    continue;
                }
                formattedValue = String.format("%s%.1f%%", value >= 0.0f ? "+" : "", Float.valueOf(value));
                tooltip.add((Component)Component.m_237113_((String)("\u00a77\u00a7o" + translateName + ": " + formattedValue)));
            }
        }
        if (ArtifactStatsManager.isMaxLevel(stack)) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237113_((String)Component.m_237115_((String)"etheria.max_level").getString()).m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getColorByElement(this.element).getRGB())));
        }
        if (ArtifactStatsManager.isBlessed(stack)) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237113_((String)Component.m_237115_((String)"etheria.artifact.blessed").getString()).m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getColorByElement(this.element).getRGB())));
        }
    }

    public Component m_7626_(ItemStack p_41458_) {
        Component component = super.m_7626_(p_41458_);
        int stars = p_41458_.m_41784_().m_128441_("etheria$stars") ? p_41458_.m_41783_().m_128451_("etheria$stars") : 1;
        String starsText = "[" + "\u2605".repeat(Math.max(0, stars)) + "\u2606".repeat(Math.max(0, 5 - stars)) + "]";
        MutableComponent starsComponent = Component.m_237113_((String)starsText).m_130948_(component.m_7383_());
        return Component.m_237113_((String)(component.getString() + " " + starsComponent.getString())).m_130948_(component.m_7383_());
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public Chapter getChapter() {
        return MageMiconUtils.getChapter("items", "artifacts");
    }
}

